/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.datanode;

import com.agfa.pacs.data.lw.datainfo.impl.RootInfo;
import com.agfa.pacs.data.shared.filter.FilterLevel;
import com.agfa.pacs.data.shared.filter.FilterTag;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoRetriever;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.node.AbstractDataInfoNode;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEPatientData;
import com.agfa.pacs.impaxee.glue.datanode.ImpaxEEDataInfoNodeIdentifier;
import com.agfa.pacs.impaxee.glue.datanode.ImpaxEEIconProvider;
import com.tiani.base.data.IPatientData;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class ImpaxEEDataInfoNode
extends AbstractDataInfoNode {
    private ImpaxEEDataInfoNodeIdentifier dni;
    private DataManager dataManager;
    private static List<FilterTag> resultFilterTags;
    private static final int[] PATIENT_RESULT_TAGS;
    private static final int[] STUDY_RESULT_TAGS;
    private static final int[] SERIES_RESULT_TAGS;
    private static final int[] IMAGE_RESULT_TAGS;

    static {
        PATIENT_RESULT_TAGS = new int[]{0x100010, 0x100020, 0x100021, 0x100040, 0x100030, 0x201200, 0x201202, 2101764};
        STUDY_RESULT_TAGS = new int[]{524320, 524336, 524368, 0x200010, 524385, 524432, 528432, 2101766, 2101768};
        SERIES_RESULT_TAGS = new int[]{524384, 0x200011, 2101769};
        IMAGE_RESULT_TAGS = new int[]{2097171, 2621456, 2621457, 2621696, 0x280008, 0x700080, 7340161, 7340162, 7340163, 4236433, 4236435, 524323, 524339, 4235314};
    }

    public ImpaxEEDataInfoNode(String string, ImpaxEEDataInfoNodeIdentifier impaxEEDataInfoNodeIdentifier) {
        super(string);
        this.dni = impaxEEDataInfoNodeIdentifier;
        this.iconProvider = new ImpaxEEIconProvider();
        this.dataManager = DataManager.getInstance();
    }

    public String getType() {
        return "IMPAXEE";
    }

    public IRootInfo getDataInfo(IFilter iFilter) throws Exception {
        List list = this.dataManager.getPatientDatas();
        RootInfo rootInfo = new RootInfo();
        for (IPatientData iPatientData : list) {
            ImpaxEEPatientData impaxEEPatientData = (ImpaxEEPatientData)iPatientData;
            IPatientInfo iPatientInfo = (IPatientInfo)((IPatientInfo)impaxEEPatientData.getDataInfo()).deepCopy(true);
            rootInfo.addChild((IDataInfo)iPatientInfo);
        }
        return rootInfo;
    }

    public List<FilterTag> getSearchTags() {
        return null;
    }

    public List<FilterTag> getResultTags() {
        if (resultFilterTags == null) {
            resultFilterTags = new ArrayList<FilterTag>();
            ImpaxEEDataInfoNode.createFilterTags(resultFilterTags, PATIENT_RESULT_TAGS, FilterLevel.Patient);
            ImpaxEEDataInfoNode.createFilterTags(resultFilterTags, STUDY_RESULT_TAGS, FilterLevel.Study);
            ImpaxEEDataInfoNode.createFilterTags(resultFilterTags, SERIES_RESULT_TAGS, FilterLevel.Series);
            ImpaxEEDataInfoNode.createFilterTags(resultFilterTags, IMAGE_RESULT_TAGS, FilterLevel.Image);
        }
        return resultFilterTags;
    }

    public IDataInfoRetriever getRetriever() {
        return null;
    }

    public IDataProviderIdentifier getIdentifier() {
        return this.dni;
    }

    public void cancelQuery() {
    }

    public String getSourceAET() {
        return null;
    }

    private static void createFilterTags(List<FilterTag> list, int[] nArray, FilterLevel filterLevel) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            list.add(FilterTag.createDicomFilterTag((int)n3, (FilterLevel)filterLevel));
            ++n2;
        }
    }

    public List<Attributes> rawDicomSearch(Attributes attributes, String string) throws Exception {
        throw new UnsupportedOperationException();
    }
}

