/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.datahandler;

import com.agfa.pacs.base.data.action.DataActionFactory;
import com.agfa.pacs.base.data.action.IDataAction;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.store.ISendNode;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.data.shared.store.IStoreListener;
import com.agfa.pacs.data.shared.store.StoreProviderFactory;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.glue.cycling.Messages;
import com.agfa.pacs.impaxee.glue.data.DataObjectUtilities;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEFrameObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEESeriesData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyData;
import com.agfa.pacs.listtext.lta.util.SendExportNotification;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IStudyData;
import com.tiani.gui.util.LocationUtil;
import com.tiani.jvision.util.StorageLicense;
import com.tiani.util.message.Message;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataPerformManager {
    private static DataPerformManager instance = null;
    private Map<String, IPerform> performs = new LinkedHashMap<String, IPerform>();

    private DataPerformManager() {
        for (IDataAction iDataAction : DataActionFactory.getInstance().getActions()) {
            if (!iDataAction.isAllowed()) continue;
            this.performs.put(iDataAction.getActionCode(), new Perform(iDataAction));
        }
        this.performs.put("ADD_TO_WORKLIST", new Perform(DataActionFactory.getInstance().getActionForCode("ADD_TO_WORKLIST")));
        this.performs.put("EXPORT_SC_DIRECT", new SCPerform());
    }

    public static synchronized DataPerformManager getInstance() {
        if (instance == null) {
            instance = new DataPerformManager();
        }
        return instance;
    }

    public Collection<String> getPerformCodes() {
        return this.performs.keySet();
    }

    public Collection<IPerform> getPerforms() {
        return this.performs.values();
    }

    public IPerform getPerform(String string) {
        return this.performs.get(string);
    }

    private static IDataAction.IActionContext createActionContext(IPerform.IPerformContext iPerformContext, Rectangle rectangle) {
        return iPerformContext == null ? null : new IDataAction.DefaultActionContext(iPerformContext.getUIContext(), iPerformContext.getExecutionContext(), rectangle);
    }

    private class Perform
    extends PerformAdapter {
        private IDataAction dataAction;

        public Perform(IDataAction iDataAction) {
            this.dataAction = iDataAction;
        }

        public String getCode() {
            return this.dataAction.getActionCode();
        }

        public int getPriority() {
            return this.dataAction.getPriority();
        }

        public boolean isMenuItemCapable() {
            return this.dataAction.isAllowed();
        }

        public IPerform.IPerformResult perform(IPerform.IPerformContext iPerformContext, Collection<? extends IDataObject> collection) {
            Rectangle rectangle = null;
            if (iPerformContext != null && iPerformContext.getUIContext() != null) {
                rectangle = LocationUtil.getAbsoluteMonitorRectangle((Point)LocationUtil.getCurrentAbsoluteMousepointerLocation(), (Dimension)new Dimension(1, 1));
            }
            List<Object> list = null;
            list = "ADD_TO_WORKLIST".equals(this.getCode()) ? DataObjectUtilities.createDataInfosForWorklist(collection) : ("PRINT".equals(this.getCode()) ? DataObjectUtilities.createObjectInfosForPrinting(collection) : DataObjectUtilities.createObjectInfos(collection));
            return new IPerform.DefaultPerformResult(this.dataAction.perform(DataPerformManager.createActionContext(iPerformContext, rectangle), list));
        }

        public String toString() {
            return this.dataAction.toString();
        }
    }

    private abstract class PerformAdapter
    implements IPerform {
        private PerformAdapter() {
        }

        public boolean canInferStoreTargetNode(IStudyData iStudyData) {
            if (!(iStudyData instanceof ImpaxEEStudyData)) {
                return false;
            }
            IStudyInfo iStudyInfo = (IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo();
            if (iStudyInfo == null) {
                return false;
            }
            try {
                ISendNode iSendNode = StoreProviderFactory.getInstance().getStoreProvider().inferStoreTargetNode(iStudyInfo);
                return iSendNode != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private class SCPerform
    extends PerformAdapter {
        private ALogger log = ALogger.getLogger(SCPerform.class);

        private SCPerform() {
        }

        public String getCode() {
            return "EXPORT_SC_DIRECT";
        }

        public int getPriority() {
            return 0;
        }

        public IPerform.IPerformResult perform(IPerform.IPerformContext iPerformContext, Collection<? extends IDataObject> collection) {
            if (!StorageLicense.canStoreSC()) {
                this.log.info("SC Not stored due to licensing");
                return new IPerform.DefaultPerformResult(1);
            }
            ImpaxEEFrameObjectData impaxEEFrameObjectData = null;
            IDataObject iDataObject = null;
            IStudyInfo iStudyInfo = null;
            IStoreHandler iStoreHandler = null;
            if (collection != null) {
                Iterator<? extends IDataObject> iterator = collection.iterator();
                if (iterator.hasNext()) {
                    iDataObject = iterator.next();
                }
                if (iDataObject instanceof ImpaxEEFrameObjectData) {
                    impaxEEFrameObjectData = (ImpaxEEFrameObjectData)iDataObject;
                    iStudyInfo = (IStudyInfo)((ImpaxEEStudyData)impaxEEFrameObjectData.getMainFrame().getParent().getParent()).getDataInfo();
                } else if (iDataObject instanceof ImpaxEESeriesData) {
                    iStudyInfo = (IStudyInfo)((ImpaxEEStudyData)((ImpaxEESeriesData)iDataObject).getParent()).getDataInfo();
                }
                ArrayList<String> arrayList = new ArrayList<String>(collection.size());
                for (IDataObject iDataObject2 : collection) {
                    String string = iDataObject2.getDicomObject().getString(524312);
                    arrayList.add(string);
                }
                Map<IObjectInfo, IObjectInfo> map = DataObjectUtilities.createObjectInfoMap(collection);
                iStoreHandler = StoreProviderFactory.getInstance().getStoreProvider().store(map.keySet(), iStudyInfo, null);
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getKey() == entry.getValue()) continue;
                    ((IObjectInfo)entry.getValue()).setSource(((IObjectInfo)entry.getKey()).getSource());
                }
                if (iStoreHandler == null) {
                    return new IPerform.DefaultPerformResult(-1);
                }
                new StoreCallback(iStoreHandler, arrayList);
            }
            return new IPerform.DefaultPerformResult(1, iStoreHandler);
        }

        public boolean isMenuItemCapable() {
            return true;
        }

        private class StoreCallback
        implements IStoreListener {
            private List<String> sopInstanceUIDs;

            public StoreCallback(IStoreHandler iStoreHandler, List<String> list) {
                this.sopInstanceUIDs = list;
                iStoreHandler.addStoreListener((IStoreListener)this);
            }

            private void handleError() {
                Message.error((Object)Messages.getString("DataPerformManager.StoreFailed"));
            }

            private void handleSuccess() {
                SendExportNotification.sendExportNotification(this.sopInstanceUIDs);
            }

            public void storeStateChanged(JobState jobState) {
                if (jobState == JobState.FAILED) {
                    this.handleError();
                } else if (jobState == JobState.FINISHED) {
                    this.handleSuccess();
                }
            }
        }
    }
}

