/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.data.shared.icon.DefaultIconFactory;
import com.agfa.pacs.data.shared.icon.IIconInfo;
import com.agfa.pacs.data.shared.icon.IIconProvider;
import com.agfa.pacs.data.shared.icon.IIconProviderListener;
import com.agfa.pacs.data.shared.icon.IconException;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.TokenData;
import com.tiani.base.data.TokenListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ImpaxEETokenData
implements TokenData,
IIconProviderListener {
    private static final int TOKEN_WIDTH = 64;
    private static final int TOKEN_HEIGHT = 64;
    private static final ALogger log = ALogger.getLogger(ImpaxEETokenData.class);
    private List<TokenListener> tokenListener;
    private IIconInfo iconInfo;
    private IObjectInfo dataInfo;
    private int frameNumber = 0;
    private BufferedImage image;

    public ImpaxEETokenData(IObjectInfo iObjectInfo) {
        this.dataInfo = iObjectInfo;
        this.tokenListener = new CopyOnWriteArrayList<TokenListener>();
    }

    public ImpaxEETokenData(IObjectInfo iObjectInfo, int n) {
        this(iObjectInfo);
        this.frameNumber = n;
    }

    public void addTokenListener(TokenListener tokenListener) {
        this.tokenListener.add(tokenListener);
    }

    private void tokenChanged() {
        for (TokenListener tokenListener : this.tokenListener) {
            tokenListener.tokenChanged((TokenData)this);
        }
    }

    public int getWidth() {
        return 64;
    }

    public int getHeight() {
        return 64;
    }

    public boolean hasToken() {
        return this.iconInfo != null;
    }

    public void paintToken(Graphics graphics, int n, int n2, int n3, int n4, TokenListener tokenListener) {
        if (this.hasToken()) {
            try {
                if (this.image == null) {
                    this.image = this.iconInfo.getImageAsync((IIconProviderListener)this);
                }
                if (this.image != null) {
                    int n5;
                    int n6 = this.image.getWidth();
                    if (n6 != (n5 = this.image.getHeight())) {
                        Dimension dimension = this.computeScaledDimension(n3, n4, this.image.getWidth(), this.image.getHeight());
                        int n7 = dimension.width < n3 ? (n3 - dimension.width) / 2 + n : n;
                        int n8 = dimension.height < n4 ? (n4 - dimension.height) / 2 + n2 : n2;
                        graphics.drawImage(this.image, n7, n8, dimension.width, dimension.height, null);
                    } else {
                        graphics.drawImage(this.image, n, n2, n3, n4, null);
                    }
                } else {
                    this.drawDefaultIcon(graphics, n, n2, n3, n4);
                }
                if (this.image != null) {
                    this.iconInfo.release(this.image);
                    this.image = null;
                }
            }
            catch (IconException iconException) {
                log.error("Error drawing token.", (Throwable)iconException);
                this.drawDefaultIcon(graphics, n, n2, n3, n4);
            }
        } else {
            this.drawDefaultIcon(graphics, n, n2, n3, n4);
            if (tokenListener != null) {
                this.addTokenListener(tokenListener);
            }
            this.ensureToken(false);
        }
    }

    private void drawDefaultIcon(Graphics graphics, int n, int n2, int n3, int n4) {
        try {
            graphics.drawImage(this.dataInfo.getSource().getIconProvider().getDefaultIcon(this.dataInfo).getImage(), n, n2, n3, n4, null);
        }
        catch (IconException iconException) {
            iconException.printStackTrace();
        }
    }

    public void paintToken(Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintToken(graphics, n, n2, n3, n4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getFinalImage() {
        if (!this.hasToken()) {
            ImpaxEETokenData impaxEETokenData = this;
            synchronized (impaxEETokenData) {
                if (this.iconInfo == null) {
                    this.ensureToken(true);
                }
            }
        }
        return this.getImage(null);
    }

    public BufferedImage getImage(TokenListener tokenListener) {
        BufferedImage bufferedImage = new BufferedImage(64, 64, 1);
        this.paintToken(bufferedImage.getGraphics(), 0, 0, 64, 64, tokenListener);
        return bufferedImage;
    }

    private void ensureToken(boolean bl) {
        if (this.hasToken()) {
            return;
        }
        if (this.dataInfo.getSource() == null) {
            return;
        }
        IIconProvider iIconProvider = this.dataInfo.getSource().getIconProvider();
        if (iIconProvider == null) {
            return;
        }
        if (bl) {
            IIconInfo iIconInfo = iIconProvider.getIcon(this.dataInfo, this.frameNumber);
            if (iIconInfo == null) {
                return;
            }
            try {
                this.iconAvailable(this.dataInfo, iIconInfo, iIconInfo.getImage());
            }
            catch (IconException iconException) {
                log.debug("Loading token icon failed.", (Throwable)iconException);
            }
        } else {
            iIconProvider.getIcon(this.dataInfo, (IIconProviderListener)this, this.frameNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iconAvailable(IObjectInfo iObjectInfo, IIconInfo iIconInfo, BufferedImage bufferedImage) {
        if (iObjectInfo != null && (DicomUtils.isVideoData((String)iObjectInfo.getSOPClassUID()) || iIconInfo == null)) {
            iIconInfo = DefaultIconFactory.getInstance().getDefaultIcon(iObjectInfo.getString(524312));
        }
        ImpaxEETokenData impaxEETokenData = this;
        synchronized (impaxEETokenData) {
            this.iconInfo = iIconInfo;
            this.image = bufferedImage;
            this.notifyAll();
        }
        this.tokenChanged();
    }

    public boolean isFinalToken() {
        if (this.iconInfo != null) {
            return !this.iconInfo.isDefaultIcon();
        }
        return false;
    }

    private Dimension computeScaledDimension(int n, int n2, int n3, int n4) {
        float f = (float)n3 / (float)n;
        float f2 = (float)n4 / (float)n2;
        float f3 = f > f2 ? f : f2;
        return new Dimension((int)((float)n3 / f3), (int)((float)n4 / f3));
    }

    public void cleanup() {
        this.image = null;
        this.iconInfo = null;
        this.tokenListener.clear();
    }
}

