/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.base.swing.studystatus.IStudyStatusHandler;
import com.agfa.pacs.base.swing.studystatus.IStudyStatusNotification;
import com.agfa.pacs.base.swing.studystatus.StudyStatusUtilties;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.data.dicom.device.DicomDeviceFactory;
import com.agfa.pacs.data.lw.datainfo.impl.StudyInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.valuemapping.ISUVStudyData;
import com.agfa.pacs.impaxee.PerformanceProfiler;
import com.agfa.pacs.impaxee.attributefilter.AttributeFilterRegistry;
import com.agfa.pacs.impaxee.glue.data.ImpaxEENonLeafDataObject;
import com.agfa.pacs.impaxee.glue.data.ImpaxEESeriesData;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.listtext.dicomobject.presentationstate.FramePresentationStateProviderContainer;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.base.data.IStudyStatusListener;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class ImpaxEEStudyData
extends ImpaxEENonLeafDataObject<IStudyInfo>
implements IStudyData {
    private static final int[] studyTags = DicomTag.extractTags((List)AttributeFilterRegistry.getInstance().getStudyDicomTags());
    private List<ISeriesData> series = new CopyOnWriteArrayList<ISeriesData>();
    private IPatientData parent;
    private FramePresentationStateProviderContainer presentationStateContainer = new FramePresentationStateProviderContainer(overlayDataFactory);
    private IStudyStatusHandler statusHandler;
    private StudyStateListener statusListener = null;
    private List<IStudyStatusListener> listeners;
    private int numberOfAvailImages;
    private boolean studyMonitoring = true;
    private String studyUID;
    private ISUVStudyData suvData;

    public ImpaxEEStudyData(IStudyInfo iStudyInfo) {
        this(iStudyInfo, -1);
    }

    public ImpaxEEStudyData(IStudyInfo iStudyInfo, int n) {
        this(iStudyInfo, true, n);
    }

    public ImpaxEEStudyData(IStudyInfo iStudyInfo, boolean bl) {
        this(iStudyInfo, bl, -1);
    }

    public ImpaxEEStudyData(IStudyInfo iStudyInfo, boolean bl, int n) {
        super(iStudyInfo);
        this.numberOfAvailImages = n;
        if (bl) {
            this.statusListener = new StudyStateListener();
            this.statusHandler = StudyStatusUtilties.getStudyStatusHandler(this.getDataInfo(), (IStudyStatusNotification)this.statusListener, (boolean)true);
            this.listeners = new CopyOnWriteArrayList<IStudyStatusListener>();
        }
        this.studyUID = iStudyInfo.getString(0x20000D);
    }

    public String getStudyInstanceUID() {
        return this.studyUID;
    }

    public String[] getModalitiesInStudy() {
        String string;
        String[] stringArray = ((IStudyInfo)this.getDataInfo()).getAttributes().getStrings(524385);
        if ((stringArray == null || stringArray.length == 0) && (string = this.resolveString(524384)) != null) {
            stringArray = new String[]{string};
        }
        return stringArray;
    }

    public boolean includeInStudyMonitoring() {
        return this.studyMonitoring;
    }

    public void removeFromStudyMonitoring() {
        this.studyMonitoring = false;
    }

    public int getNumberOfAvailableImages() {
        return this.numberOfAvailImages;
    }

    public int getNumberOfLoadedFrames() {
        int n = 0;
        for (ISeriesData iSeriesData : this.series) {
            if (!iSeriesData.isImageSeries()) continue;
            n += iSeriesData.getNumberOfFrames();
        }
        return n;
    }

    public int getNumberOfLoadedImages() {
        int n = 0;
        for (ISeriesData iSeriesData : this.series) {
            List list;
            if (!iSeriesData.isImageSeries() || (list = iSeriesData.getObjects()) == null) continue;
            n += list.size();
        }
        return n;
    }

    public synchronized void addSeries(ISeriesData iSeriesData) {
        if (!this.series.contains(iSeriesData)) {
            iSeriesData.setParent((IStudyData)this);
            this.series.add(iSeriesData);
        }
    }

    public IDataObject removeSeries(ISeriesData iSeriesData) {
        ISeriesData iSeriesData2 = this.series.remove(iSeriesData) ? iSeriesData : null;
        iSeriesData.cleanUp();
        if (this.getImageSeriesCount() == 0) {
            iSeriesData2 = this.getParent().removeStudy((IStudyData)this);
        }
        return iSeriesData2;
    }

    private int getImageSeriesCount() {
        int n = 0;
        for (ISeriesData iSeriesData : this.series) {
            if (!iSeriesData.isImageSeries()) continue;
            ++n;
        }
        return n;
    }

    public List<ISeriesData> getSeries() {
        return Collections.unmodifiableList(this.series);
    }

    public void setParent(IPatientData iPatientData) {
        this.parent = iPatientData;
    }

    public IPatientData getParent() {
        return this.parent;
    }

    public FramePresentationStateProviderContainer getFramePresentationStateProviderContainer() {
        return this.presentationStateContainer;
    }

    public boolean isStudyLoaded() {
        for (ISeriesData iSeriesData : this.series) {
            if (iSeriesData.isSeriesLoaded()) continue;
            return false;
        }
        return true;
    }

    public ISeriesData createSeriesData(String string) {
        Object u = this.getDataInfo();
        ISeriesInfo iSeriesInfo = ((IStudyInfo)this.getDataInfo()).createSeries(string);
        if ("PR".equals(string)) {
            iSeriesInfo.getAttributes().setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.11.1");
        } else if ("KO".equals(string)) {
            iSeriesInfo.getAttributes().setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.59");
        } else if ("SR".equals(string)) {
            iSeriesInfo.getAttributes().setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.11");
        }
        Attributes attributes = DicomDeviceFactory.getDeviceInfo();
        if (attributes != null) {
            iSeriesInfo.getAttributes().addAll(attributes);
        }
        ImpaxEESeriesData impaxEESeriesData = new ImpaxEESeriesData(iSeriesInfo, true);
        this.addSeries(impaxEESeriesData);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (u.containsValue(524385)) {
            arrayList.addAll(Arrays.asList(u.getString(524385)));
        }
        if (!arrayList.contains(string)) {
            arrayList.add(string);
            if (u instanceof StudyInfo) {
                ((StudyInfo)u).duplicateData();
            }
            u.getAttributes().setString(524385, VR.CS, arrayList.toArray(new String[0]));
        }
        return impaxEESeriesData;
    }

    public boolean isSeen() {
        if (this.statusHandler != null) {
            List list = this.statusHandler.getCurrentStatus();
            return list.contains(IStudyStatusHandler.StudyStatus.Seen);
        }
        return false;
    }

    public boolean isDiagnosed() {
        if (this.statusHandler != null) {
            List list = this.statusHandler.getCurrentStatus();
            return list.contains(IStudyStatusHandler.StudyStatus.Approved) || list.contains(IStudyStatusHandler.StudyStatus.Dictated);
        }
        return false;
    }

    public List<Action> getAvailableNewStudyStates() {
        if (this.statusHandler != null) {
            return this.statusHandler.getAvailableTransitions();
        }
        return null;
    }

    public ISeriesData getSeries(String string) {
        for (ISeriesData iSeriesData : this.series) {
            if (!iSeriesData.getKey().equals(string)) continue;
            return iSeriesData;
        }
        return null;
    }

    @Override
    public String resolveString(int n) {
        if (PrivateTagDictionary.isPrivateTag((int)n)) {
            if (PrivateTagDictionary.studyLoadOrderTag == n) {
                IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
                if (iHanging == null) {
                    return null;
                }
                IStudyContainer iStudyContainer = iHanging.getStudyContainer();
                if (iStudyContainer == null) {
                    return null;
                }
                return iStudyContainer.getIndexStringOfStudy(this.getStudyInstanceUID());
            }
            if (PrivateTagDictionary.studyLoadOrderReverseTag == n) {
                IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
                if (iHanging == null) {
                    return null;
                }
                IStudyContainer iStudyContainer = iHanging.getStudyContainer();
                if (iStudyContainer == null) {
                    return null;
                }
                int n2 = iStudyContainer.getIndexOfStudy(this.getStudyInstanceUID());
                return Integer.toString(iStudyContainer.getLoadedPriorCount() - n2);
            }
            if (PrivateTagDictionary.studyNumberOfImagesTag == n) {
                return Integer.toString(this.getNumberOfLoadedFrames());
            }
            if (PrivateTagDictionary.seriesNumberOfImagesTag == n) {
                return Integer.toString(this.getMaxSeriesNumberOfImages());
            }
            if (PrivateTagDictionary.imageAreaNumberOfScreensTag == n) {
                return Integer.toString(JVision2.getMainFrame().getScreens().size());
            }
            if (PrivateTagDictionary.patientNumberOfLoadedStudiesTag == n) {
                return Integer.toString(this.parent.getStudies().size());
            }
        }
        return super.resolveString(n);
    }

    private int getMaxSeriesNumberOfImages() {
        int n = 0;
        for (ISeriesData iSeriesData : this.series) {
            int n2;
            if (!iSeriesData.isImageSeries() || (n2 = iSeriesData.getNumberOfFrames()) <= n) continue;
            n = n2;
        }
        return n;
    }

    public void addListener(IStudyStatusListener iStudyStatusListener) {
        this.listeners.add(iStudyStatusListener);
    }

    public void removeListener(IStudyStatusListener iStudyStatusListener) {
        this.listeners.remove(iStudyStatusListener);
    }

    public void cleanUp() {
        if (log.isTraceEnabled()) {
            log.trace("Cleaning up references in instance of " + this.getClass().getName() + ": " + this.getKey());
        }
        Iterator<ISeriesData> iterator = this.series.iterator();
        while (iterator.hasNext()) {
            iterator.next().cleanUp();
        }
        this.series.clear();
        this.presentationStateContainer = new FramePresentationStateProviderContainer(overlayDataFactory);
        if (this.statusHandler != null) {
            this.statusHandler.destroy((IStudyStatusNotification)this.statusListener);
            this.statusHandler = null;
            this.statusListener = null;
        }
        this.listeners.clear();
    }

    public void dispose() {
        ((IStudyInfo)this.dataInfo).dispose();
    }

    public String getModality() {
        return null;
    }

    public String getSeriesDescription() {
        return null;
    }

    public void setSUVData(ISUVStudyData iSUVStudyData) {
        this.suvData = iSUVStudyData;
    }

    public ISUVStudyData getSUVData() {
        return this.suvData;
    }

    public void notifySeriesLoaded() {
        if (this.isStudyLoaded()) {
            if (PerformanceProfiler.active) {
                int n = 0;
                for (ISeriesData iSeriesData : this.series) {
                    n += iSeriesData.getObjectCount();
                }
                PerformanceProfiler.getInstance().setStudyLoaded(this.studyUID, n);
            }
            this.parent.notifyStudyLoaded();
        }
    }

    @Override
    public void setDicomObject(Attributes attributes) {
        Attributes attributes2 = new Attributes();
        attributes2.addSelected(attributes, studyTags);
        attributes2.addAll(this.dicomObject);
        this.dicomObject = attributes2;
        this.headerComplete = true;
    }

    class StudyStateListener
    implements IStudyStatusNotification {
        StudyStateListener() {
        }

        public void closeStudy() {
            this.notifyListeners();
        }

        public void updateView() {
            this.notifyListeners();
        }

        private void notifyListeners() {
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (IStudyStatusListener iStudyStatusListener : ImpaxEEStudyData.this.listeners) {
                        iStudyStatusListener.studyStateChanged((IStudyData)ImpaxEEStudyData.this);
                    }
                }
            });
        }
    }
}

