/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.glue.cycling.Messages;
import com.agfa.pacs.impaxee.glue.data.AbstractImageObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEFrameObjectData;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.tiani.base.data.IFrameObjectData;
import org.dcm4che3.data.Attributes;

public class ImpaxEESingleFrameData
extends AbstractImageObjectData {
    private IFrameObjectData frame = new ImpaxEEFrameObjectData(this, 0);

    ImpaxEESingleFrameData(IObjectInfo iObjectInfo) {
        super(iObjectInfo);
    }

    public IFramePresentationState getFramePresentationState(int n, IPixelDataFrame iPixelDataFrame) {
        return this.frame.getFramePresentationState();
    }

    @Override
    protected synchronized void initFromCachedDicomObject(Attributes attributes) {
        super.initFromCachedDicomObject(attributes);
        if (Math.max(1, attributes.getInt(0x280008, 0)) != this.getFrameCount()) {
            ImpaxEEUtils.handleDisplayProblem((String)this.getSOPInstanceUID(), (String)Messages.getString("ImpaxEEImageObjectData.NumberFramesMismatch"));
        }
    }

    @Override
    public IFrameObjectData getFrame(int n) {
        return this.frame;
    }

    @Override
    public int getFrameCount() {
        return 1;
    }

    @Override
    public void setFrame(IPixelDataFrame iPixelDataFrame, int n) {
        super.setFrame(iPixelDataFrame, n);
        this.loadState = 4;
    }

    @Override
    public boolean isMultiframe() {
        return false;
    }

    public IFrameObjectData[] frames() {
        return new IFrameObjectData[]{this.frame};
    }

    public IFrameObjectData getFirstFrame() {
        return this.frame;
    }

    @Override
    public boolean storeToCache() {
        if (super.storeToCache()) {
            this.frame.storeToCache();
            return true;
        }
        return false;
    }
}

