/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.glue.cycling.Messages;
import com.agfa.pacs.impaxee.glue.data.AbstractImageObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEFrameObjectData;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.tiani.base.data.IFrameObjectData;
import org.dcm4che3.data.Attributes;

public class ImpaxEEImageObjectData
extends AbstractImageObjectData {
    protected IFrameObjectData[] frames = null;
    private boolean isFrameCountCheckEnabled = true;

    ImpaxEEImageObjectData(IObjectInfo iObjectInfo) {
        super(iObjectInfo);
    }

    ImpaxEEImageObjectData(IObjectInfo iObjectInfo, int n) {
        this(iObjectInfo, n, true);
    }

    protected ImpaxEEImageObjectData(IObjectInfo iObjectInfo, int n, boolean bl) {
        this(iObjectInfo);
        this.isFrameCountCheckEnabled = bl;
        this.init(n);
    }

    protected IFrameObjectData createFrameObject(int n) {
        return new ImpaxEEFrameObjectData(this, n);
    }

    protected void init(int n) {
        this.frames = new IFrameObjectData[n];
        int n2 = 0;
        while (n2 < n) {
            this.frames[n2] = this.createFrameObject(n2);
            ++n2;
        }
    }

    public IFramePresentationState getFramePresentationState(int n, IPixelDataFrame iPixelDataFrame) {
        return this.frames[n].getFramePresentationState();
    }

    @Override
    protected synchronized void initFromCachedDicomObject(Attributes attributes) {
        super.initFromCachedDicomObject(attributes);
        if (this.isFrameCountCheckEnabled && Math.max(1, attributes.getInt(0x280008, 0)) != this.getFrameCount()) {
            ImpaxEEUtils.handleDisplayProblem((String)this.getSOPInstanceUID(), (String)Messages.getString("ImpaxEEImageObjectData.NumberFramesMismatch"));
        }
    }

    @Override
    public IFrameObjectData getFrame(int n) {
        return this.frames[n];
    }

    @Override
    public int getFrameCount() {
        return this.frames.length;
    }

    @Override
    public boolean isMultiframe() {
        return this.frames.length > 1;
    }

    public IFrameObjectData[] frames() {
        return this.frames;
    }

    public IFrameObjectData getFirstFrame() {
        return this.frames[0];
    }

    @Override
    public boolean storeToCache() {
        if (super.storeToCache()) {
            if (this.frames != null) {
                IFrameObjectData[] iFrameObjectDataArray = this.frames;
                int n = this.frames.length;
                int n2 = 0;
                while (n2 < n) {
                    IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n2];
                    iFrameObjectData.storeToCache();
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }
}

