/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.data.EnhancedSliceFrameObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEImageObjectData;
import com.tiani.base.data.IFrameObjectData;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class EnhancedImpaxEEImageObject
extends ImpaxEEImageObjectData {
    private static IFetcher fetcher = DataManager.getInstance().getFetcher();
    private boolean allowPerFrameDownload = false;

    EnhancedImpaxEEImageObject(IObjectInfo iObjectInfo, int n) {
        super(iObjectInfo);
        String string;
        if (iObjectInfo.getInstanceInfo() != null && ((string = iObjectInfo.getInstanceInfo().getType()).equals("CGET") || string.equals("WADO_EE"))) {
            this.allowPerFrameDownload = true;
        }
        this.init(n);
    }

    @Override
    protected IFrameObjectData createFrameObject(int n) {
        EnhancedSliceFrameObjectData enhancedSliceFrameObjectData = new EnhancedSliceFrameObjectData(this, this.getPerFrameGroup(this.getDicomObject(), n), n);
        if (!this.allowPerFrameDownload) {
            enhancedSliceFrameObjectData.setDoNotDownloadPerFrame();
        }
        return enhancedSliceFrameObjectData;
    }

    @Override
    protected synchronized void initFromCachedDicomObject(Attributes attributes) {
        super.initFromCachedDicomObject(attributes);
        int n = 0;
        while (n < this.frames.length) {
            ((EnhancedSliceFrameObjectData)this.frames[n]).update(attributes, this.getPerFrameGroup(attributes, n));
            ++n;
        }
        this.loadState = 3;
    }

    void pixelDataAvailableFromSlice(String string, IPixelDataInfo iPixelDataInfo, int n) {
        super.pixelDataAvailable(string, iPixelDataInfo, n);
    }

    @Override
    public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
        ILoadableInfo iLoadableInfo = ((EnhancedSliceFrameObjectData)this.frames[n]).wasLoadedSeparately();
        if (iLoadableInfo != null) {
            fetcher.cancelRequest(iLoadableInfo);
        }
        super.pixelDataAvailable(string, iPixelDataInfo, n);
    }

    private Attributes getPerFrameGroup(Attributes attributes, int n) {
        Sequence sequence = attributes.getSequence(1375769136);
        if (sequence == null) {
            return null;
        }
        return (Attributes)sequence.get(n);
    }
}

