/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.base.swing.hardware.HardwareRestrictions;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrameProvider;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PixelDataFrameUtilities;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.IUndoInformation;
import com.agfa.pacs.event.ListenerSynchronizationFactory;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.fetcher.IFetchable;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.cycling.Messages;
import com.agfa.pacs.impaxee.glue.data.EnhancedImpaxEEImageObject;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEImageObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEESingleFrameData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEUSVolumeObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEVideoObjectData;
import com.agfa.pacs.impaxee.glue.data.NMImageObjectData;
import com.agfa.pacs.listtext.lta.util.primitives.ArrayIntList;
import com.agfa.pacs.listtext.lta.util.primitives.IntList;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.HierarchicalAttributes;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IObjectListener;
import com.tiani.base.data.ImageInformation2;
import com.tiani.base.data.RawDataContainer16CT;
import com.tiani.base.data.RawDataContainer16NM;
import com.tiani.base.data.RawDataContainer3x8;
import com.tiani.base.data.RawDataContainer8CT;
import com.tiani.base.data.RawDataContainer8NM;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public abstract class AbstractImageObjectData
extends ImpaxEEObjectData
implements IImageObjectData {
    private static final Set<String> MULTIFRAME_SOP_CLASSES = new HashSet<String>();
    private static final int LARGE_IMAGE = 1500000;
    private static final int VERY_LARGE_IMAGE = 30000000;
    private static final DecoderListener decoderListener = new DecoderListener();
    private static final String DECODE_EVENT_NAME = "DECODE_EVENT_IA";
    private static final int DECODING_EVENT = EventEngineFactory.getInstance().getEventID("DECODE_EVENT_IA");
    private static final IFetcher FETCHER = DataManager.getInstance().getFetcher();
    private static final boolean filterPrivateTags = Config.impaxee.workstation.FilterPrivateTags.get() && !HardwareRestrictions.isHardwarePresent((String)"TOMTEC") && !LicenseManager.getInstance().isLicenseIDSupported("ORTHOGON");
    private static final int SIZE_OF_PRIVATE_TAG_TO_FILTER = 128;
    private Attributes dataInfoDicomObject;
    private CachedDicomObject dicomObject;
    private long updateTimeStamp = -1L;
    private volatile boolean isPrefetchingLossyImageEnabled = true;

    static {
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.2.1");
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.4.1");
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.13.1.3");
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.77.1.5.4");
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.13.1.1");
        MULTIFRAME_SOP_CLASSES.add("1.2.840.10008.5.1.4.1.1.13.1.2");
    }

    public static AbstractImageObjectData createObjectData(IObjectInfo iObjectInfo, String string, UIDType uIDType) {
        if (uIDType == UIDType.Video) {
            return new ImpaxEEVideoObjectData(iObjectInfo);
        }
        if (uIDType == UIDType.USVolume) {
            return new ImpaxEEUSVolumeObjectData(iObjectInfo);
        }
        int n = Math.max(1, iObjectInfo.getInt(0x280008));
        if (MULTIFRAME_SOP_CLASSES.contains(string)) {
            return new EnhancedImpaxEEImageObject(iObjectInfo, n);
        }
        IImageInformation.ImageClass imageClass = ImageInformation2.getImageClass((String)string);
        if (IImageInformation.ImageClass.NM.equals((Object)imageClass)) {
            return new NMImageObjectData(iObjectInfo, n);
        }
        if (n > 1) {
            return new ImpaxEEImageObjectData(iObjectInfo, n);
        }
        return new ImpaxEESingleFrameData(iObjectInfo);
    }

    public static AbstractImageObjectData createObjectData(IObjectInfo iObjectInfo) {
        String string = iObjectInfo.getSOPClassUID();
        return AbstractImageObjectData.createObjectData(iObjectInfo, string, UIDUtilities.getBaseType((String)string));
    }

    public long getObjectUpdateTimestamp() {
        return this.updateTimeStamp;
    }

    @Override
    protected void replaceBySmallCopy(Attributes attributes) {
        Attributes attributes2 = ((IObjectInfo)this.dataInfo).getAttributes();
        Attributes attributes3 = new Attributes(attributes2, new int[]{524310, 524312, 4325394});
        attributes3.addSelected(attributes, new int[]{131088});
        ((IObjectInfo)this.dataInfo).setAttributes(attributes3);
    }

    public AbstractImageObjectData(IObjectInfo iObjectInfo) {
        super(iObjectInfo);
        try {
            Date date = iObjectInfo.getAttributes().getDate("dcm4che/archive", 4390934);
            if (date != null) {
                this.updateTimeStamp = date.getTime();
            }
        }
        catch (Exception exception) {
            ALogger.getLogger(AbstractImageObjectData.class).warn("Could not parse server timestamp", (Throwable)exception);
        }
        this.dataInfoDicomObject = new HierarchicalAttributes((IDataInfo)iObjectInfo);
    }

    public abstract IFrameObjectData getFrame(int var1);

    public abstract int getFrameCount();

    public abstract boolean isMultiframe();

    public boolean isPrefetchingLossyImageEnabled() {
        return this.isPrefetchingLossyImageEnabled && this.getParent().getParent().getParent().isPrefetchingLossyImagesEnabled();
    }

    public synchronized void requestDownloadOfLosslessImage(byte by) {
        if (this.isPrefetchingLossyImageEnabled) {
            this.isPrefetchingLossyImageEnabled = false;
            this.addListener(new LossyObjectListener(by));
            FETCHER.changeToHigherPriorityIfExists((IFetchable)this, by);
        }
    }

    @Override
    public Attributes getDicomObject() {
        Attributes attributes = this.dataInfoDicomObject;
        if (attributes == null) {
            return this.dicomObject.getDelegate();
        }
        return attributes;
    }

    @Override
    public IObjectInfo getFullDataInfo() {
        IObjectInfo iObjectInfo = (IObjectInfo)((IObjectInfo)this.dataInfo).copy(true);
        if (this.dicomObject != null) {
            iObjectInfo.getAttributes().addAll(this.dicomObject.getDelegate());
        }
        return iObjectInfo;
    }

    @Override
    public void setDicomObject(Attributes attributes) {
        this.dicomObject = new CachedDicomObject(attributes);
        this.dataInfoDicomObject = null;
    }

    @Override
    public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
        IFrameObjectData iFrameObjectData = this.getFrame(n);
        if (iFrameObjectData.getRawDataContainer() != null) {
            if (iFrameObjectData.isBeingLossyPrefetched() && !((Boolean)iPixelDataInfo.getDescription().getProperty("LOSSY", (Object)Boolean.FALSE)).booleanValue()) {
                iFrameObjectData.resetFramePresentationState();
            } else {
                return;
            }
        }
        IPixelDataFrame iPixelDataFrame = PixelDataFrameUtilities.createPixelDataFrame((IPixelDataFrameProvider)PixelDataFrameUtilities.DefaultPixelDataFrameProvider, (IPixelDataInfo)iPixelDataInfo, (String)string);
        this.setFrame(iFrameObjectData, iPixelDataFrame);
    }

    @Override
    public void dicomDataError(String string, String string2, Throwable throwable) {
        super.dicomDataError(string, string2, throwable);
        if (string2 == null) {
            string2 = throwable.toString();
        }
        int n = 0;
        while (n < this.getFrameCount()) {
            this.getFrame(n).setHasError(string2);
            ++n;
        }
    }

    @Override
    public boolean storeToCache() {
        this.listeners = null;
        if (cacheSupportsMetadata && this.loadState >= 2) {
            this.dicomObject.putToCache();
            super.storeToCache();
            return true;
        }
        return false;
    }

    public void setFrame(IPixelDataFrame iPixelDataFrame, int n) {
        this.setFrame(this.getFrame(n), iPixelDataFrame);
    }

    private void setFrame(IFrameObjectData iFrameObjectData, IPixelDataFrame iPixelDataFrame) {
        IImagePixel iImagePixel;
        int n;
        boolean bl;
        String string;
        Object object = null;
        Class clazz = iPixelDataFrame.getPixelDataClass();
        if (clazz == byte[].class) {
            string = this.getSOPClassUID();
            object = "1.2.840.10008.5.1.4.1.1.20".equals(string) || "1.2.840.10008.5.1.4.1.1.5".equals(string) || "1.2.840.10008.5.1.4.1.1.128".equals(string) ? new RawDataContainer8NM(iPixelDataFrame) : new RawDataContainer8CT(iPixelDataFrame);
        }
        if (clazz == short[].class) {
            string = this.getSOPClassUID();
            object = "1.2.840.10008.5.1.4.1.1.20".equals(string) || "1.2.840.10008.5.1.4.1.1.5".equals(string) || "1.2.840.10008.5.1.4.1.1.128".equals(string) ? new RawDataContainer16NM(iPixelDataFrame) : new RawDataContainer16CT(iPixelDataFrame);
        }
        if (clazz == int[].class) {
            object = new RawDataContainer3x8(iPixelDataFrame);
        }
        if (!(bl = iFrameObjectData.setRawDataContainer(object)) && (n = (iImagePixel = iPixelDataFrame.getImagePixel()).getColumns() * iImagePixel.getRows()) > 1500000 && n < 30000000 && this.getFrameCount() == 1) {
            decoderListener.sendDecodingEvent(iPixelDataFrame);
        }
    }

    private class CachedDicomObject {
        private volatile Attributes myDelegate;

        public CachedDicomObject(Attributes attributes) {
            this.myDelegate = this.filterOutPrivateTags(attributes);
        }

        public Attributes getDelegate() {
            Attributes attributes = this.myDelegate;
            if (attributes != null) {
                return attributes;
            }
            this.getFromCache();
            return this.myDelegate;
        }

        public void putToCache() {
            this.myDelegate = null;
        }

        private synchronized void getFromCache() {
            if (this.myDelegate != null) {
                return;
            }
            String string = AbstractImageObjectData.this.getParent().getParent().getStudyInstanceUID();
            try {
                this.myDelegate = this.filterOutPrivateTags(dicomCache.getDataset(string, AbstractImageObjectData.this.getSOPInstanceUID()));
            }
            catch (Throwable throwable) {
                log.error("Cache problem", throwable);
                ImpaxEEUtils.handleProblem((String)Messages.getString("AbstractImageObjectData.CacheProblem"), (String)Messages.getString("AbstractImageObjectData.CacheProblemExplanation"), (boolean)true);
            }
        }

        private Attributes filterOutPrivateTags(Attributes attributes) {
            if (filterPrivateTags) {
                DeleteLargePrivateTags deleteLargePrivateTags = new DeleteLargePrivateTags();
                attributes.accept((Attributes.Visitor)deleteLargePrivateTags, false);
                IntList intList = deleteLargePrivateTags.getTags2delete();
                if (intList != null) {
                    int n = 0;
                    while (n < intList.size()) {
                        attributes.remove(intList.get(n));
                        ++n;
                    }
                }
                return attributes;
            }
            return attributes;
        }
    }

    private static class DecoderListener
    implements IEventListener {
        private IListenerSynchronization sync = ListenerSynchronizationFactory.getInstance();
        private IEventEngine engine = EventEngineFactory.getInstance();
        private final IEventListenerProvider<IEventListener> decodingListener = EventEngineFactory.getInstance().createListenerProvider((IEventListener)this);

        private DecoderListener() {
        }

        public IListenerSynchronization getSync() {
            return this.sync;
        }

        public void sendDecodingEvent(IPixelDataFrame<?> iPixelDataFrame) {
            IEvent iEvent = this.engine.createInternalEvent(DECODING_EVENT);
            iEvent.setDestination(this.decodingListener);
            iEvent.setSource((Object)this);
            iEvent.setPayload(new WeakReference(iPixelDataFrame));
            iEvent.setActionInfo(ActionInfo.SINGLE);
            this.engine.sendEvent(iEvent);
        }

        public boolean handleEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
            WeakReference weakReference;
            IPixelDataFrame iPixelDataFrame;
            if (iEvent.getEventID() == DECODING_EVENT && (iPixelDataFrame = (IPixelDataFrame)(weakReference = (WeakReference)iEvent.getPayload()).get()) != null) {
                iPixelDataFrame.decodeData();
            }
            return false;
        }

        public boolean handleUndoEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
            return false;
        }
    }

    private static class DeleteLargePrivateTags
    implements Attributes.Visitor {
        private IntList tags2delete;

        private DeleteLargePrivateTags() {
        }

        public boolean visit(Attributes attributes, int n, VR vR, Object object) {
            if (TagUtils.isPrivateGroup((int)n) && object != null && object instanceof byte[] && ((byte[])object).length > 128) {
                if (this.tags2delete == null) {
                    this.tags2delete = new ArrayIntList();
                }
                this.tags2delete.add(n);
            }
            return true;
        }

        public IntList getTags2delete() {
            return this.tags2delete;
        }
    }

    private class LossyObjectListener
    implements IObjectListener {
        private final byte priority;

        public LossyObjectListener(byte by) {
            this.priority = by;
        }

        public void lossyObjectFinished(IObjectData iObjectData) {
            AbstractImageObjectData.this.getParent().decreaseLoadedObjectCount();
            AbstractImageObjectData.this.resetLoadState();
            FETCHER.appendData(Collections.singletonList(AbstractImageObjectData.this), this.priority);
        }

        public void objectFinished(IObjectData iObjectData) {
        }
    }
}

