/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.cycling;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.PatientMergeUtilities;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.data.shared.data.DicomDataListenerAdapter;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.WaitDicomDataFinished;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.hw.IDicomDataRequester;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.cycling.ImpaxEECycleListProvider;
import com.agfa.pacs.impaxee.glue.data.AbstractImageObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEKeyObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEPatientData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEESeriesData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyContainer;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyData;
import com.agfa.pacs.impaxee.glue.data.composite.CompositeObjectDataFactoryProvider;
import com.agfa.pacs.impaxee.glue.data.composite.ICompositeObjectData;
import com.agfa.pacs.impaxee.glue.data.composite.ICompositeObjectDataFactory;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.sessions.SessionBuilder;
import com.agfa.pacs.impaxee.splitsort.ReverseStudyDateComparator;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.cycling.RelevancyManager;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObjectException;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObjectFactory;
import com.agfa.pacs.listtext.dicomobject.iod.ps.SoftcopyPresentationStateInformationObject;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotation;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotationModule;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import com.agfa.pacs.listtext.lta.priors.IRelevancyListener;
import com.agfa.pacs.listtext.lta.util.Modality;
import com.agfa.pacs.listtext.lta.util.referencedobject.KeyObjectParser;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.agfa.pacs.tools.IDisposable;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;

public class LoadRequest {
    private static final ALogger log = ALogger.getLogger(LoadRequest.class);
    private static final DataManager dm = DataManager.getInstance();
    private static final IDicomCache dicomCache = DicomCacheFactory.getInstance().getDicomCache();
    private static final IDataInfoNode mpiArchive = Base.getMasterDataNode();
    private Map<String, IImageObjectData> objects = new HashMap<String, IImageObjectData>(256);
    private Map<String, ISeriesData> seq = new HashMap<String, ISeriesData>(64);
    private Map<String, IStudyInfo> studies = new LinkedHashMap<String, IStudyInfo>();
    private Map<String, IStudyData> sty = new LinkedHashMap<String, IStudyData>();
    private Map<String, IPatientData> pat = new HashMap<String, IPatientData>();
    private Set<String> newStudies = new HashSet<String>();
    private List<IObjectInfo> preLoadSessionObjects = new ArrayList<IObjectInfo>(8);
    private List<IObjectInfo> preLoadKOObjects = new ArrayList<IObjectInfo>(8);
    private List<IObjectInfo> preLoadPresentationObjects = new ArrayList<IObjectInfo>();
    private final Map<IObjectInfo, ICompositeObjectDataFactory> preLoadCompositeObjects = new HashMap<IObjectInfo, ICompositeObjectDataFactory>();
    private BlockingQueue<Runnable> sessions = null;
    private Set<String> sessionBaseStudies;
    private Set<String> sessionPriorStudies;
    private SessionBuilder lastSession = null;
    private WaitDicomDataFinished waitForHeaders = new WaitDicomDataFinished();
    private Semaphore priorSemaphore = new Semaphore(0);
    private boolean loadPrior;
    private boolean supressEvidenceDocuments = false;
    private Set<String> blindStudies;
    private int numberSupressedDocuments = 0;
    private Object dropTarget = null;
    private boolean isDisplayedPatient = true;
    private String preferredHanging = null;

    public LoadRequest(boolean bl) {
        this.loadPrior = bl;
    }

    public void setDisplayedPatient(boolean bl) {
        this.isDisplayedPatient = bl;
    }

    public void setBlindReportedStudies(Set<String> set) {
        this.blindStudies = set;
        this.supressEvidenceDocuments = set != null && !set.isEmpty();
    }

    public String getPreferredHanging() {
        return this.preferredHanging;
    }

    public void setPreferredHanging(String string) {
        this.preferredHanging = string;
    }

    public void setLoadAsSingleDisplay(Object object) {
        this.dropTarget = object;
    }

    private void addObject(IObjectInfo iObjectInfo) {
        String string = iObjectInfo.getSOPClassUID();
        UIDType uIDType = UIDUtilities.getBaseType((String)string);
        IPatientData iPatientData = null;
        if (uIDType == null) {
            log.warn("Ignoring unknown object:{},{}", (Object)iObjectInfo.getKey(), (Object)string);
            return;
        }
        switch (uIDType) {
            case Image: 
            case Video: 
            case USVolume: {
                if (!UIDUtilities.isType((String)string, (UIDType)UIDType.ForProcessing)) {
                    if (this.supressEvidenceDocuments(iObjectInfo, string, uIDType)) {
                        return;
                    }
                    AbstractImageObjectData abstractImageObjectData = AbstractImageObjectData.createObjectData(iObjectInfo, string, uIDType);
                    this.addObject(iObjectInfo, abstractImageObjectData);
                    break;
                }
                log.debug("Skipping for processing image:" + iObjectInfo.getKey());
                break;
            }
            case Presentation: {
                if (this.supressEvidenceDocuments(iObjectInfo, string, uIDType)) {
                    return;
                }
                this.preLoadPresentationObjects.add(iObjectInfo);
                break;
            }
            case KeyObject: {
                if (KeyImageType.OfInterest.match(iObjectInfo) || KeyImageType.ForPrinting.match(iObjectInfo) || KeyImageType.ForConference.match(iObjectInfo)) {
                    if (this.supressEvidenceDocuments(iObjectInfo, string, uIDType)) {
                        return;
                    }
                    this.preLoadKOObjects.add(iObjectInfo);
                    break;
                }
                if (!ReferringObjectType.SESSION.match((IDataInfo)iObjectInfo)) break;
                this.preLoadSessionObjects.add(iObjectInfo);
                break;
            }
            case Composite: {
                iPatientData = this.getPatientData(iObjectInfo);
                for (ICompositeObjectDataFactory iCompositeObjectDataFactory : CompositeObjectDataFactoryProvider.getInstance().getFactories()) {
                    if (!iCompositeObjectDataFactory.supportsData(iPatientData, iObjectInfo)) continue;
                    this.preLoadCompositeObjects.put(iObjectInfo, iCompositeObjectDataFactory);
                    break;
                }
                if (iPatientData == null) break;
                iPatientData.addAdditionalObjects(iObjectInfo);
                break;
            }
            case StructuredReport: {
                Attributes attributes = iObjectInfo.getDicomObjectMerged();
                String string2 = attributes.getString(524400);
                if (!StringUtils.containsIgnoreCase((String)string2, (String)"AGFA") && !"1.2.840.10008.5.1.4.1.1.88.50".equals(iObjectInfo.getSOPClassUID()) || (iPatientData = this.getPatientData(iObjectInfo)) == null) break;
                iPatientData.addAdditionalObjects(iObjectInfo);
            }
        }
    }

    private boolean supressEvidenceDocuments(IObjectInfo iObjectInfo, String string, UIDType uIDType) {
        if (this.supressEvidenceDocuments && this.blindStudies.contains(iObjectInfo.getStudyUID())) {
            if (uIDType == UIDType.Image && !UIDUtilities.isType((String)string, (UIDType)UIDType.SecondaryCapture)) {
                return false;
            }
            if (CompareUtils.equals((Object)iObjectInfo.getString(0x181018), (Object)Product.getProductName()) || CompareUtils.equals((Object)iObjectInfo.getString(528528), (Object)Product.getProductName())) {
                ++this.numberSupressedDocuments;
                return true;
            }
        }
        return false;
    }

    private IPatientData getPatientData(IObjectInfo iObjectInfo) {
        IPatientInfo iPatientInfo = iObjectInfo.getPatient();
        this.checkCreatePatient(iPatientInfo);
        return this.pat.get(iPatientInfo.getKey());
    }

    void addObject(IObjectInfo iObjectInfo, IImageObjectData iImageObjectData) {
        IImageObjectData iImageObjectData2;
        ISeriesData iSeriesData;
        ISeriesInfo iSeriesInfo = (ISeriesInfo)iObjectInfo.getTreeParent();
        if (!this.seq.containsKey(iSeriesInfo.getKey())) {
            IPatientInfo iPatientInfo;
            iSeriesData = dm.getSerie(iSeriesInfo.getKey());
            if (iSeriesData == null) {
                iSeriesData = new ImpaxEESeriesData(iSeriesInfo, false);
            }
            this.seq.put(iSeriesInfo.getKey(), iSeriesData);
            iImageObjectData2 = (IStudyInfo)iSeriesInfo.getTreeParent();
            if (!this.sty.containsKey(iImageObjectData2.getKey())) {
                iPatientInfo = (IPatientInfo)iImageObjectData2.getTreeParent();
                this.checkCreatePatient(iPatientInfo);
                IPatientData iPatientData = this.pat.get(iPatientInfo.getKey());
                IStudyData iStudyData = dm.getStudy((IStudyInfo)iImageObjectData2, iPatientData);
                if (iStudyData == null) {
                    iStudyData = dm.createStudy((IStudyInfo)iImageObjectData2, iPatientData, this.getNumberOfAvailableImages((IStudyInfo)iImageObjectData2), ImpaxEEStudyData.class);
                    if (this.supressEvidenceDocuments && this.blindStudies.contains(iImageObjectData2.getKey())) {
                        ((ImpaxEEStudyData)iStudyData).removeFromStudyMonitoring();
                    }
                    this.newStudies.add(iImageObjectData2.getKey());
                }
                this.sty.put(iImageObjectData2.getKey(), iStudyData);
                this.studies.put(iImageObjectData2.getKey(), (IStudyInfo)iImageObjectData2);
            }
            iPatientInfo = this.sty.get(iImageObjectData2.getKey());
            iSeriesData.setParent((IStudyData)iPatientInfo);
            iPatientInfo.addSeries(iSeriesData);
        }
        if ((iImageObjectData2 = (iSeriesData = this.seq.get(iSeriesInfo.getKey())).addObject(iImageObjectData)) != null) {
            this.objects.put(iImageObjectData2.getSOPInstanceUID(), iImageObjectData2);
        }
    }

    void checkCreatePatient(IPatientInfo iPatientInfo) {
        if (!this.pat.containsKey(iPatientInfo.getKey())) {
            IPatientData iPatientData = dm.getLoadedPatientData(iPatientInfo.getKey());
            if (iPatientData == null) {
                iPatientData = dm.getSimilarPatient(iPatientInfo.getAttributes(), this.pat.values());
                if (iPatientData == null) {
                    iPatientData = dm.getMergedPatient(iPatientInfo.getKey());
                }
                if (iPatientData != null) {
                    PatientMergeUtilities.markPatientMerged((IPatientInfo)((IPatientInfo)((ImpaxEEPatientData)iPatientData).getDataInfo()), (IPatientInfo)iPatientInfo);
                    Config.impaxee.jvision.MAPPING.UseAnonymousMode.set((boolean)false);
                    dm.updatePatientInfo();
                }
            }
            if (iPatientData == null) {
                iPatientData = new ImpaxEEPatientData(iPatientInfo);
            } else {
                ImpaxEEPatientData impaxEEPatientData = (ImpaxEEPatientData)iPatientData;
                if (iPatientInfo.getAttributes().getProperty("MPI_QUERY", null) != null && ((IPatientInfo)impaxEEPatientData.getDataInfo()).getAttributes().getProperty("MPI_QUERY", null) == null) {
                    ((IPatientInfo)impaxEEPatientData.getDataInfo()).getAttributes().setProperty("MPI_QUERY", iPatientInfo.getAttributes().getProperty("MPI_QUERY", null));
                    dm.updatePatientInfo();
                }
            }
            this.pat.put(iPatientInfo.getKey(), iPatientData);
        }
    }

    public List<IStudyData> simpleLoad(List<IObjectInfo> list, boolean bl) {
        Object object32;
        boolean bl2 = false;
        if (bl) {
            try {
                object32 = ImpaxEECycleListProvider.getDataToLoad(list);
                List object2 = DataInfoUtilities.getLevel(object32, (Level)Level.Object);
                for (Object object : object2) {
                    this.addObject((IObjectInfo)object);
                }
            }
            catch (Exception exception) {
                log.error("Preferably loading key-images of prior study failed! Loading all images...", (Throwable)exception);
            }
        }
        if (!bl || bl2) {
            for (Object object32 : list) {
                this.addObject((IObjectInfo)object32);
            }
        }
        this.preLoad(this.preLoadKOObjects);
        this.preLoad(this.preLoadCompositeObjects.keySet());
        dm.addSeries(this.seq.values(), false, false);
        this.preLoad(this.preLoadPresentationObjects);
        object32 = new ArrayList<IStudyData>(this.sty.values());
        for (String string : this.newStudies) {
            IStudyData iStudyData = this.sty.get(string);
            if (iStudyData == null) continue;
            dm.studyAdded(iStudyData.getParent(), iStudyData);
        }
        this.cleanup();
        return object32;
    }

    public SessionBuilder loadData(Collection<IObjectInfo> collection) {
        if (this.dropTarget != null) {
            this.loadPrior = false;
        }
        for (IObjectInfo iStudyDataArray : collection) {
            this.addObject(iStudyDataArray);
        }
        if (this.pat.size() > 1) {
            throw new IllegalArgumentException("Only one patient per request allowed");
        }
        this.preLoad(this.preLoadCompositeObjects.keySet());
        for (IStudyInfo iStudyInfo : this.studies.values()) {
            dicomCache.registerStudyUsage(iStudyInfo.getKey(), (IDisposable)iStudyInfo);
        }
        this.preLoad(this.preLoadKOObjects);
        if (this.dropTarget != null) {
            dm.addSeriesAsSingleDisplaySet(this.seq.values(), this.dropTarget, true);
        } else {
            dm.addSeries(this.seq.values(), this.isDisplayedPatient, true);
        }
        this.preLoad(this.preLoadPresentationObjects);
        this.preLoad(this.preLoadSessionObjects);
        this.finishSessionLoading();
        for (String string : this.newStudies) {
            IStudyData iStudyData = this.sty.get(string);
            dm.studyAdded(iStudyData.getParent(), iStudyData);
        }
        this.removeOlderStudies();
        if (!this.sty.isEmpty()) {
            IStudyData iStudyData;
            if (this.loadPrior) {
                if (this.sty.size() > 0) {
                    List<IStudyInfo> list = this.getBaseStudies();
                    Collections.sort(list, DateTimeUtils.getStudyComparator());
                    iStudyData = new PriorListener(list);
                    try {
                        boolean bl = this.priorSemaphore.tryAcquire(45L, TimeUnit.SECONDS);
                        if (!bl) {
                            iStudyData.createContainersAfterTimeout();
                            log.warn("Priors not found in time");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        log.warn("Waiting for priors interrupted");
                    }
                }
            } else {
                IStudyData[] iStudyDataArray = this.sty.values().toArray(new IStudyData[this.sty.size()]);
                Arrays.sort(iStudyDataArray, ReverseStudyDateComparator.INSTANCE);
                IStudyData[] iStudyDataArray2 = iStudyDataArray;
                int n = iStudyDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPatientRepresentation iPatientRepresentation;
                    iStudyData = iStudyDataArray2[n2];
                    if (!this.isSessionPriorStudy(iStudyData.getStudyInstanceUID()) && (iPatientRepresentation = dm.getPatientRepresentation(iStudyData.getParent().getKey())) != null) {
                        ImpaxEEStudyContainer impaxEEStudyContainer = new ImpaxEEStudyContainer(iStudyData, this);
                        iPatientRepresentation.addStudyContainer((IStudyContainer)impaxEEStudyContainer);
                    }
                    ++n2;
                }
                if (this.sty.size() > 0) {
                    iStudyData = this.getBaseStudies();
                    RelevancyManager.getInstance().startSearchRelevant(null, iStudyData, this.isDisplayedPatient);
                    if (iStudyData.size() > 0 && this.isDisplayedPatient) {
                        RelevancyManager.getInstance().sendAsLoaded(iStudyData);
                    }
                }
            }
        }
        if (this.supressEvidenceDocuments && this.numberSupressedDocuments > 0) {
            log.info("Evidence objects were supressed:" + this.numberSupressedDocuments);
        }
        this.cleanup();
        return this.lastSession;
    }

    private void removeOlderStudies() {
        Iterator<IStudyData> iterator = this.sty.values().iterator();
        while (iterator.hasNext()) {
            IStudyData iStudyData = iterator.next();
            IPatientRepresentation iPatientRepresentation = dm.getPatientRepresentation(iStudyData.getParent().getKey());
            if (iPatientRepresentation == null || !iPatientRepresentation.hasContainerForStudy(iStudyData.getKey())) continue;
            iterator.remove();
        }
    }

    private List<IStudyInfo> getBaseStudies() {
        List list = DataInfoUtilities.cloneAndCutBelowStudies(this.studies.values());
        if (this.sessionBaseStudies != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IStudyInfo iStudyInfo = (IStudyInfo)iterator.next();
                String string = iStudyInfo.getStudyUID();
                if (!this.isSessionPriorStudy(string)) continue;
                iterator.remove();
            }
        }
        return list;
    }

    boolean isSessionPriorStudy(String string) {
        return this.sessionBaseStudies != null && !this.sessionBaseStudies.contains(string) && this.sessionPriorStudies.contains(string);
    }

    private IFrameObjectData[] getFramesOfImage(String string, String string2) {
        IObjectData iObjectData = (IObjectData)this.objects.get(string2);
        if (iObjectData != null) {
            if (iObjectData instanceof IImageObjectData) {
                return ((IImageObjectData)iObjectData).frames();
            }
        } else {
            IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(string);
            if (iPatientRepresentation != null) {
                return DataManager.getInstance().getFrameObjectData(string2, iPatientRepresentation);
            }
        }
        return new IFrameObjectData[0];
    }

    private void cleanup() {
        this.pat.clear();
        this.seq.clear();
        this.objects.clear();
        this.preLoadKOObjects.clear();
        this.preLoadPresentationObjects.clear();
        this.preLoadSessionObjects.clear();
        this.preLoadCompositeObjects.clear();
        this.dropTarget = null;
        this.newStudies.clear();
    }

    private int getNumberOfAvailableImages(IStudyInfo iStudyInfo) {
        if (!ImpaxEECycleListProvider.getInstance().getCycleListPreferences().isPreferredLoadingEnabled()) {
            return -1;
        }
        ArrayList<ISeriesInfo> arrayList = new ArrayList<ISeriesInfo>();
        if (iStudyInfo.childrenAvailable()) {
            arrayList.addAll(iStudyInfo.getSeries());
        }
        if (!iStudyInfo.containsValue(2101766) || iStudyInfo.getInt(2101766) > arrayList.size()) {
            IStudyInfo iStudyInfo2 = (IStudyInfo)iStudyInfo.copy(false);
            iStudyInfo2.resetChildren();
            List list = DataInfoUtilities.getLevel((IDataInfo)iStudyInfo2, ISeriesInfo.class);
            for (ISeriesInfo iSeriesInfo : list) {
                if (DataInfoUtilities.findEqual(arrayList, (IDataInfo)iSeriesInfo) != null) continue;
                arrayList.add(iSeriesInfo);
            }
        }
        int n = 0;
        for (ISeriesInfo iSeriesInfo : arrayList) {
            String string = iSeriesInfo.getString(524384);
            if (Modality.SR.dicom().equals(string) || Modality.PR.dicom().equals(string) || Modality.KO.dicom().equals(string)) continue;
            if (iSeriesInfo.containsValue(2101769)) {
                n += iSeriesInfo.getInt(2101769);
                continue;
            }
            n += iSeriesInfo.children().size();
        }
        return n;
    }

    public void preLoad(Collection<IObjectInfo> collection) {
        IDicomDataRequester iDicomDataRequester = DicomDataRequester.getInstance();
        ArrayList<IDicomDataRequest> arrayList = new ArrayList<IDicomDataRequest>(collection.size());
        for (IObjectInfo iObjectInfo : collection) {
            IDicomDataRequest iDicomDataRequest = iDicomDataRequester.createDicomDataRequest(iObjectInfo, (byte)0);
            iDicomDataRequest.setListener(this.waitForHeaders.addListener((IDicomDataListener)new PreLoadDicomDataListener(iObjectInfo)));
            iDicomDataRequest.setFromCache(false);
            arrayList.add(iDicomDataRequest);
        }
        iDicomDataRequester.addRequests(arrayList);
        this.waitForHeaders.waitUntilFinished();
        collection.clear();
    }

    private synchronized void addSession(SessionBuilder sessionBuilder) {
        if (this.sessions == null) {
            this.sessions = new LinkedBlockingQueue<Runnable>();
            this.sessionBaseStudies = new HashSet<String>();
            this.sessionPriorStudies = new HashSet<String>();
            new SessionLoader().start();
        }
        this.sessions.add((Runnable)sessionBuilder);
        String[] stringArray = sessionBuilder.getDataset().getStrings("TIANI", 2687060);
        if (stringArray != null && stringArray.length > 0) {
            this.sessionBaseStudies.add(stringArray[0]);
            int n = 1;
            while (n < stringArray.length) {
                this.sessionPriorStudies.add(stringArray[n]);
                ++n;
            }
        }
        if (this.lastSession == null) {
            this.lastSession = sessionBuilder;
        } else if (this.lastSession.getCreationDateTime().before(sessionBuilder.getCreationDateTime())) {
            this.lastSession = sessionBuilder;
        }
    }

    private synchronized void finishSessionLoading() {
        if (this.sessions != null) {
            this.sessions.add(new SessionTerminationElement());
        }
    }

    private class PreLoadDicomDataListener
    extends DicomDataListenerAdapter {
        private IObjectInfo objectInfo;
        private Attributes compositeDataset;
        private ICompositeObjectData compositeObjectData;

        public PreLoadDicomDataListener(IObjectInfo iObjectInfo) {
            this.objectInfo = iObjectInfo;
        }

        public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
            String string2 = attributes.getString(524310);
            if (UIDUtilities.isType((String)string2, (UIDType)UIDType.Presentation)) {
                try {
                    SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject = (SoftcopyPresentationStateInformationObject)DicomInformationObjectFactory.getInstance().createDicomInformationObject(attributes);
                    this.setSaved(softcopyPresentationStateInformationObject);
                    String string3 = attributes.getString(0x20000D);
                    IStudyData iStudyData = dm.getStudyByStudyInstanceUID(string3);
                    if (iStudyData != null) {
                        iStudyData.getFramePresentationStateProviderContainer().add(softcopyPresentationStateInformationObject, false);
                    }
                }
                catch (DicomInformationObjectException dicomInformationObjectException) {
                    log.error("Dicom Loading Problem", (Throwable)dicomInformationObjectException);
                }
                return;
            }
            if (UIDUtilities.isType((String)string2, (UIDType)UIDType.KeyObject)) {
                Code code = Code.create((Attributes)attributes, (int)4235331);
                if (CodeDictionary.KeyObjectSelectionDocumentTitle.JVisionSession.equals((Object)code)) {
                    String string4 = null;
                    IDataInfoSource iDataInfoSource = this.objectInfo.getSource();
                    if (iDataInfoSource instanceof IDataInfoNode) {
                        string4 = ((IDataInfoNode)iDataInfoSource).getIdentifier().getName();
                    }
                    SessionBuilder sessionBuilder = new SessionBuilder(string4, attributes, (IKeyObjectData)new ImpaxEEKeyObjectData(this.objectInfo), mpiArchive != null);
                    LoadRequest.this.addSession(sessionBuilder);
                } else if (KeyImageType.valueOf((Attributes)attributes) != null) {
                    KeyImageType keyImageType22;
                    int n = -1;
                    if (code != null && code.getCodingSchemeDesignator() != null && code.getCodingSchemeDesignator().equals(CodeDictionary.TianiKeyObjectSelectionDocumentTitle.ForConference.getCodingSchemeDesignator())) {
                        n = 0;
                    }
                    Map map = KeyObjectParser.getAllImageReferences((List)KeyObjectParser.getKOReferences((Attributes)attributes));
                    Map map2 = KeyObjectParser.getDetailedImageReferences((Attributes)attributes);
                    ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>(map.size());
                    String string5 = PatientKeyUtils.generatePatientKey((Attributes)attributes);
                    for (KeyImageType keyImageType22 : map.values()) {
                        IFrameObjectData[] iFrameObjectData = LoadRequest.this.getFramesOfImage(string5, keyImageType22.getSOPInstanceUID());
                        if (iFrameObjectData == null) continue;
                        if (iFrameObjectData.length == 1) {
                            arrayList.add(iFrameObjectData[0]);
                            continue;
                        }
                        SRReferencedImage sRReferencedImage = (SRReferencedImage)map2.get(keyImageType22.getSOPInstanceUID());
                        if (sRReferencedImage == null || sRReferencedImage.getReferencedFrameNumbers() == null || sRReferencedImage.getReferencedFrameNumbers().length == 0) {
                            arrayList.addAll(Arrays.asList(iFrameObjectData));
                            continue;
                        }
                        int[] nArray = sRReferencedImage.getReferencedFrameNumbers();
                        int n2 = 0;
                        while (n2 < nArray.length) {
                            try {
                                arrayList.add(iFrameObjectData[nArray[n2] + n]);
                            }
                            catch (Exception exception) {
                                log.warn("Could not find referenced frame:", (Throwable)exception);
                            }
                            ++n2;
                        }
                    }
                    keyImageType22 = KeyImageType.valueOf((Attributes)attributes);
                    ReferringObject referringObject = new ReferringObject(keyImageType22.getType(), this.objectInfo);
                    for (IFrameObjectData iFrameObjectData : arrayList) {
                        KeyImageManager.getInstance().markInitially(referringObject, iFrameObjectData, keyImageType22);
                    }
                }
            } else if (UIDUtilities.isType((String)string2, (UIDType)UIDType.Composite)) {
                if (bl) {
                    this.compositeDataset = attributes;
                } else {
                    this.createCompositeObjectData(attributes);
                }
            }
        }

        private void createCompositeObjectData(Attributes attributes) {
            ICompositeObjectDataFactory iCompositeObjectDataFactory = (ICompositeObjectDataFactory)LoadRequest.this.preLoadCompositeObjects.get(this.objectInfo);
            if (iCompositeObjectDataFactory != null) {
                IPatientInfo iPatientInfo = this.objectInfo.getPatient();
                LoadRequest.this.checkCreatePatient(iPatientInfo);
                this.compositeObjectData = iCompositeObjectDataFactory.createObjectData((IPatientData)LoadRequest.this.pat.get(iPatientInfo.getKey()), this.objectInfo, attributes);
                if (this.compositeObjectData != null) {
                    LoadRequest.this.addObject(this.objectInfo, this.compositeObjectData);
                    IImageObjectData iImageObjectData = (IImageObjectData)LoadRequest.this.objects.get(this.compositeObjectData.getSOPInstanceUID());
                    if (this.compositeObjectData != iImageObjectData && iImageObjectData instanceof ICompositeObjectData) {
                        this.compositeObjectData = (ICompositeObjectData)iImageObjectData;
                    }
                }
            }
        }

        public void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
            if (this.compositeDataset != null) {
                this.createCompositeObjectData(this.compositeDataset);
            }
            if (this.compositeObjectData != null && CompareUtils.equals((Object)this.compositeObjectData.getSOPInstanceUID(), (Object)string)) {
                this.compositeObjectData.dicomDataFinished(string, status, attributes);
            }
        }

        private void setSaved(SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject) {
            GraphicAnnotationModule graphicAnnotationModule = (GraphicAnnotationModule)softcopyPresentationStateInformationObject.getModule(GraphicAnnotationModule.class);
            if (graphicAnnotationModule != null) {
                for (GraphicAnnotation graphicAnnotation : graphicAnnotationModule.graphicAnnotations()) {
                    graphicAnnotation.setSaved(true);
                }
            }
        }
    }

    protected class PriorListener
    implements IRelevancyListener {
        private Map<String, IStudyInfo> baseStudies;
        private Queue<String> toProcess = new LinkedList<String>();

        public PriorListener(List<IStudyInfo> list) {
            this.baseStudies = new HashMap<String, IStudyInfo>();
            for (IStudyInfo iStudyInfo : list) {
                this.baseStudies.put(iStudyInfo.getKey(), iStudyInfo);
                this.toProcess.add(iStudyInfo.getKey());
            }
            this.continueSearch();
        }

        public void createContainersAfterTimeout() {
            for (IStudyInfo iStudyInfo : new ArrayList(LoadRequest.this.studies.values())) {
                this.relevantFound(iStudyInfo.getPatient().getKey(), iStudyInfo.getStudyUID(), Collections.EMPTY_LIST);
            }
        }

        public void relevantFound(String string, String string2, List<IStudyInfo> list) {
            try {
                IStudyData iStudyData = this.removeStudyFromBase(string2);
                if (iStudyData != null) {
                    ImpaxEEStudyContainer impaxEEStudyContainer = new ImpaxEEStudyContainer(iStudyData, LoadRequest.this);
                    impaxEEStudyContainer.setPriors(list);
                    IPatientRepresentation iPatientRepresentation = dm.getPatientRepresentation(iStudyData.getParent().getKey());
                    if (iPatientRepresentation != null) {
                        iPatientRepresentation.addStudyContainer((IStudyContainer)impaxEEStudyContainer);
                    } else {
                        log.warn("Patient :" + iStudyData.getParent().getKey() + " not found");
                    }
                }
            }
            catch (Exception exception) {
                log.error("Exception in priors occured", (Throwable)exception);
            }
        }

        private IStudyData removeStudyFromBase(String string) {
            Iterator iterator = LoadRequest.this.sty.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((String)entry.getKey()).equals(string)) continue;
                iterator.remove();
                return (IStudyData)entry.getValue();
            }
            return null;
        }

        private synchronized void continueSearch() {
            String string = this.toProcess.poll();
            if (string == null) {
                LoadRequest.this.priorSemaphore.release();
            } else {
                ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>(this.baseStudies.values());
                IStudyInfo iStudyInfo = this.baseStudies.get(string);
                arrayList.remove(iStudyInfo);
                arrayList.add(0, iStudyInfo);
                RelevancyManager.getInstance().startSearchRelevant((IRelevancyListener)this, arrayList, LoadRequest.this.isDisplayedPatient);
            }
        }

        public void searchFinished(String string, String string2, boolean bl) {
            this.continueSearch();
        }

        public void studiesLoaded(List<IStudyInfo> list) {
        }

        public void studiesFound(String string, List<IStudyInfo> list) {
        }
    }

    private class SessionLoader
    extends Thread {
        public SessionLoader() {
            super("Session loader");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Runnable runnable;
                        if ((runnable = (Runnable)LoadRequest.this.sessions.take()) instanceof SessionTerminationElement) {
                            return;
                        }
                        runnable.run();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private static class SessionTerminationElement
    implements Runnable {
        private SessionTerminationElement() {
        }

        @Override
        public void run() {
        }
    }
}

