/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.pixeldata.frame.impl;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.data.pixeldata.frame.AbstractPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;

public class ShortPixelDataFrame
extends AbstractPixelDataFrame<short[]> {
    public ShortPixelDataFrame(IImagePixel iImagePixel, CacheID cacheID, String string) {
        super(iImagePixel, cacheID, string);
    }

    public ShortPixelDataFrame(ShortPixelDataFrame shortPixelDataFrame) {
        super(shortPixelDataFrame);
    }

    @Override
    public final IPixelDataFrame<short[]> clone() {
        return new ShortPixelDataFrame(this);
    }

    @Override
    protected final void initFields(short[] sArray) {
        if (this.getHighBit() == 15) {
            return;
        }
        int n = this.getSignBitTest();
        int n2 = 0;
        while (n2 < sArray.length) {
            short s = sArray[n2];
            sArray[n2] = (short)(s | ~((s & n) - 1));
            ++n2;
        }
    }

    public final Class<?> getPixelDataClass() {
        return short[].class;
    }

    public final IPixelAccessor<short[]> getPixelAccessor() {
        return new PrivatePixelAccessor();
    }

    public final boolean isSigned() {
        return true;
    }

    private final class PrivatePixelAccessor
    extends AbstractPixelDataFrame.AbstractPixelAccessor {
        private PrivatePixelAccessor() {
        }

        @Override
        protected void freeData() {
            cache.free((short[])this.data);
        }
    }
}

