/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.pixeldata.frame.impl;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.data.pixeldata.frame.AbstractPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;

public class BytePixelDataFrame
extends AbstractPixelDataFrame<byte[]> {
    public BytePixelDataFrame(IImagePixel iImagePixel, CacheID cacheID, String string) {
        super(iImagePixel, cacheID, string);
    }

    public BytePixelDataFrame(BytePixelDataFrame bytePixelDataFrame) {
        super(bytePixelDataFrame);
    }

    @Override
    public final IPixelDataFrame<byte[]> clone() {
        return new BytePixelDataFrame(this);
    }

    @Override
    protected final void initFields(byte[] byArray) {
        if (this.getHighBit() == 7) {
            return;
        }
        int n = this.getSignBitTest();
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by = byArray[n2];
            byArray[n2] = (byte)(by | ~((by & n) - 1));
            ++n2;
        }
    }

    public final Class<?> getPixelDataClass() {
        return byte[].class;
    }

    public final IPixelAccessor<byte[]> getPixelAccessor() {
        return new PrivatePixelAccessor();
    }

    public final boolean isSigned() {
        return true;
    }

    private final class PrivatePixelAccessor
    extends AbstractPixelDataFrame.AbstractPixelAccessor {
        private PrivatePixelAccessor() {
        }

        @Override
        protected void freeData() {
            cache.free((byte[])this.data);
        }
    }
}

