/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.menu;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.CompoundAbstractPAction;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class SelectionActionProvider
implements PActionProvider {
    public static final String SELECT_ALL_ID = "SELECT_ALL";
    public static final String DESELECT_ALL_ID = "DESELECT_ALL";
    public static final String INVERT_SELECTION_ID = "INVERT_SELECTION";
    public static final String SELECTION_GROUP_ID = "SELECTION_GROUP";
    public static final String STEPWISE_SELECTION_GROUP_ID = "STEPWISE_SELECTION_GROUP";
    private static final Object STEPWISE_SELECTION_ID_PREFIX = "STEPWISE_SELECTION_";

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new SelectAll());
        arrayList.add(new DeselectAll());
        arrayList.add(new InvertSelection());
        arrayList.add(new SelectionGroupAction(arrayList));
        ArrayList<PAction> arrayList2 = new ArrayList<PAction>();
        int n = 2;
        while (n <= 5) {
            arrayList2.add(new StepwiseSelectionAction(n));
            ++n;
        }
        arrayList.addAll(arrayList2);
        arrayList.add(new StepwiseSelectionGroupAction(arrayList2));
        return arrayList;
    }

    public static String getStepwiseActionID(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STEPWISE_SELECTION_ID_PREFIX);
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    private static class DeselectAll
    extends AbstractPAction {
        @Override
        public String getName() {
            return Messages.getString("SelectionHandler.DeselectAllImages.Name");
        }

        @Override
        public String getCaption() {
            return Messages.getString("SelectionHandler.DeselectAllImages.Caption");
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.DESELECT_ALL_ID;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            for (VisData visData : AbstractPDataAction.getVisDatas(PDataScope.CurrentDisplay)) {
                visData.setSelected(false, true);
            }
            return true;
        }
    }

    private static class InvertSelection
    extends AbstractPAction {
        @Override
        public String getName() {
            return Messages.getString("SelectionHandler.InvertSelection.Name");
        }

        @Override
        public String getCaption() {
            return Messages.getString("SelectionHandler.InvertSelection.Caption");
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.INVERT_SELECTION_ID;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            for (VisData visData : AbstractPDataAction.getVisDatas(PDataScope.CurrentDisplay)) {
                visData.setSelected(!visData.isSelected(), true);
            }
            return true;
        }
    }

    private static class SelectAll
    extends AbstractPAction {
        @Override
        public String getName() {
            return Messages.getString("SelectionHandler.SelectAllImages.Name");
        }

        @Override
        public String getCaption() {
            return Messages.getString("SelectionHandler.SelectAllImages.Caption");
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.SELECT_ALL_ID;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            for (VisData visData : AbstractPDataAction.getVisDatas(PDataScope.CurrentDisplay)) {
                visData.setSelected(true, true);
            }
            return true;
        }
    }

    private static class SelectionGroupAction
    extends CompoundAbstractPAction {
        public SelectionGroupAction(List<PAction> list) {
            this.init(list);
        }

        @Override
        public String getCaption() {
            return Messages.getString("SelectionHandler.Selection");
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.SELECTION_GROUP_ID;
        }
    }

    private static class StepwiseSelectionAction
    extends AbstractPAction {
        private final int step;

        public StepwiseSelectionAction(int n) {
            this.step = n;
        }

        @Override
        public String getName() {
            return MessageFormat.format(Messages.getString("SelectionHandler.StepwiseSelection.Step.Name"), this.step);
        }

        @Override
        public String getCaption() {
            return MessageFormat.format(Messages.getString("SelectionHandler.StepwiseSelection.Step.Caption"), this.step);
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.getStepwiseActionID(this.step);
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            List<VisData> list = AbstractPDataAction.getVisDatas(PDataScope.CurrentDisplay);
            VisData visData = AbstractPDataAction.getCurrentImage();
            int n = 0;
            int n2 = 0;
            while (n2 < list.size()) {
                VisData visData2 = list.get(n2);
                visData2.setSelected(false, true);
                if (visData2 == visData) {
                    n = n2;
                }
                ++n2;
            }
            n2 = n;
            while (n2 < list.size()) {
                list.get(n2).setSelected(true, true);
                n2 += this.step;
            }
            return true;
        }
    }

    private static class StepwiseSelectionGroupAction
    extends CompoundAbstractPAction {
        public StepwiseSelectionGroupAction(List<PAction> list) {
            this.init(list);
        }

        @Override
        public String getName() {
            return Messages.getString("SelectionHandler.StepwiseSelection.Group.Name");
        }

        @Override
        public String getCaption() {
            return Messages.getString("SelectionHandler.StepwiseSelection.Group.Caption");
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.STEPWISE_SELECTION_GROUP_ID;
        }
    }
}

