/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.menu;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.CompoundAbstractPAction;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.PrintUtils;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.menu.FlaggingActionProvider;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AbstractFlagGroupAction
extends CompoundAbstractPAction {
    private KeyImageType type;
    private static final String ID_PREFIX = "FLAG_GROUP_";

    public AbstractFlagGroupAction(KeyImageType keyImageType) {
        this.type = keyImageType;
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(PActionRegistry.getAction(FlaggingActionProvider.getIDForImageFlagging(keyImageType)));
        FlaggingActionProvider.Type[] typeArray = FlaggingActionProvider.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FlaggingActionProvider.Type type = typeArray[n2];
            arrayList.add(PActionRegistry.getAction(FlaggingActionProvider.getIDForFlagging(keyImageType, type)));
            ++n2;
        }
        arrayList.add(new PrintFlaggedImagesAction(keyImageType));
        this.init(arrayList);
    }

    @Override
    public String getCaption() {
        return this.type.getDescription();
    }

    @Override
    public String getGroupName() {
        return WORKFLOW_HANDLING_GROUP;
    }

    @Override
    public String getID() {
        return AbstractFlagGroupAction.getIDOfGroupAction(this.type);
    }

    public static String getIDOfGroupAction(KeyImageType keyImageType) {
        return ID_PREFIX + keyImageType.name();
    }

    @Override
    public boolean isUpdatingListeners() {
        return false;
    }

    private static class PrintFlaggedImagesAction
    extends AbstractPAction {
        public static final String ID = "PRINT_KEY_IMAGES";
        private KeyImageType type;

        public PrintFlaggedImagesAction(KeyImageType keyImageType) {
            this.type = keyImageType;
        }

        @Override
        public boolean isAvailable() {
            return PrintUtils.isPrintingAvailable();
        }

        @Override
        protected boolean isEnabledImpl() {
            return PrintFlaggedImagesAction.hasKeyImages(this.type);
        }

        @Override
        public String getCaption() {
            return Messages.getString("PRINT");
        }

        @Override
        public String getName() {
            return Messages.getString("PRINT");
        }

        @Override
        public String getGroupName() {
            return WORKFLOW_HANDLING_GROUP;
        }

        @Override
        public String getID() {
            return ID;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            VisData visData = VisData.getLastModified();
            if (visData != null) {
                List<VisData> list;
                IPatientData iPatientData = visData.getPatientData();
                ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>();
                Collection<IStudyData> collection = iPatientData.getStudies();
                if (collection != null) {
                    for (IStudyData object2 : collection) {
                        arrayList.addAll(KeyImageManager.getInstance().getKeyImagesOfStudy(object2, this.type));
                    }
                }
                if ((list = JVision2.getMainFrame().getAllVisDatas()) != null) {
                    Iterator<Object> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        VisData visData2 = (VisData)iterator.next();
                        if (!visData2.getPatientData().equals(iPatientData) || !KeyImageManager.getInstance().isMarked(visData2.getFrameData(), this.type)) {
                            iterator.remove();
                            continue;
                        }
                        arrayList.remove(visData2.getFrameData());
                    }
                }
                PrintUtils.print(list, arrayList);
                return true;
            }
            return false;
        }

        private static boolean hasKeyImages(KeyImageType keyImageType) {
            Collection<IStudyData> collection = PrintFlaggedImagesAction.getStudies();
            for (IStudyData iStudyData : collection) {
                List<IFrameObjectData> list = KeyImageManager.getInstance().getKeyImagesOfStudy(iStudyData, keyImageType);
                if (list == null || list.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private static Collection<IStudyData> getStudies() {
            IPatientData iPatientData;
            VisData visData = VisData.getLastModified();
            if (visData != null && (iPatientData = visData.getPatientData()) != null) {
                return iPatientData.getStudies();
            }
            return Collections.emptyList();
        }
    }
}

