/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.vistoolbar.VisDisplayToolBar;
import com.tiani.gui.util.event.DefaultMouseMoveListener;
import com.tiani.jvision.overlay.localizer.LocalizerManager;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JScrollBar;
import javax.swing.Timer;

public class VisDisplayScrollBar
extends JScrollBar
implements MouseWheelListener {
    private VisDisplay2 parent;
    private boolean visible = !VisDisplayScrollBar.isHideScrollbar();
    private static final int HIDING_COUNTER_MAX = 2;
    private AtomicInteger hideCounter;
    private Timer hideTimeout;
    public static final String Left = "LEFT";
    public static final String Right = "RIGHT";
    public static final String Top = "TOP";
    public static final String Bottom = "BOTTOM";

    static {
        VisDisplayScrollBar.getConfiguredAlignment();
    }

    public VisDisplayScrollBar(VisDisplay2 visDisplay2) {
        this.parent = visDisplay2;
        this.addMouseWheelListener(this);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JButton) {
                JButton jButton = (JButton)componentArray[n];
                jButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        VisDisplayScrollBar.this.setValueIsAdjusting(true);
                    }
                });
            }
            ++n;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LocalizerManager.setFastRepaintInProgress(true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                LocalizerManager.setFastRepaintInProgress(false);
            }
        });
    }

    public void paintNow() {
        if (!this.isVisible()) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paint(graphics);
        graphics.dispose();
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        super.paint(graphics);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.parent == null) {
            return;
        }
        int n = mouseWheelEvent.getUnitsToScroll();
        if (n > 0) {
            VisDisplayScrollBar visDisplayScrollBar = this.parent.getScrollBar();
            visDisplayScrollBar.setValue(visDisplayScrollBar.getValue() + 1);
        } else if (n < 0) {
            VisDisplayScrollBar visDisplayScrollBar = this.parent.getScrollBar();
            visDisplayScrollBar.setValue(visDisplayScrollBar.getValue() - 1);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void decreaseHidingCounter() {
        if (this.visible && this.hideCounter != null && this.hideCounter.decrementAndGet() == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            if (bl) {
                this.hideCounter = new AtomicInteger(2);
            }
            if (this.parent != null) {
                this.parent.revalidate();
                this.parent.repaint();
            }
            if (bl) {
                this.startHideTimeout();
            }
        }
    }

    private void startHideTimeout() {
        if (this.hideTimeout != null) {
            this.hideTimeout.stop();
        }
        final DefaultMouseMoveListener defaultMouseMoveListener = new DefaultMouseMoveListener();
        this.hideTimeout = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!defaultMouseMoveListener.isMouseOver() && actionEvent.getWhen() - defaultMouseMoveListener.getLastMoveTime() > 1200L) {
                    VisDisplayScrollBar.this.hideTimeout.stop();
                    defaultMouseMoveListener.deinstallFrom(VisDisplayScrollBar.this);
                    VisDisplayScrollBar.this.setVisible(false);
                }
            }
        });
        defaultMouseMoveListener.installOn(this);
        this.hideTimeout.start();
    }

    public static int getConfiguredAlignment() {
        int n = VisDisplayScrollBar.getConfiguredAlignment(Config.impaxee.jvision.DISPLAY.UseScrollBars.get(), Config.impaxee.jvision.DISPLAY.ScrollBarAlign.get());
        int n2 = VisDisplayScrollBar.adjustScrollBarAlignment(n, VisDisplayToolBar.getConfiguredAlignment(), true);
        return n2;
    }

    public static int getConfiguredAlignment(boolean bl, String string) {
        int n = -1;
        if (bl && string != null) {
            if (string.equalsIgnoreCase(Left)) {
                n = 0;
            } else if (string.equalsIgnoreCase(Top)) {
                n = 2;
            } else if (string.equalsIgnoreCase(Right)) {
                n = 1;
            } else if (string.equalsIgnoreCase(Bottom)) {
                n = 3;
            }
        }
        return n;
    }

    public static int adjustScrollBarAlignment(int n, int n2) {
        return VisDisplayScrollBar.adjustScrollBarAlignment(n, n2, false);
    }

    private static int adjustScrollBarAlignment(int n, int n2, boolean bl) {
        if (n2 == n) {
            int n3 = n = n2 == 1 ? 3 : 1;
            if (bl) {
                VisDisplayScrollBar.setConfiguredAlignment(n);
            }
        }
        return n;
    }

    private static void setConfiguredAlignment(int n) {
        Config.impaxee.jvision.DISPLAY.ScrollBarAlign.set(n == 0 ? Left : (n == 1 ? Right : (n == 2 ? Top : Bottom)));
    }

    public static boolean isHideScrollbar() {
        return Config.impaxee.jvision.DISPLAY.HideScrollbar.get();
    }
}

