/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.User;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PSelectableAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.config.ConfigUtils;
import com.agfa.pacs.impaxee.frameofreference.FrameOfReferenceManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.impl.HangingCaseDisplay;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeInfoGlobal;
import com.agfa.pacs.impaxee.plugin.AbstractPlugin;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.plugin.IPluginActivationListener;
import com.agfa.pacs.impaxee.plugin.PluginActivationListenerFactory;
import com.agfa.pacs.impaxee.plugin.PluginManager;
import com.agfa.pacs.impaxee.plugin.PluginObjectData;
import com.agfa.pacs.impaxee.presentationstate.PresentationStatePoolCollector;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.actioncontext.ActionContextManager;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.CrossSliceAngleMeasurement;
import com.tiani.jvision.overlay.Localizer;
import com.tiani.jvision.overlay.localizer.DisplayLocalizerInfo;
import com.tiani.jvision.plugin.DefaultDisplayPlugin;
import com.tiani.jvision.plugin.DefaultPlugin;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.toptoolbar.PluginActions;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.SyncType;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.LytDisplay;
import com.tiani.jvision.vis.layout.StateLytScreen;
import com.tiani.util.message.Message;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class VisDisplayData {
    private static final ALogger log = ALogger.getLogger(VisDisplayData.class);
    private static final double orientationAngle = Math.cos(Math.PI / 180 * Config.impaxee.jvision.SYNCHRONIZE.OrientationAngle.get());
    private static Double distanceToSyncPoint = null;
    static int syncedImagePosition = 0;
    private static AtomicInteger counter = new AtomicInteger();
    private ZoomMode zoomMode = ZoomMode.NORMAL;
    private IPlugin plugin;
    private IDisplayPlugin displayPlugin;
    private IPlugin defaultPlugin = new DefaultPlugin();
    private VisDisplay2 parent;
    private IDisplaySet displaySet;
    private boolean isSynchronized;
    private boolean manuallyLinked;
    private final int ID = counter.incrementAndGet();
    private boolean wasDefaultPlugin;
    private List<VisData> visDatas = new CopyOnWriteArrayList<VisData>();
    private Map<VisData, Integer> visDataMap = new HashMap<VisData, Integer>();
    private boolean isSaved = true;
    private VisData lastMovedOverOnSyncPosUpdate;
    private VisData synchronisationPointData;
    private int indexOfSyncedPoint;
    private VisData currentSynchronizedData;
    private boolean synchronizedMatchSize = false;
    private boolean useLocationInformation = true;
    private int nColsBeforeTypeSwitch = -1;
    private int nRowsBeforeTypeSwitch = -1;
    private DisplayLocalizerInfo localizerInfo = null;
    private IPlugin lastPlugin;
    private PluginObjectData[] lastPluginObjectDatas;
    private boolean switchedLastPluginToFull = false;
    private StateLytScreen storedScreenLayout;
    private CrossSliceAngleMeasurement crossSliceAngleMeasurement;
    private Properties properties;

    static int getNumberOfImagesNearToScrollPos() {
        return 8;
    }

    public static int getKeyFrameDistance(int n) {
        return 20;
    }

    public static synchronized Double getDistanceToSyncPos() {
        return distanceToSyncPoint;
    }

    public static synchronized void setDistanceToSyncPos(Double d, int n) {
        distanceToSyncPoint = d;
        syncedImagePosition = n;
    }

    private static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    private static boolean isDisplaySetSyncConsistent(IDisplaySet iDisplaySet) {
        if (iDisplaySet.getFrameCount() == 0) {
            return true;
        }
        IFrameObjectData[] iFrameObjectDataArray = iDisplaySet.getObjects();
        IFrameObjectData iFrameObjectData = iFrameObjectDataArray[0];
        String string = VisDisplayData.nullToEmpty(iFrameObjectData.getDicomObject().getString(524384));
        String string2 = VisDisplayData.nullToEmpty(iFrameObjectData.getDicomObject().getString(1572885));
        IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray;
        int n = iFrameObjectDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFrameObjectData iFrameObjectData2 = iFrameObjectDataArray2[n2];
            if (!string.equals(VisDisplayData.nullToEmpty(iFrameObjectData2.getDicomObject().getString(524384))) || !string2.equals(VisDisplayData.nullToEmpty(iFrameObjectData2.getDicomObject().getString(1572885)))) {
                return false;
            }
            ++n2;
        }
        return iDisplaySet.getFrameCount() > 2;
    }

    VisDisplayData(VisDisplay2 visDisplay2) {
        this.parent = visDisplay2;
        this.setType(this.defaultPlugin, ActivationMode.DEFAULT);
    }

    public IPlugin getPlugin() {
        return this.plugin;
    }

    public VisDisplay2 getVisDisplay() {
        return this.parent;
    }

    public boolean isSavedForSession() {
        if (!this.isSaved) {
            return false;
        }
        int n = 0;
        while (n < this.getVisCount()) {
            if (!this.getVis(n).isSavedForSession()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public List<IFrameObjectData> getFrameData() {
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>();
        for (VisData visData : this.visDatas) {
            if (visData.isSaved()) continue;
            arrayList.add(visData.getFrameData());
        }
        return arrayList;
    }

    void save() {
        try {
            PresentationStatePoolCollector presentationStatePoolCollector = new PresentationStatePoolCollector(User.getUserNameAsPN(), Messages.getString("TemporaryPresentationStateLabel"), Messages.getString("TemporaryPresentationStateDescription"), true);
            for (VisData visData : this.visDatas) {
                if (visData.isSaved()) continue;
                presentationStatePoolCollector.addVisData(visData);
            }
            presentationStatePoolCollector.storeInStudies(this.getDisplaySet().getID());
        }
        catch (Exception exception) {
            log.error("Could not store State", (Throwable)exception);
        }
    }

    public VisData getLastMovedOverOnSyncPosUpdate() {
        return this.lastMovedOverOnSyncPosUpdate;
    }

    public void setLastMovedOverOnSyncPosUpdate(VisData visData) {
        this.lastMovedOverOnSyncPosUpdate = visData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayLocalizerInfo getLocalizerInfo() {
        DisplayLocalizerInfo displayLocalizerInfo = this.localizerInfo;
        if (displayLocalizerInfo == null) {
            VisDisplayData visDisplayData = this;
            synchronized (visDisplayData) {
                displayLocalizerInfo = this.localizerInfo;
                if (displayLocalizerInfo == null) {
                    if (!this.visDatas.isEmpty()) {
                        this.localizerInfo = displayLocalizerInfo = new DisplayLocalizerInfo(this.visDatas.get(0).getImageInformation(), this.visDatas.get(this.visDatas.size() / 2).getImageInformation(), this.visDatas.get(this.visDatas.size() - 1).getImageInformation());
                    } else {
                        displayLocalizerInfo = DisplayLocalizerInfo.getEmptyInstance();
                    }
                }
            }
        }
        return displayLocalizerInfo;
    }

    public int getIndexOfSyncPointData() {
        return this.indexOfSyncedPoint;
    }

    public VisData getSyncPointData() {
        return this.synchronisationPointData;
    }

    public void setSyncPointData(VisData visData) {
        this.setSyncPointData(visData, null);
    }

    private void setSyncPointData(VisData visData, Double d) {
        this.synchronisationPointData = visData;
        if (visData != null) {
            this.indexOfSyncedPoint = this.indexOf(visData);
            this.currentSynchronizedData = this.getVis(this.getVisDisplay().getNavigPos());
        } else {
            this.indexOfSyncedPoint = 0;
            this.currentSynchronizedData = visData;
        }
        this.getDisplayPlugin().activateSynchronisation(visData != null);
    }

    public VisData getCurrentSynchronizedData() {
        return this.currentSynchronizedData;
    }

    public void setCurrentSynchronizedData(VisData visData) {
        this.currentSynchronizedData = visData;
    }

    public void synchronizeWithOthers() {
        this.getVisDisplay().startSyncGroup();
        if (VisDisplayData.getDistanceToSyncPos() == null && this.useLocationInformation() && this.getCurrentSynchronizedData() != null) {
            VisDisplayData.setDistanceToSyncPos(this.getCurrentSynchronizedData().getDistanceToSyncPoint(), this.indexOf(this.getCurrentSynchronizedData()));
        }
    }

    public void synchronizeWithCurrentSyncPosition() {
        this.synchronizeWithCurrentSyncPosition(0);
    }

    void synchronizeWithCurrentSyncPosition(int n) {
        VisData visData = this.getCurrentSynchronizedData();
        int n2 = visData == null ? -1 : this.indexOf(visData);
        double d = Double.MAX_VALUE;
        int n3 = -1;
        double d2 = 5.0;
        if (this.visDatas.get(0).getImageInformation().getSliceThickness() != null) {
            d2 = 4.0 * this.visDatas.get(0).getImageInformation().getSliceThickness();
        }
        Double d3 = VisDisplayData.getDistanceToSyncPos();
        if (this.useLocationInformation() && d3 != null) {
            double d4 = this.displaySet.getRelativeSliceLocation(this.indexOfSyncedPoint);
            int n4 = 0;
            while (n4 < this.visDatas.size()) {
                double d5 = Math.abs(d3 - (this.displaySet.getRelativeSliceLocation(n4) - d4));
                if (d5 < d || d5 == d && VisDisplayData.isMinimalIndexChange(n4, n2, n3, n)) {
                    d = d5;
                    n3 = n4;
                }
                ++n4;
            }
        } else {
            int n5 = this.indexOfSyncedPoint + syncedImagePosition;
            if (n5 < 0) {
                n3 = 0;
            } else if (n5 < this.visDatas.size()) {
                n3 = n5;
            } else {
                n3 = this.visDatas.size() - 1;
                d = d2 + 1.0;
            }
        }
        if (n3 == -1) {
            return;
        }
        VisData visData2 = this.visDatas.get(n3);
        this.setCurrentSynchronizedData(visData2);
        if (visData != null) {
            if (n2 != -1) {
                this.parent.move2synchronisedPosition(n3);
            }
            if (visData.getVisual() != null) {
                visData.getVisual().repaintBorder();
            }
        }
        if ((n3 == 0 || n3 + 1 == this.visDatas.size()) && d > d2) {
            visData2.showStopSign();
        }
        if (visData2.getVisual() != null) {
            visData2.getVisual().repaintBorder();
        }
    }

    private static boolean isMinimalIndexChange(int n, int n2, int n3, int n4) {
        return n2 != -1 && (long)n4 * (long)(n - n2) > 0L && (n3 == n2 || Math.abs(n - n2) < Math.abs(n3 - n2));
    }

    public boolean useLocationInformation() {
        return this.hasLocationInformation() & this.useLocationInformation;
    }

    public boolean hasLocationInformation() {
        return this.displaySet.hasLocationInformation();
    }

    public boolean isUsingLocationInformation() {
        return this.useLocationInformation;
    }

    public void setUseLocationInformation(boolean bl) {
        this.useLocationInformation = bl;
        VisDisplayData.setDistanceToSyncPos(this.getCurrentSynchronizedData().getDistanceToSyncPoint(), this.indexOf(this.getCurrentSynchronizedData()));
        for (VisScreen2 visScreen2 : JVision2.getMainFrame().getScreens()) {
            for (VisDisplay2 visDisplay2 : visScreen2.getSynchronizedDisplays()) {
                if (visDisplay2.getData() == this) continue;
                visDisplay2.getData().synchronizeWithCurrentSyncPosition();
            }
        }
    }

    boolean isSyncableWithGroup(List<VisDisplayData> list) {
        if (this.displaySet == null) {
            return false;
        }
        if (!VisDisplayData.isDisplaySetSyncConsistent(this.displaySet)) {
            return false;
        }
        IFrameObjectData iFrameObjectData = this.displaySet.getOneObject();
        String string = VisDisplayData.emptyStringWhenNull(iFrameObjectData.getImageInformation().getModality());
        Vector3d vector3d = iFrameObjectData.getImageInformation().getPlaneNormalUV();
        for (VisDisplayData visDisplayData : list) {
            IDisplaySet iDisplaySet = visDisplayData.getDisplaySet();
            IFrameObjectData iFrameObjectData2 = iDisplaySet.getOneObject();
            if (visDisplayData == this) continue;
            String string2 = VisDisplayData.emptyStringWhenNull(iFrameObjectData2.getImageInformation().getModality());
            if (!string2.equals(string)) {
                return false;
            }
            Vector3d vector3d2 = iFrameObjectData2.getImageInformation().getPlaneNormalUV();
            if (VisDisplayData.equalsOrientation(vector3d, vector3d2)) continue;
            return false;
        }
        return true;
    }

    private static String emptyStringWhenNull(String string) {
        return string == null ? "" : string;
    }

    boolean isSyncableWithData(VisDisplayData visDisplayData, SyncType syncType) {
        if (this.displaySet == null) {
            return false;
        }
        if (visDisplayData == this) {
            return true;
        }
        if (this.getPlugin().getPluginName() != PluginName.DEFAULT) {
            return false;
        }
        if (!VisDisplayData.isDisplaySetSyncConsistent(this.displaySet)) {
            return false;
        }
        return VisDisplayData.isSyncableWithData(this.displaySet, visDisplayData.getDisplaySet(), syncType);
    }

    public static boolean isSyncableWithData(IDisplaySet iDisplaySet, IDisplaySet iDisplaySet2, SyncType syncType) {
        String string;
        IImageInformation iImageInformation;
        IFrameObjectData[] iFrameObjectDataArray = iDisplaySet.getObjects();
        IImageInformation iImageInformation2 = iFrameObjectDataArray[0].getImageInformation();
        if (!VisDisplayData.hasSameOrientation(iImageInformation2, iImageInformation = (iFrameObjectDataArray = iDisplaySet2.getObjects())[0].getImageInformation())) {
            return false;
        }
        Point3d point3d = iImageInformation2.getPointOrigin();
        Point3d point3d2 = iImageInformation.getPointOrigin();
        String string2 = iImageInformation2.getFrameOfReferenceUID();
        if (string2 != null ^ (string = iImageInformation.getFrameOfReferenceUID()) != null) {
            return false;
        }
        if (string2 != null && string != null && !syncType.isCompatible(string2, string)) {
            return false;
        }
        if (point3d != null && point3d2 != null) {
            return true;
        }
        String string3 = VisDisplayData.emptyStringWhenNull(iImageInformation2.getBodyPartExamined());
        String string4 = VisDisplayData.emptyStringWhenNull(iImageInformation.getBodyPartExamined());
        return string4.equals(string3);
    }

    public static boolean hasSameOrientation(IImageInformation iImageInformation, IImageInformation iImageInformation2) {
        try {
            return VisDisplayData.equalsOrientation(iImageInformation.getPlaneNormalUV(), iImageInformation2.getPlaneNormalUV());
        }
        catch (Exception exception) {
            log.error("error", (Throwable)exception);
            return false;
        }
    }

    public static boolean equalsOrientation(Vector3d vector3d, Vector3d vector3d2) {
        if (vector3d == null || vector3d2 == null) {
            log.debug("Orientation missing");
            return false;
        }
        if (vector3d.equals((Tuple3d)vector3d2)) {
            return true;
        }
        if (vector3d.dot(vector3d2) < orientationAngle) {
            log.debug("Orientation difference exceeded:" + Math.acos(vector3d.dot(vector3d2)) / (Math.PI / 180));
            return false;
        }
        return true;
    }

    public IPlugin getType() {
        return this.plugin;
    }

    void resetType() {
        if (this.plugin != this.defaultPlugin) {
            this.setType(this.defaultPlugin, ActivationMode.DEFAULT);
        }
    }

    public IDisplayPlugin getDisplayPlugin() {
        return this.displayPlugin;
    }

    void resetZoomMode() {
        this.setZoomMode(ZoomMode.NORMAL);
    }

    public ZoomMode getZoomMode() {
        return this.zoomMode;
    }

    private boolean isLicenseInUse(String string) {
        List<VisDisplay2> list = JVision2.getMainFrame().getAllDisplays();
        for (VisDisplay2 visDisplay2 : list) {
            String string2;
            if (visDisplay2.getData() == this || (string2 = visDisplay2.getData().getPlugin().getLicensingPluginID()) == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private void initializePlugin(IDisplayPlugin iDisplayPlugin, ActivationMode activationMode) {
        int n;
        boolean bl = false;
        if (iDisplayPlugin != null && !(iDisplayPlugin instanceof DefaultDisplayPlugin) && VisData.isBlockLastModifiedChange()) {
            VisData.blockLastModifiedChange(false);
            bl = true;
        }
        this.displayPlugin = iDisplayPlugin;
        if (this.displaySet == null) {
            return;
        }
        IFrameObjectData[] iFrameObjectDataArray = null;
        if (this.wasDefaultPlugin) {
            iFrameObjectDataArray = new IFrameObjectData[this.visDatas.size()];
            n = 0;
            while (n < this.visDatas.size()) {
                iFrameObjectDataArray[n] = this.visDatas.get(n).getFrameData();
                ++n;
            }
        } else {
            iFrameObjectDataArray = new IFrameObjectData[this.lastPluginObjectDatas.length];
            n = 0;
            while (n < this.lastPluginObjectDatas.length) {
                iFrameObjectDataArray[n] = this.lastPluginObjectDatas[n].frameData;
                ++n;
            }
        }
        VisData[] visDataArray = this.visDatas.toArray(new VisData[0]);
        this.parent.clearForNewPlugin(activationMode == ActivationMode.HANGUP || activationMode == ActivationMode.AUTOSTART);
        if (!this.wasDefaultPlugin && !this.getVisDisplay().isDetached() && activationMode == ActivationMode.MANUAL && iDisplayPlugin instanceof DefaultDisplayPlugin && this.nColsBeforeTypeSwitch != -1 && this.nRowsBeforeTypeSwitch != -1) {
            if (this.switchedLastPluginToFull) {
                if (this.parent.getScreen().getLytMode() == MainLayoutType.variable && this.parent.getScreen().getLyt().getCols() == 1 && this.parent.getScreen().getLyt().getRows() == 1) {
                    this.parent.getScreen().setLytMode(MainLayoutType.variable, this.storedScreenLayout, false);
                }
                this.switchedLastPluginToFull = false;
                this.storedScreenLayout = null;
            }
            this.parent.setLytMode(this.parent.getScreen().getLytMode().getNewLytDisplay(), this.nColsBeforeTypeSwitch, this.nRowsBeforeTypeSwitch, true, false);
            this.nRowsBeforeTypeSwitch = -1;
            this.nColsBeforeTypeSwitch = -1;
        }
        this.initDisplayMode(iFrameObjectDataArray, visDataArray, activationMode);
        this.parent.applyMostRecentPresState(null);
        this.parent.updateData(true);
        this.parent.updateScrollBar();
        this.parent.addAllVisHRs();
        this.parent.updateAllVisHRsOutsideMode();
        this.parent.repaint();
        if (this.getVis(0) != null) {
            VisData.resetLastModified();
            this.getVis(0).makeTheLastModified();
        }
        ActionContextManager.singleton.contextChanged(this);
        if (bl) {
            VisData.blockLastModifiedChange(true);
        }
        if (this.displayPlugin instanceof DefaultDisplayPlugin) {
            this.getVisDisplay().updateActionStates();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setType(IPlugin iPlugin, ActivationMode activationMode) {
        void var6_20;
        IDisplayPlugin iDisplayPlugin;
        log.info("Setting display plugin: " + iPlugin);
        LicenseManager licenseManager = LicenseManager.getInstance();
        if (iPlugin == null) {
            iPlugin = this.defaultPlugin;
        }
        if (!this.parent.isPluginAllowed(iPlugin)) {
            Message.error(Messages.getString("VisDisplayData.PluginNotAllowed.Title"), (Object)MessageFormat.format(Messages.getString("VisDisplayData.PluginNotAllowed.Message"), iPlugin.getDescription()));
            return;
        }
        if (iPlugin.getLicensingPluginID() != null && licenseManager.getLicense(iPlugin.getLicensingPluginID()) == null) {
            Message.error(Messages.getString("VisDisplayData.PluginLicenseMissingTitle"), (Object)(String.valueOf(Messages.getString("VisDisplayData.PluginLicenseMissing")) + "."));
            return;
        }
        if (iPlugin.getPluginName() != PluginName.DEFAULT && this.displaySet.isBeingLossyPrefetched()) {
            Message.error(Messages.getString("AbstractLosslessImageFetcher.DownloadLosslessImages.Title"), (Object)MessageFormat.format(Messages.getString("PluginStarter.LossyImageWarning.Message"), iPlugin.getDescription()));
            return;
        }
        IPlugin iPlugin2 = this.plugin;
        if (activationMode == ActivationMode.MANUAL && iPlugin2 == iPlugin) {
            return;
        }
        boolean bl = this.wasDefaultPlugin = iPlugin2 == this.defaultPlugin;
        if (this.wasDefaultPlugin && this.parent != null && this.parent.getLyt() != null) {
            this.nColsBeforeTypeSwitch = this.parent.getLyt().getCols();
            this.nRowsBeforeTypeSwitch = this.parent.getLyt().getRows();
        }
        if (iPlugin2 instanceof AbstractPlugin) {
            ((AbstractPlugin)iPlugin2).cleanUp();
        }
        if ((iDisplayPlugin = this.getDisplayPlugin()) != null) {
            for (PAction pAction : this.displayPlugin.getInvalidDisplayToolbarActions()) {
                pAction.setEnabled(true);
            }
            iDisplayPlugin.cleanUp();
        }
        this.plugin = iPlugin;
        if (iPlugin2 != null && iPlugin2.getLicensingPluginID() != null && !this.isLicenseInUse(iPlugin2.getLicensingPluginID())) {
            licenseManager.releaseLicense(iPlugin2.getLicensingPluginID());
        }
        for (IPluginActivationListener iPluginActivationListener : PluginActivationListenerFactory.getInstance().getPluginsActivationListeners()) {
            iPluginActivationListener.pluginWillBeActivated(this, this.plugin.getPluginName());
        }
        IDisplayPlugin iDisplayPlugin2 = iPlugin.createDisplayPlugin(this);
        if (iDisplayPlugin2 == null) {
            this.plugin = this.defaultPlugin;
            for (IPluginActivationListener iPluginActivationListener : PluginActivationListenerFactory.getInstance().getPluginsActivationListeners()) {
                iPluginActivationListener.pluginWillBeActivated(this, this.plugin.getPluginName());
            }
            IDisplayPlugin iDisplayPlugin3 = this.plugin.createDisplayPlugin(this);
        }
        this.initializePlugin((IDisplayPlugin)var6_20, activationMode);
        for (PAction pAction : this.displayPlugin.getInvalidDisplayToolbarActions()) {
            pAction.setEnabled(false);
        }
        VisDisplay2 visDisplay2 = this.getVisDisplay();
        if (iPlugin2 != null && visDisplay2.hasAction(iPlugin2.getActionID())) {
            PAction pAction = visDisplay2.getAction(iPlugin2.getActionID());
            ((PSelectableAction)((Object)pAction)).setSelected(false);
        }
        if (visDisplay2.hasAction(this.plugin.getActionID())) {
            PAction pAction = visDisplay2.getAction(this.plugin.getActionID());
            ((PSelectableAction)((Object)pAction)).setSelected(true);
        }
        visDisplay2.updateAllActionsRegardingLayoutChanges();
        IMouseModeInfo iMouseModeInfo = this.displayPlugin.getMouseModeInfo();
        MouseModeInfoGlobal mouseModeInfoGlobal = MouseModeInfoGlobal.getInstance();
        if (iMouseModeInfo != mouseModeInfoGlobal || iPlugin2 != null && iMouseModeInfo == mouseModeInfoGlobal && !this.wasDefaultPlugin) {
            if (!this.displayPlugin.isMeasuringAllowed() && mouseModeInfoGlobal.getSubMode().isMeasurement()) {
                mouseModeInfoGlobal.resetSubMode();
            } else {
                iMouseModeInfo.setPresentationObjectCreationStatus(mouseModeInfoGlobal.getPresentationObjectCreationStatus());
                iMouseModeInfo.setSubMode(mouseModeInfoGlobal.getSubMode());
            }
        } else if (iMouseModeInfo == mouseModeInfoGlobal && !this.displayPlugin.isMeasuringAllowed() && mouseModeInfoGlobal.getSubMode().isMeasurement()) {
            mouseModeInfoGlobal.resetSubMode();
        }
    }

    public void setZoomMode(ZoomMode zoomMode) {
        if (zoomMode == this.zoomMode) {
            return;
        }
        this.zoomMode = zoomMode;
        if (this.getVisDisplay() != null) {
            int n = 0;
            while (n < this.getVisDisplay().getVisViewCount()) {
                this.getVisDisplay().getVisView(n).setZoomHREnabled(zoomMode != ZoomMode.TRUESIZE);
                ++n;
            }
        }
    }

    public void clear(boolean bl) {
        if (!this.visDatas.isEmpty()) {
            try {
                FrameOfReferenceManager.clearLocalizerDataForDisplay(this.parent);
            }
            catch (Exception exception) {
                log.warn("Some damaged display", (Throwable)exception);
            }
        }
        for (VisData visData : this.visDatas) {
            visData.clear();
        }
        this.clearVisDatas();
        if (!bl) {
            this.displaySet.decrementLoadCount();
            this.displaySet = null;
            this.resetType();
            this.lastPluginObjectDatas = null;
            this.lastPlugin = null;
        }
        this.setSynchronized(false);
        this.synchronisationPointData = null;
        this.indexOfSyncedPoint = 0;
        this.currentSynchronizedData = null;
        this.synchronizedMatchSize = false;
        this.isSaved = true;
        this.localizerInfo = null;
        this.crossSliceAngleMeasurement = null;
        if (!bl) {
            this.properties = null;
        }
    }

    public IDisplaySet getDisplaySet() {
        return this.displaySet;
    }

    public int getDisplaySetID() {
        if (this.displaySet == null) {
            return -1;
        }
        return this.displaySet.getID();
    }

    public int getID() {
        return this.ID;
    }

    public IPatientRepresentation getPatientRepresentation() {
        if (this.displaySet == null) {
            return null;
        }
        return this.displaySet.getSplitAndSortRuntime().getPatientRepresentation();
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public boolean isManuallySynced() {
        return this.manuallyLinked;
    }

    public void setSynchronized(boolean bl) {
        this.setSynchronized(bl, false);
    }

    public void setSynchronized(boolean bl, boolean bl2) {
        this.isSynchronized = bl;
        this.manuallyLinked = bl2;
        this.synchronizedMatchSize = false;
        if (this.parent.hasAction("SYNCHRONIZE")) {
            this.parent.getAction("SYNCHRONIZE").fireSelectionChanged();
        }
        if (!bl) {
            for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
                if (!visDisplay2.getData().isSynchronized()) continue;
                return;
            }
            VisDisplayData.setDistanceToSyncPos(null, 0);
        }
    }

    public void setMatchSizeOnSynchronisation() {
        this.synchronizedMatchSize = true;
    }

    public boolean isMatchSizeOnSynchronisation() {
        return this.synchronizedMatchSize;
    }

    private void clearVisDatas() {
        this.visDatas.clear();
        this.visDataMap.clear();
    }

    private void removeVisData(int n) {
        VisData visData = this.visDatas.remove(n);
        this.visDataMap.remove(visData);
    }

    private void addVisDatas(VisData[] visDataArray) {
        if (visDataArray.length == 0) {
            return;
        }
        int n = this.visDatas.size();
        ArrayList<VisData> arrayList = new ArrayList<VisData>(this.visDatas.size() + visDataArray.length);
        arrayList.addAll(this.visDatas);
        VisData[] visDataArray2 = visDataArray;
        int n2 = visDataArray.length;
        int n3 = 0;
        while (n3 < n2) {
            VisData visData = visDataArray2[n3];
            this.visDataMap.put(visData, n);
            arrayList.add(n, visData);
            ++n;
            ++n3;
        }
        this.visDatas = new CopyOnWriteArrayList<VisData>(arrayList);
    }

    private void setVisData(int n, VisData visData) {
        this.visDatas.set(n, visData);
        this.visDataMap.put(visData, n);
    }

    public int getVisCount() {
        return this.visDatas.size();
    }

    public boolean hasData() {
        return !this.visDatas.isEmpty();
    }

    public boolean areVisSelected() {
        for (VisData visData : this.visDatas) {
            if (!visData.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean areAllVisSelected() {
        for (VisData visData : this.visDatas) {
            if (visData.isSelected()) continue;
            return false;
        }
        return true;
    }

    public List<VisData> getSelectedVis() {
        ArrayList<VisData> arrayList = new ArrayList<VisData>();
        for (VisData visData : this.visDatas) {
            if (!visData.isSelected()) continue;
            arrayList.add(visData);
        }
        return arrayList;
    }

    public List<VisData> getVis() {
        return this.visDatas;
    }

    public VisData getVis(int n) {
        if (this.visDatas.isEmpty() || n < 0) {
            return null;
        }
        if (n < this.visDatas.size()) {
            return this.visDatas.get(n);
        }
        return null;
    }

    public int indexOf(VisData visData) {
        return this.visDataMap.get(visData);
    }

    public VisData getFirstVis() {
        if (this.visDatas.isEmpty()) {
            return null;
        }
        return this.visDatas.get(0);
    }

    public VisData getLastVis() {
        if (this.visDatas.isEmpty()) {
            return null;
        }
        return this.visDatas.get(this.visDatas.size() - 1);
    }

    public VisData getFirstSelectedVis() {
        for (VisData visData : this.visDatas) {
            if (!visData.isSelected()) continue;
            return visData;
        }
        return null;
    }

    public VisData getPrevVis(VisData visData) {
        int n = this.visDataMap.get(visData);
        if (n < 0) {
            return null;
        }
        if (--n < 0) {
            return null;
        }
        return this.visDatas.get(n);
    }

    public VisData getNextVis(VisData visData) {
        int n = this.visDataMap.get(visData);
        if (n < 0) {
            return null;
        }
        if (++n >= this.visDatas.size()) {
            return null;
        }
        return this.visDatas.get(n);
    }

    public void setAllVisSelected(boolean bl) {
        for (VisData visData : this.visDatas) {
            visData.setSelected(bl);
        }
    }

    public boolean initVisDisplayData(IDisplaySet iDisplaySet, IPlugin iPlugin, boolean bl) {
        if (iDisplaySet != this.displaySet) {
            if (this.displaySet != null) {
                this.displaySet.decrementLoadCount();
            }
            iDisplaySet.incrementLoadCount();
        }
        this.displaySet = iDisplaySet;
        return this.initVisDisplay(this.displaySet.getObjects(), iPlugin, bl);
    }

    private boolean initVisDisplay(IFrameObjectData[] iFrameObjectDataArray, IPlugin iPlugin, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        ActivationMode activationMode;
        this.lastPluginObjectDatas = null;
        this.localizerInfo = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = iPlugin != null;
        PluginName pluginName = null;
        if (this.displayPlugin != null && !this.displayPlugin.isReusable() && !bl4) {
            activationMode = ConfigUtils.getFirstMatchOfList(iFrameObjectDataArray[0], Config.impaxee.jvision.PLUGINS.autoUsePlugin.getList(), null, "conditionText");
            object3 = this.defaultPlugin;
            object2 = null;
            if (activationMode != null && (pluginName = PluginName.getItemWithName((String)(object2 = activationMode.getString("pluginName")))) != PluginName.DEFAULT && pluginName.isPlugin()) {
                object3 = PluginManager.getPlugin((String)object2);
            }
            if (object3 != null) {
                if (object3.getLicensingPluginID() != null && LicenseManager.getInstance().getLicense(object3.getLicensingPluginID()) == null) {
                    log.error("Could not start auto use plugin as not valid license found");
                    object3 = this.defaultPlugin;
                }
                if (object3.getPluginName() != PluginName.DEFAULT && this.displaySet.isBeingLossyPrefetched()) {
                    log.error("Plugin start on lossy prefetched data is disallowed.");
                    object3 = this.defaultPlugin;
                }
                if (!object3.areDataSuitable(this.displaySet)) {
                    log.error("Plugin {} does not support selected display set.", (Object)this.plugin.getDescription());
                    object3 = this.defaultPlugin;
                }
                if (!this.parent.isPluginAllowed((IPlugin)object3)) {
                    log.error("Plugin {} disallowed on current display.", (Object)this.plugin.getDescription());
                    object3 = this.defaultPlugin;
                }
                if (this.plugin != null && this.parent.hasAction(this.plugin.getActionID())) {
                    object = this.parent.getAction(this.plugin.getActionID());
                    ((PSelectableAction)object).setSelected(false);
                }
                this.plugin = object3;
                if (this.parent.hasAction(this.plugin.getActionID())) {
                    object = this.parent.getAction(this.plugin.getActionID());
                    ((PSelectableAction)object).setSelected(true);
                }
                if (this.displayPlugin != null) {
                    this.displayPlugin.cleanUp();
                }
                for (IPluginActivationListener iPluginActivationListener : PluginActivationListenerFactory.getInstance().getPluginsActivationListeners()) {
                    iPluginActivationListener.pluginWillBeActivated(this, this.plugin.getPluginName());
                }
                this.displayPlugin = this.plugin.createDisplayPlugin(this);
                if (this.displayPlugin == null) {
                    this.plugin = this.defaultPlugin;
                    for (IPluginActivationListener iPluginActivationListener : PluginActivationListenerFactory.getInstance().getPluginsActivationListeners()) {
                        iPluginActivationListener.pluginWillBeActivated(this, this.defaultPlugin.getPluginName());
                    }
                    this.displayPlugin = this.defaultPlugin.createDisplayPlugin(this);
                }
            }
        }
        activationMode = ActivationMode.MANUAL;
        activationMode = bl ? ActivationMode.HANGUP : (pluginName != null && pluginName.isPlugin() ? ActivationMode.AUTOSTART : ActivationMode.MANUAL);
        this.initDisplayMode(iFrameObjectDataArray, new VisData[0], activationMode);
        if (pluginName != null && !pluginName.isPlugin() && !bl) {
            log.info("Autostart will apply:" + pluginName.getPluginName());
            if (pluginName == PluginName.INVERT) {
                bl2 = true;
            } else if (pluginName == PluginName.TRUESIZE_ZOOM) {
                HangingCaseDisplay.applyZoomMode(this.getVisDisplay(), ZoomMode.TRUESIZE, 1.0);
            } else if (pluginName == PluginName.PIXELIDENTITY_ZOOM) {
                HangingCaseDisplay.applyZoomMode(this.getVisDisplay(), ZoomMode.PIXELIDENTITY, 1.0);
            } else if (pluginName == PluginName.FLIP) {
                HangingCaseDisplay.applyHorizonalFlip(this.getVisDisplay());
            } else if (pluginName == PluginName.LOCALIZER) {
                bl3 = true;
            }
        }
        if (bl3 && ((VisDisplay2)(object3 = this.getVisDisplay())).hasData() && (object2 = ((VisDisplay2)object3).getVis(0).getView()) instanceof ImgView2 && ((ImgView2)object2).canHaveLocalizer()) {
            object = new TEvent(116);
            TEventDispatch.sendEventToVis((VisDisplay2)object3, (TEvent)object, (Object)Localizer.LocalizerState.UserForcedOn, TEventDispatch.ALL_VISUALS);
        }
        if (this.getVisCount() > 0 && (bl4 || this.displayPlugin != null && !(this.displayPlugin instanceof DefaultDisplayPlugin))) {
            boolean bl5 = VisData.isBlockLastModifiedChange();
            if (VisData.isBlockLastModifiedChange()) {
                VisData.blockLastModifiedChange(false);
            }
            this.getFirstVis().makeTheLastModified();
            if (bl5) {
                VisData.blockLastModifiedChange(true);
            }
            object2 = bl4 ? iPlugin : this.plugin;
            if (activationMode == ActivationMode.MANUAL) {
                JVision2.getMainFrame().getPluginToolbox().attachToDisplayOnPluginStart(this.getVisDisplay(), (IPlugin)object2);
            } else {
                JVision2.getMainFrame().getPluginToolbox().attachToDisplayOnPluginAutoStart(this.getVisDisplay(), (IPlugin)object2);
            }
        }
        return bl2;
    }

    public void appendViews(View[] viewArray, Dimension dimension) {
        VisData[] visDataArray = new VisData[viewArray.length];
        int n = 0;
        while (n < viewArray.length) {
            visDataArray[n] = new VisData(this, viewArray[n], dimension);
            ++n;
        }
        this.addVisDatas(visDataArray);
        n = 0;
        while (n < viewArray.length) {
            viewArray[n].setVis(visDataArray[n]);
            ++n;
        }
    }

    VisData replaceView(View view, Dimension dimension, int n) {
        VisData visData = new VisData(this, view, dimension);
        this.setVisData(n, visData);
        view.setVis(visData);
        return visData;
    }

    VisData removeView(View view) {
        int n = 0;
        while (n < this.visDatas.size()) {
            VisData visData = this.visDatas.get(n);
            if (visData.getView() == view) {
                visData.clear();
                this.removeVisData(n);
                return visData;
            }
            ++n;
        }
        return null;
    }

    public void removeAllVisDatas() {
        this.clearVisDatas();
    }

    public void initDisplayMode(IFrameObjectData[] iFrameObjectDataArray, VisData[] visDataArray, ActivationMode activationMode) {
        Object object;
        int n;
        if (this.displayPlugin == null) {
            log.error("Can't init displaymode, no displayplugin loaded");
            return;
        }
        PluginObjectData[] pluginObjectDataArray = new PluginObjectData[iFrameObjectDataArray.length];
        if (this.lastPlugin == null) {
            n = 0;
            while (n < iFrameObjectDataArray.length) {
                pluginObjectDataArray[n] = new PluginObjectData(iFrameObjectDataArray[n], true);
                n += 1;
            }
            this.lastPluginObjectDatas = pluginObjectDataArray;
            this.lastPlugin = this.plugin;
        } else {
            if (this.lastPlugin.isSelectionMaster()) {
                int n2 = 0;
                while (n2 < iFrameObjectDataArray.length) {
                    n = n2 < visDataArray.length ? (int)(visDataArray[n2].isSelected() ? 1 : 0) : 1;
                    pluginObjectDataArray[n2] = new PluginObjectData(iFrameObjectDataArray[n2], n != 0);
                    ++n2;
                }
            } else if (this.lastPluginObjectDatas == null) {
                n = 0;
                while (n < iFrameObjectDataArray.length) {
                    pluginObjectDataArray[n] = new PluginObjectData(iFrameObjectDataArray[n], true);
                    n += 1;
                }
            } else {
                pluginObjectDataArray = this.lastPluginObjectDatas;
            }
            this.lastPluginObjectDatas = pluginObjectDataArray;
            this.lastPlugin = this.plugin;
            if (this.displayPlugin.wantsFullscreenOnStart() && this.parent.getScreen().getLytMode() == MainLayoutType.variable && activationMode == ActivationMode.MANUAL && !this.getVisDisplay().isDetached()) {
                this.storedScreenLayout = new StateLytScreen(this.parent.getScreen().getLyt());
                this.switchedLastPluginToFull = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VisDisplayData.this.parent.getScreen().setLytMode(VisDisplayData.this.parent.getScreen().getLytMode(), 1, 1, true);
                    }
                });
            }
        }
        Dimension dimension = this.displayPlugin.getPreferredVisLayout();
        LytDisplay lytDisplay = this.displayPlugin.getSpecialLayout();
        if (dimension != null) {
            object = lytDisplay != null ? lytDisplay : this.parent.getScreen().getLytMode().getNewLytDisplay();
            EventUtil.invoke((Runnable)new Runnable((LytDisplay)object, dimension){
                private final /* synthetic */ LytDisplay val$appliedLayout;
                private final /* synthetic */ Dimension val$preferredVisLayout;
                {
                    this.val$appliedLayout = lytDisplay;
                    this.val$preferredVisLayout = dimension;
                }

                @Override
                public void run() {
                    VisDisplayData.this.parent.setLytMode(this.val$appliedLayout, this.val$preferredVisLayout.width, this.val$preferredVisLayout.height, true, false);
                }
            });
        }
        object = null;
        if (this.getVisDisplay().getVisView(0) != null) {
            object = this.getVisDisplay().getVisView(0).getSize();
        }
        View[] viewArray = this.displayPlugin.createDisplayViews(pluginObjectDataArray, (Dimension)object, activationMode);
        if (this.getVisDisplay().getVisView(0) != null) {
            object = this.getVisDisplay().getVisView(0).getSize();
        }
        if (viewArray != null) {
            this.appendViews(viewArray, (Dimension)object);
        } else {
            viewArray = new View[iFrameObjectDataArray.length];
            int n3 = 0;
            while (n3 < iFrameObjectDataArray.length) {
                viewArray[n3] = new ImgView2(iFrameObjectDataArray[n3]);
                ++n3;
            }
            this.appendViews(viewArray, (Dimension)object);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VisDisplayData.this.getVisDisplay().getAction(PluginActions.PLUGIN_OFF).perform(null);
                }
            });
        }
    }

    public void setSequenceData(IDisplaySet iDisplaySet) {
        this.displaySet = iDisplaySet;
        IFrameObjectData[] iFrameObjectDataArray = iDisplaySet.getObjects();
        this.lastPluginObjectDatas = new PluginObjectData[iFrameObjectDataArray.length];
        int n = 0;
        while (n < iFrameObjectDataArray.length) {
            this.lastPluginObjectDatas[n] = new PluginObjectData(iFrameObjectDataArray[n], true);
            ++n;
        }
    }

    public Map<VisData, Integer> getVisIndexMap() {
        return this.visDataMap;
    }

    public boolean isDefaultPluginActive() {
        return this.getPlugin() instanceof DefaultPlugin;
    }

    public void copyAngleMeasurements(View view) {
        this.crossSliceAngleMeasurement = CrossSliceAngleMeasurement.newInstance(view);
    }

    public void pasteAngleMeasurements(View view) {
        if (this.crossSliceAngleMeasurement == null) {
            CrossSliceAngleMeasurement.showPasteWarningDialog(Messages.getString("CrossSliceAngleMeasurement.PasteFailure.NoData"));
        } else {
            this.crossSliceAngleMeasurement.paste(view);
        }
    }

    public String getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        if (this.properties == null) {
            if (string2 == null) {
                return;
            }
            this.properties = new Properties();
        }
        if (string2 == null) {
            this.properties.remove(string);
        } else {
            this.properties.setProperty(string, string2);
        }
    }
}

