/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.frameofreference.FrameOfReferenceManager;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransform;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.math.GeomUtil;
import com.agfa.pacs.tools.CompareUtils;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.overlay.OverlaySynchronizationMode;
import com.tiani.jvision.overlay.localizer.DisplayLocalizerInfo;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.toptoolbar.StudyLinkageInfo;
import com.tiani.jvision.vis.SyncType;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class SyncUtils {
    private static final double EPSILON = 1.0E-4;
    private static final ALogger log = ALogger.getLogger(SyncUtils.class);
    private static final List<String> autoSyncOnModality = Arrays.asList(Config.impaxee.jvision.SYNCHRONIZE.AutoSyncOnModality.get().split("/"));

    private SyncUtils() {
    }

    public static boolean makeSyncGroup(VisDisplay2 visDisplay2) {
        VisData visData;
        String string = visDisplay2.getFirstVis().getImageInformation().getModality();
        if (!autoSyncOnModality.contains(string)) {
            return false;
        }
        if (visDisplay2.getData().getPlugin().getPluginName() != PluginName.DEFAULT) {
            return false;
        }
        log.info("Performing auto sync");
        boolean bl = SyncUtils.containSpaceInformation(visDisplay2.getData());
        if (bl) {
            int n = visDisplay2.getData().getVisCount() / 2;
            visDisplay2.setSynchronized(true, visDisplay2.getData().getVis(n), false);
        } else {
            visDisplay2.setSynchronized(true, visDisplay2.getData().getFirstVis(), false);
        }
        VisData visData2 = visDisplay2.getData().getSyncPointData();
        MainFrame2 mainFrame2 = JVision2.getMainFrame();
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>(16);
        for (VisDisplay2 object2 : mainFrame2.getDisplays()) {
            if (object2 == visDisplay2 || !object2.hasData()) continue;
            object2.getData().setSynchronized(false);
            arrayList.add(object2);
        }
        StudyLinkageInfo studyLinkageInfo = visDisplay2.getData().getPatientRepresentation().getLinkage(visDisplay2.getData().getDisplaySet());
        if (studyLinkageInfo != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Object object3 = (VisDisplay2)iterator.next();
                Vector3d bl2 = studyLinkageInfo.getLinked(((VisDisplay2)object3).getData().getDisplaySet());
                if (bl2 == null || !((VisDisplay2)object3).getData().isSyncableWithData(visDisplay2.getData(), SyncType.IGNORE_FRAME_OF_REFERENCE) || (visData = SyncUtils.searchAppropriateSyncPoint(visData2, (VisDisplay2)object3, bl2, false)) == null) continue;
                ((VisDisplay2)object3).setSynchronized(true, visData, true);
                ((Component)object3).repaint();
                iterator.remove();
            }
        }
        for (Object object3 : arrayList) {
            boolean bl2 = ((VisDisplay2)object3).getData().isSyncableWithData(visDisplay2.getData(), SyncType.FRAME_OF_REFERENCE_TRANSFORM_AVAILABLE);
            if (bl2) {
                visData = ((VisDisplay2)object3).getFirstVis();
                VisData visData3 = null;
                if (bl) {
                    visData3 = SyncUtils.searchAppropriateSyncPoint(visData2, (VisDisplay2)object3, null, true);
                    if (visData3 != null) {
                        ((VisDisplay2)object3).setSynchronized(true, visData3, false);
                    }
                } else {
                    ((VisDisplay2)object3).setSynchronized(true, visData, false);
                }
            }
            ((Component)object3).repaint();
        }
        return true;
    }

    private static boolean containSpaceInformation(VisDisplayData visDisplayData) {
        if (!visDisplayData.hasData()) {
            return false;
        }
        IImageInformation iImageInformation = visDisplayData.getFirstVis().getImageInformation();
        return iImageInformation.getFrameOfReferenceUID() != null && iImageInformation.getPointOrigin() != null;
    }

    private static Point3d getSliceMidleLocation(IImageInformation iImageInformation) {
        return SyncUtils.getSliceMidleLocation(iImageInformation, null);
    }

    private static Point3d getSliceMidleLocation(IImageInformation iImageInformation, Vector3d vector3d) {
        Point3d point3d = iImageInformation.getPointOrigin();
        Vector3d vector3d2 = iImageInformation.getScaledSizedVectorU();
        Vector3d vector3d3 = iImageInformation.getScaledSizedVectorV();
        if (point3d == null || vector3d2 == null || vector3d3 == null) {
            return null;
        }
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.scale(0.5);
        Vector3d vector3d5 = new Vector3d(vector3d3);
        vector3d5.scale(0.5);
        point3d = new Point3d(point3d);
        point3d.add((Tuple3d)vector3d4);
        point3d.add((Tuple3d)vector3d5);
        if (vector3d != null) {
            point3d.add((Tuple3d)vector3d);
        }
        return point3d;
    }

    private static VisData searchAppropriateSyncPoint(VisData visData, VisDisplay2 visDisplay2, Vector3d vector3d, boolean bl) {
        Object object;
        VisData visData2 = visDisplay2.getFirstVis();
        Point3d point3d = SyncUtils.getSliceMidleLocation(visData.getImageInformation());
        Point3d point3d2 = SyncUtils.getSliceMidleLocation(visData2.getImageInformation());
        if (point3d == null || point3d2 == null) {
            log.debug("Auto Sync point not found because Image position not available");
            return null;
        }
        Object object2 = null;
        double d = Double.MAX_VALUE;
        visData.getImageInformation().getPlaneNormalUV();
        String string = visData.getImageInformation().getFrameOfReferenceUID();
        double[] dArray = visData.getImageInformation().getImagePosition();
        double[] dArray2 = visData.getImageInformation().getImageOrientation();
        Object object3 = visDisplay2.getData().getVis().iterator();
        while (object3.hasNext()) {
            object = object3.next();
            try {
                double d2;
                String string2;
                Point3d point3d3 = SyncUtils.getSliceMidleLocation(((VisData)object).getImageInformation(), vector3d);
                if (point3d3 == null) continue;
                if (bl && !CompareUtils.equals((Object)string, (Object)(string2 = ((VisData)object).getImageInformation().getFrameOfReferenceUID()))) {
                    IWorldToWorldTransform iWorldToWorldTransform = FrameOfReferenceManager.getWorldToWorldTransform(string2, string);
                    if (iWorldToWorldTransform == null) continue;
                    iWorldToWorldTransform.transform(point3d3);
                }
                if (!((d2 = GeomUtil.getDistanceFromPlane((Tuple3d)point3d3, (double[])dArray, (double[])dArray2)) < d)) continue;
                d = d2;
                object2 = object;
            }
            catch (Exception exception) {
                log.error("Error on synchronisation", (Throwable)exception);
            }
        }
        log.debug("Best auto sync point has distance:" + d);
        object = 0.0;
        if (object2 != null) {
            object = ((VisData)object2).getImageInformation().getSliceThickness();
        }
        if ((object = (Double)CompareUtils.max((Comparable)object, (Comparable)(object3 = visData.getImageInformation().getSliceThickness()))) != null && (Double)object * 3.0 < d) {
            log.info("Nearest point to far to synchronize:" + d);
            return null;
        }
        if (object2 != null) {
            int n = visDisplay2.getData().indexOf((VisData)object2);
            log.info("Best linked is at position:" + n + " with distance " + d);
        }
        return object2;
    }

    public static List<VisData> getCompatibleDisplaySets(VisData visData, List<VisDisplay2> list, CompatibilityMode compatibilityMode) {
        ArrayList<VisData> arrayList = new ArrayList<VisData>();
        IImageInformation iImageInformation = visData.getImageInformation();
        int n = iImageInformation.getRows();
        int n2 = iImageInformation.getColumns();
        double[] dArray = iImageInformation.getPixelSpacing();
        Vector3d vector3d = iImageInformation.getPlaneNormalUV();
        Point3d point3d = iImageInformation.getPointOrigin();
        String string = iImageInformation.getModality();
        if (dArray == null || vector3d == null || point3d == null || string == null || !DoubleEquals.equals((double)dArray[0], (double)dArray[1], (double)1.0E-4)) {
            return arrayList;
        }
        for (VisDisplay2 visDisplay2 : list) {
            VisData visData2;
            if (visDisplay2 == visData.getParent().getVisDisplay() || !visDisplay2.hasData() || !visDisplay2.getData().isSyncableWithData(visData.getParent(), compatibilityMode.getSynchronizationType()) || (visData2 = SyncUtils.searchAppropriateSyncPoint(visData, visDisplay2, null, compatibilityMode.isWorldToWorldTransformEnabled())) == null) continue;
            IImageInformation iImageInformation2 = visData2.getImageInformation();
            double[] dArray2 = iImageInformation2.getPixelSpacing();
            if (compatibilityMode.isDimensionCheckEnabled() && (n != iImageInformation2.getRows() || n2 != iImageInformation2.getColumns()) || compatibilityMode.isDimensionCheckEnabled() && (!DoubleEquals.equals((double)dArray[0], (double)dArray2[0], (double)1.0E-4) || !DoubleEquals.equals((double)dArray[1], (double)dArray2[1], (double)1.0E-4)) || !DisplayLocalizerInfo.isParallel(vector3d, iImageInformation2.getPlaneNormalUV()) || !DoubleEquals.equals((double)dArray2[0], (double)dArray2[1], (double)1.0E-4)) continue;
            Point3d point3d2 = iImageInformation2.getPointOrigin();
            if (compatibilityMode.isDimensionCheckEnabled() && (!DoubleEquals.equals((double)point3d.x, (double)point3d2.x, (double)(dArray[1] / 2.0)) || !DoubleEquals.equals((double)point3d.y, (double)point3d2.y, (double)(dArray[0] / 2.0)))) continue;
            arrayList.add(visData2);
        }
        return arrayList;
    }

    public static List<IDisplaySet> searchCompatibleSeriesInActiveHanging(IImageInformation iImageInformation, ImageType imageType) {
        IDisplaySet[] iDisplaySetArray;
        String string = iImageInformation.getFrameOfReferenceUID();
        String string2 = iImageInformation.getModality();
        Vector3d vector3d = iImageInformation.getPlaneNormalUV();
        if (string == null || string2 == null || vector3d == null) {
            return Collections.emptyList();
        }
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        DataSelectionManager dataSelectionManager = DataSelectionManager.getInstance();
        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray = dataSelectionManager.getActiveHanging().getSplitAndSortRuntime().getDisplaySets();
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
            IImageInformation iImageInformation2 = iDisplaySet.getOneObject().getImageInformation();
            if (string.equals(iDisplaySet.getFrameOfReferenceUID()) && string2.equals(iImageInformation2.getModality()) && iImageInformation2.getPlaneNormalUV() != null && DisplayLocalizerInfo.isParallel(vector3d, iImageInformation2.getPlaneNormalUV()) && (imageType == null || iImageInformation2.getImageType().contains(imageType))) {
                arrayList.add(iDisplaySet);
            }
            ++n2;
        }
        return arrayList;
    }

    public static enum CompatibilityMode {
        SAME_DIMENSION(OverlaySynchronizationMode.IMAGE_COORDINATES, SyncType.SAME_FRAME_OF_REFERENCE),
        SAME_FRAME_OF_REFERENCE(OverlaySynchronizationMode.WORLD_COORDINATES, SyncType.SAME_FRAME_OF_REFERENCE),
        FRAME_OF_REFERENCE_TRANSFORM_AVAILABLE(OverlaySynchronizationMode.WORLD_COORDINATES, SyncType.FRAME_OF_REFERENCE_TRANSFORM_AVAILABLE);

        private final OverlaySynchronizationMode syncMode;
        private final SyncType syncType;

        private CompatibilityMode(OverlaySynchronizationMode overlaySynchronizationMode, SyncType syncType) {
            this.syncMode = overlaySynchronizationMode;
            this.syncType = syncType;
        }

        public OverlaySynchronizationMode getOverlaySynchronizationMode() {
            return this.syncMode;
        }

        SyncType getSynchronizationType() {
            return this.syncType;
        }

        boolean isDimensionCheckEnabled() {
            return this.syncMode != OverlaySynchronizationMode.WORLD_COORDINATES;
        }

        boolean isWorldToWorldTransformEnabled() {
            return this.syncType == SyncType.FRAME_OF_REFERENCE_TRANSFORM_AVAILABLE;
        }
    }
}

