/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;

public interface IVisDataChooser {
    public static final IVisDataChooser ByOne = new NextChooser();
    public static final IVisDataChooser ByPage = new PageChooser();

    public VisData chooseData(VisDisplayData var1, VisDisplay2 var2, int var3);

    public static abstract class AbstractVisDataChooser
    implements IVisDataChooser {
        @Override
        public VisData chooseData(VisDisplayData visDisplayData, VisDisplay2 visDisplay2, int n) {
            int n2 = this.getIndexOffset(visDisplay2, n);
            int n3 = visDisplayData.indexOf(visDisplayData.getCurrentSynchronizedData()) + n2;
            if (n2 < 0 && n3 < visDisplayData.getVisCount() - 1 && n3 >= visDisplayData.getVisCount() - visDisplay2.getVisViewCount()) {
                n3 = visDisplayData.getVisCount() - visDisplay2.getVisViewCount() - 1;
            }
            return visDisplayData.getVis(n3);
        }

        abstract int getIndexOffset(VisDisplay2 var1, int var2);
    }

    public static class NextChooser
    extends AbstractVisDataChooser {
        @Override
        int getIndexOffset(VisDisplay2 visDisplay2, int n) {
            return n;
        }
    }

    public static class PageChooser
    extends AbstractVisDataChooser {
        @Override
        int getIndexOffset(VisDisplay2 visDisplay2, int n) {
            return n * visDisplay2.getVisViewCount();
        }
    }
}

