/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.List;

public class ToggleMiniLocalizerDataAction
extends AbstractPDataAction {
    public static final String ID = "TOGGLE_MINI_LOCALIZER";

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new ToggleMiniLocalizerAction(pDataScope);
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentImage};
    }

    @Override
    public boolean canHandleDataProvider(PDataProvider.ProviderType providerType) {
        return false;
    }

    @Override
    public String getID() {
        return ID;
    }

    private class ToggleMiniLocalizerAction
    extends AbstractPDataAction.AbstractInnerPAction {
        public ToggleMiniLocalizerAction(PDataScope pDataScope) {
            super(pDataScope, null);
        }

        @Override
        public String getCaption() {
            return Messages.getString("ImgView2.MiniLocalizer");
        }

        @Override
        public String getName() {
            return Messages.getString("ImgView2.MiniLocalizerDescription");
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean isSelected() {
            ImgView2 imgView2 = this.getView();
            if (imgView2 == null) {
                return false;
            }
            return imgView2.isMiniLocalizerEnabled();
        }

        @Override
        protected boolean isEnabledImpl() {
            ImgView2 imgView2 = this.getView();
            if (imgView2 == null) {
                return false;
            }
            return imgView2.canHaveLocalizer();
        }

        @Override
        public String getToolTipText() {
            return this.getCaption();
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            ImgView2 imgView2 = this.getView();
            if (imgView2 != null) {
                imgView2.toggleMiniLocalizer();
            }
            this.fireSelectionChanged();
            return true;
        }

        private ImgView2 getView() {
            List<VisData> list = ToggleMiniLocalizerDataAction.getVisDatas(this.scope);
            if (list.isEmpty()) {
                return null;
            }
            VisData visData = list.get(0);
            if (visData == null) {
                return null;
            }
            View view = visData.getView();
            if (!(view instanceof ImgView2)) {
                return null;
            }
            return (ImgView2)view;
        }
    }
}

