/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class StripeRowsActionProvider
implements PActionProvider {
    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        int n = 1;
        while (n <= 8) {
            arrayList.add(new StripeRowsAction(n));
            ++n;
        }
        return arrayList;
    }

    public static String getActionIDForRowCount(int n) {
        return "STRIPE_ROWS_" + Integer.toString(n);
    }

    private static class StripeRowsAction
    extends AbstractPAction {
        private int rows;

        public StripeRowsAction(int n) {
            this.rows = n;
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return LAYOUT_GROUP;
        }

        @Override
        public boolean isAvailable() {
            return this.rows == 1;
        }

        @Override
        protected boolean isEnabledImpl() {
            return JVision2.getMainFrame().getLytMode() == MainLayoutType.stripe;
        }

        @Override
        public String getID() {
            return StripeRowsActionProvider.getActionIDForRowCount(this.rows);
        }

        @Override
        public String getToolTipText() {
            if (this.rows > 1) {
                return MessageFormat.format(Messages.getString("CustomActions1.screenLayoutStripe.screenLayoutStripe.Multiple.ToolTip"), Integer.toString(this.rows));
            }
            return MessageFormat.format(Messages.getString("CustomActions1.screenLayoutStripe.screenLayoutStripe.Single.ToolTip"), Integer.toString(this.rows));
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            MainFrame2 mainFrame2 = JVision2.getMainFrame();
            mainFrame2.setLytMode(MainLayoutType.stripe, -1, this.rows, true);
            mainFrame2.requestFocus();
            mainFrame2.updateLytHRs();
            return true;
        }
    }
}

