/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class StripeColumnsActionProvider
implements PActionProvider {
    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        int n = 1;
        while (n <= 8) {
            arrayList.add(new StripeColumnsAction(n));
            ++n;
        }
        return arrayList;
    }

    public static String getActionIDForColumnCount(int n) {
        return "STRIPE_COLUMNS_" + Integer.toString(n);
    }

    private static class StripeColumnsAction
    extends AbstractPAction {
        private int columns;

        public StripeColumnsAction(int n) {
            this.columns = n;
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return LAYOUT_GROUP;
        }

        @Override
        public boolean isAvailable() {
            return this.columns == 1;
        }

        @Override
        protected boolean isEnabledImpl() {
            return JVision2.getMainFrame().getLytMode() == MainLayoutType.stripe;
        }

        @Override
        public String getID() {
            return StripeColumnsActionProvider.getActionIDForColumnCount(this.columns);
        }

        @Override
        public String getToolTipText() {
            if (this.columns > 1) {
                return MessageFormat.format(Messages.getString("CustomActions1.screenLayoutStripeCols.screenLayoutStripeCols.Multiple.ToolTip"), Integer.toString(this.columns));
            }
            return MessageFormat.format(Messages.getString("CustomActions1.screenLayoutStripeCols.screenLayoutStripeCols.Single.ToolTip"), Integer.toString(this.columns));
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            VisScreen2 visScreen2 = JVision2.getMainFrame().getScreens().get(0);
            visScreen2.setLytMode(visScreen2.getLytMode(), this.columns, -1, true);
            JVision2.getMainFrame().updateLytHRs();
            return true;
        }
    }
}

