/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.tiani.jvision.vis.PrintUtils;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.List;

public class PrintDataAction
extends AbstractPDataAction {
    public static final String ID = "PRINT";
    private static final boolean isAvailable = PrintUtils.isPrintingAvailable();

    public static boolean isAvailable() {
        return isAvailable;
    }

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new PrintAction(pDataScope, pDataProvider);
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay, PDataScope.AllDisplayed, PDataScope.SelectedImages, PDataScope.CurrentImage};
    }

    @Override
    public String getID() {
        return ID;
    }

    private static String getIconForType(PDataScope pDataScope, PDataProvider pDataProvider) {
        if (pDataScope == PDataScope.AllDisplayed) {
            return "print_screen.svg";
        }
        if (pDataScope == PDataScope.CurrentDisplay || pDataProvider != null) {
            return "print_display.svg";
        }
        return null;
    }

    private class PrintAction
    extends AbstractPDataAction.AbstractInnerPAction {
        public PrintAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(PrintDataAction.getIconForType(pDataScope, pDataProvider), pDataScope, pDataProvider);
        }

        @Override
        public String getCaption() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("CustomActions1.printAllImagesOnScreen.Caption");
            }
            if (this.scope == PDataScope.CurrentDisplay) {
                return Messages.getString("CustomActions1.printAllImagesInDisplay.Caption");
            }
            if (this.scope == PDataScope.SelectedImages) {
                return Messages.getString("CustomActions1.printSelectedImages.Caption");
            }
            if (this.scope == PDataScope.CurrentImage) {
                return Messages.getString("PrintDataAction.PrintCurrentImage.Caption");
            }
            return Messages.getString(PrintDataAction.ID);
        }

        @Override
        public String getGroupName() {
            return EXPORT_PRINT_GROUP;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            if (this.scope == PDataScope.CurrentDisplay) {
                return new KeyShortcut(80, 2);
            }
            if (this.scope == PDataScope.AllDisplayed) {
                return new KeyShortcut(80, 3);
            }
            return null;
        }

        @Override
        public String getToolTipText() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("CustomActions1.printAllImagesOnScreen.ToolTip");
            }
            if (this.scope == PDataScope.CurrentDisplay || this.scope == null) {
                return Messages.getString("CustomActions1.printAllImagesInDisplay.ToolTip");
            }
            if (this.scope == PDataScope.SelectedImages) {
                return Messages.getString("CustomActions1.printSelectedImages.ToolTip");
            }
            if (this.scope == PDataScope.CurrentImage) {
                return Messages.getString("PrintDataAction.PrintCurrentImage.ToolTip");
            }
            return null;
        }

        @Override
        public String getName() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("CustomActions1.printAllImagesOnScreen.Name");
            }
            if (this.scope == PDataScope.CurrentDisplay || this.scope == null) {
                return Messages.getString("CustomActions1.printAllImagesInDisplay.Name");
            }
            if (this.scope == PDataScope.SelectedImages) {
                return Messages.getString("CustomActions1.printSelectedImages.Name");
            }
            if (this.scope == PDataScope.CurrentImage) {
                return Messages.getString("PrintDataAction.PrintCurrentImage.Name");
            }
            return null;
        }

        @Override
        public boolean isAvailable() {
            return isAvailable;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            List<VisData> list = this.scope != null ? PrintDataAction.getVisDatas(this.scope) : this.provider.getVisDatas();
            if (list.isEmpty()) {
                return false;
            }
            return PrintUtils.print(list);
        }
    }
}

