/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.base.swing.util.EventConst;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.IUndoInformation;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.FixTextPAction;
import com.agfa.pacs.impaxee.actions.impl.FlatCompoundAbstractPAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.PersonName;

public class PatientNavigationProvider
implements PActionProvider {
    public static final String NEXT_PATIENT = "NEXT_PATIENT";
    public static final String PREVIOUS_PATIENT = "PREVIOUS_PATIENT";
    public static final String PATIENT_NAVIGATION = "PATIENT_NAVIGATION";
    private static DataManager dm = DataManager.getInstance();
    private static DataSelectionManager dsm = DataSelectionManager.getInstance();
    private static final NextPatientAction next = new NextPatientAction();
    private static final PreviousPatientAction previous = new PreviousPatientAction();

    public PatientNavigationProvider() {
        IEventEngine iEventEngine = EventEngineFactory.getInstance();
        IEventListenerProvider iEventListenerProvider = iEventEngine.createListenerProvider((IEventListener)new NextPreviousWorklistEntryListener());
        iEventEngine.register(iEventListenerProvider, "impaxee.actions");
    }

    private static boolean selectNextPatient(boolean bl) {
        int n = dm.getPatientPosition(dsm.getCurrentPatient());
        if ((n += bl ? 1 : -1) - 1 >= 0 && n - 1 < dm.getPatientCount()) {
            previous.setPreviousPatientName(PersonNameUtilities.personNameToHRReverse((PersonName)dm.getPatientOnPosition(n - 1).getPatientName()));
        } else {
            previous.setPreviousPatientName(null);
        }
        if (n >= 0 && n + 1 < dm.getPatientCount()) {
            next.setNextPatientName(PersonNameUtilities.personNameToHRReverse((PersonName)dm.getPatientOnPosition(n + 1).getPatientName()));
        } else {
            next.setNextPatientName(null);
        }
        if (n >= 0 && n < dm.getPatientCount()) {
            dsm.setCurrentPatient(dm.getPatientOnPosition(n));
            return true;
        }
        return false;
    }

    private static void sendPatientEvent(int n, Component component) {
        IEventEngine iEventEngine = EventEngineFactory.getInstance();
        IEvent iEvent = iEventEngine.createEvent(n);
        iEvent.setRemoteDispatch(false);
        iEvent.setPayload((Object)false);
        iEvent.setSource((Object)component);
        iEvent.setDestination(null, "lta.listarea.ui");
        iEventEngine.sendEvent(iEvent);
    }

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new PatientNavigationAction(previous, next));
        arrayList.add(next);
        arrayList.add(previous);
        return arrayList;
    }

    private static class NextPatientAction
    extends AbstractPAction {
        private String nextPatientName = null;

        public NextPatientAction() {
            super("next_item.svg");
        }

        @Override
        public String getName() {
            return Messages.getString("GeneralActions.nextPatient.Name");
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(39, 8);
        }

        @Override
        public String getID() {
            return PatientNavigationProvider.NEXT_PATIENT;
        }

        public void setNextPatientName(String string) {
            this.nextPatientName = string;
            this.fireContentChanged(false);
        }

        @Override
        public String getToolTipText() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append(Messages.getString("GeneralActions.nextPatient.ToolTip"));
            if (this.nextPatientName != null) {
                stringBuilder.append("<br/><b>");
                stringBuilder.append(this.nextPatientName);
                stringBuilder.append("</b>");
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            if (Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get()) {
                PatientNavigationProvider.sendPatientEvent(EventConst.NEXT_PATIENT_EVENT_ID, component);
                return true;
            }
            return PatientNavigationProvider.selectNextPatient(true);
        }
    }

    private static class NextPreviousWorklistEntryListener
    implements IEventListener {
        private NextPreviousWorklistEntryListener() {
        }

        public boolean handleEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
            if (iEvent.getEventID() == EventConst.NEXT_PREVIOUS_WORKLIST_ENTRY_INFORMATION_ID) {
                String[] stringArray = (String[])iEvent.getPayload();
                if (stringArray != null) {
                    next.setNextPatientName(stringArray[1]);
                    previous.setPreviousPatientName(stringArray[0]);
                } else {
                    next.setNextPatientName(null);
                    previous.setPreviousPatientName(null);
                }
            }
            return false;
        }

        public boolean handleUndoEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
            return false;
        }

        public IListenerSynchronization getSync() {
            return null;
        }
    }

    private static class PatientNavigationAction
    extends FlatCompoundAbstractPAction {
        public PatientNavigationAction(PAction pAction, PAction pAction2) {
            super(new PAction[]{pAction, new FixTextPAction(Messages.getString("GeneralActions.scrollPatients.Text")), pAction2});
        }

        @Override
        public String getCaption() {
            return Messages.getString("GeneralActions.PatientNavigation.ToolTip");
        }

        @Override
        public boolean isAvailable() {
            return !Product.isReducedVersion();
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return PatientNavigationProvider.PATIENT_NAVIGATION;
        }
    }

    private static class PreviousPatientAction
    extends AbstractPAction {
        private String previousPatientName = null;

        public PreviousPatientAction() {
            super("previous_item.svg");
        }

        @Override
        public String getName() {
            return Messages.getString("GeneralActions.previousPatient.Name");
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public String getID() {
            return PatientNavigationProvider.PREVIOUS_PATIENT;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(37, 8);
        }

        @Override
        public String getToolTipText() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append(Messages.getString("GeneralActions.previousPatient.ToolTip"));
            if (this.previousPatientName != null) {
                stringBuilder.append("<br/><b>");
                stringBuilder.append(this.previousPatientName);
                stringBuilder.append("</b>");
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            if (Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get()) {
                PatientNavigationProvider.sendPatientEvent(EventConst.PREVIOUS_PATIENT_EVENT_ID, component);
                return true;
            }
            return PatientNavigationProvider.selectNextPatient(false);
        }

        public void setPreviousPatientName(String string) {
            this.previousPatientName = string;
            this.fireContentChanged(false);
        }
    }
}

