/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.base.swing.util.EventConst;
import com.agfa.pacs.base.util.AgeUtil;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.PatientMergeUtilities;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.data.shared.valuemapping.PatientSex;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionIcon;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.PActionIconFactory;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.listtext.lta.util.INumberOfPatientInWorklistRequestor;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import java.awt.Component;
import java.util.Date;
import javax.swing.Icon;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.PersonName;

public class PatientInfoAction
extends AbstractPAction {
    public static final String ID = "PATIENT_INFO";
    public static final String TEXT_ID = "TEXT_INFO";
    public static final String SEX_ID = "SEX_INFO";
    private static final String LABEL_SPACE = "";
    private static final ALogger log = ALogger.getLogger(PatientInfoAction.class);
    private LabelAction[] subActions = new LabelAction[]{new PatientSexAction(), new PatientTextAction()};
    private boolean updateEnabled = true;
    private static final PActionIcon MALE_ICON = PActionIconFactory.getInstance().loadUnchangingIcon(null, "gender_male.svg");
    private static final PActionIcon FEMALE_ICON = PActionIconFactory.getInstance().loadUnchangingIcon(null, "gender_female.svg");

    public boolean isUpdateEnabled() {
        return this.updateEnabled;
    }

    public void setUpdateEnabled(boolean bl) {
        this.updateEnabled = bl;
    }

    public PActionIcon getIcon(PatientSex patientSex) {
        switch (patientSex) {
            case Male: {
                return MALE_ICON;
            }
            case Female: {
                return FEMALE_ICON;
            }
        }
        return null;
    }

    public String getPatientName() {
        return this.subActions[1].getPatientName();
    }

    public String getPatientBirthdate() {
        return this.subActions[1].getPatientBirthdate();
    }

    public Icon getGenderIcon(boolean bl) {
        return this.subActions[0].getIcon(bl);
    }

    public void setCurrentData(IDisplaySet iDisplaySet) {
        if (this.updateEnabled) {
            if (iDisplaySet == null || iDisplaySet.getFrameCount() == 0) {
                this.setData(null);
            } else {
                this.setData(iDisplaySet.getOneObject().getParent());
            }
        }
    }

    private void clear() {
        this.subActions[1].updateAll(LABEL_SPACE, LABEL_SPACE, null);
        this.subActions[0].changeIcon2(null);
    }

    private synchronized void setData(final ISeriesData iSeriesData) {
        if (iSeriesData != null) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder(32);
            String string = LABEL_SPACE;
            Attributes attributes = iSeriesData.getParent().getDicomObject();
            Attributes attributes2 = iSeriesData.getParent().getParent().getDicomObject();
            string = attributes2.getString(0x100010);
            if (string != null) {
                string = PersonNameUtilities.personNameToHRReverse((PersonName)new PersonName(string, true));
            }
            Date date = null;
            try {
                date = attributes2.getDate(0x100030);
                if (date != null) {
                    stringBuilder.append(DateTimeUtils.date2String((Date)date));
                    stringBuilder.append(" (").append(AgeUtil.getCurrentAgeLocalized((Date)date)).append(')');
                } else if (attributes.containsValue(0x101010)) {
                    object = attributes.getString(0x101010);
                    stringBuilder.append(AgeUtil.formatPatientAge((String)object));
                }
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("Could not parse Birthday", (Throwable)numberFormatException);
            }
            object = PatientMergeUtilities.getPatientMergeStatus((Attributes)iSeriesData.getParent().getParent().getQueryObject().getAttributes());
            if (object != PatientMergeUtilities.PatientMergeStatus.NotMerged) {
                string = String.valueOf(string) + " (!)";
            }
            this.subActions[1].updateAll(string, stringBuilder.toString(), this.compileTooltipText(string, stringBuilder.toString(), -1, -1, (PatientMergeUtilities.PatientMergeStatus)object));
            String string2 = attributes2.getString(0x100040);
            this.subActions[0].changeIcon2(this.getIcon(PatientSex.getByCode((String)string2)));
            IEventEngine iEventEngine = EventEngineFactory.getInstance();
            IEvent iEvent = iEventEngine.createEvent(EventConst.NUMBER_OF_PATIENT_IN_WORKLIST_REQUEST_EVENT_ID, null, null, null, ActionInfo.SINGLE);
            iEvent.setDestination(null, "lta.listarea.ui");
            iEvent.setPayload((Object)new INumberOfPatientInWorklistRequestor(){

                public String getPatientKey() {
                    return iSeriesData.getParent().getParent().getKey();
                }

                public void setNumberOfPatient(int n, int n2) {
                    if (n >= 0 && n2 > 0) {
                        IPatientData iPatientData = iSeriesData.getParent().getParent();
                        PatientInfoAction.this.subActions[1].updateToolTipText(PatientInfoAction.this.compileTooltipText(PatientInfoAction.this.subActions[1].getPatientName(), PatientInfoAction.this.subActions[1].getPatientBirthdate(), n, n2, PatientMergeUtilities.getPatientMergeStatus((Attributes)iPatientData.getQueryObject().getAttributes())));
                    }
                }
            });
            iEventEngine.sendEvent(iEvent);
        } else {
            this.clear();
        }
    }

    @Override
    public PAction.ActionType getActionType() {
        return PAction.ActionType.FlatGroup;
    }

    @Override
    public PAction[] getSubactions() {
        return this.subActions;
    }

    @Override
    public String getCaption() {
        return "Patient Information";
    }

    @Override
    public String getGroupName() {
        return "INTERNAL";
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return this.subActions[1].getToolTipText();
    }

    @Override
    public boolean perform(Component component) {
        throw new UnsupportedOperationException();
    }

    private String compileTooltipText(String string, String string2, int n, int n2, PatientMergeUtilities.PatientMergeStatus patientMergeStatus) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("<html>");
        stringBuilder.append("<b><font size=\"+");
        stringBuilder.append(ComponentFactory.instance.scaleInt(1));
        stringBuilder.append("\">");
        if (string != null) {
            stringBuilder.append(string);
            if (n > 0 && n2 > 0) {
                stringBuilder.append(' ');
                stringBuilder.append('(');
                stringBuilder.append(n);
                stringBuilder.append(' ');
                stringBuilder.append(Messages.getString("PatInfo.Of.Text"));
                stringBuilder.append(' ');
                stringBuilder.append(n2);
                stringBuilder.append(')');
            }
        } else {
            stringBuilder.append("<font color=\"#ff0000\">");
            stringBuilder.append(Messages.getString("PatInfoCommanderLabel.NoPatientName"));
            stringBuilder.append("</font>");
        }
        stringBuilder.append("</font></b>");
        stringBuilder.append("<br>");
        if (string2 != null) {
            stringBuilder.append(string2);
        } else {
            stringBuilder.append("<font color=\"#ff0000\">");
            stringBuilder.append(Messages.getString("PatInfoCommanderLabel.NoBirthDate"));
            stringBuilder.append("</font>");
        }
        stringBuilder.append("<br>");
        if (patientMergeStatus == PatientMergeUtilities.PatientMergeStatus.MergedDifferentName) {
            stringBuilder.append("<b>").append(Messages.getString("PatInfoCommanderLabel.PatientIsMergedDifferentNames")).append("</b>");
            stringBuilder.append("<br>");
        } else if (patientMergeStatus == PatientMergeUtilities.PatientMergeStatus.MergedSameName) {
            stringBuilder.append("<b>").append(Messages.getString("PatInfoCommanderLabel.PatientIsMergedSameNames")).append("</b>");
            stringBuilder.append("<br>");
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private abstract class LabelAction
    extends AbstractPAction {
        private String patientName = "";
        private String patientBirthdate = "";
        private String tooltip;

        private LabelAction() {
        }

        @Override
        public String getCaption() {
            return String.valueOf(this.patientName) + " " + this.patientBirthdate;
        }

        @Override
        public String getGroupName() {
            return "INTERNAL";
        }

        public void updateAll(String string, String string2, String string3) {
            this.patientName = string;
            this.patientBirthdate = string2;
            this.tooltip = string3;
            this.fireContentChanged(false);
        }

        public void updateToolTipText(String string) {
            this.tooltip = string;
            this.fireContentChanged(false);
        }

        public void changeIcon2(PActionIcon pActionIcon) {
            this.changeIcon(pActionIcon);
        }

        @Override
        public PAction.ActionType getActionType() {
            return PAction.ActionType.TextLabel;
        }

        @Override
        public String getToolTipText() {
            return this.tooltip;
        }

        public String getPatientName() {
            return this.patientName;
        }

        public String getPatientBirthdate() {
            return this.patientBirthdate;
        }

        @Override
        public boolean perform(Component component) {
            throw new UnsupportedOperationException();
        }
    }

    private class PatientSexAction
    extends LabelAction {
        private PatientSexAction() {
        }

        @Override
        public String getID() {
            return PatientInfoAction.SEX_ID;
        }

        @Override
        public String getCaption() {
            return PatientInfoAction.LABEL_SPACE;
        }

        @Override
        public PAction.ActionType getActionType() {
            return PAction.ActionType.None;
        }

        @Override
        protected boolean isEnabledImpl() {
            return false;
        }

        @Override
        public boolean perform(Component component) {
            return false;
        }
    }

    private class PatientTextAction
    extends LabelAction {
        private PatientTextAction() {
        }

        @Override
        public String getID() {
            return PatientInfoAction.TEXT_ID;
        }
    }
}

