/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.impl.CompoundAbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class MainLayoutActionProvider
implements PActionProvider {
    public static final String MAIN_LAYOUT_GROUP_ID = "MAIN_LAYOUT_GROUP";

    public String getIconForType(MainLayoutType mainLayoutType) {
        return "layout_type_" + mainLayoutType.name() + ".svg";
    }

    public static String getActionIDForType(MainLayoutType mainLayoutType) {
        return String.valueOf(mainLayoutType.name().toUpperCase()) + "_LAYOUT";
    }

    public static void fireEnabledChanged() {
        MainLayoutType[] mainLayoutTypeArray = MainLayoutType.values();
        int n = mainLayoutTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MainLayoutType mainLayoutType = mainLayoutTypeArray[n2];
            PAction pAction = PActionRegistry.getActionNoException(MainLayoutActionProvider.getActionIDForType(mainLayoutType));
            if (pAction != null) {
                pAction.fireEnabledChanged();
            }
            ++n2;
        }
    }

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        if (!Product.isReducedVersion()) {
            MainLayoutType[] mainLayoutTypeArray = MainLayoutType.values();
            int n = mainLayoutTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MainLayoutType mainLayoutType = mainLayoutTypeArray[n2];
                arrayList.add(new MainLayoutAction(mainLayoutType));
                ++n2;
            }
            arrayList.add(new MainLayoutActionGroup(arrayList));
        } else {
            arrayList.add(new MainLayoutAction(MainLayoutType.variable));
        }
        return arrayList;
    }

    private class MainLayoutAction
    extends SelectablePAction {
        private MainLayoutType type;

        public MainLayoutAction(MainLayoutType mainLayoutType) {
            super(MainLayoutActionProvider.this.getIconForType(mainLayoutType));
            this.type = mainLayoutType;
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return LAYOUT_GROUP;
        }

        @Override
        public String getID() {
            return MainLayoutActionProvider.getActionIDForType(this.type);
        }

        @Override
        public boolean isSelected() {
            return JVision2.getMainFrame().getLytMode() == this.type;
        }

        @Override
        protected boolean isEnabledImpl() {
            for (VisScreen2 visScreen2 : JVision2.getMainFrame().getScreens()) {
                if (visScreen2.isLayoutChangeAllowed()) continue;
                return false;
            }
            return true;
        }

        private String toFirstUpper(String string) {
            return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("CustomActions1.screenLayout" + this.toFirstUpper(this.type.name()) + ".ToolTip");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            if (JVision2.getMainFrame().getLytMode() != this.type) {
                int n = this.type == MainLayoutType.variable ? 2 : 4;
                JVision2.getMainFrame().setLytMode(this.type, n, n, true);
            }
            JVision2.getMainFrame().requestFocus();
            return true;
        }
    }

    private static class MainLayoutActionGroup
    extends CompoundAbstractPAction {
        public MainLayoutActionGroup(List<PAction> list) {
            this.init(list);
        }

        @Override
        public PAction.ActionType getActionType() {
            return PAction.ActionType.SubmenuExclusive;
        }

        @Override
        public String getCaption() {
            return Messages.getString("CustomActions1.mainLayoutType.ToolTip");
        }

        @Override
        public String getGroupName() {
            return LAYOUT_GROUP;
        }

        @Override
        public String getID() {
            return MainLayoutActionProvider.MAIN_LAYOUT_GROUP_ID;
        }
    }
}

