/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.List;

public class ClearDataAction
extends AbstractPDataAction {
    public static final String ID = "CLEAR_DISPLAY";

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new ClearAction(pDataScope, pDataProvider);
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay, PDataScope.AllDisplayed};
    }

    @Override
    public String getID() {
        return ID;
    }

    private class ClearAction
    extends AbstractPDataAction.AbstractInnerPAction {
        public ClearAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(pDataScope == PDataScope.AllDisplayed ? "clear_screen.svg" : "clear_display.svg", pDataScope, pDataProvider);
        }

        @Override
        public String getCaption() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("CustomActions1.clearAllDisplays.Caption");
            }
            return Messages.getString("CustomActions1.clearCurrentDisplay.Caption");
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getToolTipText() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("CustomActions1.clearAllDisplays.ToolTip");
            }
            return Messages.getString("CustomActions1.clearCurrentDisplay.ToolTip");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            List<VisDisplay2> list = this.scope != null ? ClearDataAction.getVisDisplays(this.scope) : this.provider.getVisDisplays();
            for (VisDisplay2 visDisplay2 : list) {
                visDisplay2.clearByUser();
            }
            return true;
        }
    }
}

