/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.IUndoInformation;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.IntermediateNode;
import com.tiani.jvision.renderer.OrderedImageSequence;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.renderer.SelectorNodeController;
import com.tiani.jvision.renderer.SelectorNodePositionListener;
import com.tiani.jvision.renderer.WaitingForFrameRendererAdapter;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.util.expressions.IEvaluableData;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.dcm4che3.data.Attributes;

public class SelectorNode
extends IntermediateNode
implements OrderedImageSequence,
IEvaluableData {
    private static final String EVENT_NEXT_CHILD = "RSNNextChild";
    private static final String EVENT_PREVIOUS_CHILD = "RSNPreviousChild";
    private static final String EVENT_BEST_MATCH_CHILD = "RSNBestMatchChildChild";
    private static final String EVENT_GOTO_CHILD = "RSNGotoChild";
    private static final String EVENT_PREFETCH_NEXT_CHILD = "PrefetchNextChild";
    private static final String EVENT_PREFETCH_PREVIOUS_CHILD = "PrefetchPreviousChild";
    public static int EVENTID_GOTO_CHILD;
    public static int EVENTID_NEXT_CHILD;
    public static int EVENTID_PREVIOUS_CHILD;
    public static int EVENTID_BEST_MATCH_CHILD;
    private static int EVENTID_PREFETCH_NEXT_CHILD;
    private static int EVENTID_PREFETCH_PREVIOUS_CHILD;
    private boolean listenToMouseWheel;
    private ArrayList<SelectorNodePositionListener> positionListeners = new ArrayList(2);
    private IEventEngine engine = EventEngineFactory.getInstance();
    private IEventListenerProvider<IEventListener> listener = new EventHandler();
    protected Renderer activeChild = null;
    private volatile int activeChildIndex = -1;
    protected List<Renderer> children = new ArrayList<Renderer>(256);
    protected boolean autoSyncOnAdd = true;
    private boolean allChildrenVisible = false;
    private boolean orderChangeAllowed = false;

    static {
        EVENTID_PREFETCH_NEXT_CHILD = EventEngineFactory.getInstance().getEventID(EVENT_PREFETCH_NEXT_CHILD);
        EVENTID_PREFETCH_PREVIOUS_CHILD = EventEngineFactory.getInstance().getEventID(EVENT_PREFETCH_PREVIOUS_CHILD);
        EVENTID_NEXT_CHILD = TEvent.getThisEventID(EVENT_NEXT_CHILD);
        EVENTID_PREVIOUS_CHILD = TEvent.getThisEventID(EVENT_PREVIOUS_CHILD);
        EVENTID_BEST_MATCH_CHILD = TEvent.getThisEventID(EVENT_BEST_MATCH_CHILD);
        EVENTID_GOTO_CHILD = TEvent.getThisEventID(EVENT_GOTO_CHILD);
    }

    public SelectorNode() {
        this(false);
    }

    public SelectorNode(boolean bl) {
        this.setName("RENDERER_SELECTOR_NAME");
        this.listenToMouseWheel = bl;
    }

    public void setAutoSyncOnAdd(boolean bl) {
        this.autoSyncOnAdd = bl;
    }

    @Override
    public void addChild(Renderer renderer) {
        this.children.add(renderer);
        renderer.setName("child" + this.children.size());
        if (this.activeChild == null) {
            this.activeChild = renderer;
            this.activeChildIndex = this.children.indexOf(this.activeChild);
        } else if (this.autoSyncOnAdd && renderer != this.activeChild) {
            if (this.activeChild instanceof WaitingForFrameRendererAdapter) {
                WaitingForFrameRendererAdapter waitingForFrameRendererAdapter = (WaitingForFrameRendererAdapter)this.activeChild;
                waitingForFrameRendererAdapter.synchronizeWith(this);
            } else {
                renderer.synchronizeWith(this.activeChild);
            }
        }
    }

    @Override
    public void addOverlay(Overlay overlay) {
        this.activeChild.addOverlay(overlay);
    }

    @Override
    public List<Renderer> getChildren() {
        return new Vector<Renderer>(this.children);
    }

    @Override
    public TransferFunction getTransferFunction() {
        return this.activeChild.getTransferFunction();
    }

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2, View view) {
        return this.activeChild.getHRSet(visHRSet, vis2, view);
    }

    @Override
    public void getOptimumOutputSize(SnapOutputGeometry snapOutputGeometry) {
        this.activeChild.getOptimumOutputSize(snapOutputGeometry);
    }

    @Override
    public List<Overlay> getOverlays() {
        return this.activeChild.getOverlays();
    }

    @Override
    public Object getRaw(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        return this.activeChild.getRaw(n, n2, n3, n4, n5, n6, bl);
    }

    @Override
    public List<Renderer> getVisibleChildren() {
        if (this.allChildrenVisible) {
            return this.getChildren();
        }
        Vector<Renderer> vector = new Vector<Renderer>();
        vector.addElement(this.activeChild);
        return vector;
    }

    @Override
    public void paintOverlays(RGBBufferedImageHolder rGBBufferedImageHolder, Collection<Overlay> collection, boolean bl) {
        this.activeChild.paintOverlays(rGBBufferedImageHolder, collection, bl);
    }

    @Override
    public void removeChild(Renderer renderer) {
        int n = 0;
        while (n < this.children.size()) {
            Renderer renderer2 = this.children.get(n);
            if (renderer2 == renderer) {
                if (this.activeChild == renderer) {
                    this.activeChild = null;
                    this.activeChildIndex = -1;
                }
                renderer2.invalidate();
                if (renderer2 instanceof IntermediateNode) {
                    Renderer renderer3 = renderer2;
                    renderer2 = ((IntermediateNode)renderer2).getChildren().get(0);
                    renderer2.invalidate();
                    ((IntermediateNode)renderer3).removeSubtree(renderer2);
                    this.children.set(n, renderer2);
                    if (this.activeChild == null) {
                        this.activeChild = renderer2;
                        this.activeChildIndex = this.children.indexOf(this.activeChild);
                    }
                    return;
                }
                this.children.remove(n);
                if (this.children.size() > 0 && this.activeChild == null) {
                    this.activeChild = this.children.get(Math.max(n - 1, 0));
                    this.activeChildIndex = this.children.indexOf(this.activeChild);
                }
                return;
            }
            if (renderer2 instanceof IntermediateNode) {
                ((IntermediateNode)renderer2).removeChild(renderer);
            }
            ++n;
        }
    }

    @Override
    public void removeOverlay(Overlay overlay) {
        this.activeChild.removeOverlay(overlay);
    }

    @Override
    public void removeSubtree(Renderer renderer) {
        int n = 0;
        while (n < this.children.size()) {
            Renderer renderer2 = this.children.get(n);
            if (renderer2 == renderer) {
                if (this.activeChild == renderer) {
                    this.activeChild = null;
                    this.activeChildIndex = -1;
                }
                this.children.remove(n);
                if (this.children.size() > 0 && this.activeChild == null) {
                    this.activeChild = this.children.get(Math.max(n - 1, 0));
                    this.activeChildIndex = this.children.indexOf(this.activeChild);
                }
                return;
            }
            if (renderer2 instanceof IntermediateNode) {
                ((IntermediateNode)renderer2).removeChild(renderer);
            }
            ++n;
        }
    }

    @Override
    public void setChild(Renderer renderer, int n) {
        if (this.children.size() > n) {
            if (this.activeChild == this.children.get(n)) {
                this.activeChild = renderer;
            }
            this.children.set(n, renderer);
            this.invalidate();
        } else if (this.children.size() == n) {
            this.children.add(renderer);
            if (this.activeChild == null) {
                this.activeChild = renderer;
            }
        }
    }

    @Override
    public void storeOverlaysToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        this.activeChild.storeOverlaysToSnapshot(viewSnapshot, snapOutputGeometry);
    }

    @Override
    public void storeToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        this.activeChild.storeToSnapshot(viewSnapshot, snapOutputGeometry);
    }

    @Override
    public void updateImageState() {
        this.activeChild.updateImageState();
    }

    @Override
    public ImageState getImageState() {
        return this.activeChild.getImageState();
    }

    @Override
    public void setRawBuffer(Object object) {
        this.activeChild.setRawBuffer(object);
    }

    @Override
    public int[] getLUTForRaw() {
        return this.activeChild.getLUTForRaw();
    }

    @Override
    public int getRawContentType() {
        return this.activeChild.getRawContentType();
    }

    @Override
    public int getMaxRawValue() {
        return this.activeChild.getMaxRawValue();
    }

    @Override
    public MousePositionDestination getMouseFollower() {
        return this.activeChild.getMouseFollower();
    }

    public Renderer getActiveChild() {
        return this.activeChild;
    }

    @Override
    public synchronized boolean handleHotRegionPressed(String string, Rectangle rectangle, MouseEvent mouseEvent, View view) {
        boolean bl = false;
        int n = 0;
        while (n < this.children.size()) {
            bl |= this.children.get(n).handleHotRegionPressed(string, rectangle, mouseEvent, view);
            ++n;
        }
        return bl;
    }

    @Override
    public synchronized boolean handleHotRegionReleased(String string, MouseEvent mouseEvent, int n, int n2, View view) {
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.children.size()) {
            bl |= this.children.get(n3).handleHotRegionReleased(string, mouseEvent, n, n2, view);
            ++n3;
        }
        return bl;
    }

    @Override
    public synchronized boolean handleHotRegionDragged(String string, MouseEvent mouseEvent, int n, int n2, int n3, int n4, View view) {
        boolean bl = false;
        int n5 = 0;
        while (n5 < this.children.size()) {
            bl |= this.children.get(n5).handleHotRegionDragged(string, mouseEvent, n, n2, n3, n4, view);
            ++n5;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        int n2;
        if (tEvent.destinationNodeID == 0 || tEvent.destinationNodeID == this.nodeID) {
            if (tEvent.id == EVENTID_NEXT_CHILD) {
                n2 = this.activeChildIndex;
                if (n2 == this.children.size() - 1) {
                    if (tEvent.source instanceof SelectorNodeController) {
                        ((SelectorNodeController)tEvent.source).operationNotPossible();
                    }
                } else {
                    if (!this.selectChild(n2 + 1) || view == null) return false;
                    this.sentPrefetchEvent(true, n2 + 1);
                    view.refreshPresentationObjects();
                    view.delayedRepaint();
                }
            } else if (tEvent.id == EVENTID_PREVIOUS_CHILD) {
                n2 = this.activeChildIndex;
                if (n2 == 0) {
                    if (tEvent.source instanceof SelectorNodeController) {
                        ((SelectorNodeController)tEvent.source).operationNotPossible();
                    }
                } else {
                    if (!this.selectChild(n2 - 1) || view == null) return false;
                    this.sentPrefetchEvent(false, n2 - 1);
                    view.refreshPresentationObjects();
                    view.delayedRepaint();
                }
            } else if (tEvent.id == EVENTID_BEST_MATCH_CHILD) {
                n2 = object instanceof Integer ? this.gotoChild((Integer)object, tEvent.source) : (((String)object).indexOf(46) >= 0 ? (int)(this.gotoChild((int)Math.round(Double.parseDouble((String)object) * (double)this.children.size() - 0.5), tEvent.source) ? 1 : 0) : (int)(this.gotoChild(Integer.parseInt((String)object), tEvent.source) ? 1 : 0));
                if (view == null || n2 == 0 && view.getCaptureDestination() == null) return false;
                view.refreshPresentationObjects();
                view.delayedRepaint();
            }
            if (tEvent.id == EVENTID_GOTO_CHILD) {
                if (!this.gotoChild((Integer)object, tEvent.source) || view == null) return false;
                view.refreshPresentationObjects();
                view.delayedRepaint();
                view.invalidate();
            } else if (tEvent.id == 66) {
                if (view != null) {
                    view.refreshPresentationObjects();
                    view.delayedRepaint();
                }
                n2 = 0;
                while (n2 < this.children.size()) {
                    this.children.get(n2).handleTEvent(tEvent, object, n, view);
                    ++n2;
                }
                return true;
            }
            if (tEvent.destinationNodeID == this.nodeID) {
                return super.handleTEvent(tEvent, object, n, view);
            }
        }
        n2 = super.handleTEvent(tEvent, object, n, view) ? 1 : 0;
        int n3 = 0;
        while (n3 < this.children.size()) {
            int n4 = this.children.get(n3).handleTEvent(tEvent, object, n, view);
            n2 |= n4;
            ++n3;
        }
        return n2 != 0;
    }

    private void sentPrefetchEvent(boolean bl, int n) {
        IEvent iEvent = this.engine.createInternalEvent(bl ? EVENTID_PREFETCH_NEXT_CHILD : EVENTID_PREFETCH_PREVIOUS_CHILD);
        iEvent.setActionInfo(ActionInfo.PROGRESS);
        iEvent.setDestination(this.listener);
        iEvent.setPayload((Object)n);
        this.engine.sendEvent(iEvent);
    }

    private boolean gotoChild(int n, Object object) {
        if (n < 0) {
            n = 0;
            if (object instanceof SelectorNodeController) {
                ((SelectorNodeController)object).operationNotPossible();
            }
        }
        if (n >= this.children.size()) {
            n = this.children.size() - 1;
            if (object instanceof SelectorNodeController) {
                ((SelectorNodeController)object).operationNotPossible();
            }
        }
        return this.selectChild(n);
    }

    public void reset() {
        this.selectChild(0);
    }

    public void writeCache() {
    }

    @Override
    public void cleanUp() {
        this.children = null;
        this.activeChild = null;
        this.activeChildIndex = -1;
    }

    @Override
    public void invalidate() {
        int n = 0;
        while (n < this.children.size()) {
            this.children.get(n).invalidate();
            ++n;
        }
    }

    @Override
    public boolean isInvalid() {
        return this.activeChild.isInvalid();
    }

    @Override
    public boolean isCacheGeometryValid(boolean bl, int n, int n2, int n3, int n4, int n5) {
        return this.activeChild.isCacheGeometryValid(bl, n, n2, n3, n4, n5);
    }

    @Override
    public void setCacheGeometry(boolean bl, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        while (n6 < this.children.size()) {
            this.children.get(n6).setCacheGeometry(bl, n, n2, n3, n4, n5);
            ++n6;
        }
    }

    @Override
    public void fillBackground(boolean bl) {
        super.fillBackground(bl);
        int n = 0;
        while (n < this.children.size()) {
            this.children.get(n).fillBackground(bl);
            ++n;
        }
    }

    @Override
    public void setValid() {
        this.activeChild.setValid();
    }

    @Override
    public String resolveString(int n) {
        if (this.activeChild == null) {
            return null;
        }
        return this.activeChild.getImageInformation().resolveString(n);
    }

    @Override
    public Attributes resolveStringEnhanced(int[] nArray, int n) {
        if (this.activeChild == null) {
            return null;
        }
        return this.activeChild.getImageInformation().resolveStringEnhanced(nArray, n);
    }

    @Override
    public String[] resolveStrings(int n) {
        if (this.activeChild == null) {
            return null;
        }
        return this.activeChild.getImageInformation().resolveStrings(n);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SelectorNode selectorNode = (SelectorNode)super.clone();
        selectorNode.children = new ArrayList<Renderer>();
        int n = 0;
        while (n < this.children.size()) {
            selectorNode.children.add((Renderer)this.children.get(n).clone());
            if (this.activeChild == this.children.get(n)) {
                selectorNode.activeChild = selectorNode.children.get(n);
            }
            ++n;
        }
        selectorNode.activeChildIndex = this.activeChildIndex;
        return selectorNode;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public boolean selectChild(int n) {
        if (n >= this.children.size()) {
            n = this.children.size() - 1;
        }
        if (n < 0) {
            n = 0;
        }
        Renderer renderer = this.activeChild;
        this.activeChild = this.children.get(n);
        this.activeChildIndex = n;
        if (this.activeChild instanceof IRDCRenderer) {
            ((IRDCRenderer)((Object)this.activeChild)).checkImageLoaded();
        }
        return renderer != this.activeChild;
    }

    @Override
    public synchronized void paint(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4, boolean bl) {
        this.activeChild.paint(rGBBufferedImageHolder, n, n2, n3, n4, bl);
    }

    @Override
    public PickingResult pick(double d, double d2) {
        return this.activeChild.pick(d, d2);
    }

    @Override
    public Renderer getLeaf() {
        return this.activeChild.getLeaf();
    }

    @Override
    public IImageInformation getImageInformation() {
        return this.activeChild.getImageInformation();
    }

    public void setOrderChangeAllowed(boolean bl) {
        this.orderChangeAllowed = bl;
    }

    public boolean isOrderChangeAllowed() {
        return this.orderChangeAllowed;
    }

    @Override
    public String getMinimumPositionValue() {
        return "0";
    }

    @Override
    public String getMaximumPositionValue() {
        return Integer.toString(this.children.size() - 1);
    }

    @Override
    public String getCurrentPositionValue() {
        return Integer.toString(this.activeChildIndex);
    }

    @Override
    public int getCurrentPosition() {
        return this.activeChildIndex;
    }

    public boolean isAllChildrenVisible() {
        return this.allChildrenVisible;
    }

    public void setAllChildrenVisible(boolean bl) {
        this.allChildrenVisible = bl;
    }

    private void broadcastNewPosition() {
        for (SelectorNodePositionListener selectorNodePositionListener : this.positionListeners) {
            selectorNodePositionListener.selectorNodeIndexChanged(this.activeChildIndex);
        }
    }

    @Override
    public boolean wantsMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        return this.listenToMouseWheel;
    }

    @Override
    public boolean handleMouseWheel(MouseWheelEvent mouseWheelEvent, View view) {
        if (ModifierKeys.isSpacePressed()) {
            return this.activeChild.handleMouseWheel(mouseWheelEvent, view);
        }
        if (mouseWheelEvent.getWheelRotation() != 0) {
            TEvent tEvent = mouseWheelEvent.getWheelRotation() < 0 ? new TEvent(EVENTID_PREVIOUS_CHILD) : new TEvent(EVENTID_NEXT_CHILD);
            this.handleTEvent(tEvent, null, 0, view);
            this.broadcastNewPosition();
            return true;
        }
        return false;
    }

    public void registerIndexListener(SelectorNodePositionListener selectorNodePositionListener) {
        this.positionListeners.add(selectorNodePositionListener);
    }

    public void unRegisterIndexListener(SelectorNodePositionListener selectorNodePositionListener) {
        this.positionListeners.remove(selectorNodePositionListener);
    }

    protected void prefetchImage(int n) {
    }

    private class EventHandler
    implements IEventListener,
    IEventListenerProvider<IEventListener> {
        private EventHandler() {
        }

        public IListenerSynchronization getSync() {
            return null;
        }

        public boolean handleEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
            if (iEvent.getEventID() == EVENTID_PREFETCH_NEXT_CHILD) {
                int n = (Integer)iEvent.getPayload();
                SelectorNode.this.prefetchImage(n + 3);
            } else if (iEvent.getEventID() == EVENTID_PREFETCH_PREVIOUS_CHILD) {
                int n = (Integer)iEvent.getPayload();
                SelectorNode.this.prefetchImage(n - 3);
            }
            return false;
        }

        public boolean handleUndoEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
            return false;
        }

        public Iterator<IEventListener> iterator() {
            return new SoloIterator(this);
        }

        public Iterator<IEventListener> iterator(IEvent iEvent, String string) {
            return new SoloIterator(this);
        }
    }

    private static class SoloIterator
    implements Iterator<IEventListener> {
        private IEventListener listener;
        private boolean onFirst = true;

        public SoloIterator(IEventListener iEventListener) {
            this.listener = iEventListener;
        }

        @Override
        public boolean hasNext() {
            return this.onFirst;
        }

        @Override
        public IEventListener next() {
            if (!this.onFirst) {
                throw new NoSuchElementException();
            }
            this.onFirst = false;
            return this.listener;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

