/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.CompoundAbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.FixTextMenuPAction;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.tiani.base.data.RawDataContainerRGB;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.renderer.RDCRendererRGB;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.ArrayList;

public class RGBWindowingActions
extends CompoundAbstractPAction {
    public static final String ID = "RGB_WINDOWING";
    private static final String ID_PREFIX = "RGB_";
    private String[] captions = new String[]{Messages.getString("VISPOPUP_RGB_WINDOW_NONE"), Messages.getString("VISPOPUP_RGB_WINDOW_ALL"), Messages.getString("VISPOPUP_RGB_WINDOW_GRAY")};
    private String[] names = new String[]{Messages.getString("VISPOPUP_RGB_WINDOW_NONE_NAME"), Messages.getString("VISPOPUP_RGB_WINDOW_ALL_NAME"), Messages.getString("VISPOPUP_RGB_WINDOW_GRAY_NAME")};

    public RGBWindowingActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new FixTextMenuPAction(Messages.getString("VISPOPUP_RGB_WINDOW")));
        arrayList.add(new RGBWindowingMode(1));
        arrayList.add(new RGBWindowingMode(2));
        arrayList.add(new RGBWindowingMode(0));
        this.init(arrayList);
    }

    private RDCRendererRGB getRenderer() {
        VisData visData = AbstractPDataAction.getCurrentImage();
        if (visData == null) {
            return null;
        }
        Renderer renderer = visData.getView().getRenderer();
        if (renderer instanceof RDCRendererRGB) {
            return (RDCRendererRGB)renderer;
        }
        return null;
    }

    @Override
    protected boolean isEnabledImpl() {
        return this.getRenderer() != null;
    }

    @Override
    public String getCaption() {
        return Messages.getString("VISPOPUP_RGB_WINDOW");
    }

    @Override
    public String getGroupName() {
        return IMAGE_DISPLAY_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public boolean isUpdatingListeners() {
        return false;
    }

    private class RGBWindowingMode
    extends SelectablePAction {
        private int mode;

        public RGBWindowingMode(int n) {
            this.mode = n;
        }

        @Override
        public boolean isSelected() {
            RDCRendererRGB rDCRendererRGB = RGBWindowingActions.this.getRenderer();
            if (rDCRendererRGB == null) {
                return false;
            }
            RawDataContainerRGB rawDataContainerRGB = (RawDataContainerRGB)rDCRendererRGB.getRawDataContainer();
            return rawDataContainerRGB.getWindowableMode() == this.mode;
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getCaption() {
            return RGBWindowingActions.this.captions[this.mode];
        }

        @Override
        public String getName() {
            return RGBWindowingActions.this.names[this.mode];
        }

        @Override
        public String getGroupName() {
            return WINDOW_LEVEL_GROUP;
        }

        @Override
        public String getID() {
            return RGBWindowingActions.ID_PREFIX + this.mode;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            TEvent tEvent = new TEvent(106);
            TEventDispatch.sendEvent(tEvent, (Object)this.mode, TEventDispatch.SELECTED_VISUALS | TEventDispatch.ALL_DISPLAYS);
            return true;
        }
    }
}

