/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUTShape;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.ILUTContainer;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.RawDataContainer;
import com.tiani.base.data.RawDataContainerRGB;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.fithandler.PixelIdentityFitHandler;
import com.tiani.jvision.renderer.RDCRenderer;
import com.tiani.util.TicketOffice;
import java.awt.Rectangle;
import java.util.Arrays;

public class RDCRendererRGB
extends RDCRenderer {
    private static final ALogger log = ALogger.getLogger(RDCRendererRGB.class);
    private RawDataContainerRGB rdc = null;
    private boolean invert = false;

    RDCRendererRGB(IFrameObjectData iFrameObjectData, boolean bl, ZoomMode zoomMode) {
        super(iFrameObjectData, bl);
        if (zoomMode == ZoomMode.PIXELIDENTITY) {
            this.vpHandler = new PixelIdentityFitHandler();
        }
        this.rdc = (RawDataContainerRGB)iFrameObjectData.getRawDataContainer();
        if (this.rdc.isWindowable()) {
            this.initWindowing();
        }
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        switch (tEvent.id) {
            case 106: {
                int n2 = (Integer)object;
                this.rdc.setWindowable(n2);
                if (n2 == 0) {
                    this.windowHandler = null;
                    break;
                }
                if (this.windowHandler != null) break;
                this.initWindowing();
            }
        }
        return super.handleTEvent(tEvent, object, n, view);
    }

    @Override
    protected void applyLUTs(IFramePresentationState iFramePresentationState) {
        if (this.frameObjectData.isBeingLossyPrefetched()) {
            return;
        }
        if (this.rdc != null && this.rdc.isWindowable()) {
            this.initWindowing((ILUTContainer)iFramePresentationState);
        } else {
            this.windowHandler = null;
        }
    }

    @Override
    protected PresentationLUT getPresentationLUT() {
        if (this.invert) {
            PresentationLUT presentationLUT = new PresentationLUT();
            presentationLUT.setPresentationLUTShape(PresentationLUTShape.Inverse);
            return presentationLUT;
        }
        return super.getPresentationLUT();
    }

    private void initWindowing() {
        this.initWindowing(this.imageInformation);
    }

    private void initWindowing(ILUTContainer iLUTContainer) {
        this.windowHandler = WindowHandlerBase.getInstance(this.imageInformation, iLUTContainer, false, this.rdc.getPixelDataFrame().isSigned(), this);
        this.windowHandler.setNodeID(this.nodeID);
        this.tf = this.windowHandler.getTransferFunction();
    }

    @Override
    public void clearWindowingCache() {
    }

    @Override
    public RDCRendererRGB clone() throws CloneNotSupportedException {
        RDCRendererRGB rDCRendererRGB = (RDCRendererRGB)super.clone();
        return rDCRendererRGB;
    }

    @Override
    protected void invertAction() {
        this.invert = !this.invert;
    }

    public boolean isInverted() {
        return this.invert;
    }

    @Override
    public void reset() {
        super.reset();
        this.invert = false;
    }

    @Override
    protected void extractTo(int[] nArray, int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.fitImage(n, n2);
        n3 += rectangle.x + rectangle.y * n4;
        n = rectangle.width;
        n2 = rectangle.height;
        try {
            if (this.tf != null) {
                this.rdc.extract32bitFull(nArray, n, n2, n3, n4, this.xs, this.ys, this.ws, this.hs, this.transform, this.tf.getRGB(false), this.tf.getOffset(false));
            } else {
                this.rdc.extract32bitFull(nArray, n, n2, n3, n4, this.xs, this.ys, this.ws, this.hs, this.transform, null, 0);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            log.warn("failed to resample RGB image", (Throwable)arrayIndexOutOfBoundsException);
            Arrays.fill(nArray, 0);
        }
        catch (Exception exception) {
            log.warn("Error on image drawing occured", (Throwable)exception);
            Arrays.fill(nArray, 0);
        }
        if (this.fillBG) {
            this.doFillBackground(nArray, n, n2, n3, n4, this.getBackgroundColor().getRGB());
        }
        this.setContentStamp(TicketOffice.getNewStamp(), 0);
        if (this.invert) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = n3 + n5 * n4;
                int n7 = 0;
                while (n7 < n) {
                    int n8 = n6++;
                    nArray[n8] = nArray[n8] ^ 0xFFFFFF;
                    ++n7;
                }
                ++n5;
            }
        }
    }

    @Override
    protected void separateExtractTo(int[] nArray, int n, int n2, int n3, int n4) {
        this.extractTo(nArray, n, n2, n3, n4);
    }

    @Override
    public void setRawBuffer(Object object) {
        super.setRawBuffer(object);
    }

    @Override
    public RawDataContainer getRawDataContainer() {
        return this.rdc;
    }

    @Override
    protected void internalStoreToSnapshot(ViewSnapshot viewSnapshot) {
        int[] nArray = (int[])this.getRaw(viewSnapshot.getWidth(), viewSnapshot.getHeight(), 0, viewSnapshot.getWidth(), viewSnapshot.getWidth() * viewSnapshot.getHeight(), 0, false);
        viewSnapshot.setDataBuffer(nArray);
        super.internalStoreToSnapshot(viewSnapshot);
    }

    @Override
    protected void setRawDataContainer(RawDataContainer rawDataContainer) {
        this.rdc = (RawDataContainerRGB)rawDataContainer;
    }
}

