/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.valuemapping.ISUVData;
import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import com.agfa.pacs.data.shared.valuemapping.RealWorldValueMapping;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gsts.GrayScaleTransformationSequence;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.agfa.pacs.impaxee.presentationstate.IPresentationState;
import com.agfa.pacs.impaxee.presentationstate.IPresentationStateProvider;
import com.agfa.pacs.impaxee.presentationstate.OverlayFrameCollector;
import com.agfa.pacs.impaxee.valuemapping.ValueMappingProperties;
import com.agfa.pacs.impaxee.valuemapping.suv.ImpaxEESUVMapping;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVUtil;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayedArea;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotation;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicLayer;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUTShape;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.TextObject;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.ILUTContainer;
import com.agfa.pacs.listtext.dicomobject.presentation.PaletteColorLUTWrapper;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.math.Matrix2d;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.IRegionInfoSource;
import com.tiani.base.data.ImageRegion;
import com.tiani.base.data.Orientation;
import com.tiani.base.data.RawDataContainer;
import com.tiani.base.data.RawDataContainer16CT;
import com.tiani.base.data.RawDataContainer8CT;
import com.tiani.base.data.RawDataContainerRGB;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.ClippingCircle;
import com.tiani.jvision.image.GeneralWindowTransferFunction;
import com.tiani.jvision.image.IPickingHandler;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.OutputDeviceMetric;
import com.tiani.jvision.image.PickingHandler2D;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.SegmentedPaletteColorLUT;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.WindowTransferFunction;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.FullVisualFitHandler;
import com.tiani.jvision.image.fithandler.IViewportRestoreHandler;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.image.fithandler.PixelIdentityFitHandler;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.image.fithandler.TrueSizeFitHandler;
import com.tiani.jvision.image.fithandler.ViewPort;
import com.tiani.jvision.image.fithandler.ViewportDefinition;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.BitmapOverlay;
import com.tiani.jvision.overlay.ColorBarOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.ITextObjectContainer;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayBitmap;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ROIFactory;
import com.tiani.jvision.overlay.Shutter;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.LeafRenderer;
import com.tiani.jvision.renderer.RDCRenderer16;
import com.tiani.jvision.renderer.RDCRenderer8;
import com.tiani.jvision.renderer.RDCRendererRGB;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.toptoolbar.ZoomUtils;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.jvision.vis.VisHRSetDefault;
import com.tiani.jvision.vis.VisMouseHandler;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.dcm4che3.data.Attributes;

public abstract class RDCRenderer
extends LeafRenderer
implements IRDCRenderer,
IPresentationStateProvider,
IViewportRestoreHandler {
    private static final ALogger log = ALogger.getLogger(RDCRenderer.class);
    public static final float MINIMAL_ZOOM = 0.2f;
    private static ImageRegion infoir;
    private static final ConfigListener changeListener;
    private static String lastPixelAspectRatioErrorStudyKey;
    private static final boolean whiteBackground;
    private static final boolean autoApplyRealWorld;
    private static final boolean autoApplySUV;
    private static final String LAYER_NAME = "ROI";
    protected CacheID windowingDataId;
    protected IFrameObjectData frameObjectData;
    protected WindowHandlerBase windowHandler;
    private Rectangle pstViewport;
    protected TransferFunction tf;
    private boolean borderLockMode = false;
    private ImageDef activedef;
    protected Matrix2d transform;
    protected int xs;
    protected int ys;
    protected int ws;
    protected int hs;
    protected AreaFitHandler vpHandler = new FullVisualFitHandler(OutputDeviceMetric.screen);
    private ViewPort newViewPort = new ViewPort();
    private Rectangle imgBounds;
    private InteractionInfoHolder dragInfo;
    private IFramePresentationState currentFramePresentationState;

    static {
        changeListener = new ConfigListener();
        lastPixelAspectRatioErrorStudyKey = null;
        whiteBackground = Config.impaxee.jvision.DISPLAY.whiteBackground.get();
        autoApplyRealWorld = Config.impaxee.jvision.ValueMapping.RealWorld.AutoApply.get();
        autoApplySUV = Config.impaxee.jvision.ValueMapping.SUV.AutoApply.get();
        Config.impaxee.jvision.MEASUREMENT.DensityMeasurementRadius.registerChangeListener(changeListener);
        RDCRenderer.initInfoRegion();
    }

    public RDCRenderer(IFrameObjectData iFrameObjectData, boolean bl) {
        super(iFrameObjectData.getImageInformation());
        this.frameObjectData = iFrameObjectData;
        this.imageInformation = iFrameObjectData.getImageInformation();
        this.setRawDataContainer(this.frameObjectData.getRawDataContainer());
        IFramePresentationState iFramePresentationState = iFrameObjectData.getFramePresentationState();
        this.initSpacing();
        if (bl) {
            this.applyPresentationState(iFramePresentationState);
        } else {
            this.applyLUTs(iFramePresentationState);
        }
    }

    @Override
    public IPickingHandler getPickingHandler() {
        return PickingHandler2D.getInstance();
    }

    @Override
    public TransferFunction getTransferFunction() {
        return this.tf;
    }

    @Override
    public void setBorderLockMode(boolean bl) {
        this.borderLockMode = bl;
        if (this.vpHandler != null) {
            this.vpHandler.setBorderLockMode(this.borderLockMode);
        }
    }

    public static RDCRenderer createRenderer(IFrameObjectData iFrameObjectData, boolean bl, ZoomMode zoomMode) {
        RawDataContainer rawDataContainer = iFrameObjectData.getRawDataContainer();
        if (rawDataContainer instanceof RawDataContainer16CT) {
            return new RDCRenderer16(iFrameObjectData, bl, zoomMode);
        }
        if (rawDataContainer instanceof RawDataContainer8CT) {
            return new RDCRenderer8(iFrameObjectData, bl, zoomMode);
        }
        if (rawDataContainer instanceof RawDataContainerRGB) {
            return new RDCRendererRGB(iFrameObjectData, bl, zoomMode);
        }
        return null;
    }

    @Override
    public RDCRenderer clone() throws CloneNotSupportedException {
        RDCRenderer rDCRenderer = (RDCRenderer)super.clone();
        if (this.windowHandler != null) {
            rDCRenderer.windowHandler = WindowHandlerBase.getInstance(this.windowHandler);
            rDCRenderer.tf = rDCRenderer.windowHandler.getTransferFunction();
        }
        rDCRenderer.activedef = new ImageDef(this.activedef);
        if (this.transform != null) {
            rDCRenderer.transform = new Matrix2d(this.transform);
        }
        rDCRenderer.vpHandler = new FullVisualFitHandler(OutputDeviceMetric.screen);
        rDCRenderer.vpHandler.set(this.vpHandler);
        rDCRenderer.imageState = new ImageState(this.imageState.spacingDefs());
        rDCRenderer.imageState.setCurrentSpacingDef(this.imageState.getCurrentSpacingDef());
        if (this.imageState.hview > 0.0) {
            rDCRenderer.updateImageState(new Rectangle(0, 0, (int)this.imageState.wview, (int)this.imageState.hview));
        } else {
            this.setGeometry(512, 512, 0, 512);
            rDCRenderer.setGeometry(512, 512, 0, 512);
            rDCRenderer.updateImageState(new Rectangle(0, 0, 512, 512));
        }
        return rDCRenderer;
    }

    @Override
    public void updateImageState() {
    }

    private void initSpacing() {
        block5: {
            this.imageState.initSpacing(this.frameObjectData.getImageInformation());
            double d = this.imageState.getCurrentSpacingDef().getDataPixelSizeX();
            double d2 = this.imageState.getCurrentSpacingDef().getDataPixelSizeY();
            if (d != 0.0 && d2 != 0.0) {
                this.activedef = new ImageDef(this.imageInformation.getColumns(), this.imageInformation.getRows(), d, d2);
                this.vpHandler.setBorderLockMode(this.borderLockMode);
            } else {
                try {
                    int[] nArray = this.imageInformation.getPixelAspectRatio();
                    if (nArray == null) {
                        nArray = new int[]{1, 1};
                    }
                    this.activedef = new ImageDef(this.imageInformation.getColumns(), this.imageInformation.getRows(), 0.0, 0.0);
                    this.activedef.setAspectRatio(nArray[1], nArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string = this.frameObjectData.getParent().getParent().getKey();
                    if (lastPixelAspectRatioErrorStudyKey != null && lastPixelAspectRatioErrorStudyKey.equals(string)) break block5;
                    lastPixelAspectRatioErrorStudyKey = string;
                    ImpaxEEUtils.handleDisplayProblem(this.frameObjectData.getSOPInstanceUID(), Messages.getString("ImpaxEEUtils.PixelAspectRationProblem"), true);
                }
            }
        }
    }

    public void initValueMappings(VisDisplay2 visDisplay2) {
        this.initRealWorldValueMapping();
        if (SUVUtil.isSUVSupported(this.frameObjectData)) {
            boolean bl;
            if (visDisplay2 != null) {
                visDisplay2.updateSUVEnabledState();
            }
            if ((bl = this.initSUVMapping(visDisplay2)) && visDisplay2 != null) {
                visDisplay2.updateSUVSelectionState();
            }
        }
    }

    private void initRealWorldValueMapping() {
        if (autoApplyRealWorld) {
            this.activateRealWorldValueMapping();
        }
    }

    private boolean initSUVMapping(VisDisplay2 visDisplay2) {
        if (autoApplySUV && SUVUtil.isSUVSupported(this.frameObjectData)) {
            return this.activateSUV(visDisplay2);
        }
        return false;
    }

    private void activateRealWorldValueMapping() {
        List<RealWorldValueMapping> list = this.getImageInformation().getRealWorldValueMappings();
        if (list.size() == 1) {
            this.imageState.setCurrentValueMapping((IValueMapping)list.get(0));
        }
    }

    private boolean activateSUV(VisDisplay2 visDisplay2) {
        ISUVData iSUVData = SUVUtil.getSUVDataForFrame(visDisplay2, this.frameObjectData);
        if (SUVUtil.isSUVPermitted() && !iSUVData.needsData()) {
            this.imageState.setCurrentValueMapping((IValueMapping)new ImpaxEESUVMapping(iSUVData, new ValueMappingProperties(this)));
            return true;
        }
        return false;
    }

    @Override
    public void setNodeID(int n) {
        super.setNodeID(n);
        if (this.windowHandler != null) {
            this.windowHandler.setNodeID(this.nodeID);
        }
    }

    private boolean tfChanged() {
        return this.tf != null && (long)this.tf.getUpdateID() > super.getContentStamp(0);
    }

    @Override
    public IRegionInfoSource getRegionSource() {
        IRegionInfoSource iRegionInfoSource = this.getRawDataContainer();
        for (Overlay overlay : this.overlays) {
            if (!(overlay instanceof IRegionInfoSource) || iRegionInfoSource != null && iRegionInfoSource.getInfoSourcePriority() >= ((IRegionInfoSource)((Object)overlay)).getInfoSourcePriority()) continue;
            iRegionInfoSource = (IRegionInfoSource)((Object)overlay);
        }
        return iRegionInfoSource;
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2 = this.tfChanged();
        boolean bl3 = bl & bl2;
        if (bl3) {
            this.separateExtractTo(rGBBufferedImageHolder.data, n, n2, n3, n4);
        } else {
            this.extractTo(rGBBufferedImageHolder.data, n, n2, n3, n4);
        }
        this.setValid();
    }

    @Override
    public Object getRaw(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int[] nArray = cache.allocInts((long)n5);
        this.extractTo(nArray, n, n2, n3, n4);
        return nArray;
    }

    protected abstract void extractTo(int[] var1, int var2, int var3, int var4, int var5);

    protected abstract void separateExtractTo(int[] var1, int var2, int var3, int var4, int var5);

    @Override
    public int getMaxRawValue() {
        return this.tf.getGrays() - 1;
    }

    @Override
    public int getRawValueOffset() {
        return this.tf.getOffset(false);
    }

    @Override
    public int[] getLUTForRaw() {
        return this.tf.getRGB(false);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.windowHandler = null;
        this.tf = null;
        this.clearWindowingCache();
    }

    protected void invertAction() {
        if (this.windowHandler != null && this.windowHandler.getGSTS() != null) {
            this.windowHandler.getGSTS().setInversion(!this.windowHandler.getGSTS().getInversion());
        }
        this.tf.recalc();
    }

    private void flipHorizontalAction() {
        this.applyTransform(Matrix2d.trafoFlipH);
    }

    private void flipVerticalAction() {
        this.applyTransform(Matrix2d.trafoFlipV);
    }

    private void rotateLeft90Action() {
        this.applyTransform(Matrix2d.trafoRotL);
    }

    private void rotateRight90Action() {
        this.applyTransform(Matrix2d.trafoRotR);
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean bl) {
        this.clearWindowingCache();
        if (this.windowHandler != null) {
            if (this.currentFramePresentationState != null && this.currentFramePresentationState.isTemporary()) {
                this.windowHandler.reset(this.imageInformation);
            } else {
                this.windowHandler.reset(null);
            }
            this.tf = this.windowHandler.getTransferFunction();
        }
        if (bl) {
            this.setTransform(Orientation.createStandardTransform2D(this.imageInformation));
        }
        this.pstViewport = null;
        this.vpHandler.setZoomFactor(this.getDefaultZoomFactor());
        this.activedef.resetTransformedViewportCenter();
        int n = this.imageState.spacingDefs().size();
        this.imageState.setCurrentSpacingDef(n - 1);
        this.invalidate();
    }

    @Override
    public MousePositionDestination getMouseFollower() {
        return this;
    }

    @Override
    public void setMousePosition(int n, int n2, double d, double d2, int n3, int n4) {
    }

    private static void initInfoRegion() {
        int n = (int)Config.impaxee.jvision.MEASUREMENT.DensityMeasurementRadius.get();
        infoir = n == 0 ? new ImageRegion() : new ImageRegion(new ClippingCircle(0, 0, n));
    }

    @Override
    public String getInfoAt(int n, int n2, int n3, int n4) {
        if (this.windowHandler == null) {
            return null;
        }
        if (this.isInvalid()) {
            this.fitImage(n3, n4);
        }
        double[] dArray = new double[]{n, n2};
        double[] dArray2 = new double[]{0.0, 0.0};
        ImageState imageState = this.getImageState();
        imageState.screenToImage(dArray, dArray2, null);
        RDCRenderer.infoir.x = (int)dArray2[0];
        RDCRenderer.infoir.y = (int)dArray2[1];
        if (RDCRenderer.infoir.clip != null) {
            ((ClippingCircle)RDCRenderer.infoir.clip).setCenter(RDCRenderer.infoir.x, RDCRenderer.infoir.y);
        }
        IImageRegionProperties iImageRegionProperties = this.getRawDataContainer().getImageRegionProperties(infoir, 0, 0, imageState.getCurrentValueMapping());
        return iImageRegionProperties.getStatistics();
    }

    @Override
    public AreaFitHandler getAreaFitHandler() {
        return this.vpHandler;
    }

    @Override
    public void setAreaFitHandler(AreaFitHandler areaFitHandler) {
        try {
            AreaFitHandler areaFitHandler2 = this.vpHandler;
            this.vpHandler = areaFitHandler.getClone();
            if (this.vpHandler instanceof FullVisualFitHandler) {
                ((FullVisualFitHandler)this.vpHandler).matchTotalZoom(areaFitHandler2.getZoomFactor() * areaFitHandler2.getViewScaleX());
            }
        }
        catch (Exception exception) {
            log.error("could not clone viewport handler", (Throwable)exception);
        }
        this.vpHandler.setBorderLockMode(this.borderLockMode);
        this.invalidate();
    }

    @Override
    public Rectangle getContentBounds() {
        return this.imgBounds;
    }

    protected Rectangle fitImage(int n, int n2) {
        if (this.imgBounds == null) {
            this.imgBounds = new Rectangle();
        }
        if (n == 0 || n2 == 0) {
            return this.imgBounds;
        }
        this.vpHandler.setViewScale(this.activedef, n, n2);
        Rectangle rectangle = this.pstViewport;
        if (rectangle != null) {
            Vector2d vector2d = new Vector2d(this.activedef.getViewportCenter());
            this.vpHandler.checkViewPortCenter(this.activedef, n, n2);
            this.vpHandler.updateViewPort(this.activedef, this.newViewPort, this.imgBounds, n, n2);
            this.setSourceArea(this.newViewPort.getXFp(), this.newViewPort.getYFp(), this.newViewPort.getWidthFp(), this.newViewPort.getHeightFp(), this.activedef.getPossibleTransform());
            this.updateImageState(this.imgBounds);
            double d = rectangle.width;
            double d2 = rectangle.height;
            double[] dArray = new double[]{0.0, 0.0};
            double[] dArray2 = new double[]{0.0, 0.0};
            this.getImageState().screenToImage(dArray, dArray2, null);
            float f = (float)dArray2[0];
            float f2 = (float)dArray2[1];
            dArray[0] = n;
            dArray[1] = n2;
            this.getImageState().screenToImage(dArray, dArray2, null);
            double d3 = Math.abs(dArray2[0] - (double)f);
            double d4 = Math.abs(dArray2[1] - (double)f2);
            double d5 = this.vpHandler.getAbsoluteZoomFactor();
            double d6 = d4 / d2;
            double d7 = d3 / d;
            if (this.vpHandler.getZoomFactor() == 1.0 && this.vpHandler instanceof FullVisualFitHandler) {
                ((FullVisualFitHandler)this.vpHandler).matchTotalZoom(d5 * Math.min(d7, d6));
            }
            this.pstViewport = null;
            this.activedef.setViewportCenter(vector2d);
            Rectangle rectangle2 = this.fitImage(n, n2);
            return rectangle2;
        }
        this.vpHandler.checkViewPortCenter(this.activedef, n, n2);
        this.vpHandler.updateViewPort(this.activedef, this.newViewPort, this.imgBounds, n, n2);
        Rectangle rectangle3 = this.newViewPort.getRectangle();
        this.setSourceArea(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, this.activedef.getTransform());
        this.updateImageState(this.imgBounds);
        ImageState imageState = this.getImageState();
        imageState.wview = n;
        imageState.hview = n2;
        this.updateOverlays(n, n2);
        return this.imgBounds;
    }

    private void applyTransform(Matrix2d matrix2d) {
        this.activedef.applyTransform(matrix2d);
        this.invalidate();
    }

    public void setTransform(Matrix2d matrix2d) {
        if (!this.activedef.isIdentity() || !matrix2d.isIdentity()) {
            boolean bl = !this.activedef.getTransform().equals(matrix2d);
            this.activedef.setTransform(matrix2d);
            if (bl) {
                this.invalidate();
            }
        }
    }

    private void panRelative(double d, double d2) {
        double d3 = this.getDrag().xstart + d / this.vpHandler.getZoomFactor() / (this.vpHandler.getViewScaleX() / (1.0 / (double)this.activedef.getDisplayedColumns()));
        double d4 = this.getDrag().ystart + d2 / this.vpHandler.getZoomFactor() / (this.vpHandler.getViewScaleY() / (1.0 / (double)this.activedef.getDisplayedRows()));
        this.activedef.setTransformedViewportCenter(d3, d4);
        double[] dArray = this.activedef.getInterchangeableViewportCenter();
        TEvent tEvent = new TEvent();
        tEvent.id = 2;
        tEvent.interactionModifier = 1;
        tEvent.destinationNodeID = this.nodeID;
        TEventDispatch.sendEvent(tEvent, (Object)dArray, this.isViewportChangeDispatchedToSynchronizedDisplays());
    }

    @Override
    public void broadcastViewportChange(ViewportDefinition viewportDefinition) {
        TEventDispatch.sendEvent(new TEvent(17), (Object)viewportDefinition, this.isViewportChangeDispatchedToSynchronizedDisplays());
    }

    protected void broadcastViewportChangeOnMouseWheel(ViewportDefinition viewportDefinition) {
        this.broadcastViewportChange(viewportDefinition);
    }

    public boolean isViewportChangeDispatchedToSynchronizedDisplays() {
        return true;
    }

    protected double getDefaultZoomFactor() {
        return 1.0;
    }

    private void getZoomRectModeCenter(float f, Vector2d vector2d, Vector2d vector2d2) {
        vector2d2.x = 1.0 / (double)f;
        vector2d2.y = 1.0 / (double)f;
        vector2d.x = this.getDrag().centerX - vector2d2.x / 2.0;
        vector2d.y = this.getDrag().centerY - vector2d2.y / 2.0;
    }

    private float getNormalizedViewCenterY() {
        return (float)this.activedef.getTransformedViewportCenter()[0];
    }

    private float getNormalizedViewCenterX() {
        return (float)this.activedef.getTransformedViewportCenter()[1];
    }

    private void setZoomFactorFromMouseDrag() {
        if (this.getDrag().currentZoom > 8.0) {
            this.getDrag().currentZoom = 8.0;
        } else if (this.getDrag().currentZoom < (double)0.2f) {
            this.getDrag().currentZoom = 0.2f;
        }
        this.vpHandler.setZoomFactor(this.getDrag().currentZoom);
    }

    private void centerZoomStart() {
        this.getDrag().centerX = this.getNormalizedViewCenterX();
        this.getDrag().centerY = this.getNormalizedViewCenterY();
        TEvent tEvent = new TEvent();
        tEvent.id = 2;
        tEvent.interactionModifier = 0;
        tEvent.destinationNodeID = this.nodeID;
        TEventDispatch.sendEvent(tEvent, new ZoomParameter(this));
    }

    private void centerZoomProgress() {
        this.setZoomFactorFromMouseDrag();
        TEvent tEvent = new TEvent();
        tEvent.id = 2;
        tEvent.interactionModifier = 1;
        tEvent.destinationNodeID = this.nodeID;
        TEventDispatch.sendEvent(tEvent, new ZoomParameter(this));
    }

    private void centerZoomEnd(View view) {
        this.clearWindowingCache();
        this.setZoomFactorFromMouseDrag();
        TEvent tEvent = new TEvent();
        tEvent.id = 2;
        tEvent.interactionModifier = 2;
        tEvent.destinationNodeID = this.nodeID;
        tEvent.source = view;
        if (view == null) {
            TEventDispatch.sendEvent(tEvent, new ZoomParameter(this));
        } else {
            TEventDispatch.sendEvent(view.getDisplay(), tEvent, (Object)new ZoomParameter(this), this.isViewportChangeDispatchedToSynchronizedDisplays());
            view.delayedRepaintBroadcast();
        }
    }

    private void setViewport(ViewportDefinition viewportDefinition) {
        this.fitImage(viewportDefinition.cwidth, viewportDefinition.cheight);
        ImageState imageState = this.getImageState();
        switch (viewportDefinition.getType()) {
            case RELATIVE: {
                if (viewportDefinition.relWidth != 0.0 && viewportDefinition.relHeight != 0.0) {
                    double d = viewportDefinition.relXo;
                    double d2 = viewportDefinition.relYo;
                    double d3 = viewportDefinition.relWidth;
                    double d4 = viewportDefinition.relHeight;
                    d = (d * (double)viewportDefinition.cwidth - (double)imageState.validBounds.x) / (double)imageState.validBounds.width;
                    d2 = (d2 * (double)viewportDefinition.cheight - (double)imageState.validBounds.y) / (double)imageState.validBounds.height;
                    d3 = d3 * (double)viewportDefinition.cwidth / (double)imageState.validBounds.width;
                    d4 = d4 * (double)viewportDefinition.cheight / (double)imageState.validBounds.height;
                    double d5 = (this.newViewPort.x + this.newViewPort.width * d) / (double)this.activedef.getDisplayedColumns();
                    double d6 = (this.newViewPort.y + this.newViewPort.height * d2) / (double)this.activedef.getDisplayedRows();
                    double d7 = d3 * this.newViewPort.width / (double)this.activedef.getDisplayedColumns();
                    double d8 = d4 * this.newViewPort.height / (double)this.activedef.getDisplayedRows();
                    this.activedef.setTransformedViewportCenter(d5 + d7 / 2.0, d6 + d8 / 2.0);
                    d7 = d8 = Math.min(d7, d8);
                    this.setZoomFactor(d7);
                    break;
                }
                double[] dArray = new double[]{viewportDefinition.relXo * (double)viewportDefinition.cwidth, viewportDefinition.relYo * (double)viewportDefinition.cheight};
                double[] dArray2 = new double[]{0.0, 0.0};
                imageState.screenToImage(dArray, dArray2, null);
                this.activedef.setTransformedViewportCenter(dArray2[0] / (double)this.activedef.getDisplayedColumns(), dArray2[1] / (double)this.activedef.getDisplayedRows());
                break;
            }
            case IMAGE_PIXEL_RELATIVE: {
                double d = this.activedef.getTransformedViewportCenter()[0] * (double)this.activedef.getDisplayedColumns() + viewportDefinition.pixelXo;
                double d9 = this.activedef.getTransformedViewportCenter()[1] * (double)this.activedef.getDisplayedRows() + viewportDefinition.pixelYo;
                this.activedef.setTransformedViewportCenter(d / (double)this.activedef.getDisplayedColumns(), d9 / (double)this.activedef.getDisplayedRows());
                break;
            }
            case IMAGE_PIXEL_ABSOLUTE: {
                if (viewportDefinition.pixelWidth == 0.0) {
                    double d = viewportDefinition.pixelXo / (double)this.activedef.getUntransformedColumns();
                    double d10 = viewportDefinition.pixelYo / (double)this.activedef.getUntransformedRows();
                    Vector2d vector2d = this.activedef.getViewportCenter();
                    vector2d.x = d;
                    vector2d.y = d10;
                    break;
                }
                double d = (viewportDefinition.pixelXo + viewportDefinition.pixelWidth / 2.0) / (double)this.activedef.getUntransformedColumns();
                double d11 = (viewportDefinition.pixelYo + viewportDefinition.pixelHeight / 2.0) / (double)this.activedef.getUntransformedRows();
                Vector2d vector2d = this.activedef.getViewportCenter();
                vector2d.x = d;
                vector2d.y = d11;
                double d12 = viewportDefinition.pixelWidth / (double)this.activedef.getDisplayedColumns();
                double d13 = viewportDefinition.pixelHeight / (double)this.activedef.getDisplayedRows();
                this.setZoomFactor(Math.min(d12, d13));
                break;
            }
            case IMAGE_PIXEL_ABSOLUTE_NORMALIZED: {
                this.activedef.setTransformedViewportCenter(viewportDefinition.pixelXo, viewportDefinition.pixelYo);
            }
        }
    }

    private void setZoomFactor(double d) {
        this.pstViewport = null;
        this.vpHandler.setZoomFactor(1.0 / d);
    }

    public abstract void clearWindowingCache();

    private boolean zoomHandleTEvent(TEvent tEvent, Object object, View view) {
        if (tEvent.destinationNodeID != 0 && tEvent.destinationNodeID != this.nodeID) {
            return false;
        }
        this.clearWindowingCache();
        switch (tEvent.id) {
            case 17: {
                ViewportDefinition viewportDefinition = null;
                if (object instanceof PickingResult) {
                    PickingResult pickingResult = (PickingResult)object;
                    IImageInformation iImageInformation = this.frameObjectData.getImageInformation();
                    Point3d point3d = pickingResult.getPoint(pickingResult.frameOfReferenceUID);
                    if (point3d != null && iImageInformation.getFrameOfReferenceUID() != null && iImageInformation.getPointOrigin() != null && iImageInformation.getImageOrientation() != null) {
                        Vector3d vector3d = pickingResult.projectToPlane(iImageInformation);
                        Vector2d vector2d = PickingResult.worldToImage((Tuple3d)vector3d, iImageInformation);
                        viewportDefinition = ViewportDefinition.getImageAbsolute(vector2d.x, vector2d.y);
                    } else if (point3d != null) {
                        viewportDefinition = ViewportDefinition.getImageAbsolute(point3d.x, point3d.y);
                    }
                } else {
                    viewportDefinition = (ViewportDefinition)object;
                }
                if (viewportDefinition != null) {
                    this.setViewport(viewportDefinition);
                    this.invalidate();
                }
                if (view != null) {
                    view.delayedRepaint();
                }
                return true;
            }
            case 2: {
                if (tEvent.interactionModifier != 2) break;
                if (object instanceof ZoomParameter) {
                    this.pstViewport = null;
                    double d = this.calculateZoomFactor((ZoomParameter)object, view);
                    if (Double.isNaN(d) || Double.isInfinite(d) || !(Math.abs(d - 1.0 / this.vpHandler.getZoomFactor()) > 0.001)) break;
                    this.vpHandler.setZoomFactor(1.0 / d);
                    this.invalidate();
                    return true;
                }
                if (this.activedef.getInterchangeableViewportCenter() == object) break;
                double[] dArray = (double[])object;
                this.activedef.setInterchangeableViewportCenter(dArray[0], dArray[1]);
                this.invalidate();
                return true;
            }
        }
        return false;
    }

    private double calculateZoomFactor(ZoomParameter zoomParameter, View view) {
        SpacingDef spacingDef;
        if (view != null && (zoomParameter.matchForced || view.getVis().getParent().isMatchSizeOnSynchronisation()) && zoomParameter.isRelative() && this.getAreaFitHandler().isUnrestrictedZoom() && (spacingDef = this.imageState.getCurrentSpacingDef()).getSizeUnit().isMM() && DoubleEquals.equals((double)zoomParameter.spacing.getAspectRatio(), (double)spacingDef.getAspectRatio(), (double)1.0E-4)) {
            this.fitImage(view.getcwidth(), view.getcheight());
            double d = ZoomParameter.getDensity(this);
            return zoomParameter.density / d * (1.0 / this.getAreaFitHandler().getZoomFactor());
        }
        return zoomParameter.zoom;
    }

    private void setSourceArea(int n, int n2, int n3, int n4, Matrix2d matrix2d) {
        double[] dArray = new double[]{1.0, this.activedef.getRowScalingFactor()};
        if (matrix2d != null) {
            matrix2d.transform(dArray);
        }
        int n5 = (int)((double)n / Math.abs(dArray[0]));
        int n6 = (int)((double)n2 / Math.abs(dArray[1]));
        int n7 = (int)((double)n3 / Math.abs(dArray[0]));
        int n8 = (int)((double)n4 / Math.abs(dArray[1]));
        if (n5 != this.xs || n6 != this.ys || n7 != this.ws || n8 != this.hs || matrix2d != null && !Objects.equals(this.transform, matrix2d)) {
            if (matrix2d != null) {
                this.transform = matrix2d;
            }
            this.invalidate();
        }
        this.xs = n5;
        this.ys = n6;
        this.ws = n7;
        this.hs = n8;
        if (matrix2d != null) {
            this.transform = matrix2d;
        }
    }

    private double getPixelSizeY() {
        return this.activedef.getDisplayedPixelSpaceY() / this.vpHandler.getZoomFactor() / this.vpHandler.getViewScaleY();
    }

    @Override
    public double getPixelSizeX() {
        return this.activedef.getDisplayPixelSpaceX() / this.vpHandler.getZoomFactor() / this.vpHandler.getViewScaleX();
    }

    @Override
    public abstract RawDataContainer getRawDataContainer();

    private void updateImageState(Rectangle rectangle) {
        ImageState imageState = super.getImageState();
        boolean bl = false;
        try {
            boolean bl2;
            imageState.validBounds = rectangle;
            imageState.transform = this.activedef.getTransform();
            double d = this.getPixelSizeX();
            double d2 = this.getPixelSizeY();
            bl |= d != imageState.pixelSizeX;
            bl |= d2 != imageState.pixelSizeY;
            imageState.pixelSizeX = d;
            imageState.pixelSizeY = d2;
            if (this.windowHandler != null) {
                imageState.window = this.windowHandler.getWindow();
                imageState.updated();
            }
            double d3 = 0.0;
            double d4 = 0.0;
            int n = 1;
            int n2 = 1;
            double[] dArray = new double[]{1.0, 1.0};
            this.activedef.getTransform().transform(dArray);
            if (dArray[0] < 0.0) {
                d3 = this.activedef.toTrueWidth(this.activedef.getDisplayedColumns());
                n = -1;
            }
            if (dArray[1] < 0.0) {
                d4 = this.activedef.toTrueHeight(this.activedef.getDisplayedRows());
                n2 = -1;
            }
            int n3 = (bl2 = this.activedef.isRotated()) ? 1 : 0;
            int n4 = 1 - n3;
            double d5 = (double)n * this.activedef.toTrueWidth(this.newViewPort.width);
            double d6 = (double)n2 * this.activedef.toTrueHeight(this.newViewPort.height);
            d = imageState.cv[0];
            d2 = imageState.cv[1];
            imageState.cv[n3] = d5 / (double)rectangle.width;
            imageState.cv[n4] = 0.0;
            bl |= d != imageState.cv[0];
            bl |= d2 != imageState.cv[1];
            d = imageState.rv[0];
            d2 = imageState.rv[1];
            imageState.rv[n3] = 0.0;
            imageState.rv[n4] = d6 / (double)rectangle.height;
            bl |= d != imageState.rv[0];
            bl |= d2 != imageState.rv[1];
            d = imageState.visOrig[0];
            d2 = imageState.visOrig[1];
            double d7 = d3 + (double)n * this.activedef.toTrueWidth(this.newViewPort.x);
            double d8 = d4 + (double)n2 * this.activedef.toTrueHeight(this.newViewPort.y);
            imageState.visOrig[n3] = d7 - (double)rectangle.x * imageState.cv[n3];
            imageState.visOrig[n4] = d8 - (double)rectangle.y * imageState.rv[n4];
            bl |= d != imageState.visOrig[0];
            boolean bl3 = d2 != imageState.visOrig[1];
            imageState.s2i.set(imageState.cv[0], imageState.rv[0], imageState.cv[1], imageState.rv[1]);
            imageState.i2s.invert(imageState.s2i);
            if (bl |= bl3) {
                imageState.updated();
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    @Override
    public boolean handleHotRegionPressed(String string, Rectangle rectangle, MouseEvent mouseEvent, View view) {
        if (string.equals("FLIP_HOR")) {
            return true;
        }
        if (string.equals("FLIP_VER")) {
            return true;
        }
        if (string.equals("ROTATE_LEFT")) {
            return true;
        }
        if (string.equals("ROTATE_RIGHT")) {
            return true;
        }
        if (string.equals("ZOOM")) {
            this.getDrag().currentZoom = this.vpHandler.getZoomFactor();
            this.centerZoomStart();
            return true;
        }
        if (string.equals("PAN")) {
            double[] dArray = this.activedef.getTransformedViewportCenter();
            this.getDrag().xstart = dArray[0];
            this.getDrag().ystart = dArray[1];
            TEvent tEvent = new TEvent();
            tEvent.id = 2;
            tEvent.interactionModifier = 0;
            tEvent.destinationNodeID = this.nodeID;
            TEventDispatch.sendEvent(tEvent, (Object)this.activedef.getInterchangeableViewportCenter(), this.isViewportChangeDispatchedToSynchronizedDisplays());
            return true;
        }
        return false;
    }

    @Override
    public boolean handleHotRegionReleased(String string, MouseEvent mouseEvent, int n, int n2, View view) {
        if (string.equals("FLIP_HOR")) {
            TEvent tEvent = new TEvent();
            tEvent.id = 7;
            tEvent.source = view;
            tEvent.destinationNodeID = this.nodeID;
            this.handleTEvent(tEvent, null, 0, view);
            TEventDispatch.sendEvent(tEvent, null);
            view.delayedRepaintBroadcast();
            return true;
        }
        if (string.equals("FLIP_VER")) {
            TEvent tEvent = new TEvent();
            tEvent.id = 8;
            tEvent.source = view;
            tEvent.destinationNodeID = this.nodeID;
            this.handleTEvent(tEvent, null, 0, view);
            TEventDispatch.sendEvent(tEvent, null);
            view.delayedRepaintBroadcast();
            return true;
        }
        if (string.equals("ROTATE_LEFT")) {
            TEvent tEvent = new TEvent();
            tEvent.id = 9;
            tEvent.source = view;
            tEvent.destinationNodeID = this.nodeID;
            this.handleTEvent(tEvent, null, 0, view);
            TEventDispatch.sendEvent(tEvent, null);
            view.delayedRepaintBroadcast();
            return true;
        }
        if (string.equals("ROTATE_RIGHT")) {
            TEvent tEvent = new TEvent();
            tEvent.id = 10;
            tEvent.source = view;
            tEvent.destinationNodeID = this.nodeID;
            this.handleTEvent(tEvent, null, 0, view);
            TEventDispatch.sendEvent(tEvent, null);
            view.delayedRepaintBroadcast();
            return true;
        }
        if (string.equals("ZOOM")) {
            this.centerZoomEnd(view);
            this.dragInfo = null;
            return true;
        }
        if (string.equals("PAN")) {
            this.clearWindowingCache();
            double[] dArray = this.activedef.getInterchangeableViewportCenter();
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            TEvent tEvent = new TEvent();
            tEvent.id = 2;
            tEvent.interactionModifier = 2;
            tEvent.destinationNodeID = this.nodeID;
            tEvent.source = view;
            TEventDispatch.sendEvent(tEvent, (Object)dArray2, this.isViewportChangeDispatchedToSynchronizedDisplays());
            if (view != null) {
                view.delayedRepaintBroadcast();
            }
            this.dragInfo = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMouseWheel(MouseWheelEvent mouseWheelEvent, View view) {
        IMouseModeInfo iMouseModeInfo = view.getDisplayData().getDisplayPlugin().getMouseModeInfo();
        if (ModifierKeys.isSpaceOr4thMButton((MouseEvent)mouseWheelEvent) || VisMouseHandler.zoomByMouseWheel(mouseWheelEvent, view) || iMouseModeInfo.getSubMode() == MouseSubModes.ZOOM_PAN) {
            if (iMouseModeInfo.getSubMode().isMeasurement()) {
                iMouseModeInfo.storeStateBeforeMeasurement(this, this.activedef.getViewportCenter(), this.vpHandler.getZoomFactor());
            }
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            dArray[0] = mouseWheelEvent.getPoint().x;
            dArray[1] = mouseWheelEvent.getPoint().y;
            this.imageState.screenToImage(dArray, dArray2, null);
            this.getDrag().currentZoom = this.vpHandler.getZoomFactor() * RDCRenderer.getZoomFactorChange(mouseWheelEvent);
            this.centerZoomEnd(view);
            this.fitImage(view.getcwidth(), view.getcheight());
            this.imageState.screenToImage(dArray, dArray3, null);
            double[] dArray4 = this.activedef.getTransformedViewportCenter();
            double d = (dArray3[0] - dArray2[0]) / (double)this.activedef.getColumnCount();
            double d2 = (dArray3[1] - dArray2[1]) / (double)this.activedef.getRowCount();
            Vector2d vector2d = new Vector2d();
            vector2d.x = this.activedef.isFlippedHorizontally() ? dArray4[0] + d : dArray4[0] - d;
            vector2d.y = this.activedef.isFlippedVertically() ? dArray4[1] + d2 : dArray4[1] - d2;
            this.restoreViewportCenter(view, vector2d.x, vector2d.y);
            view.getMapping().updateContent(true, true);
            view.invalidate();
            view.repaint();
            return true;
        }
        return false;
    }

    @Override
    public void restoreViewportCenter(View view, double d, double d2) {
        ViewportDefinition viewportDefinition = ViewportDefinition.getImageAbsoluteNormalized(d, d2);
        viewportDefinition.src = view;
        this.broadcastViewportChangeOnMouseWheel(viewportDefinition);
    }

    @Override
    public boolean handleHotRegionDragged(String string, MouseEvent mouseEvent, int n, int n2, int n3, int n4, View view) {
        if (string.equals("ZOOM")) {
            this.getDrag().currentZoom *= Math.pow(2.0, (double)(-n4) / 60.0);
            this.centerZoomProgress();
            this.invalidate();
            return true;
        }
        if (string.equals("PAN")) {
            this.panRelative(-((float)n), -((float)n2));
            this.invalidate();
            return true;
        }
        return false;
    }

    private InteractionInfoHolder getDrag() {
        if (this.dragInfo == null) {
            this.dragInfo = new InteractionInfoHolder();
            return this.dragInfo;
        }
        return this.dragInfo;
    }

    private void localWindow(double d, double d2, int n, View view) {
        if (n == 0) {
            n = 10;
        }
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{0.0, 0.0};
        this.imageState.screenToImage(dArray, dArray2, null);
        ClippingCircle clippingCircle = new ClippingCircle((int)dArray2[0], (int)dArray2[1], n);
        clippingCircle.setBBoxOnly(view == null);
        ImageRegion imageRegion = new ImageRegion(clippingCircle);
        try {
            IImageRegionProperties iImageRegionProperties = this.getRawDataContainer().getImageRegionProperties(imageRegion, 0, 0, null);
            double d3 = iImageRegionProperties.getMean();
            double d4 = iImageRegionProperties.getStdDev() * 4.0;
            if (this.windowHandler != null) {
                this.windowHandler.setDataWindow(d3, d4, view != null);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            log.error("Exc:", (Throwable)arrayIndexOutOfBoundsException);
        }
    }

    private void calibratePixelSize(double d, double d2, double d3) {
        double d4 = d;
        double d5 = d2 * this.activedef.getRowScalingFactor();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = d3 / d6;
        double d8 = d3 / d6 * this.activedef.getRowScalingFactor();
        if (d7 != 0.0 && d8 != 0.0) {
            SpacingDef spacingDef = new SpacingDef();
            spacingDef.setSizeUnit(SpacingDef.Unit.mm_man);
            spacingDef.setDataPixelSizeX(d7);
            spacingDef.setDataPixelSizeY(d8);
            ImageState imageState = this.getImageState();
            imageState.setCurrentSpacingDef(spacingDef);
            this.activedef.resetAspectRatio();
            this.activedef.setPixelSpacing(spacingDef);
        }
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (tEvent.destinationNodeID != 0 && tEvent.destinationNodeID != this.nodeID) {
            return false;
        }
        switch (tEvent.id) {
            case 2: 
            case 17: {
                return this.zoomHandleTEvent(tEvent, object, view);
            }
            case 132: {
                if (!(object instanceof AreaFitHandler.ViewportCenterAlignmentX)) break;
                this.getAreaFitHandler().setViewportCenterAlignmentX((AreaFitHandler.ViewportCenterAlignmentX)((Object)object));
                return true;
            }
            case 62: 
            case 63: 
            case 64: {
                if (this.windowHandler == null) break;
                int n2 = this.windowHandler.handleTEvent(tEvent, object, n, view);
                this.tf = this.windowHandler.getTransferFunction();
                if (tEvent.id == 64) {
                    this.updateNearestNeighbourInterpolationSetting();
                }
                return n2 != 0;
            }
            case 69: {
                WindowHandlerBase windowHandlerBase = this.getWindowHandler();
                if (windowHandlerBase != null && windowHandlerBase.canPerformLocalWindowing()) {
                    this.localWindow(((Point)object).getX(), ((Point)object).getY(), 0, view);
                    this.invalidate();
                    if (view != null) {
                        view.delayedRepaintBroadcast();
                    }
                }
                return true;
            }
            case 65: {
                Point3d point3d = (Point3d)object;
                this.calibratePixelSize(point3d.x, point3d.y, point3d.z);
                return true;
            }
            case 6: {
                this.invertAction();
                if (view != null) {
                    view.delayedRepaint();
                }
                return true;
            }
            case 7: {
                this.clearWindowingCache();
                this.flipHorizontalAction();
                return true;
            }
            case 8: {
                this.clearWindowingCache();
                this.flipVerticalAction();
                return true;
            }
            case 9: {
                this.clearWindowingCache();
                this.rotateLeft90Action();
                return true;
            }
            case 10: {
                this.clearWindowingCache();
                this.rotateRight90Action();
                return true;
            }
            case 80: {
                this.clearWindowingCache();
                if (view != null) {
                    this.fitImage(view.getcwidth(), view.getcheight());
                }
                this.setAreaFitHandler((AreaFitHandler)object);
                if (view != null) {
                    this.fitImage(view.getcwidth(), view.getcheight());
                    view.delayedRepaint();
                }
                Vector2d vector2d = new Vector2d();
                Vector2d vector2d2 = new Vector2d();
                float f = (float)this.vpHandler.getZoomFactor();
                if (f < 0.2f) {
                    f = 0.2f;
                }
                this.getZoomRectModeCenter(f, vector2d, vector2d2);
                this.vpHandler.setZoomFactor(1.0 / vector2d2.x);
                return true;
            }
            case 66: {
                this.reset(object == null || Boolean.TRUE.equals(object));
                if (view != null) {
                    view.delayedRepaint();
                }
                return true;
            }
            case 95: {
                int[] nArray;
                this.activedef.resetAspectRatio();
                this.activedef.setPixelSpacing((SpacingDef)object);
                if (((SpacingDef)object).getSizeUnit() == SpacingDef.Unit.pix && (nArray = this.getImageInformation().getPixelAspectRatio()) != null) {
                    this.activedef.setAspectRatio(nArray[1], nArray[0]);
                }
                return true;
            }
            default: {
                return super.handleTEvent(tEvent, object, n, view);
            }
        }
        return false;
    }

    protected abstract void setRawDataContainer(RawDataContainer var1);

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2, View view) {
        if (visHRSet != null && visHRSet.getType().equals("DEF")) {
            return visHRSet;
        }
        return new VisHRSetDefault(vis2);
    }

    @Override
    public WindowHandlerBase getWindowHandler() {
        return this.windowHandler;
    }

    @Override
    public void getOptimumOutputSize(SnapOutputGeometry snapOutputGeometry) {
        AreaFitHandler areaFitHandler = this.vpHandler;
        snapOutputGeometry.destinationHeight = snapOutputGeometry.maxHeight;
        snapOutputGeometry.destinationWidth = snapOutputGeometry.maxWidth;
        this.vpHandler = snapOutputGeometry.vpHandler;
        this.vpHandler.set(areaFitHandler);
        snapOutputGeometry.initDestination();
        Rectangle rectangle = this.fitImage(snapOutputGeometry.maxWidth, snapOutputGeometry.maxHeight);
        ImageState imageState = this.getImageState();
        double d = 1.0;
        d = imageState.getDataPixelSizeX() != 0.0 ? imageState.getDataPixelSizeX() / imageState.pixelSizeX : (double)rectangle.width / this.newViewPort.width;
        double d2 = (double)snapOutputGeometry.maxHeight / d;
        double d3 = (double)snapOutputGeometry.maxWidth / d;
        if (snapOutputGeometry.aspectRatioChangeAllowed) {
            d2 = Math.round((double)rectangle.width / d);
            d3 = Math.round((double)rectangle.height / d);
        }
        while (d2 > (double)snapOutputGeometry.maxWidth || d3 > (double)snapOutputGeometry.maxHeight) {
            d2 /= 2.0;
            d3 /= 2.0;
        }
        while (d2 < (double)snapOutputGeometry.minWidth || d3 < (double)snapOutputGeometry.minHeight) {
            d2 *= 2.0;
            d3 *= 2.0;
        }
        snapOutputGeometry.destinationHeight = (int)d3;
        snapOutputGeometry.destinationWidth = (int)d2;
        this.vpHandler = areaFitHandler;
    }

    @Override
    public void storeToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        AreaFitHandler areaFitHandler = this.vpHandler;
        this.vpHandler = snapOutputGeometry.vpHandler;
        this.vpHandler.set(areaFitHandler);
        snapOutputGeometry.initDestination();
        this.internalStoreToSnapshot(viewSnapshot);
        this.vpHandler = areaFitHandler;
    }

    @Override
    public void storeOverlaysToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        AreaFitHandler areaFitHandler = this.vpHandler;
        this.vpHandler = snapOutputGeometry.vpHandler;
        this.vpHandler.set(areaFitHandler);
        snapOutputGeometry.initDestination();
        viewSnapshot.applyOverlays(this.getOverlays());
        this.vpHandler = areaFitHandler;
    }

    protected void internalStoreToSnapshot(ViewSnapshot viewSnapshot) {
        if (this.tf != null) {
            this.tf.storeTo(viewSnapshot.getDataset());
        }
    }

    @Override
    public void synchronizeWith(Renderer renderer) {
        ImageState imageState = renderer.getImageState();
        this.fitImage((int)imageState.wview, (int)imageState.hview);
        if (imageState.window != null && this.windowHandler != null) {
            this.windowHandler.setWindow(imageState.window);
        }
        if (renderer instanceof RDCRenderer) {
            RDCRenderer rDCRenderer = (RDCRenderer)renderer;
            if (this.vpHandler.getClass() != rDCRenderer.vpHandler.getClass()) {
                try {
                    this.vpHandler = rDCRenderer.vpHandler.getClone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    log.error("RDCRenderer", (Throwable)cloneNotSupportedException);
                }
            } else {
                this.vpHandler.set(rDCRenderer.vpHandler);
            }
        } else {
            log.info("other is no RDCRenderer");
        }
    }

    @Override
    public void setGeometry(int n, int n2, int n3, int n4) {
        this.fitImage(n, n2);
    }

    @Override
    public Color getBackgroundColor() {
        if (whiteBackground) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    private void applyIndexedColorPST(ILUTContainer iLUTContainer) {
        boolean bl = this.imageInformation.isInverse();
        boolean bl2 = this.frameObjectData.getRawDataContainer().getPixelDataFrame().isSigned();
        int n = this.imageInformation.getBitsStored();
        int n2 = -1;
        if (this.frameObjectData != null && this.frameObjectData.getDicomObject().containsValue(2621728)) {
            n2 = this.frameObjectData.getDicomObject().getInt(2621728, 0);
        }
        this.windowHandler = WindowHandlerBase.getInstance(this.imageInformation, iLUTContainer, bl, bl2, this);
        this.tf = new SegmentedPaletteColorLUT(iLUTContainer.getPaletteColorLUT(), n, new WindowDef(iLUTContainer, this.imageInformation.getHighBit(), this.imageInformation.isSigned()), n2);
        this.windowHandler.setTransferFunction((SegmentedPaletteColorLUT)this.tf);
        boolean bl3 = false;
        Set<ImageType> set = this.imageInformation.getImageType();
        if (set.contains(ImageType.PERFUSION) && set.contains(ImageType.SECONDARY)) {
            bl3 = true;
        }
        if (bl3) {
            ColorBarOverlay colorBarOverlay = new ColorBarOverlay(0.85, 0.2, 0.87, 0.8, AnnotationUnits.Display);
            this.addOverlay(colorBarOverlay);
            ModalityLUT modalityLUT = this.imageInformation.getModalityLUT();
            String string = this.imageInformation.getDataset().getString(0x204000);
            String string2 = null;
            if (string == null) {
                string2 = "";
            } else if (string.equals("Perfusion: BLOOD_VOLUME")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.BLOOD_VOLUME");
            } else if (string.equals("Perfusion: FLOW")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.FLOW");
            } else if (string.equals("Perfusion: FLOW_WITHOUT_VESSELS")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.FLOW_WITHOUT_VESSELS");
            } else if (string.equals("Perfusion: MEAN_TRANSIT_TIME")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.MEAN_TRANSIT_TIME");
            } else if (string.equals("Perfusion: PEAK_ENHANCEMENT")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.PEAK_ENHANCEMENT");
            } else if (string.equals("Perfusion: TIME_TO_PEAK")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.TIME_TO_PEAK");
            } else if (string.equals("Perfusion: TIME_TO_START")) {
                string2 = Messages.getString("impaxee.plugins.PerfusionPlugin.COLORS.TIME_TO_START");
            }
            try {
                if (string2 != null && modalityLUT != null) {
                    colorBarOverlay.init((SegmentedPaletteColorLUT)this.tf, modalityLUT.getRescaleType().dicom(), string2);
                } else {
                    this.removeOverlay(colorBarOverlay);
                }
            }
            catch (Exception exception) {
                this.removeOverlay(colorBarOverlay);
                log.warn("Incomplete Perfusion image, ommiting overlay");
            }
        }
    }

    protected void applyLUTs(IFramePresentationState iFramePresentationState) {
        boolean bl = this.imageInformation.isInverse();
        int n = this.imageInformation.getHighBit();
        boolean bl2 = this.frameObjectData.getRawDataContainer().getPixelDataFrame().isSigned();
        PhotometricInterpretation photometricInterpretation = this.imageInformation.getPhotometricInterpretation();
        if (this.imageInformation.hasColorPaletteLUT() && iFramePresentationState.getForceLUT()) {
            photometricInterpretation = PhotometricInterpretation.IndexedColor;
        }
        if (photometricInterpretation == PhotometricInterpretation.IndexedColor && !iFramePresentationState.getForceLUT()) {
            photometricInterpretation = PhotometricInterpretation.Monochrome;
        }
        switch (photometricInterpretation) {
            case IndexedColor: {
                PaletteColorLUTWrapper paletteColorLUTWrapper = new PaletteColorLUTWrapper((ILUTContainer)this.imageInformation, (ILUTContainer)iFramePresentationState);
                if (paletteColorLUTWrapper.getPaletteColorLUT() != null) {
                    this.applyIndexedColorPST((ILUTContainer)paletteColorLUTWrapper);
                    break;
                }
                GeneralWindowTransferFunction generalWindowTransferFunction = new GeneralWindowTransferFunction((ILUTContainer)paletteColorLUTWrapper, n, bl, bl2);
                this.windowHandler = WindowHandlerBase.getInstance(this.imageInformation, (ILUTContainer)iFramePresentationState, bl, bl2, this);
                this.windowHandler.setTransferFunction(generalWindowTransferFunction);
                this.tf = this.windowHandler.getTransferFunction();
                break;
            }
            case Color: {
                GeneralWindowTransferFunction generalWindowTransferFunction = new GeneralWindowTransferFunction((ILUTContainer)iFramePresentationState, n, bl, bl2);
                this.windowHandler = WindowHandlerBase.getInstance(this.imageInformation, (ILUTContainer)iFramePresentationState, bl, bl2, this);
                this.windowHandler.setTransferFunction(generalWindowTransferFunction);
                this.tf = this.windowHandler.getTransferFunction();
                break;
            }
            case RGBColor: {
                this.windowHandler = null;
                break;
            }
            default: {
                this.windowHandler = WindowHandlerBase.getInstance(this.imageInformation, (ILUTContainer)iFramePresentationState, bl, bl2, this);
                this.windowHandler.setNodeID(this.nodeID);
                this.tf = this.windowHandler.getTransferFunction();
            }
        }
        this.updateNearestNeighbourInterpolationSetting();
    }

    private void updateNearestNeighbourInterpolationSetting() {
        WindowTransferFunction windowTransferFunction;
        if (this.tf != null && this.tf instanceof WindowTransferFunction && (windowTransferFunction = (WindowTransferFunction)this.tf).getGSTS() != null) {
            this.getRawDataContainer().setNearestNeighbourInterpolation(windowTransferFunction.getGSTS().useNearestNeighbourInterpolation());
        }
    }

    @Override
    public List<PresentationObject> applyPresentationState(IFramePresentationState iFramePresentationState) {
        EnumSet<View.CAPTURE_STATES> enumSet = this.captureStates();
        ArrayList<PresentationObject> arrayList = new ArrayList<PresentationObject>();
        if (iFramePresentationState == this.currentFramePresentationState) {
            if (enumSet.contains((Object)View.CAPTURE_STATES.WINDOW_LEVEL)) {
                this.applyLUTs(iFramePresentationState);
            }
            return arrayList;
        }
        if (iFramePresentationState != null) {
            this.clearPresentationState(iFramePresentationState);
        }
        try {
            PresentationLUT presentationLUT;
            YN yN;
            boolean bl = this.imageInformation.isInverse();
            int n = this.imageInformation.getHighBit();
            boolean bl2 = this.frameObjectData.getRawDataContainer().getPixelDataFrame().isSigned();
            boolean bl3 = this.isVOILutInPSSame(iFramePresentationState);
            if (bl3) {
                iFramePresentationState.setVOILUT(this.imageInformation.getVOILUT());
            }
            if (enumSet.contains((Object)View.CAPTURE_STATES.WINDOW_LEVEL)) {
                this.applyLUTs(iFramePresentationState);
            }
            if (enumSet.contains((Object)View.CAPTURE_STATES.TRANSFORMATION) && iFramePresentationState != null && iFramePresentationState.getSpatialTransformation() != null) {
                int n2 = iFramePresentationState.getSpatialTransformation().getImageRotation();
                yN = iFramePresentationState.getSpatialTransformation().getImageHorizontalFlip();
                Matrix2d matrix2d = new Matrix2d(Orientation.createStandardTransform2D(this.imageInformation));
                matrix2d.invert();
                while (n2 > 0) {
                    matrix2d.mul(Matrix2d.trafoRotR, matrix2d);
                    n2 -= 90;
                }
                if (yN == YN.Yes) {
                    matrix2d.mul(Matrix2d.trafoFlipV, matrix2d);
                }
                this.applyTransform(matrix2d);
            }
            PresentationLUT presentationLUT2 = presentationLUT = iFramePresentationState == null ? null : iFramePresentationState.getPresentationLUT();
            if (enumSet.contains((Object)View.CAPTURE_STATES.WINDOW_LEVEL) && presentationLUT != null && !bl3 && PresentationLUTShape.Color.equals((Object)presentationLUT.getPresentationLUTShape())) {
                this.tf = new GeneralWindowTransferFunction((ILUTContainer)iFramePresentationState, n, bl, bl2);
                this.windowHandler.setTransferFunction((WindowTransferFunction)this.tf);
            }
            DisplayedArea displayedArea = yN = iFramePresentationState == null ? null : iFramePresentationState.getDisplayedArea();
            if (yN != null) {
                boolean bl4 = enumSet.contains((Object)View.CAPTURE_STATES.ZOOM_PAN);
                this.applyDisplayedArea((DisplayedArea)yN, iFramePresentationState, bl4, bl4);
            } else {
                this.setDefaultSpacing();
            }
            if (iFramePresentationState != null) {
                List<PresentationObject> list = this.constructMarkups(iFramePresentationState);
                arrayList.addAll(list);
            }
        }
        catch (Exception exception) {
            log.error("error", (Throwable)exception);
        }
        this.invalidate();
        return arrayList;
    }

    private void applyDisplayedArea(DisplayedArea displayedArea, IFramePresentationState iFramePresentationState, boolean bl, boolean bl2) {
        double[] dArray = displayedArea.getPresentationPixelSpacing();
        int[] nArray = displayedArea.getPresentationPixelAspectRatio();
        if (iFramePresentationState.isExternal() && dArray != null && dArray.length > 0) {
            SpacingDef spacingDef = new SpacingDef();
            spacingDef.setDataPixelSizeX(dArray[1]);
            spacingDef.setDataPixelSizeY(dArray[0]);
            spacingDef.setSizeUnit(SpacingDef.Unit.mm_pres);
            this.imageState.setCurrentSpacingDef(spacingDef);
            this.activedef.resetAspectRatio();
            this.activedef.setPixelSpacing(spacingDef);
        } else if (iFramePresentationState.isExternal() && nArray != null && nArray.length > 0) {
            if (nArray[0] != 0 || nArray[1] != 0) {
                this.activedef.setAspectRatio(nArray[1], nArray[0]);
            }
        } else {
            this.removePresentationStateSpacing();
            this.setDefaultSpacing();
        }
        int n = displayedArea.getDisplayedAreaTopLeftHandCorner()[0];
        int n2 = displayedArea.getDisplayedAreaTopLeftHandCorner()[1];
        int n3 = displayedArea.getDisplayedAreaBottomRightHandCorner()[0];
        int n4 = displayedArea.getDisplayedAreaBottomRightHandCorner()[1];
        int n5 = 0;
        YN yN = YN.No;
        if (iFramePresentationState.getSpatialTransformation() != null) {
            n5 = iFramePresentationState.getSpatialTransformation().getImageRotation();
            yN = iFramePresentationState.getSpatialTransformation().getImageHorizontalFlip();
        }
        if (n2 != n4 && n != n3) {
            if (bl) {
                boolean bl3 = false;
                if (n < n3 && n2 < n4) {
                    bl3 = n5 == 0 && yN == YN.No || n5 == 90 && yN == YN.Yes;
                } else if (n < n3 && n2 > n4) {
                    bl3 = n5 == 90 && yN == YN.No || n5 == 180 && yN == YN.Yes;
                } else if (n > n3 && n2 > n4) {
                    bl3 = n5 == 180 && yN == YN.No || n5 == 270 && yN == YN.Yes;
                } else if (n > n3 && n2 < n4) {
                    bl3 = n5 == 270 && yN == YN.No || n5 == 0 && yN == YN.Yes;
                }
                double d = (double)(n2 + n4 - 1) / (double)(2 * this.activedef.getRowCount());
                double d2 = this.vpHandler.getViewportCenterAlignmentX().calculateViewportCenterX(n, n3, this.activedef.getColumnCount());
                if (bl3) {
                    this.activedef.setViewportCenter(new Vector2d(d2, d));
                } else {
                    this.activedef.setTransformedViewportCenter(d2, d);
                }
            }
            if (bl2) {
                PresentationSizeMode presentationSizeMode = displayedArea.getPresentationSizeMode();
                if (presentationSizeMode == PresentationSizeMode.TrueSize && !ZoomUtils.isTrueSizeZoomAllowed()) {
                    presentationSizeMode = PresentationSizeMode.ScaleToFit;
                }
                switch (presentationSizeMode) {
                    case ScaleToFit: {
                        this.vpHandler = new FullVisualFitHandler(this.vpHandler);
                        this.vpHandler.setZoomFactor(1.0);
                        if (iFramePresentationState.isTemporary()) break;
                        this.pstViewport = new Rectangle(0, 0, Math.abs(n3 - n + 1), Math.abs(n4 - n2 + 1));
                        break;
                    }
                    case TrueSize: {
                        AreaFitHandler areaFitHandler = this.vpHandler;
                        this.vpHandler = new TrueSizeFitHandler();
                        this.vpHandler.setViewportCenterAlignmentX(areaFitHandler.getViewportCenterAlignmentX());
                        break;
                    }
                    case Magnify: {
                        float f = displayedArea.getPresentationPixelMagnificationRatio().floatValue();
                        if (Math.abs((double)f - 1.0) < 0.01) {
                            this.vpHandler = new PixelIdentityFitHandler(this.vpHandler);
                            this.vpHandler.setZoomFactor(1.0);
                            break;
                        }
                        this.vpHandler = new FullVisualFitHandler(this.vpHandler);
                        this.vpHandler.setZoomFactor(displayedArea.getPresentationPixelMagnificationRatio().floatValue());
                    }
                }
            }
        }
    }

    private boolean isVOILutInPSSame(IFramePresentationState iFramePresentationState) {
        return this.imageInformation.getVOILUT() != null && iFramePresentationState.getVOILUT() == null;
    }

    @Override
    public void clearPresentationState(IFramePresentationState iFramePresentationState) {
        this.reset(this.captureStates().contains((Object)View.CAPTURE_STATES.TRANSFORMATION));
        this.removeAllROIs();
        if (iFramePresentationState.getProviderUID().equals(this.imageInformation.getSOPInstanceUID())) {
            this.removeAll(OverlayBitmap.class);
        } else {
            this.removeAllNonImageOverlayBitmaps();
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<PresentationObject> constructMarkups(IFramePresentationState var1_1) {
        block22: {
            var2_2 = new ArrayList<PresentationObject>(2);
            var3_3 = var1_1.getGraphicAnnotations();
            if (var3_3 == null || var3_3.isEmpty()) break block22;
            var4_4 = new HashMap<K, V>();
            var5_5 = new ArrayList<E>();
            for (Iterator<PresentationObject> var6_7 : var3_3) {
                var8_8 = var6_7.graphicObjects();
                var9_12 = 0;
                while (var9_12 < var8_8.size()) {
                    var10_13 = (GraphicObject)var8_8.get(var9_12);
                    var11_14 = var10_13.getTianiROIID();
                    if (var11_14 == null) ** GOTO lbl-1000
                    var11_14.trim();
                    if (var11_14.startsWith("H") || var11_14.startsWith("P")) {
                        var5_5.add(var10_13);
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (var10_13.getGraphicType() == GraphicType.PolyLine && var10_13.getTianiSubType() != null && var10_13.getTianiSubType().getPartCount() > 1 && (var13_18 = var9_12 + (var12_16 = var10_13.getTianiSubType().getPartCount()) - 1) < var8_8.size()) {
                            var14_20 = 0;
                            var15_23 = var9_12;
                            while (var15_23 <= var13_18) {
                                var16_24 = ((GraphicObject)var8_8.get(var15_23)).getGraphicData();
                                var14_20 += var16_24.length;
                                ++var15_23;
                            }
                            var15_22 = new float[var14_20];
                            var16_25 = 0;
                            var17_27 = var9_12;
                            while (var17_27 <= var13_18) {
                                var18_28 = ((GraphicObject)var8_8.get(var17_27)).getGraphicData();
                                System.arraycopy(var18_28, 0, var15_22, var16_25, var18_28.length);
                                var16_25 += var18_28.length;
                                ++var17_27;
                            }
                            var10_13.setGraphicData((float[])var15_22);
                            var10_13.setNumberOfGraphicPoints(Integer.valueOf(((Object)var15_22).length / 2));
                            var9_12 = var13_18;
                        }
                        if ((var12_15 = ROIFactory.makeBasicGraphicMarkup((GraphicObject)var10_13, 1, var6_7.isSaved())) != null) {
                            var12_15.setProviderUID(var1_1.getProviderUID());
                            var12_15.setName(String.valueOf(var10_13.getGraphicType().dicom()) + " [" + var6_7.getGraphicLayer() + "]");
                            var12_15.setLayerLabel(var6_7.getGraphicLayer());
                            this.addOverlay(var12_15);
                            var2_2.add(var12_15);
                            var4_4.put(var12_15.getID(), var12_15);
                        }
                    }
                    ++var9_12;
                }
                var9_11 = var6_7.getGraphicLayer();
                var10_13 = var1_1.getGraphicLayers();
                var11_14 = null;
                if (var10_13 != null) {
                    var13_19 = var10_13.iterator();
                    while (var13_19.hasNext()) {
                        var12_15 = (GraphicLayer)var13_19.next();
                        if (var9_11.equals(var12_15.getGraphicLayer()) && ("ROI".equals(var9_11) && "[Default Layer]".equals(var12_15.getGraphicLayerDescription()) || (var11_14 = var12_15.getColor(ComponentFactory.instance.isOnColorMonitor())) != null)) break;
                    }
                }
                for (PresentationObject var12_15 : var6_7.textObjects()) {
                    for (PresentationObject var14_21 : ROIFactory.makeTextMarkup((TextObject)var12_15, this.getImageInformation(), 1, var6_7.isSaved())) {
                        var14_21.setProviderUID(var1_1.getProviderUID());
                        var14_21.setName("Text [" + var6_7.getGraphicLayer() + "]");
                        var14_21.setLayerLabel(var6_7.getGraphicLayer());
                        if (var11_14 != null) {
                            var14_21.setColor((Color)var11_14);
                        }
                        this.addOverlay(var14_21);
                        var16_26 = (PresentationObject)var4_4.get(var14_21.getID());
                        if (var16_26 != null) {
                            if (var11_14 != null) {
                                var16_26.setColor((Color)var11_14);
                            }
                            var16_26.addCompanion(var14_21);
                        }
                        var2_2.add(var14_21);
                    }
                }
                var6_7.setSaved(true);
            }
            var7_6 = var5_5.iterator();
            while (var7_6.hasNext()) {
                var6_7 = (GraphicObject)var7_6.next();
                try {
                    var8_9 = Integer.parseInt(var6_7.getTianiROIID().substring(1));
                    var9_11 = (PresentationObject)var4_4.get(var8_9);
                    if (var9_11 == null) continue;
                    var10_13 = ROIFactory.makeLinkedGraphicMarkup(var6_7, 1, (PresentationObject)var9_11, true);
                    var9_11.addCompanion((PresentationObject)var10_13);
                    var2_2.add((PresentationObject)var10_13);
                }
                catch (NumberFormatException var8_10) {
                    RDCRenderer.log.error("Error", (Throwable)var8_10);
                }
            }
        }
        if ((var4_4 = Shutter.createShutterObjectPST(var1_1)) != null) {
            var6_7 = var4_4.iterator();
            while (var6_7.hasNext()) {
                var5_5 = var6_7.next();
                var5_5.setProviderUID(var1_1.getProviderUID());
                var5_5.setName("Shutter");
                var5_5.setLayerLabel("__JV_DEFAULT__");
                this.addOverlay((Overlay)var5_5);
                var2_2.add((PresentationObject)var5_5);
            }
        }
        if (var1_1.getOverlayFrames() != null) {
            for (Cloneable var5_5 : var1_1.getOverlayFrames()) {
                if (var5_5 == null) continue;
                var7_6 = new OverlayBitmap(new BitmapOverlay((OverlayFrame)var5_5));
                var7_6.setProviderUID(var1_1.getProviderUID());
                var7_6.setLayerLabel("__JV_DEFAULT__");
                this.addOverlay((Overlay)var7_6);
            }
        }
        this.currentFramePresentationState = var1_1;
        return var2_2;
    }

    private void removePresentationStateSpacing() {
        List<SpacingDef> list = this.imageState.spacingDefs();
        ArrayList<SpacingDef> arrayList = new ArrayList<SpacingDef>();
        int n = list.size() - 1;
        while (n >= 0) {
            SpacingDef spacingDef = list.get(n);
            if (spacingDef.getSizeUnit() == SpacingDef.Unit.mm_pres) {
                arrayList.add(spacingDef);
            }
            --n;
        }
        for (SpacingDef spacingDef : arrayList) {
            this.imageState.removeSpacingDef(spacingDef);
        }
    }

    private void setDefaultSpacing() {
        int[] nArray;
        SpacingDef spacingDef = this.getDefaultSpacing();
        this.activedef.resetAspectRatio();
        if (spacingDef != null) {
            this.activedef.setPixelSpacing(spacingDef);
        }
        if ((nArray = this.imageInformation.getPixelAspectRatio()) != null) {
            this.activedef.setAspectRatio(nArray[1], nArray[0]);
        }
    }

    @Override
    public IFramePresentationState getCurrentFramePresentationState() {
        return this.currentFramePresentationState;
    }

    @Override
    public IFrameObjectData getFrameObjectData() {
        return this.frameObjectData;
    }

    public EnumSet<View.CAPTURE_STATES> captureStates() {
        return EnumSet.allOf(View.CAPTURE_STATES.class);
    }

    @Override
    public IPresentationState getPresentationState() {
        return this.getPresentationState(this.captureStates());
    }

    @Override
    public IPresentationState getPresentationState(Set<View.CAPTURE_STATES> set) {
        if (UIDUtilities.getBaseType((String)this.frameObjectData.getSOPClassUID()) != UIDType.Image) {
            return null;
        }
        return new PresentationState(set);
    }

    public IPresentationState getPresentationState(int n, int n2) {
        this.fitImage(n, n2);
        return this.getPresentationState();
    }

    protected PresentationLUT getPresentationLUT() {
        if (this.windowHandler == null) {
            return null;
        }
        GrayScaleTransformationSequence grayScaleTransformationSequence = this.windowHandler.getGSTS();
        if (grayScaleTransformationSequence == null) {
            return null;
        }
        return grayScaleTransformationSequence.createPresentationLUT();
    }

    private SpacingDef getDefaultSpacing() {
        List<SpacingDef> list = this.imageState.spacingDefs();
        if (!list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public void setAlternativeImageState(ImageState imageState) {
        this.imageState = imageState;
    }

    public void setActiveImageDef(ImageDef imageDef) {
        this.activedef = imageDef;
    }

    @Override
    public ImageDef getActiveImageDef() {
        return this.activedef;
    }

    @Override
    public void checkImageLoaded() {
    }

    private static class ConfigListener
    implements IConfigurationChangeListener {
        private ConfigListener() {
        }

        public void configurationChanged(String string) {
            RDCRenderer.initInfoRegion();
        }
    }

    private static class InteractionInfoHolder {
        public double xstart;
        public double ystart;
        public double currentZoom;
        public double centerX;
        public double centerY;

        private InteractionInfoHolder() {
        }
    }

    private class PresentationState
    implements IPresentationState {
        private static final double FLOATING_POINT_TOLERANCE = 0.01;
        private boolean hasColorLUT;
        private int layerCounter;
        private final Set<View.CAPTURE_STATES> captureStates;

        public PresentationState(Set<View.CAPTURE_STATES> set) {
            this.captureStates = set;
            Attributes attributes = RDCRenderer.this.imageInformation.getDataset();
            boolean bl = true;
            if (!attributes.contains(2625795)) {
                bl = false;
            }
            if (!attributes.contains(2625794)) {
                bl = false;
            }
            if (!attributes.contains(2625793)) {
                bl = false;
            }
            this.hasColorLUT = bl;
        }

        @Override
        public boolean isIndexedColor() {
            return this.hasColorLUT && this.getCurrentPresentationState().getForceLUT();
        }

        @Override
        public IFramePresentationState getCurrentPresentationState() {
            return RDCRenderer.this.getCurrentFramePresentationState();
        }

        @Override
        public DisplayedArea createDisplayedArea() {
            DisplayedArea displayedArea;
            if (!this.captureStates.contains((Object)View.CAPTURE_STATES.ZOOM_PAN)) {
                return null;
            }
            SpacingDef spacingDef = RDCRenderer.this.getImageState().getCurrentSpacingDef();
            int n = RDCRenderer.this.activedef.getUntransformedColumns();
            int n2 = RDCRenderer.this.activedef.getUntransformedRows();
            double[] dArray = new double[]{0.0, 0.0};
            double[] dArray2 = new double[]{0.0, 0.0};
            RDCRenderer.this.getImageState().screenToImage(dArray, dArray2, null);
            int n3 = (int)Math.round(dArray2[0]);
            int n4 = (int)Math.round(dArray2[1]);
            dArray[0] = dArray[0] + RDCRenderer.this.getImageState().wview;
            dArray[1] = dArray[1] + RDCRenderer.this.getImageState().hview;
            RDCRenderer.this.getImageState().screenToImage(dArray, dArray2, null);
            int n5 = (int)Math.round(dArray2[0]);
            int n6 = (int)Math.round(dArray2[1]);
            ++n3;
            ++n4;
            if (RDCRenderer.this.getNormalizedViewCenterX() == 0.5f && RDCRenderer.this.getNormalizedViewCenterY() == 0.5f && RDCRenderer.this.vpHandler.getZoomFactor() == 1.0) {
                n3 = 1;
                n4 = 1;
                n5 = n;
                n6 = n2;
            }
            if (RDCRenderer.this.borderLockMode) {
                if (n3 < 0 && (double)Math.abs(n5 + n3 - n) < 0.01 * (double)n) {
                    n5 += n3;
                    n3 = 0;
                } else if (n5 < 0 && (double)Math.abs(n5 + n3 - n) < 0.01 * (double)n) {
                    n3 += n5;
                    n5 = 0;
                }
                if (n4 < 0 && (double)Math.abs(n6 + n4 - n2) < 0.01 * (double)n2) {
                    n6 += n4;
                    n4 = 0;
                } else if (n6 < 0 && (double)Math.abs(n6 + n4 - n2) < 0.01 * (double)n2) {
                    n4 += n6;
                    n6 = 0;
                }
            }
            DisplayedArea displayedArea2 = new DisplayedArea();
            displayedArea2.setDisplayedAreaTopLeftHandCorner(new int[]{n3, n4});
            displayedArea2.setDisplayedAreaBottomRightHandCorner(new int[]{n5, n6});
            double[] dArray3 = new double[]{spacingDef.getDataPixelSizeY(), spacingDef.getDataPixelSizeX()};
            PresentationSizeMode presentationSizeMode = null;
            if (RDCRenderer.this.vpHandler instanceof TrueSizeFitHandler) {
                presentationSizeMode = PresentationSizeMode.TrueSize;
                displayedArea2.setPresentationPixelSpacing(dArray3);
            } else if (RDCRenderer.this.vpHandler instanceof PixelIdentityFitHandler) {
                presentationSizeMode = PresentationSizeMode.Magnify;
                displayedArea2.setPresentationPixelMagnificationRatio(Float.valueOf(1.0f));
            } else if (RDCRenderer.this.vpHandler instanceof FullVisualFitHandler) {
                float f = (float)RDCRenderer.this.vpHandler.getZoomFactor();
                if (Math.abs((double)f - 1.0) < 0.01) {
                    presentationSizeMode = PresentationSizeMode.ScaleToFit;
                } else {
                    presentationSizeMode = PresentationSizeMode.Magnify;
                    displayedArea2.setPresentationPixelMagnificationRatio(Float.valueOf(f));
                }
            }
            displayedArea2.setPresentationSizeMode(presentationSizeMode);
            if (!(RDCRenderer.this.vpHandler instanceof TrueSizeFitHandler || spacingDef.getSizeUnit() != SpacingDef.Unit.mm_man && spacingDef.getSizeUnit() != SpacingDef.Unit.mm_pres)) {
                displayedArea2.setPresentationPixelSpacing(dArray3);
            }
            int[] nArray = null;
            IFramePresentationState iFramePresentationState = RDCRenderer.this.currentFramePresentationState;
            if (iFramePresentationState == null) {
                iFramePresentationState = RDCRenderer.this.frameObjectData.getFramePresentationState();
            }
            if ((displayedArea = iFramePresentationState.getDisplayedArea()) != null && (nArray = displayedArea.getPresentationPixelAspectRatio()) != null && dArray3[0] == 1.0 && dArray3[1] == 1.0) {
                dArray3 = null;
            }
            if (nArray != null) {
                displayedArea2.setPresentationPixelAspectRatio(nArray);
            } else if (presentationSizeMode == PresentationSizeMode.ScaleToFit || presentationSizeMode == PresentationSizeMode.Magnify) {
                displayedArea2.setPresentationPixelAspectRatio(new int[]{1, 1});
            }
            return displayedArea2;
        }

        @Override
        public ReferencedImage createReferencedImage() {
            ReferencedImage referencedImage = new ReferencedImage();
            referencedImage.setSOPClassUID(RDCRenderer.this.imageInformation.getSOPClassUID());
            referencedImage.setSOPInstanceUID(RDCRenderer.this.imageInformation.getSOPInstanceUID());
            if (RDCRenderer.this.frameObjectData.getMainFrame().getFrameCount() != 1) {
                referencedImage.setFrame(RDCRenderer.this.frameObjectData.getFrameNumber() + 1);
            }
            return referencedImage;
        }

        @Override
        public SpatialTransformationModule createSpatialTransformationModule() {
            if (!this.captureStates.contains((Object)View.CAPTURE_STATES.TRANSFORMATION)) {
                return null;
            }
            SpatialTransformationModule spatialTransformationModule = new SpatialTransformationModule();
            int n = 0;
            YN yN = null;
            Matrix2d matrix2d = new Matrix2d(RDCRenderer.this.activedef.getTransform());
            while (!Matrix2d.trafoUnity.equals(matrix2d) && n < 360) {
                n += 90;
                matrix2d.mul(Matrix2d.trafoRotL, matrix2d);
            }
            if (n == 360) {
                matrix2d.set(RDCRenderer.this.activedef.getTransform());
                matrix2d.mul(Matrix2d.trafoFlipV, matrix2d);
                n = 0;
                while (!Matrix2d.trafoUnity.equals(matrix2d) && n < 360) {
                    n += 90;
                    matrix2d.mul(Matrix2d.trafoRotL, matrix2d);
                }
                if (n < 360) {
                    yN = YN.Yes;
                }
            } else {
                yN = YN.No;
            }
            spatialTransformationModule.setImageHorizontalFlip(yN);
            spatialTransformationModule.setImageRotation(Integer.valueOf(n));
            return spatialTransformationModule;
        }

        @Override
        public int getColumns() {
            return RDCRenderer.this.imageInformation.getColumns();
        }

        @Override
        public List<GraphicAnnotation> getGraphicAnnotations(List<GraphicLayer> list, boolean bl) {
            this.layerCounter = 1;
            HashMap<String, GraphicAnnotation> hashMap = new HashMap<String, GraphicAnnotation>();
            HashMap<Color, String> hashMap2 = new HashMap<Color, String>();
            hashMap2.put(null, RDCRenderer.LAYER_NAME);
            boolean bl2 = false;
            for (GraphicLayer object : list) {
                if (!object.getGraphicLayer().equals(RDCRenderer.LAYER_NAME)) {
                    hashMap2.put(object.getColor(ComponentFactory.instance.isOnColorMonitor()), object.getGraphicLayer());
                    continue;
                }
                bl2 = true;
            }
            if (!bl2) {
                GraphicLayer graphicLayer = new GraphicLayer();
                graphicLayer.setGraphicLayerRecommendedDisplayRGBValue(GraphicLayer.to16BitRgbValue((Color)OverlayConfig.mappingColor));
                graphicLayer.setGraphicLayer(RDCRenderer.LAYER_NAME);
                list.add(graphicLayer);
            }
            for (Overlay overlay : RDCRenderer.this.overlays) {
                Object object;
                GraphicAnnotation graphicAnnotation;
                String string;
                if (!overlay.isVisible() || "__JV_BURN__".equals(string = overlay.getLayerLabel()) || "__JV_DELETED__".equals(string) || !(overlay instanceof PresentationObject)) continue;
                PresentationObject presentationObject = (PresentationObject)overlay;
                if (bl) {
                    presentationObject.setSaved(true);
                }
                if (!presentationObject.isROI() || !(presentationObject instanceof ITextObjectContainer) && !(presentationObject instanceof IGraphicObjectContainer)) continue;
                string = this.setGraphicLayerColorAndName(presentationObject, list, hashMap2);
                if (!hashMap.containsKey(string)) {
                    graphicAnnotation = new GraphicAnnotation();
                    graphicAnnotation.setGraphicLayer(string);
                    graphicAnnotation.setSaved(true);
                    hashMap.put(string, graphicAnnotation);
                } else {
                    graphicAnnotation = (GraphicAnnotation)hashMap.get(string);
                }
                if (!presentationObject.isSaved()) {
                    graphicAnnotation.setSaved(false);
                }
                if (presentationObject instanceof ITextObjectContainer) {
                    object = ((ITextObjectContainer)((Object)presentationObject)).storeROI();
                    graphicAnnotation.textObjects().add(object);
                }
                if (!(presentationObject instanceof IGraphicObjectContainer) || (object = ((IGraphicObjectContainer)((Object)presentationObject)).storeROI()) == null) continue;
                graphicAnnotation.graphicObjects().addAll(object);
            }
            return new ArrayList<GraphicAnnotation>(hashMap.values());
        }

        private String setGraphicLayerColorAndName(PresentationObject presentationObject, List<GraphicLayer> list, Map<Color, String> map) {
            String string;
            if (presentationObject.isColorUserDefined()) {
                Color color = presentationObject.objCol;
                if (!map.containsKey(color)) {
                    int[] nArray = GraphicLayer.to16BitRgbValue((Color)color);
                    GraphicLayer graphicLayer = new GraphicLayer();
                    graphicLayer.setGraphicLayerOrder(Integer.toString(this.layerCounter));
                    graphicLayer.setGraphicLayerRecommendedDisplayRGBValue(nArray);
                    string = RDCRenderer.LAYER_NAME + this.layerCounter;
                    map.put(color, string);
                    graphicLayer.setGraphicLayer(string);
                    list.add(graphicLayer);
                    ++this.layerCounter;
                } else {
                    String string2;
                    string = string2 = map.get(color);
                }
            } else {
                string = RDCRenderer.LAYER_NAME;
            }
            return string;
        }

        @Override
        public ModalityLUT getModalityLUT() {
            if (RDCRenderer.this.windowHandler == null) {
                return null;
            }
            GrayScaleTransformationSequence grayScaleTransformationSequence = RDCRenderer.this.windowHandler.getGSTS();
            if (grayScaleTransformationSequence != null) {
                return grayScaleTransformationSequence.createModalityLUT();
            }
            return RDCRenderer.this.getImageInformation().getModalityLUT();
        }

        @Override
        public PresentationLUT getPresentationLUT() {
            if (!this.captureStates.contains((Object)View.CAPTURE_STATES.INVERT)) {
                return null;
            }
            return RDCRenderer.this.getPresentationLUT();
        }

        @Override
        public int getRows() {
            return RDCRenderer.this.imageInformation.getRows();
        }

        @Override
        public String getSeriesInstanceUID() {
            return RDCRenderer.this.imageInformation.getSeriesInstanceUID();
        }

        @Override
        public IVOILUT getVOILUT(boolean bl) {
            if (!this.captureStates.contains((Object)View.CAPTURE_STATES.WINDOW_LEVEL)) {
                return null;
            }
            if (this.hasColorLUT || RDCRenderer.this.windowHandler == null) {
                return null;
            }
            return RDCRenderer.this.windowHandler.getVOILUTForPresentationState(bl);
        }

        @Override
        public boolean getOverlayFrames(OverlayFrameCollector overlayFrameCollector) {
            boolean bl = false;
            for (Overlay overlay : RDCRenderer.this.overlays) {
                PresentationObject presentationObject;
                String string = overlay.getLayerLabel();
                if ("__JV_BURN__".equals(string) || "__JV_DELETED__".equals(string) || !(overlay instanceof PresentationObject) || !(presentationObject = (PresentationObject)overlay).isShutter() || presentationObject.hasDisplayShutterModule()) continue;
                OverlayFrame overlayFrame = presentationObject.getOverlayFrame();
                overlayFrameCollector.addOverlayFrame(RDCRenderer.this.frameObjectData.getFrameNumber() + 1, overlayFrame, string, presentationObject.getProviderUID(), true);
                bl = true;
            }
            return bl;
        }
    }
}

