/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.OverlayBitmap;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BitmapOverlaySelector
extends AbstractPAction {
    public static final String ID = "BITMAP_SELECTION";
    private PAction[] cachedActions;
    private long cachedStamp;

    @Override
    public String getCaption() {
        return Messages.getString("Action.BitmapOverlaySelector.Caption");
    }

    @Override
    public String getGroupName() {
        return IMAGE_DISPLAY_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public PAction.ActionType getActionType() {
        return PAction.ActionType.Submenu;
    }

    @Override
    public PAction[] getSubactions() {
        if (this.cachedActions != null && System.currentTimeMillis() - this.cachedStamp < CACHING_TIMEOUT) {
            return this.cachedActions;
        }
        ArrayList<BitmapOverlayActivateAction> arrayList = new ArrayList<BitmapOverlayActivateAction>();
        VisData visData = AbstractPDataAction.getCurrentImage();
        if (visData != null) {
            View view = visData.getView();
            for (OverlayBitmap overlayBitmap : view.getOverlays(OverlayBitmap.class)) {
                arrayList.add(new BitmapOverlayActivateAction(overlayBitmap, view));
            }
        }
        this.cachedActions = arrayList.toArray(new PAction[arrayList.size()]);
        this.cachedStamp = System.currentTimeMillis();
        return this.cachedActions;
    }

    @Override
    protected boolean isEnabledImpl() {
        return !BitmapOverlaySelector.getBitmapOverlays().isEmpty();
    }

    private static List<OverlayBitmap> getBitmapOverlays() {
        VisData visData = AbstractPDataAction.getCurrentImage();
        if (visData == null) {
            return Collections.emptyList();
        }
        return visData.getView().getOverlays(OverlayBitmap.class);
    }

    @Override
    public boolean isUpdatingListeners() {
        return false;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public boolean perform(Component component) {
        throw new UnsupportedOperationException();
    }

    private static String compileName(OverlayBitmap overlayBitmap) {
        String string = overlayBitmap.getOverlayDefinition().getLabel();
        String string2 = overlayBitmap.getOverlayDefinition().getDescription();
        if (string == null && string2 == null) {
            return "[Unnamed Overlay]";
        }
        String string3 = "";
        if (string != null) {
            string3 = String.valueOf(string3) + string + " ";
        }
        if (string2 != null) {
            string3 = String.valueOf(string3) + string2;
        }
        return string3;
    }

    private static class BitmapOverlayActivateAction
    extends AnonymousPAction {
        private OverlayBitmap overlay;
        private View view;

        public BitmapOverlayActivateAction(OverlayBitmap overlayBitmap, View view) {
            this.overlay = overlayBitmap;
            this.view = view;
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean isSelected() {
            return this.overlay.isActive();
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getCaption() {
            return BitmapOverlaySelector.compileName(this.overlay);
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed(BitmapOverlaySelector.ID);
            this.overlay.setActive(!this.overlay.isActive());
            if (this.view.getRenderer() != null) {
                this.view.getRenderer().invalidate();
            }
            if (this.view != null) {
                this.view.invalidate();
                this.view.repaint();
            }
            return true;
        }
    }
}

