/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.studies;

import com.agfa.pacs.base.swing.busylabel.ColorUtil;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.splitsort.runtime.IDisplaySetContainerRuntime;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.awt.Color;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.UIManager;
import org.dcm4che3.data.Attributes;

class StudyTableData {
    private static final Set<String> filteredModalities = new HashSet<String>();
    private static final boolean monochrome;
    private static final int fontSize;
    private IStudyData study;
    private boolean open;
    private boolean active;
    private boolean mergedPatient;
    private String description;
    private String modalities;
    private String dateTime;
    private String htmlString;
    private String htmlStringActive;

    static {
        filteredModalities.add("SR");
        filteredModalities.add("KO");
        filteredModalities.add("PR");
        monochrome = !GuiUtil.isOnColorMonitor();
        fontSize = ComponentFactory.instance.scaleInt(UIManager.getFont("defaultFont").getSize());
    }

    StudyTableData(IStudyData iStudyData, boolean bl) {
        this.study = iStudyData;
        this.open = bl;
        this.active = false;
        this.description = iStudyData.getDicomObject().getString(528432);
        Date date = DateTimeUtils.getStudyDateTime((Attributes)iStudyData.getDicomObject());
        if (date != null) {
            this.dateTime = DateTimeUtils.dateTime2String((Date)date);
        }
        this.modalities = StudyTableData.getModalityString(iStudyData);
        this.mergedPatient = DataManager.getInstance().isStudyMerged(iStudyData);
        this.generateHTML();
    }

    private void generateHTML() {
        this.htmlString = this.createHtmlString(false);
        this.htmlStringActive = this.createHtmlString(true);
    }

    public IStudyData getStudy() {
        return this.study;
    }

    public IDisplaySet getKODisplaySet() {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation != null) {
            return iPatientRepresentation.getDecompositionRuntime().getKeyImageDisplaySet(this.getStudy());
        }
        return null;
    }

    boolean hasKODisplaySet() {
        return this.getKODisplaySet() != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.description != null) {
            stringBuilder.append(this.description);
            if (this.dateTime != null || this.modalities != null && this.modalities.length() > 0) {
                stringBuilder.append(" | ");
            }
        }
        if (this.modalities != null && this.modalities.length() > 0) {
            stringBuilder.append(this.modalities);
            if (this.dateTime != null) {
                stringBuilder.append(" | ");
            }
        }
        if (this.dateTime != null) {
            stringBuilder.append(this.dateTime);
        }
        return stringBuilder.toString();
    }

    String toHtmlString() {
        return this.toHtmlString(false);
    }

    String toHtmlString(boolean bl) {
        if (bl) {
            return this.htmlStringActive;
        }
        return this.htmlString;
    }

    private String createHtmlString(boolean bl) {
        Color color = null;
        if (!this.isActive()) {
            color = UIManager.getColor("color.primary.3");
            if (color == null) {
                color = UIManager.getColor("Label.foreground");
            }
        } else if (monochrome) {
            color = ColorUtils.darker((Color)Color.WHITE, (float)0.9f);
        } else {
            color = new Color((int)Config.impaxee.jvision.MAPPING.MappingColor.get());
            color = ColorUtils.darker((Color)color, (float)0.9f);
        }
        if (bl) {
            color = ColorUtils.brighter((Color)color, (float)0.7f);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        stringBuilder.append("<font size=\"").append(this.toHtmlFontSize(fontSize)).append("\" color=\"").append(ColorUtil.toHexString((Color)color)).append("\">");
        if (monochrome && this.isActive()) {
            stringBuilder.append("<b>");
        }
        if (this.mergedPatient) {
            stringBuilder.append("! ");
        }
        boolean bl2 = true;
        if (this.description != null) {
            stringBuilder.append(this.description);
            if (this.dateTime != null || this.modalities != null && this.modalities.length() > 0) {
                stringBuilder.append("<br>");
            }
            bl2 = false;
        }
        if (this.modalities != null && this.modalities.length() > 0) {
            stringBuilder.append(this.modalities);
            if (this.dateTime != null) {
                stringBuilder.append(" | ");
            }
            bl2 = false;
        }
        if (this.dateTime != null) {
            stringBuilder.append(this.dateTime);
            bl2 = false;
        }
        if (bl2) {
            stringBuilder.append("NA");
        }
        if (monochrome && this.isActive()) {
            stringBuilder.append("</b>");
        }
        stringBuilder.append("</font></body></html>");
        return stringBuilder.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
        this.htmlString = this.createHtmlString(false);
        this.htmlStringActive = this.createHtmlString(true);
    }

    public boolean isCollapsable() {
        IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(this.study.getParent().getKey());
        if (iPatientRepresentation != null && iPatientRepresentation.getDecompositionRuntime() instanceof IDisplaySetContainerRuntime && !(iPatientRepresentation.getActiveHanging() instanceof IHangingSession)) {
            IDisplaySetContainerRuntime iDisplaySetContainerRuntime = (IDisplaySetContainerRuntime)iPatientRepresentation.getDecompositionRuntime();
            return iDisplaySetContainerRuntime.isStudyCollapsableOrExpandable(this.study);
        }
        return false;
    }

    public boolean isCollapsed() {
        IPatientRepresentation iPatientRepresentation;
        if (this.isCollapsable() && (iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(this.study.getParent().getKey())) != null && iPatientRepresentation.getDecompositionRuntime() instanceof IDisplaySetContainerRuntime) {
            IDisplaySetContainerRuntime iDisplaySetContainerRuntime = (IDisplaySetContainerRuntime)iPatientRepresentation.getDecompositionRuntime();
            return iDisplaySetContainerRuntime.isStudyCollapsed(this.study);
        }
        return false;
    }

    public void setCollapsed(boolean bl) {
        IPatientRepresentation iPatientRepresentation;
        if (this.isCollapsable() && (iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(this.study.getParent().getKey())) != null && iPatientRepresentation.getDecompositionRuntime() instanceof IDisplaySetContainerRuntime) {
            IDisplaySetContainerRuntime iDisplaySetContainerRuntime = (IDisplaySetContainerRuntime)iPatientRepresentation.getDecompositionRuntime();
            if (bl) {
                iDisplaySetContainerRuntime.setStudyCollapsed(this.study);
            } else {
                iDisplaySetContainerRuntime.setStudyExpanded(this.study);
            }
        }
    }

    public int getPriorIndex() {
        IStudyContainer iStudyContainer;
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging != null && (iStudyContainer = iHanging.getStudyContainer()) != null) {
            return iStudyContainer.getIndexOfStudy(this.study.getKey());
        }
        return -1;
    }

    private String toHtmlFontSize(int n) {
        if (n <= 0) {
            return "4";
        }
        if (n <= 6) {
            return "1";
        }
        if (n <= 8) {
            return "2";
        }
        if (n <= 12) {
            return "3";
        }
        if (n <= 16) {
            return "4";
        }
        if (n <= 24) {
            return "5";
        }
        if (n <= 36) {
            return "6";
        }
        return "7";
    }

    public int hashCode() {
        return this.study.getKey().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof StudyTableData) {
            return this.study.getKey().equals(((StudyTableData)object).study.getKey());
        }
        return false;
    }

    private static String getModalityString(IStudyData iStudyData) {
        String[] stringArray = iStudyData.getModalitiesInStudy();
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (!filteredModalities.contains(string)) {
                    if (stringBuilder.length() == 0) {
                        stringBuilder.append(string);
                    } else {
                        stringBuilder.append(',').append(string);
                    }
                }
                ++n2;
            }
        }
        return stringBuilder.toString();
    }
}

