/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.data.action.DataActionFactory;
import com.agfa.pacs.base.data.action.IDataAction;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.agfa.pacs.impaxee.actions.ui.ActionUIFactory;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.IActionUI;
import com.agfa.pacs.impaxee.data.fetcher.DataHandlerProviderFactory;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.data.fetcher.IStore;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.sessions.gui.WorklistChooser;
import com.agfa.pacs.impaxee.splitsort.ManualSplitAndSortActionProvider;
import com.agfa.pacs.listtext.lta.util.referencedobject.XDSDataInfoNode;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DisplaySetLabel;
import com.tiani.jvision.util.StorageLicense;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;

class DisplaySetLabelPopup
extends JPopupMenu {
    private static final ALogger log = ALogger.getLogger(DisplaySetLabelPopup.class);
    private IDisplaySet displaySet;
    private DisplaySetLabel parent;
    private boolean showDeleteOption;

    DisplaySetLabelPopup(DisplaySetLabel displaySetLabel, boolean bl) {
        this.parent = displaySetLabel;
        this.displaySet = displaySetLabel.getDisplaySet();
        this.showDeleteOption = bl;
        this.fillMenu();
    }

    private void fillMenu() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new CreateIconsAction());
        arrayList.add(new RemoveDisplaySetAction());
        arrayList.add(new RemoveAllDisplaySetsAction());
        arrayList.addAll(ManualSplitAndSortActionProvider.getSeriesPaletteActions(this.displaySet));
        arrayList.add(new StoreSecondaryCapture());
        if (this.isPerformActionAvailable("PRINT")) {
            arrayList.add(new SimpleDataAction("PRINT", false));
        }
        if (this.isPerformActionAvailable("EXPORT")) {
            arrayList.add(new SimpleDataAction("EXPORT", false));
        }
        arrayList.add(new DisplaySetStudySubMenu());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (((PAction)iterator.next()).isAvailable()) continue;
            iterator.remove();
        }
        for (PAction pAction : arrayList) {
            try {
                IActionUI iActionUI = ActionUIFactory.createUI(pAction, ActionUIScope.VisMenu);
                if (iActionUI == null) continue;
                this.add(iActionUI.getComponent());
            }
            catch (ActionNotFoundException actionNotFoundException) {
                log.warn("Creating action-ui for action '" + pAction.getID() + "' failed! Skipped...");
            }
            catch (Exception exception) {
                log.warn("Creating action-ui for action '" + pAction.getID() + "' failed! Skipped...", (Throwable)exception);
            }
        }
    }

    private boolean isPerformActionAvailable(String string) {
        IDataAction iDataAction = DataActionFactory.getInstance().getActionForCode(string);
        if (iDataAction == null) {
            return false;
        }
        return iDataAction.isAllowed();
    }

    private IPerform.IPerformContext getContext() {
        return new IPerform.DefaultPerformContext(JVision2.getMainFrame(), null);
    }

    private List<IDataObject> getData(boolean bl, boolean bl2) {
        ArrayList<IDataObject> arrayList = new ArrayList<IDataObject>();
        if (bl) {
            arrayList.add(this.displaySet.getOneObject().getParent().getParent());
        } else {
            arrayList.addAll(Arrays.asList(this.displaySet.getObjects()));
        }
        if (bl2) {
            boolean bl3 = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                IDataObject iDataObject = (IDataObject)iterator.next();
                if (!(iDataObject.getQueryObject().getSource() instanceof XDSDataInfoNode)) continue;
                iterator.remove();
                bl3 = true;
            }
            if (bl3) {
                ComponentFactory.instance.showErrorDialog(Messages.getString("AbstractExportDataAction.XDSRemovedTitle"), Messages.getString("AbstractExportDataAction.XDSRemovedMessage"), null);
            }
        }
        return arrayList;
    }

    private class AddStudyToWorklist
    extends AnonymousPAction {
        private AddStudyToWorklist() {
        }

        @Override
        public boolean isAvailable() {
            return DisplaySetLabelPopup.this.isPerformActionAvailable("ADD_TO_WORKLIST");
        }

        @Override
        public String getCaption() {
            return Messages.getString("DisplaySetLabelPopup.AddStudyToWorklist");
        }

        @Override
        public boolean perform(Component component) {
            Collection<IWorklistContext> collection;
            this.notifyActionPerformed("SERIES_ADD_TO_WORKLIST");
            IStore iStore = DataManager.getInstance().getDataStore();
            ArrayList<IWorklistContext> arrayList = new ArrayList<IWorklistContext>(iStore.getAvailableWorklistContexts());
            WorklistChooser worklistChooser = new WorklistChooser(JVision2.getMainFrame(), arrayList, null);
            if ("OK_OPTION" == worklistChooser.getDialogResult() && (collection = worklistChooser.getSelectedWorklistContexts()) != null && !collection.isEmpty()) {
                EventUtil.invokeNotOnEDT((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<IStudyData> arrayList = new ArrayList<IStudyData>();
                        arrayList.add(DisplaySetLabelPopup.this.displaySet.getOneObject().getParent().getParent());
                        IPerform iPerform = DataManager.getInstance().getDataPerform("ADD_TO_WORKLIST");
                        if (iPerform != null) {
                            iPerform.perform(new IPerform.DefaultPerformContext(null, collection), arrayList);
                        }
                    }
                });
            }
            return false;
        }
    }

    private class CreateIconsAction
    extends AnonymousPAction {
        private CreateIconsAction() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("DisplaySetLabelPopup.UpdateIcons");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("SERIES_UPDATE_ICONS");
            DisplaySetLabelPopup.this.parent.updateTokens();
            return false;
        }
    }

    private class DisplaySetStudySubMenu
    extends AnonymousPAction {
        private PAction[] cachedActions;
        private long cacheTimeStamp;

        private DisplaySetStudySubMenu() {
        }

        @Override
        public PAction.ActionType getActionType() {
            return PAction.ActionType.Submenu;
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public PAction[] getSubactions() {
            IStudyData iStudyData;
            AddStudyToWorklist addStudyToWorklist;
            if (this.cachedActions != null) {
                if (System.currentTimeMillis() - this.cacheTimeStamp < CACHING_TIMEOUT) {
                    return this.cachedActions;
                }
                this.cachedActions = null;
                this.cacheTimeStamp = 0L;
            }
            ArrayList<AnonymousPAction> arrayList = new ArrayList<AnonymousPAction>();
            if (DisplaySetLabelPopup.this.isPerformActionAvailable("PRINT")) {
                arrayList.add(new SimpleDataAction("PRINT", true));
            }
            if (DisplaySetLabelPopup.this.isPerformActionAvailable("EXPORT")) {
                arrayList.add(new SimpleDataAction("EXPORT", true));
            }
            if ((addStudyToWorklist = new AddStudyToWorklist()).isAvailable()) {
                arrayList.add(addStudyToWorklist);
            }
            if ((iStudyData = DisplaySetLabelPopup.this.parent.getStudyDataOfFirstFrame()) != null && iStudyData.getAvailableNewStudyStates() != null) {
                for (Action action : iStudyData.getAvailableNewStudyStates()) {
                    arrayList.add(new NewStudyStateAction(action));
                }
            }
            this.cachedActions = arrayList.toArray(new PAction[arrayList.size()]);
            this.cacheTimeStamp = System.currentTimeMillis();
            return this.cachedActions;
        }

        @Override
        public String getCaption() {
            return Messages.getString("VisPopup.Study");
        }

        @Override
        public boolean perform(Component component) {
            throw new UnsupportedOperationException();
        }

        private class NewStudyStateAction
        extends AnonymousPAction {
            private Action action;

            public NewStudyStateAction(Action action) {
                this.action = action;
            }

            @Override
            public String getCaption() {
                return this.action.getValue("ShortDescription").toString();
            }

            @Override
            public boolean perform(Component component) {
                this.notifyActionPerformed("SERIES_STUDY_STATE");
                this.action.actionPerformed(null);
                return true;
            }
        }
    }

    private class RemoveAllDisplaySetsAction
    extends AnonymousPAction {
        private RemoveAllDisplaySetsAction() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("SEQPANEL_POPUP_DELETE_ALL");
        }

        @Override
        public boolean isAvailable() {
            return DisplaySetLabelPopup.this.showDeleteOption;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("SERIES_REMOVE_ALL_DS");
            DataManager.getInstance().removePatient(DisplaySetLabelPopup.this.displaySet.getSplitAndSortRuntime().getPatientRepresentation().getPatientKey(), true);
            return true;
        }
    }

    private class RemoveDisplaySetAction
    extends AnonymousPAction {
        private RemoveDisplaySetAction() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("SEQPANEL_POPUP_DELETE");
        }

        @Override
        public boolean isAvailable() {
            return DisplaySetLabelPopup.this.showDeleteOption;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("SERIES_REMOVE_DS");
            DataManager.getInstance().removeDisplaySet(new IDisplaySet[]{DisplaySetLabelPopup.this.displaySet}, true);
            return true;
        }
    }

    private class SimpleDataAction
    extends AnonymousPAction {
        private boolean wholeStudy;
        private String actionCode;

        public SimpleDataAction(String string, boolean bl) {
            this.wholeStudy = bl;
            this.actionCode = string;
        }

        @Override
        public String getCaption() {
            if (this.actionCode == "PRINT") {
                return Messages.getString("DisplaySetLabelPopup.PrintStudy");
            }
            if (this.actionCode == "EXPORT") {
                return Messages.getString("DisplaySetLabelPopup.ExportStudy");
            }
            return DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getDataPerform(this.actionCode).toString();
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("SERIES_ACTION_" + this.actionCode);
            IPerform iPerform = DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getDataPerform(this.actionCode);
            List list = DisplaySetLabelPopup.this.getData(this.wholeStudy, this.actionCode.equals("EXPORT"));
            if (list.size() > 0) {
                return iPerform.perform(DisplaySetLabelPopup.this.getContext(), list).getReturnCode() == 0;
            }
            return false;
        }
    }

    private class StoreSecondaryCapture
    extends AnonymousPAction {
        private StoreSecondaryCapture() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("DisplaySetLabelPopup.ExportSCDirect");
        }

        @Override
        public boolean isAvailable() {
            if (DisplaySetLabelPopup.this.displaySet.isSecondaryCaptureSaved()) {
                return false;
            }
            return StorageLicense.canStoreSC();
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("SERIES_STORE_SC");
            IPerform iPerform = DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getDataPerform("EXPORT_SC_DIRECT");
            if (iPerform == null) {
                return false;
            }
            iPerform.perform(DisplaySetLabelPopup.this.getContext(), Arrays.asList(DisplaySetLabelPopup.this.parent.getDisplaySet().getObjects()));
            DisplaySetLabelPopup.this.displaySet.setSecondaryCaptureSaved(true);
            DisplaySetLabelPopup.this.parent.invalidate();
            JVision2.getMainFrame().repaintSeriesPalettes();
            return true;
        }
    }
}

