/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.swing.imagednd.ImageDragAndDropManager;
import com.agfa.pacs.base.swing.progress.IActivityIndicator;
import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.base.swing.util.ProgressUtil;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.impl.ImpaxEESessionDisplaySet;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.runtime.IDisplaySetContainerRuntime;
import com.agfa.pacs.listtext.dicomobject.presentationstate.FramePresentationStateProviderContainer;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IObjectListener;
import com.tiani.base.data.IStudyData;
import com.tiani.base.data.IStudyStatusListener;
import com.tiani.base.data.RawDataContainerTokenCreator;
import com.tiani.base.data.RawDataContainerTokenData;
import com.tiani.base.data.TokenData;
import com.tiani.base.data.TokenListener;
import com.tiani.base.data.TokenOwner;
import com.tiani.config.LayoutConfig;
import com.tiani.config.mappingfonts.model.AwtFontFactory;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorLabel;
import com.tiani.jvision.dnd.SeqTransferable;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.Modes;
import com.tiani.jvision.patinfo.DisplaySetLabelPopup;
import com.tiani.jvision.patinfo.FastDisplaySetReplaceMode;
import com.tiani.jvision.patinfo.SeqLabelMapping;
import com.tiani.jvision.patinfo.TToken;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.layout.LytMainVariable;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JViewport;

public class DisplaySetLabel
extends MultiMonitorLabel
implements TokenListener,
IObjectListener,
IDisplaySet.ILoadStatusListener,
DragGestureListener,
IStudyStatusListener {
    private static final int DEFAULT_TOKEN_SIZE = 64;
    private static final ALogger log = ALogger.getLogger(DisplaySetLabel.class);
    public static final int tokenSize = GUI.getScaledDiagnosticInt((int)((int)Config.impaxee.jvision.SEQPANEL.TokenSize.get()));
    static final int infoHeight = (int)Config.impaxee.jvision.SEQPANEL.FontSize.get();
    private static final boolean showTooltips = Config.impaxee.jvision.SEQLABEL.ShowTooltips.get();
    private static final PIcon ICON_DIAG = IAIconFactory.DEFAULT_FACTORY.loadIcon("606_okay.svg");
    private static final PIcon ICON_PR = IAIconFactory.DEFAULT_FACTORY.loadIcon("neutral_presstate_hr.svg");
    private static final PIcon ICON_SEEN = IAIconFactory.DEFAULT_FACTORY.loadIcon("seqlabel_seen.svg");
    private static final PIcon ICON_SEQ_NOTSAVED = IAIconFactory.DEFAULT_FACTORY.loadIcon("seqlabel_notsaved.svg");
    private static final PIcon ICON_LOSSY = IAIconFactory.DEFAULT_FACTORY.loadIcon("jpeglossy.svg");
    private static final PIcon ICON_SECCAPTURE = IAIconFactory.DEFAULT_FACTORY.loadIcon("seqlabel_secondarycapture.svg");
    private static final int MINIMUM_WIDTH = 350;
    private static final int MINIMUM_WIDTH_HORIZONTAL = GUI.getScaledDiagnosticInt((int)130);
    private static final Color VERY_DARK_GRAY = new Color(40, 35, 10);
    private static final int IMAGE_COUNT_PADDING = GUI.getScaledDiagnosticInt((int)3);
    private static final int IMAGE_COUNT_OFFSET = GUI.getScaledDiagnosticInt((int)5);
    private static final int REMOVE_SYMBOL_PADDING = IMAGE_COUNT_PADDING;
    private static final int REMOVE_SYMBOL_DIM = GUI.getScaledDiagnosticInt((int)13);
    private static final int COLLAPSE_SYMBOL_PADDING = GUI.getScaledDiagnosticInt((int)3);
    private static final int COLLAPSE_SYMBOL_DIM = REMOVE_SYMBOL_DIM;
    private static final int EXPAND_SYMBOL_PADDING = REMOVE_SYMBOL_PADDING;
    private static final int EXPAND_SYMBOL_DIM = REMOVE_SYMBOL_DIM;
    private static final Modes.PaletteOrientation orientation = Modes.PaletteOrientation.valueOf(Config.impaxee.workstation.MONITORS.SeriesPaletteOrientation.get());
    private static final int maximumNumberOfFrames = orientation.isHorizontal() ? 1 : 5;
    private static final Color darkBackgroundColor = new Color(30, 30, 30);
    private static final Color cMono = new Color(154, 154, 154);
    private static final Font font = AwtFontFactory.getFont(Config.impaxee.jvision.MAPPING.DisplayFontFace.get(), (int)Config.impaxee.jvision.MAPPING.DisplayFontStyle.get(), GUI.getScaledDiagnosticInt((int)((int)Config.impaxee.jvision.MAPPING.DisplayFontSize.get())));
    private static final FastDisplaySetReplaceMode REPLACE_MODE = FastDisplaySetReplaceMode.valueOf(Config.impaxee.jvision.SEQPANEL.FastDisplaySetReplace.get());
    private IDisplaySet displaySet;
    private boolean isActive;
    private Rectangle lastModRect = new Rectangle(0, 0, tokenSize, tokenSize);
    private DragSource dndSource;
    private int preferredHeight;
    private Map<TokenOwner, TToken> tokens;
    private SeqLabelMapping mapping;
    private int headerHeight;
    private PrivateMouseListener privateMouseListener;
    private Rectangle removeSymbolBounds;
    private Rectangle collapseSymbolBounds;
    private Rectangle expandSymbolBounds;
    private boolean isMouseOverRemoveSymbol;
    private boolean isMouseOverCollapseSymbol;
    private boolean isMouseOverExpandSymbol;
    private boolean hasPR;
    private boolean isDeletableByUser;
    private String tooltip;

    DisplaySetLabel(IDisplaySet iDisplaySet) {
        IDataObject iDataObject;
        this.displaySet = iDisplaySet;
        this.isDeletableByUser = !(iDisplaySet instanceof ImpaxEESessionDisplaySet);
        this.createDragSource();
        if (iDisplaySet.getFrameCount() > 0) {
            iDataObject = iDisplaySet.getOneObject();
            this.mapping = new SeqLabelMapping(iDataObject);
            iDisplaySet.addLoadStatusListener(this);
            this.privateMouseListener = new PrivateMouseListener();
            this.addMouseListener(this.privateMouseListener);
            this.addMouseMotionListener(this.privateMouseListener);
            this.init();
            if (iDataObject.getParent().containsDerivedImages()) {
                this.updateTokens();
            }
        }
        if (iDisplaySet.getFrameCount() > 0) {
            this.getStudyDataOfFirstFrame().addListener(this);
            iDataObject = iDisplaySet.getOneObject().getParent();
            FramePresentationStateProviderContainer framePresentationStateProviderContainer = iDataObject.getParent().getFramePresentationStateProviderContainer();
            this.hasPR = framePresentationStateProviderContainer.isSeriesReferencedByExtPresState(iDataObject.getSeriesInstanceUID());
        }
    }

    private void updateHeight() {
        this.headerHeight = 2 + this.mapping.getExpectedHeight();
        this.removeSymbolBounds = new Rectangle(REMOVE_SYMBOL_PADDING, this.headerHeight + REMOVE_SYMBOL_PADDING, REMOVE_SYMBOL_DIM, REMOVE_SYMBOL_DIM);
        this.collapseSymbolBounds = new Rectangle(COLLAPSE_SYMBOL_PADDING, this.headerHeight + REMOVE_SYMBOL_PADDING + COLLAPSE_SYMBOL_PADDING + REMOVE_SYMBOL_DIM, COLLAPSE_SYMBOL_DIM, COLLAPSE_SYMBOL_DIM);
        this.expandSymbolBounds = new Rectangle(EXPAND_SYMBOL_PADDING, this.headerHeight + REMOVE_SYMBOL_PADDING + COLLAPSE_SYMBOL_PADDING + REMOVE_SYMBOL_DIM, EXPAND_SYMBOL_DIM, EXPAND_SYMBOL_DIM);
        this.preferredHeight = orientation.isHorizontal() ? Math.max(tokenSize + this.headerHeight, LytMainVariable.getCommanderWidth(orientation) - GUI.getScaledDiagnosticInt((int)60)) : tokenSize + this.headerHeight;
    }

    void postGUIInit() {
        int[] nArray = this.getVisibleTokens();
        IFrameObjectData[] iFrameObjectDataArray = this.displaySet.getObjects();
        int n = nArray[0];
        while (n < nArray[1]) {
            if (!iFrameObjectDataArray[n].isStartedBeingLoaded()) {
                iFrameObjectDataArray[n].getMainFrame().addListener(this);
            }
            ++n;
        }
    }

    private void init() {
        this.setCursor(new Cursor(12));
        if (this.mapping != null) {
            this.mapping.updateContent(true, false);
            this.updateHeight();
            if (showTooltips) {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("<html>");
                for (String string : this.mapping.getMappingRowsAsStrings()) {
                    stringBuilder.append(string).append("<br>");
                }
                stringBuilder.append("</html>");
                this.tooltip = stringBuilder.toString();
            }
        }
    }

    private void createDragSource() {
        this.dndSource = new DragSource();
        this.dndSource.createDefaultDragGestureRecognizer(this, 0x40000003, this);
    }

    public Rectangle getLastModRect() {
        return this.lastModRect;
    }

    public int getImageWidth() {
        int n = this.displaySet.getFrameCount();
        if (n > maximumNumberOfFrames) {
            n = maximumNumberOfFrames;
        }
        int n2 = n * tokenSize;
        if (orientation.isHorizontal()) {
            return Math.max(n2, MINIMUM_WIDTH_HORIZONTAL);
        }
        return Math.max(n2, 350);
    }

    public IDisplaySet getDisplaySet() {
        return this.displaySet;
    }

    @Override
    public void notifyLoadStatusChange() {
        this.repaint();
    }

    private int[] getVisibleTokens() {
        int[] nArray = null;
        JViewport jViewport = this.findViewport();
        if (jViewport != null) {
            nArray = new int[2];
            nArray[0] = 0;
            if (this.displaySet.getFrameCount() > maximumNumberOfFrames && !Config.impaxee.jvision.SEQLABEL.UseFirstImagesForTokens.get()) {
                nArray[0] = this.displaySet.getFrameCount() / 2 - maximumNumberOfFrames / 2;
            }
            nArray[1] = jViewport.getVisibleRect().width / tokenSize + 2;
            if (nArray[1] > maximumNumberOfFrames) {
                nArray[1] = maximumNumberOfFrames;
            }
            if (nArray[0] + nArray[1] > this.displaySet.getFrameCount()) {
                nArray[1] = this.displaySet.getFrameCount() - nArray[0];
            }
            nArray[1] = nArray[1] + nArray[0];
        } else {
            int[] nArray2 = new int[2];
            nArray2[1] = this.displaySet.getFrameCount() - 1;
            nArray = nArray2;
        }
        return nArray;
    }

    private JViewport findViewport() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JViewport) {
                return (JViewport)container;
            }
            container = container.getParent();
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        IDisplaySetContainerRuntime iDisplaySetContainerRuntime;
        Object object;
        if (!this.isVisible() || this.getParent() == null || !this.getParent().isVisible()) {
            return;
        }
        int n = this.getBounds().width;
        Color color = this.getCurrentMappingColor();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.displaySet.isBeingLoaded()) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(darkBackgroundColor);
        }
        graphics2D.fillRect(0, 0, n - 2, this.preferredHeight);
        if (this.getParent() == null) {
            return;
        }
        int[] nArray = this.getVisibleTokens();
        Object object2 = null;
        if (tokenSize != 64) {
            object2 = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        Composite composite = null;
        if (!this.displaySet.isBeingLoaded()) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.35f));
        }
        IFrameObjectData[] iFrameObjectDataArray = this.displaySet.getObjects();
        int n2 = nArray[0];
        while (n2 < nArray[1]) {
            IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n2];
            object = this.getToken(iFrameObjectData);
            if (!((TToken)object).getTokenData().isFinalToken()) {
                iFrameObjectData.setRawDataContainerToken();
                if (iFrameObjectData.getTokenData() instanceof RawDataContainerTokenData) {
                    if (this.tokens == null) {
                        this.tokens = new HashMap<TokenOwner, TToken>(6);
                    }
                    RawDataContainerTokenCreator.getInstance().addTokenData((RawDataContainerTokenData)iFrameObjectData.getTokenData());
                    object = new TToken(iFrameObjectData.getTokenData(), this);
                    this.tokens.put(iFrameObjectData, (TToken)object);
                }
            }
            ((TToken)object).getTokenData().paintToken(graphics2D, (n2 - nArray[0]) * tokenSize, this.headerHeight, tokenSize, tokenSize, this);
            ++n2;
        }
        n2 = tokenSize + IMAGE_COUNT_PADDING + IMAGE_COUNT_OFFSET;
        int n3 = this.headerHeight + IMAGE_COUNT_OFFSET;
        object = new Integer(this.displaySet.getFrameCount()).toString();
        graphics2D.setFont(font);
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds((String)object, graphics2D);
        int n4 = (int)rectangle2D.getHeight();
        int n5 = (int)rectangle2D.getWidth();
        Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds("0000", graphics2D);
        int n6 = (int)rectangle2D2.getHeight();
        int n7 = (int)rectangle2D2.getWidth();
        boolean bl = this.displaySet.isDisplayedInImageArea();
        if (bl) {
            graphics2D.setColor(VERY_DARK_GRAY);
        } else {
            graphics2D.setColor(Color.BLACK);
        }
        int n8 = n2 - IMAGE_COUNT_PADDING;
        int n9 = n3 - IMAGE_COUNT_PADDING;
        int n10 = n7 + IMAGE_COUNT_PADDING * 2;
        int n11 = n6 + IMAGE_COUNT_PADDING * 2;
        graphics2D.fillRect(n8, n9, n10, n11);
        int n12 = (n7 - n5) / 2;
        graphics2D.setColor(color);
        graphics2D.drawString((String)object, n2 + n12, n3 + n4 - graphics2D.getFontMetrics().getDescent());
        graphics2D.drawRect(n8, n9, n10, n11);
        if (bl) {
            graphics2D.drawRect(n8 + 2, n9 + 2, n10 - 4, n11 - 4);
        }
        if (this.isDeletableByUser) {
            if (this.isMouseOverRemoveSymbol) {
                this.paintRemoveSymbol(graphics2D, Color.BLACK, color);
            } else {
                this.paintRemoveSymbol(graphics2D, color, Color.BLACK);
            }
        }
        if ((iDisplaySetContainerRuntime = this.getDisplaySetContainerRuntime()) != null && this.displaySet != null && iDisplaySetContainerRuntime.isDisplaySetCollapsable(this.displaySet)) {
            if (iDisplaySetContainerRuntime.isDisplaySetCollapsed(this.displaySet)) {
                if (iDisplaySetContainerRuntime.isDisplaySetExpandable(this.displaySet)) {
                    if (this.isMouseOverCollapseSymbol) {
                        this.paintCollapseSymbol(graphics2D, Color.BLACK, color);
                    } else {
                        this.paintCollapseSymbol(graphics2D, color, Color.BLACK);
                    }
                } else {
                    this.paintCollapseSymbol(graphics2D, cMono, Color.BLACK);
                }
            } else if (this.isMouseOverExpandSymbol && iDisplaySetContainerRuntime.isDisplaySetCollapsable(this.displaySet)) {
                this.paintExpandSymbol(graphics2D, Color.BLACK, color);
            } else {
                this.paintExpandSymbol(graphics2D, color, Color.BLACK);
            }
        }
        if (tokenSize != 64) {
            if (object2 != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
            } else {
                graphics2D.getRenderingHints().remove(RenderingHints.KEY_INTERPOLATION);
            }
        }
        if (this.isActive) {
            this.lastModRect.x = 0;
            this.lastModRect.y = 0;
            this.lastModRect.width = Math.min(maximumNumberOfFrames, this.displaySet.getFrameCount()) * tokenSize;
            this.lastModRect.height = tokenSize;
            this.paintLastModBorder(graphics2D);
        }
        if (this.displaySet.getFrameCount() > 0) {
            Image image;
            IStudyData iStudyData = this.getStudyDataOfFirstFrame();
            PIcon pIcon = this.displaySet.isLossyData() ? ICON_LOSSY : this.displaySet.getOneObject().getStatusIcon();
            if (pIcon != null) {
                graphics2D.drawImage(pIcon.getImage(), GUI.getScaledDiagnosticInt((int)20), this.getSize().height - GUI.getScaledDiagnosticInt((int)65), null);
            }
            if (this.hasPR) {
                image = ICON_PR.getImage();
                graphics2D.drawImage(image, GUI.getScaledDiagnosticInt((int)55), this.getSize().height - image.getHeight(null), null);
            }
            if (iStudyData.isDiagnosed()) {
                graphics2D.drawImage(ICON_DIAG.getImage(), GUI.getScaledDiagnosticInt((int)40), this.getSize().height - GUI.getScaledDiagnosticInt((int)55), null);
            }
            if (iStudyData.isSeen()) {
                graphics2D.drawImage(ICON_SEEN.getImage(), GUI.getScaledDiagnosticInt((int)3), this.getSize().height - GUI.getScaledDiagnosticInt((int)45), null);
            }
            if (this.displaySet.isSecondaryCapture()) {
                image = !this.displaySet.isSecondaryCaptureSaved() ? ICON_SEQ_NOTSAVED : ICON_SECCAPTURE;
                graphics2D.drawImage(image.getImage(), GUI.getScaledDiagnosticInt((int)20), this.getSize().height - image.getIconHeight(), null);
            }
        }
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
        if (this.mapping != null) {
            this.mapping.paint(graphics2D);
            if (this.mapping.getPaintedWidth() > this.getWidth() && showTooltips) {
                this.setToolTipText(this.tooltip);
            }
        }
        super.paint(graphics2D);
    }

    private Color getCurrentMappingColor() {
        return this.mapping.getMappingColor();
    }

    private void paintRemoveSymbol(Graphics graphics, Color color, Color color2) {
        graphics.setColor(color2);
        graphics.fillRect(this.removeSymbolBounds.x, this.removeSymbolBounds.y, this.removeSymbolBounds.width, this.removeSymbolBounds.height);
        graphics.setColor(color);
        graphics.drawRect(this.removeSymbolBounds.x, this.removeSymbolBounds.y, this.removeSymbolBounds.width, this.removeSymbolBounds.height);
        int n = this.removeSymbolBounds.x + REMOVE_SYMBOL_PADDING;
        int n2 = this.removeSymbolBounds.y + REMOVE_SYMBOL_PADDING;
        int n3 = this.removeSymbolBounds.x + this.removeSymbolBounds.width - REMOVE_SYMBOL_PADDING;
        int n4 = this.removeSymbolBounds.y + this.removeSymbolBounds.height - REMOVE_SYMBOL_PADDING;
        graphics.drawLine(n, n2, n3, n4);
        graphics.drawLine(n, n4, n3, n2);
    }

    private void paintCollapseSymbol(Graphics graphics, Color color, Color color2) {
        Rectangle rectangle = new Rectangle(this.collapseSymbolBounds);
        graphics.setColor(color2);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = 1 + Math.max(1, GUI.getScaledDiagnosticInt((int)2));
        rectangle.x += n;
        rectangle.y += n;
        rectangle.width -= 2 * n;
        rectangle.height -= 2 * n;
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.width);
    }

    private void paintExpandSymbol(Graphics graphics, Color color, Color color2) {
        Rectangle rectangle = new Rectangle(this.expandSymbolBounds);
        graphics.setColor(color2);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = Math.max(1, GUI.getScaledDiagnosticInt((int)2));
        int n2 = 1 + Math.max(0, GUI.getScaledDiagnosticInt((int)2));
        rectangle.x += n2;
        rectangle.y += n2;
        rectangle.width -= 2 * n2;
        rectangle.height -= 2 * n2;
        graphics.fillRect(rectangle.x, (int)(rectangle.getCenterY() - (double)(n / 2) + 0.5), rectangle.width, n);
    }

    public IStudyData getStudyDataOfFirstFrame() {
        if (this.displaySet == null) {
            return null;
        }
        try {
            return this.displaySet.getStudy();
        }
        catch (Exception exception) {
            log.error("Could not determine StudyData object from display set label.", (Throwable)exception);
            return null;
        }
    }

    private TToken getToken(TokenOwner tokenOwner) {
        if (this.tokens == null) {
            this.tokens = new HashMap<TokenOwner, TToken>(6);
        }
        if (!this.tokens.containsKey(tokenOwner)) {
            this.tokens.put(tokenOwner, new TToken(tokenOwner.getTokenData(), this));
        } else if (this.tokens.get(tokenOwner).getTokenData() != tokenOwner.getTokenData()) {
            this.tokens.put(tokenOwner, new TToken(tokenOwner.getTokenData(), this));
        }
        return this.tokens.get(tokenOwner);
    }

    @Override
    public void tokenChanged(TokenData tokenData) {
        this.repaint();
    }

    private void paintLastModBorder(Graphics graphics) {
        DisplaySetLabel.paintLastModBorder(graphics, this.lastModRect, this.headerHeight);
    }

    public static void paintLastModBorder(Graphics graphics, Rectangle rectangle, int n) {
        int n2;
        int n3;
        if (graphics == null) {
            return;
        }
        int n4 = rectangle.width - 2;
        int n5 = rectangle.height - 1;
        int n6 = 21;
        int n7 = 21;
        float f = (float)n4 / (float)n6;
        float f2 = (float)n5 / (float)n7;
        n6 = (int)((float)n4 / f2);
        f = (float)n4 / (float)n6;
        int n8 = rectangle.x + 1 + n4 - 1;
        int n9 = rectangle.y + 1 + n5 - 1 + n;
        graphics.setColor(Vis2.COLOR_SELECT);
        graphics.drawRect(rectangle.x + 1, rectangle.y + n, n4, n5);
        graphics.setColor(Vis2.COLOR_LASTMODIFIED);
        int n10 = rectangle.y + n;
        int n11 = n10 + n5;
        int n12 = (int)(2.0f * f);
        int n13 = (int)f;
        int n14 = 0;
        while (n14 < n4) {
            n3 = n14 + rectangle.x + 1;
            n2 = n3 + n13;
            if (n2 > n8) {
                n2 = n8;
            }
            graphics.drawLine(n3, n10, n2, n10);
            graphics.drawLine(n3, n11, n2, n11);
            n14 += n12;
        }
        n3 = rectangle.x + 1;
        n2 = n3 + n4;
        n14 = (int)(2.0f * f2);
        int n15 = (int)f2;
        int n16 = rectangle.y + n;
        int n17 = 0;
        while (n17 < n5) {
            n10 = n17 + n16;
            n11 = n10 + n15;
            if (n11 > n9) {
                n11 = n9;
            }
            graphics.drawLine(n3, n10, n3, n11);
            graphics.drawLine(n2, n10, n2, n11);
            n17 += n14;
        }
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.relayout();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.relayout();
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.relayout();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.relayout();
    }

    private void relayout() {
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        if (this.mapping != null) {
            this.mapping.setSize(n, n2, null);
            this.mapping.updateContent(false, false);
            this.updateHeight();
        }
    }

    public void cleanUp() {
        this.removeListeners();
        this.displaySet = null;
        this.dndSource = null;
        this.mapping = null;
        if (this.tokens != null) {
            this.tokens.clear();
        }
        this.tokens = null;
    }

    private void removeListeners() {
        this.displaySet.removeLoadStatusListener(this);
        IStudyData iStudyData = this.getStudyDataOfFirstFrame();
        if (iStudyData != null) {
            iStudyData.removeListener(this);
        }
        if (this.privateMouseListener != null) {
            this.removeMouseListener(this.privateMouseListener);
            this.privateMouseListener = null;
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean bl) {
        this.isActive = bl;
    }

    private IDisplaySetContainerRuntime getDisplaySetContainerRuntime() {
        ISplitAndSortRuntime iSplitAndSortRuntime;
        IPatientRepresentation iPatientRepresentation;
        IStudyData iStudyData = this.getStudyDataOfFirstFrame();
        if (iStudyData != null && (iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey())) != null && (iSplitAndSortRuntime = iPatientRepresentation.getDecompositionRuntime()) instanceof IDisplaySetContainerRuntime) {
            return (IDisplaySetContainerRuntime)iSplitAndSortRuntime;
        }
        return null;
    }

    public void updateTokens() {
        int[] nArray = this.getVisibleTokens();
        IFrameObjectData[] iFrameObjectDataArray = this.displaySet.getObjects();
        LinkedHashSet<IImageObjectData> linkedHashSet = new LinkedHashSet<IImageObjectData>();
        int n = nArray[0];
        while (n < nArray[1]) {
            IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n];
            if (iFrameObjectData.getRawDataContainer() == null || iFrameObjectData.getTokenData() == null || !iFrameObjectData.getTokenData().isFinalToken()) {
                linkedHashSet.add(iFrameObjectData.getMainFrame());
                iFrameObjectData.setRawDataContainerToken();
            }
            ++n;
        }
        for (IImageObjectData iImageObjectData : linkedHashSet) {
            iImageObjectData.addListener(this);
            DataManager.getInstance().getFetcher().changeToHigherPriority(iImageObjectData, (byte)5);
        }
    }

    @Override
    public int getHeight() {
        return this.preferredHeight;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        SeqTransferable seqTransferable = new SeqTransferable(this.displaySet);
        try {
            this.dndSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, seqTransferable, new PrivateDragSourceListener());
            ImageDragAndDropManager.getInstance().startImageDragAndDrop(dragGestureEvent.getDragSource(), this.createDragAndDropImage(), 0.6f);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            log.warn("Initiating display-set-label drag failed. Trying once more again ...");
            this.createDragSource();
            try {
                this.dndSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, seqTransferable, new PrivateDragSourceListener());
                ImageDragAndDropManager.getInstance().startImageDragAndDrop(dragGestureEvent.getDragSource(), this.createDragAndDropImage(), 0.6f);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException2) {
                log.error("Initiating displaysetlabel drag failed!", (Throwable)invalidDnDOperationException2);
            }
        }
    }

    private BufferedImage createDragAndDropImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.paint(graphics2D);
        return bufferedImage;
    }

    @Override
    public void studyStateChanged(IStudyData iStudyData) {
        if (this.getStudyDataOfFirstFrame().equals(iStudyData)) {
            this.repaint();
        }
    }

    @Override
    public void lossyObjectFinished(IObjectData iObjectData) {
    }

    @Override
    public void objectFinished(IObjectData iObjectData) {
        if (this.displaySet != null) {
            IFrameObjectData[] iFrameObjectDataArray = ((IImageObjectData)iObjectData).frames();
            int n = iFrameObjectDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n2];
                iFrameObjectData.setRawDataContainerToken();
                ++n2;
            }
        }
    }

    private static class PrivateDragSourceListener
    extends DragSourceAdapter {
        private PrivateDragSourceListener() {
        }
    }

    private class PrivateMouseListener
    extends MouseAdapter {
        private PrivateMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            VisDisplay2 visDisplay2;
            VisData visData;
            if (DisplaySetLabel.this.removeSymbolBounds.contains(mouseEvent.getX(), mouseEvent.getY()) && DisplaySetLabel.this.isDeletableByUser) {
                DataManager.getInstance().removeDisplaySet(new IDisplaySet[]{DisplaySetLabel.this.displaySet}, true);
            } else if (DisplaySetLabel.this.collapseSymbolBounds.contains(mouseEvent.getPoint())) {
                final IDisplaySetContainerRuntime iDisplaySetContainerRuntime = DisplaySetLabel.this.getDisplaySetContainerRuntime();
                if (iDisplaySetContainerRuntime != null) {
                    boolean bl;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            block11: {
                                IActivityIndicator iActivityIndicator = null;
                                try {
                                    try {
                                        CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
                                        boolean bl = !iDisplaySetContainerRuntime.isDisplaySetCollapsed(DisplaySetLabel.this.displaySet);
                                        try {
                                            IStudyData iStudyData = DisplaySetLabel.this.displaySet.getStudy();
                                            if (!bl && iStudyData.getNumberOfAvailableImages() > iStudyData.getNumberOfLoadedImages()) {
                                                iActivityIndicator = ProgressUtil.createActivityIndicator((Component)JVision2.getMainFrame(), (int)LayoutConfig.getInstance().getScreenColumns(), (boolean)true, (IActivityIndicator.DisplayMode)IActivityIndicator.DisplayMode.LAYER);
                                                iActivityIndicator.setText(Messages.getString("Activity.LoadStudy.Text"));
                                                iActivityIndicator.show();
                                            }
                                        }
                                        catch (Exception exception) {}
                                        if (bl) {
                                            iDisplaySetContainerRuntime.setDisplaySetCollapsed(DisplaySetLabel.this.displaySet);
                                            break block11;
                                        }
                                        iDisplaySetContainerRuntime.setDisplaySetExpanded(DisplaySetLabel.this.displaySet);
                                    }
                                    catch (Exception exception) {
                                        log.error("Error", (Throwable)exception);
                                        if (iActivityIndicator != null) {
                                            iActivityIndicator.close();
                                        }
                                        CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
                                    }
                                }
                                finally {
                                    if (iActivityIndicator != null) {
                                        iActivityIndicator.close();
                                    }
                                    CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
                                }
                            }
                        }
                    };
                    boolean bl2 = iDisplaySetContainerRuntime.isDisplaySetCollapsed(DisplaySetLabel.this.displaySet) && iDisplaySetContainerRuntime.isDisplaySetExpandable(DisplaySetLabel.this.displaySet);
                    boolean bl3 = bl = !iDisplaySetContainerRuntime.isDisplaySetCollapsed(DisplaySetLabel.this.displaySet) && iDisplaySetContainerRuntime.isDisplaySetExpandable(DisplaySetLabel.this.displaySet);
                    if (bl2 || bl) {
                        EventUtil.invokeNotOnEDT((Runnable)runnable);
                    }
                }
            } else if (REPLACE_MODE.isEnabled() && ModifierKeys.isLMB((MouseEvent)mouseEvent) && mouseEvent.getClickCount() == REPLACE_MODE.getClickCount() && (visData = VisData.getLastModified()) != null && (visDisplay2 = visData.getParent().getVisDisplay()).isDragAndDropEnabled()) {
                visDisplay2.initVisDisplay(DisplaySetLabel.this.displaySet, null, true, ActivationMode.MANUAL);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (ModifierKeys.isRMB((MouseEvent)mouseEvent)) {
                DisplaySetLabelPopup displaySetLabelPopup = new DisplaySetLabelPopup(DisplaySetLabel.this, DisplaySetLabel.this.isDeletableByUser);
                displaySetLabelPopup.show(DisplaySetLabel.this, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (ModifierKeys.isLMB((MouseEvent)mouseEvent)) {
                boolean bl = false;
                if (DisplaySetLabel.this.removeSymbolBounds.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    DisplaySetLabel.this.isMouseOverRemoveSymbol = true;
                    bl = true;
                }
                if (DisplaySetLabel.this.collapseSymbolBounds.contains(mouseEvent.getPoint())) {
                    DisplaySetLabel.this.isMouseOverCollapseSymbol = true;
                    bl = true;
                }
                if (DisplaySetLabel.this.expandSymbolBounds.contains(mouseEvent.getPoint())) {
                    DisplaySetLabel.this.isMouseOverExpandSymbol = true;
                    bl = true;
                }
                if (bl) {
                    DisplaySetLabel.this.repaint();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.checkMousePositionInsideSymbols(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.checkMousePositionInsideSymbols(mouseEvent);
        }

        private void checkMousePositionInsideSymbols(MouseEvent mouseEvent) {
            boolean bl;
            boolean bl2;
            boolean bl3 = false;
            boolean bl4 = DisplaySetLabel.this.removeSymbolBounds.contains(mouseEvent.getX(), mouseEvent.getY());
            if (bl4 != DisplaySetLabel.this.isMouseOverRemoveSymbol) {
                DisplaySetLabel.this.isMouseOverRemoveSymbol = bl4;
                bl3 = true;
            }
            if ((bl2 = DisplaySetLabel.this.collapseSymbolBounds.contains(mouseEvent.getX(), mouseEvent.getY())) != DisplaySetLabel.this.isMouseOverCollapseSymbol) {
                DisplaySetLabel.this.isMouseOverCollapseSymbol = bl2;
                bl3 = true;
            }
            if ((bl = DisplaySetLabel.this.expandSymbolBounds.contains(mouseEvent.getX(), mouseEvent.getY())) != DisplaySetLabel.this.isMouseOverExpandSymbol) {
                DisplaySetLabel.this.isMouseOverExpandSymbol = bl;
                bl3 = true;
            }
            if (bl3) {
                DisplaySetLabel.this.repaint();
            }
        }
    }
}

