/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.listtext.swingx.util.ContextSensitiveHelpUtilities;
import com.tiani.base.data.ISeriesData;
import com.tiani.gui.dialog.StandardDialog;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsChart;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsDisplayPanel;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsManager;
import com.tiani.jvision.vis.VisDisplay2;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class OverlayStatisticsDialog
extends StandardDialog
implements ChangeListener {
    private JButton createSCBtn;
    private JButton copyToClipboardBtn;
    private OverlayStatisticsChart lineChart;
    private final OverlayStatisticsDisplayPanel displayPanel;
    private JLabel intensityUnit;
    private JRadioButton relativeValuesRb;
    private JRadioButton absoluteValuesRb;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JCheckBox includeOwnerCheckBox;
    private JLabel setReferenceValueLb;
    private JPanel optionsPanel;
    private JPanel rbPanel;
    private JPanel chartPanel;

    public OverlayStatisticsDialog(View view, VisDisplay2 visDisplay2) {
        super((Frame)JVision2.getMainFrame(), Messages.getString("OverlayStatisticsDialog.Title"));
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        this.lineChart = new OverlayStatisticsChart(view);
        this.displayPanel = new OverlayStatisticsDisplayPanel(visDisplay2);
        JTabbedPane jTabbedPane = ComponentFactory.instance.createTabbedPane();
        jTabbedPane.addTab(Messages.getString("OverlayStatisticsDialog.DisplayPanel.Title"), this.displayPanel);
        jTabbedPane.addTab(Messages.getString("OverlayStatisticsDialog.ChartPanel.Title"), this.createStatisticsChartPanel());
        jTabbedPane.addChangeListener(this);
        this.setContent(jTabbedPane);
        this.setSize(GUI.getScaledDiagnosticDimension((int)563, (int)668));
        this.setMinimumSize(GUI.getScaledDiagnosticDimension((int)320, (int)360));
        ContextSensitiveHelpUtilities.setRelevantHelpTopicId((JComponent)jTabbedPane, (ContextSensitiveHelpUtilities.HelpTopic)ContextSensitiveHelpUtilities.HelpTopic.OVERLAY_STATISTICS);
    }

    private void updateChartPanel() {
        if (this.chartPanel != null) {
            this.createSCBtn.setEnabled(!this.lineChart.isInconsistent());
            this.copyToClipboardBtn.setEnabled(!this.lineChart.isInconsistent());
            this.chartPanel.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("OverlayStatisticsDialog.Chart")));
            this.chartPanel.add((Component)this.lineChart.getChartPanel(), "Center");
        }
    }

    private void createOptionsPanel() {
        this.initOptionsPanelComponents();
        this.addOptionsPanelListeners();
        this.addOptionsPanelComponents();
    }

    private void initOptionsPanelComponents() {
        this.intensityUnit = ComponentFactory.instance.createLabel(Messages.getString("OverlayStatisticsDialog.IntensityUnit"));
        this.relativeValuesRb = ComponentFactory.instance.createRadioButton(Messages.getString("OverlayStatisticsDialog.Relative"));
        this.absoluteValuesRb = ComponentFactory.instance.createRadioButton(Messages.getString("OverlayStatisticsDialog.Absolute"));
        this.includeOwnerCheckBox = ComponentFactory.instance.createCheckBox(Messages.getString("OverlayStatisticsDialog.IncludeSelectedSeries"));
        this.copyToClipboardBtn = ComponentFactory.instance.createButton(Messages.getString("OverlayStatisticsDialog.CopyData"));
        String string = Messages.getString("OverlayStatisticsDialog.SetReferenceValue");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(string.replaceAll("\\n", "<br>"));
        stringBuilder.append("</html>");
        this.setReferenceValueLb = ComponentFactory.instance.createLabel(stringBuilder.toString());
        this.setReferenceValueLb.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
    }

    private void addOptionsPanelListeners() {
        this.relativeValuesRb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OverlayStatisticsDialog.this.lineChart.setRelative(OverlayStatisticsDialog.this.relativeValuesRb.isSelected());
                OverlayStatisticsDialog.this.updateChartPanel();
            }
        });
        this.absoluteValuesRb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OverlayStatisticsDialog.this.lineChart.setRelative(!OverlayStatisticsDialog.this.absoluteValuesRb.isSelected());
                OverlayStatisticsDialog.this.updateChartPanel();
            }
        });
        this.includeOwnerCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OverlayStatisticsDialog.this.lineChart.includeOwner(OverlayStatisticsDialog.this.includeOwnerCheckBox.isSelected());
                OverlayStatisticsDialog.this.updateChartPanel();
            }
        });
        this.copyToClipboardBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OverlayStatisticsDialog.this.lineChart.copyToClipboard();
            }
        });
    }

    private void addOptionsPanelComponents() {
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0}, new double[]{-2.0, -2.0});
        tableLayout.setHGap(15);
        TableLayout tableLayout2 = new TableLayout(new double[]{-2.0}, new double[]{-2.0, -2.0, -2.0});
        this.absoluteValuesRb.doClick();
        this.absoluteValuesRb.setSelected(true);
        this.includeOwnerCheckBox.setSelected(true);
        this.rbPanel = ComponentFactory.instance.createPanel((LayoutManager)tableLayout);
        this.rbPanel.setOpaque(false);
        this.rbPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.rbPanel.add((Component)this.intensityUnit, "0,0 ");
        this.rbPanel.add((Component)this.relativeValuesRb, "1,0");
        this.rbPanel.add((Component)this.absoluteValuesRb, "1,1");
        this.optionsPanel = ComponentFactory.instance.createPanel((LayoutManager)tableLayout2);
        this.optionsPanel.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("OverlayStatisticsDialog.ChartOptions")));
        this.optionsPanel.add((Component)this.setReferenceValueLb, "0,0");
        this.optionsPanel.add((Component)this.rbPanel, "0,1");
        this.optionsPanel.add((Component)this.includeOwnerCheckBox, "0,2");
        this.buttonGroup.add(this.relativeValuesRb);
        this.buttonGroup.add(this.absoluteValuesRb);
    }

    private JPanel createStatisticsChartPanel() {
        this.createOptionsPanel();
        this.chartPanel = ComponentFactory.instance.createPanel(new BorderLayout());
        this.chartPanel.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("OverlayStatisticsDialog.Chart")));
        this.chartPanel.add((Component)this.lineChart.getChartPanel(), "Center");
        AbstractAction abstractAction = new SaveAction();
        if (!abstractAction.isEnabled()) {
            abstractAction = new CloseAction();
        }
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0}, new double[]{-2.0});
        JPanel jPanel = ComponentFactory.instance.createPanel((LayoutManager)tableLayout);
        this.createSCBtn = ComponentFactory.instance.createButton(abstractAction);
        this.createSCBtn.setEnabled(!this.lineChart.isInconsistent());
        this.copyToClipboardBtn.setEnabled(!this.lineChart.isInconsistent());
        jPanel.add((Component)this.createSCBtn, "0,0");
        jPanel.add((Component)this.copyToClipboardBtn, "1,0");
        JPanel jPanel2 = ComponentFactory.instance.createPanel(new BorderLayout());
        jPanel2.add((Component)this.optionsPanel, "North");
        jPanel2.add((Component)this.chartPanel, "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    protected void cleanUp() {
        if (this.lineChart != null) {
            this.lineChart.cleanUp();
        }
        this.displayPanel.cleanUp();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        this.displayPanel.setShown(jTabbedPane.getSelectedIndex() == 0);
    }

    private static class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Messages.getString("Ok"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OverlayStatisticsManager.INSTANCE.closeDialog();
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction() {
            super(Messages.getString("OverlayStatisticsDialog.SaveAsSecondaryCapture.Title"), (Icon)IAIconFactory.DEFAULT_FACTORY.loadIcon("seqlabel_secondarycapture.svg"));
            this.setEnabled(!Product.isCDViewer());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ISeriesData iSeriesData = OverlayStatisticsDialog.this.lineChart.createSecondaryCapture();
            if (iSeriesData != null) {
                DataManager.getInstance().addSeriesAsSingleDisplaySet(Collections.singletonList(iSeriesData), JVision2.getMainFrame().getFirstEmptyDisplay(), true);
            }
            OverlayStatisticsManager.INSTANCE.closeDialog();
        }
    }
}

