/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.pacs.impaxee.statistics.AbstractStatisticsChartMouseListener;
import com.agfa.pacs.impaxee.statistics.StatisticsChart;
import com.agfa.pacs.impaxee.statistics.StatisticsData;
import com.tiani.base.data.ISeriesData;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsChartSeries;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.entity.XYItemEntity;

class OverlayStatisticsChart
implements StatisticsPresentationObject.IStatisticsListener {
    private final List<StatisticsPresentationObject> presentationObjects;
    private final StatisticsChart<StatisticsPresentationObject> chart;
    private boolean includeOwner = true;
    private int ownerIndex;
    private final View view;

    OverlayStatisticsChart(View view) {
        this.view = view;
        this.presentationObjects = new ArrayList<StatisticsPresentationObject>();
        List<Overlay> list = view.getOverlays();
        for (Overlay overlay : list) {
            if (!(overlay instanceof StatisticsPresentationObject)) continue;
            StatisticsPresentationObject statisticsPresentationObject = (StatisticsPresentationObject)overlay;
            statisticsPresentationObject.addStatisticsListener(this);
            this.presentationObjects.add(statisticsPresentationObject);
        }
        this.chart = new StatisticsChart(this.createChartSeries());
        this.chart.getChartPanel().addChartMouseListener((ChartMouseListener)new LineChartMouseListener());
        this.chart.getChartPanel().setPreferredSize(new Dimension(500, 300));
    }

    protected ChartPanel getChartPanel() {
        return this.chart.getChartPanel();
    }

    protected void setRelative(boolean bl) {
        this.chart.setRelative(bl);
    }

    protected void includeOwner(boolean bl) {
        if (bl == this.includeOwner) {
            return;
        }
        int n = this.chart.getReferenceIndex();
        if (this.ownerIndex == n) {
            n = bl ? ++n : 0;
        } else if (this.ownerIndex < n) {
            n = bl ? ++n : --n;
        }
        this.includeOwner = bl;
        this.chart.setReferenceIndex(n);
    }

    private List<OverlayStatisticsChartSeries> createChartSeries() {
        ArrayList<OverlayStatisticsChartSeries> arrayList = new ArrayList<OverlayStatisticsChartSeries>(this.presentationObjects.size());
        for (StatisticsPresentationObject statisticsPresentationObject : this.presentationObjects) {
            List<StatisticsData<SyncablePresentationObject>> list = StatisticsData.createSortedList(statisticsPresentationObject.getRelatives());
            ArrayList<StatisticsPresentationObject> arrayList2 = new ArrayList<StatisticsPresentationObject>(list.size());
            int n = 0;
            for (StatisticsData<SyncablePresentationObject> statisticsData : list) {
                boolean bl;
                StatisticsPresentationObject statisticsPresentationObject2 = (StatisticsPresentationObject)statisticsData.getData();
                if (statisticsPresentationObject2 == statisticsPresentationObject) continue;
                boolean bl2 = bl = statisticsPresentationObject2.getImageInformation() == statisticsPresentationObject.getImageInformation();
                if (bl) {
                    this.ownerIndex = n;
                }
                arrayList2.add(statisticsPresentationObject2);
                ++n;
            }
            arrayList.add(new OverlayStatisticsChartSeries(this, statisticsPresentationObject, arrayList2));
        }
        return arrayList;
    }

    @Override
    public void statisticsUpdated() {
        this.chart.updateChart();
    }

    protected boolean isInconsistent() {
        return this.chart.isInconsistent();
    }

    boolean isOwnerIncluded() {
        return this.includeOwner;
    }

    protected void copyToClipboard() {
        this.chart.copyToClipboard();
    }

    protected ISeriesData createSecondaryCapture() {
        return this.chart.createSecondaryCapture(this.view);
    }

    protected void cleanUp() {
        for (StatisticsPresentationObject statisticsPresentationObject : this.presentationObjects) {
            statisticsPresentationObject.setRemovable(true);
            statisticsPresentationObject.removeStatisticsListener(this);
        }
    }

    private class LineChartMouseListener
    extends AbstractStatisticsChartMouseListener {
        private LineChartMouseListener() {
        }

        @Override
        protected void chartItemDoubleClicked(XYItemEntity xYItemEntity) {
            OverlayStatisticsChart.this.chart.setReferenceIndex(xYItemEntity.getItem());
        }
    }
}

