/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.demographics;

import com.agfa.pacs.logging.ALogger;
import com.tiani.config.mappingfonts.model.NamedArgument;
import com.tiani.jvision.overlay.demographics.AbstractSubstituteEvaluation;
import java.util.Date;
import java.util.List;

class LinearTransformationSubstituteEvaluation
extends AbstractSubstituteEvaluation {
    private static final ALogger logger = ALogger.getLogger(LinearTransformationSubstituteEvaluation.class);
    private double intercept = 0.0;
    private double slope = 1.0;

    LinearTransformationSubstituteEvaluation(List<NamedArgument> list) {
        if (list != null) {
            for (NamedArgument namedArgument : list) {
                if ("slope".equalsIgnoreCase(namedArgument.getName())) {
                    try {
                        this.slope = Double.parseDouble(namedArgument.getValue());
                    }
                    catch (Exception exception) {
                        logger.warn("Argument slope for linear evaluation method.");
                    }
                    continue;
                }
                if (!"intercept".equalsIgnoreCase(namedArgument.getName())) continue;
                try {
                    this.intercept = Double.parseDouble(namedArgument.getValue());
                }
                catch (Exception exception) {
                    logger.warn("Argument intercept for linear evaluation method.");
                }
            }
        }
    }

    @Override
    protected Date transformDate(Date date) {
        logger.warn("Cannot perform a linear transformation on non-numeric values.");
        return date;
    }

    @Override
    protected Double transformDouble(Double d) {
        return d * this.slope + this.intercept;
    }
}

