/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.curve;

import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.overlay.curve.CurvePolyLine;
import com.tiani.jvision.overlay.curve.IInterpolatable;
import com.tiani.jvision.overlay.curve.SamplingAdapter3D;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3d;

public class SamplingAdapter
implements Cloneable {
    protected SamplingAdapter3D delegate;

    SamplingAdapter(IInterpolatable iInterpolatable, float f) {
        this.delegate = new SamplingAdapter3D(iInterpolatable);
        this.delegate.setMaximumSamplingPointDistance(f);
    }

    SamplingAdapter(IInterpolatable iInterpolatable, float f, float f2, float f3) {
        this(iInterpolatable, f3);
        this.delegate.setSamplingMetrics(f, f2, 1.0f);
    }

    public SamplingAdapter clone() {
        SamplingAdapter samplingAdapter = null;
        try {
            samplingAdapter = (SamplingAdapter)super.clone();
            samplingAdapter.delegate = this.delegate.clone();
        }
        catch (Exception exception) {
            ALogger.getLogger(SamplingAdapter.class).error("SamplingAdapter", (Throwable)exception);
        }
        return samplingAdapter;
    }

    public void cleanUp() {
        this.delegate.cleanUp();
        this.delegate = null;
    }

    public CurvePolyLine getImgPointsRef() {
        return this.delegate.getPoints();
    }

    public int getImgPointCount() {
        return this.delegate.getPoints().getCount();
    }

    public Vector2f getTangentAt(float f) {
        int n = this.getIndexAtPositionRef(f);
        return this.getTangentAt(n);
    }

    public Vector2f getTangentAt(int n) {
        Vector3d vector3d = this.delegate.getTangentAt(n);
        return new Vector2f((float)vector3d.x, (float)vector3d.y);
    }

    public int getPointIndexClosestTo(float f, float f2, int n) {
        return this.delegate.getPointIndexClosestTo(f, f2, 0.0f, n);
    }

    public Point2f getPointAtPositionRef(float f) {
        int n = this.getIndexAtPositionRef(f);
        return this.getPointAtPositionRef(n);
    }

    public int getIndexAtPositionRef(float f) {
        return this.delegate.getIndexAtPosition(f);
    }

    public Point2f getPointAtPositionRef(int n) {
        Point3d point3d = this.delegate.getPointAtPosition(n);
        return new Point2f((float)point3d.x, (float)point3d.y);
    }

    public void forceUpdate() {
        this.delegate.forceUpdate();
    }

    public double getRelativePositionFromIndex(int n) {
        return this.delegate.getRelativePositionFromIndex(n);
    }
}

