/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.chart;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.tiani.jvision.image.DoubleRectangle;
import com.tiani.jvision.overlay.OverlayContainer;
import com.tiani.jvision.overlay.chart.ChartAxis;
import com.tiani.jvision.overlay.chart.ChartDataChannel;
import com.tiani.jvision.overlay.chart.LinearAxis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class LineChart
extends OverlayContainer {
    protected ChartAxis xAxis;
    protected ChartAxis yAxis;
    List<ChartDataChannel> channels = new ArrayList<ChartDataChannel>();
    private int dimm = 50;
    private boolean box = true;

    public LineChart(String string, double d, double d2, double d3, double d4, AnnotationUnits annotationUnits, OverlayContainer.AnchorPosition anchorPosition) {
        super(string, d, d2, d3, d4, annotationUnits, anchorPosition);
        this.init();
    }

    protected LineChart(String string, DoubleRectangle doubleRectangle, AnnotationUnits annotationUnits, OverlayContainer.AnchorPosition anchorPosition) {
        super(string, doubleRectangle, annotationUnits, anchorPosition);
        this.init();
    }

    private void init() {
        this.setEditable(true);
        this.xAxis = new LinearAxis(null);
        this.yAxis = new LinearAxis(null);
        this.updateAxisColor();
        super.setOnlyTranslateAnchor(false);
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        this.updateAxisColor();
    }

    private void updateAxisColor() {
        this.xAxis.setColor(this.objCol);
        this.yAxis.setColor(this.objCol);
    }

    public void addChannel(ChartDataChannel chartDataChannel) {
        this.channels.add(chartDataChannel);
    }

    public void removeChannel(ChartDataChannel chartDataChannel) {
        this.channels.remove(chartDataChannel);
    }

    public void showBox(boolean bl) {
        this.box = bl;
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (this.dimm > 0) {
            this.dimm(this.p0x, this.p0y, this.p1x - this.p0x, this.p3y - this.p0y, this.dimm, bufferedImageHolder);
        }
        if (this.box) {
            super.paintShape(bufferedImageHolder);
        }
        this.yAxis.setLabel(this.getImageState().getCurrentValueMapping().getUnit());
        this.xAxis.setOutputRange(this.p0x, this.p1x);
        this.yAxis.setOutputRange(this.p3y, this.p0y);
        this.xAxis.paint(bufferedImageHolder, this.p3x, this.p3y, this.p2x, this.p2y, this);
        this.yAxis.paint(bufferedImageHolder, this.p3x, this.p3y, this.p0x, this.p0y, this);
        int n = 0;
        while (n < this.channels.size()) {
            this.channels.get(n).paint(bufferedImageHolder, this.xAxis, this.yAxis, this);
            ++n;
        }
    }
}

