/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.demographics.Mapping;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;

public class RulerMapping
extends Overlay {
    protected static final double[] tick = new double[]{1000.0, 500.0, 200.0, 100.0, 50.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5, 0.2, 0.1, 0.05, 0.02, 0.01, 0.005, 0.002, 0.001};
    private static final DecimalFormat numberFormat = new DecimalFormat("0.###");
    private static final int TICK_LENGTH = 10;
    private static boolean hideVerticalRuler = false;
    private static boolean hideHorizontalRuler = true;
    private static IConfigurationChangeListener rulerListener = new RulerConfigListener();
    private int imgLength = 100;
    private SpacingDef.Unit unit = null;
    private boolean positionL = false;

    static {
        Config.impaxee.jvision.DISPLAY.HideRuler.registerChangeListener(rulerListener);
        Config.impaxee.jvision.DISPLAY.HideHorizontalRuler.registerChangeListener(rulerListener);
    }

    public boolean isPositionL() {
        return this.positionL;
    }

    public void setPositionL(boolean bl) {
        this.positionL = bl;
    }

    public RulerMapping(View view) {
        this.owner = view;
    }

    public RulerMapping() {
    }

    public void setMaxRulerLength(int n) {
        this.imgLength = n;
    }

    public int getMaxRulerLength() {
        return this.imgLength;
    }

    private int getX(int n) {
        if (this.positionL) {
            return this.width - n;
        }
        return n;
    }

    @Override
    public ImageState getImageState() {
        if (this.owner != null) {
            return this.owner.getImageState();
        }
        return null;
    }

    @Override
    public void paint(BufferedImageHolder bufferedImageHolder) {
        Color color = bufferedImageHolder.graphics.getColor();
        Color color2 = null;
        if (this.getView() != null) {
            color2 = Mapping.getMappingColor(this.getView().getEvaluationContext());
        }
        if (color2 == null) {
            color2 = OverlayConfig.mappingColor;
        }
        if (!hideVerticalRuler) {
            this.paintVertical(bufferedImageHolder, color2);
        }
        if (!hideHorizontalRuler) {
            this.paintHorizontal(bufferedImageHolder, color2);
        }
        if (color2 != null) {
            bufferedImageHolder.graphics.setColor(color);
        }
    }

    public boolean isHideVerticalRuler() {
        return hideVerticalRuler;
    }

    private void paintVertical(BufferedImageHolder bufferedImageHolder, Color color) {
        if (!this.visible) {
            return;
        }
        ImageState imageState = this.getImageState();
        if (imageState != null) {
            this.setUnit(imageState.getCurrentSpacingDef().getSizeUnit());
        }
        if (this.hasImageRegionSpacing() && SpacingDef.Unit.pix == this.unit) {
            return;
        }
        bufferedImageHolder.graphics.setFont(this.getCurrentFont());
        if (this.height > this.getMinSize() && imageState != null && imageState.pixelSizeY > 0.0) {
            int n;
            int n2;
            double d;
            int n3 = this.width - this.getVerticalRulerMargin();
            int n4 = this.height >> 1;
            int n5 = 0;
            while (n5 < tick.length && tick[n5] / imageState.pixelSizeY > (double)(this.imgLength / 2)) {
                ++n5;
            }
            if (n5 > tick.length - 1) {
                n5 = tick.length - 1;
            }
            if ((d = tick[n5] / imageState.pixelSizeY) == 0.0) {
                d = 0.1;
            }
            int n6 = (int)((double)this.imgLength / d);
            double d2 = 0.0;
            n4 -= (int)((double)n6 * d / 2.0);
            if (this.isUseOutlineFont()) {
                bufferedImageHolder.graphics.setColor(Color.black);
                bufferedImageHolder.graphics.drawLine(this.getX(n3 - 1), n4, this.getX(n3 - 1), n4 + (int)((double)n6 * d + 0.5));
                bufferedImageHolder.graphics.drawLine(this.getX(n3 + 1), n4, this.getX(n3 + 1), n4 + (int)((double)n6 * d + 0.5));
                n2 = 0;
                while (n2 <= n6) {
                    n = n4 + (int)(d2 + 0.5);
                    bufferedImageHolder.graphics.drawLine(this.getX(n3 - 10), n - 1, this.getX(n3), n - 1);
                    bufferedImageHolder.graphics.drawLine(this.getX(n3 - 10), n + 1, this.getX(n3), n + 1);
                    d2 += d;
                    ++n2;
                }
            }
            d2 = 0.0;
            bufferedImageHolder.graphics.setColor(color);
            bufferedImageHolder.graphics.drawLine(this.getX(n3), n4, this.getX(n3), n4 + (int)((double)n6 * d + 0.5));
            n2 = 0;
            while (n2 <= n6) {
                n = n4 + (int)(d2 + 0.5);
                bufferedImageHolder.graphics.drawLine(this.getX(n3 - 10), n, this.getX(n3), n);
                d2 += d;
                ++n2;
            }
            d2 -= d;
            String string = "";
            String string2 = null;
            if (this.unit != null) {
                string = this.unit.mainPart();
                string2 = this.unit.commentPart();
            }
            string = (double)n6 * tick[n5] == (double)((int)((double)n6 * tick[n5])) ? String.valueOf((int)((double)n6 * tick[n5])) + string : String.valueOf(numberFormat.format((double)n6 * tick[n5])) + string;
            if (this.positionL) {
                this.drawString(string, color, bufferedImageHolder, this.width - n3, n4 + (int)d2 + this.getFontHeight());
                if (string2 != null && string2.length() > 0) {
                    this.drawString(string2, color, bufferedImageHolder, this.width - n3, n4 + (int)d2 + 2 * this.getFontHeight());
                }
            } else {
                this.drawString(string, color, bufferedImageHolder, n3 - this.getStringWidth(string), n4 + (int)d2 + this.getFontHeight());
                if (string2 != null && string2.length() > 0) {
                    this.drawString(string2, color, bufferedImageHolder, n3 - this.getStringWidth(string2), n4 + (int)d2 + 2 * this.getFontHeight());
                }
            }
        }
    }

    public void paintHorizontal(BufferedImageHolder bufferedImageHolder, Color color) {
        if (!this.visible) {
            return;
        }
        ImageState imageState = this.getImageState();
        if (imageState != null) {
            this.setUnit(imageState.getCurrentSpacingDef().getSizeUnit());
        }
        if (this.hasImageRegionSpacing() && SpacingDef.Unit.pix == this.unit) {
            return;
        }
        Font font = this.getCurrentFont();
        bufferedImageHolder.graphics.setFont(font);
        if (this.width > this.getMinSize() && imageState != null && imageState.pixelSizeX > 0.0) {
            int n;
            int n2;
            double d;
            int n3 = this.width / 2;
            int n4 = this.getFontHeight() + 5;
            int n5 = 0;
            while (n5 < tick.length && tick[n5] / imageState.pixelSizeX > (double)(this.imgLength / 2)) {
                ++n5;
            }
            if (n5 > tick.length - 1) {
                n5 = tick.length - 1;
            }
            if ((d = tick[n5] / imageState.pixelSizeX) == 0.0) {
                d = 0.1;
            }
            int n6 = (int)((double)this.imgLength / d);
            double d2 = 0.0;
            n3 -= (int)((double)n6 * d / 2.0);
            if (this.isUseOutlineFont()) {
                bufferedImageHolder.graphics.setColor(Color.black);
                bufferedImageHolder.graphics.drawLine(n3, n4 - 1, n3 + (int)((double)n6 * d + 0.5), n4 - 1);
                bufferedImageHolder.graphics.drawLine(n3, n4 + 1, n3 + (int)((double)n6 * d + 0.5), n4 + 1);
                n2 = 0;
                while (n2 <= n6) {
                    n = n3 + (int)(d2 + 0.5);
                    bufferedImageHolder.graphics.drawLine(n - 1, n4, n - 1, n4 + 10);
                    bufferedImageHolder.graphics.drawLine(n + 1, n4, n + 1, n4 + 10);
                    d2 += d;
                    ++n2;
                }
            }
            d2 = 0.0;
            bufferedImageHolder.graphics.setColor(color);
            bufferedImageHolder.graphics.drawLine(n3, n4, n3 + (int)((double)n6 * d + 0.5), n4);
            n2 = 0;
            while (n2 <= n6) {
                n = n3 + (int)(d2 + 0.5);
                bufferedImageHolder.graphics.drawLine(n, n4, n, n4 + 10);
                d2 += d;
                ++n2;
            }
            d2 -= d;
            String string = "";
            String string2 = null;
            if (this.unit != null) {
                string = this.unit.mainPart();
                string2 = this.unit.commentPart();
            }
            string = (double)n6 * tick[n5] == (double)((int)((double)n6 * tick[n5])) ? String.valueOf((int)((double)n6 * tick[n5])) + string : String.valueOf(numberFormat.format((double)n6 * tick[n5])) + string;
            if (string2 != null && string2.length() > 0) {
                string = String.valueOf(string) + " " + string2;
            }
            this.drawString(string, color, bufferedImageHolder, (int)((double)n3 + d2 + 8.0), n4 + 10 + this.getCurrentFontMetrics().getDescent());
        }
    }

    public SpacingDef.Unit getUnit() {
        return this.unit;
    }

    public void setUnit(SpacingDef.Unit unit) {
        this.unit = unit;
    }

    public int estimateTotalVerticalRulerWidth() {
        if (!this.isVisible() || hideVerticalRuler) {
            return 0;
        }
        int n = 10;
        SpacingDef.Unit[] unitArray = SpacingDef.Unit.values();
        int n2 = unitArray.length;
        int n3 = 0;
        while (n3 < n2) {
            SpacingDef.Unit unit = unitArray[n3];
            if (unit.isMM()) {
                n = Math.max(n, this.getStringWidth(unit.commentPart()));
            }
            ++n3;
        }
        return this.getVerticalRulerMargin() + n;
    }

    private int getVerticalRulerMargin() {
        return this.positionL ? 15 : 10;
    }

    private int getStringWidth(String string) {
        if (string == null || string.isEmpty()) {
            return 0;
        }
        return this.getCurrentFontMetrics().bytesWidth(string.getBytes(), 0, string.length());
    }

    private boolean hasImageRegionSpacing() {
        return this.owner != null && this.owner.getImageInformation() != null && this.owner.getImageInformation().hasImageRegionSpacing();
    }

    private static class RulerConfigListener
    implements IConfigurationChangeListener {
        public RulerConfigListener() {
            this.readConfiguration();
        }

        public void readConfiguration() {
            hideVerticalRuler = Config.impaxee.jvision.DISPLAY.HideRuler.get();
            hideHorizontalRuler = Config.impaxee.jvision.DISPLAY.HideHorizontalRuler.get();
        }

        public void configurationChanged(String string) {
            this.readConfiguration();
        }
    }
}

