/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.OverlayContainer;
import com.tiani.jvision.renderer.Renderer;

public class RendererOverlay
extends OverlayContainer {
    protected Renderer renderer;
    protected boolean enableOverlays = false;

    public RendererOverlay(String string, double d, double d2, double d3, double d4, Renderer renderer) {
        super(string, d, d2, d3, d4);
        this.renderer = renderer;
        this.renderer.fillBackground(false);
        super.setAllowDragOutOfBounds(false);
    }

    @Override
    public boolean captureAsRGB() {
        return true;
    }

    @Override
    public String getLayerLabel() {
        return "__JV_BURN__";
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        int n = this.p0x;
        int n2 = this.p0y;
        int n3 = this.getDisplayedWidth();
        int n4 = this.getDisplayedHeight();
        this.renderer.paint((RGBBufferedImageHolder)bufferedImageHolder, n3, n4, n + n2 * bufferedImageHolder.width, bufferedImageHolder.width, false);
        if (this.enableOverlays) {
            RGBBufferedImageHolder rGBBufferedImageHolder = ((RGBBufferedImageHolder)bufferedImageHolder).getSubImage(n, n2, n3, n4);
            rGBBufferedImageHolder.graphics.setColor(OverlayConfig.mappingColor);
            this.renderer.paintOverlays(rGBBufferedImageHolder, null, false);
        }
    }

    public Renderer getRendererRef() {
        return this.renderer;
    }

    public void setOverlayPaint(boolean bl) {
        this.enableOverlays = true;
    }

    public int getDisplayedWidth() {
        return this.p1x - this.p0x;
    }

    public int getDisplayedHeight() {
        return this.p3y - this.p0y;
    }
}

