/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.DialListener;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ScalablePresentationHandle;
import java.util.ArrayList;
import java.util.List;

public class RelativeDial
extends PresentationObject {
    protected String caption;
    protected double xo;
    protected double yo;
    private boolean startAction = false;
    private int sx = 0;
    private int sy = 0;
    protected List<DialListener> dialListeners = new ArrayList<DialListener>();

    public RelativeDial(String string, double d, double d2) {
        super("Relative Dial");
        this.caption = string;
        this.xo = d;
        this.yo = d2;
        this.handles = new PresentationHandle[]{new ScalablePresentationHandle(0, 0)};
    }

    @Override
    public void setSize(int n, int n2, ImageState imageState) {
        super.setSize(n, n2, imageState);
        this.updateBounds();
    }

    private void updateBounds() {
        int n = (int)((double)this.width * this.xo);
        int n2 = (int)((double)this.height * this.yo - (double)(this.getFontHeight() / 2));
        int n3 = this.getFontHeight();
        int n4 = n3 * this.caption.length();
        this.bounds.x = n;
        this.bounds.y = n2;
        this.bounds.width = n4;
        this.bounds.height = n3;
        this.handles[0].setPosition(n, n2);
        this.handles[0].setHandleSize(n4, n3);
    }

    @Override
    protected void paintShape(BufferedImageHolder bufferedImageHolder) {
        int n = (int)((double)bufferedImageHolder.width * this.xo);
        int n2 = (int)((double)bufferedImageHolder.height * this.yo + (double)(this.getFontHeight() / 2));
        this.drawString(this.caption, bufferedImageHolder, n, n2);
    }

    @Override
    public PresentationObject cloneAll() {
        return null;
    }

    @Override
    protected boolean mousePressed(int n, int n2, boolean bl) {
        boolean bl2 = super.mousePressed(n, n2, bl);
        if (bl2 && !bl) {
            this.startAction = true;
        }
        return bl2;
    }

    @Override
    protected void handleDragged(int n, double[] dArray) {
        double[] dArray2 = this.toScreen(dArray);
        int n2 = (int)(dArray2[0] + 0.5);
        int n3 = (int)(dArray2[1] + 0.5);
        if (this.startAction) {
            this.sx = n2;
            this.sy = n3;
        }
        n3 -= this.sy;
        this.fireDialAction(n2 -= this.sx, this.startAction);
        this.startAction = false;
    }

    public void addDialListener(DialListener dialListener) {
        this.dialListeners.add(dialListener);
    }

    protected void fireDialAction(int n, boolean bl) {
        int n2 = 0;
        while (n2 < this.dialListeners.size()) {
            this.dialListeners.get(n2).dialAction(this, n, bl);
            ++n2;
        }
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        return -1;
    }
}

