/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.jvision.overlay.AbstractDoubleLineOverlay;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.OverlayInformation;
import com.tiani.jvision.overlay.OverlayInformationID;
import java.util.ArrayList;
import java.util.List;

public class RatioOverlay
extends AbstractDoubleLineOverlay {
    private double length1;
    private double length2;

    public RatioOverlay() {
        super(TianiSubType.Ratio, AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_FULLY);
        this.isSecondLineHighlighted = true;
    }

    public RatioOverlay(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, AnnotationUnits annotationUnits) {
        super(TianiSubType.Ratio, AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_FULLY, d, d2, d3, d4, d5, d6, d7, d8, annotationUnits);
        this.isSecondLineHighlighted = true;
        this.setEditable(!Product.isCDViewer());
    }

    @Override
    double calculateMeasurementResult() {
        this.length1 = this.calculateLength(this.p, this.pxi, this.pyi, this.q, this.qxi, this.qyi);
        this.length2 = this.calculateLength(this.r, this.rxi, this.ryi, this.s, this.sxi, this.syi);
        if (this.length2 == 0.0) {
            return Double.NaN;
        }
        return this.length1 / this.length2;
    }

    @Override
    List<IOverlayInformation> updateAnnotation() {
        OverlayInformation overlayInformation = new OverlayInformation(OverlayInformationID.MANDATORY, 100.0 * this.getMeasurementResult(), "%");
        OverlayInformation overlayInformation2 = new OverlayInformation(OverlayInformationID.MANDATORY, String.valueOf(Messages.getString("ROI_LEGEND_LENGTH")) + " 1", this.length1, this.dimensionUnit());
        OverlayInformation overlayInformation3 = new OverlayInformation(OverlayInformationID.MANDATORY, String.valueOf(Messages.getString("ROI_LEGEND_LENGTH")) + " 2", this.length2, this.dimensionUnit());
        ArrayList<IOverlayInformation> arrayList = new ArrayList<IOverlayInformation>();
        arrayList.add(overlayInformation);
        arrayList.add(overlayInformation2);
        arrayList.add(overlayInformation3);
        return arrayList;
    }

    @Override
    void onTranslation(double d, double d2) {
    }
}

