/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.module.ps.TextObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.HorizontalJustification;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.DoubleRectangle;
import com.tiani.jvision.overlay.AngleOverlay;
import com.tiani.jvision.overlay.ArrowOverlay;
import com.tiani.jvision.overlay.BidimensionalLengthOverlay;
import com.tiani.jvision.overlay.CenterlineOverlay;
import com.tiani.jvision.overlay.Circle3PointOverlay;
import com.tiani.jvision.overlay.CircleOverlay;
import com.tiani.jvision.overlay.ClosedFreehandPolygonOverlay;
import com.tiani.jvision.overlay.CobbAngleOverlay;
import com.tiani.jvision.overlay.DataProfile;
import com.tiani.jvision.overlay.DoubleCenterlineOverlay;
import com.tiani.jvision.overlay.EllipseOverlay;
import com.tiani.jvision.overlay.HistogramOverlay;
import com.tiani.jvision.overlay.HorizontalDistanceOverlay;
import com.tiani.jvision.overlay.LeftMarkerPolygonOverlay;
import com.tiani.jvision.overlay.LengthOverlay;
import com.tiani.jvision.overlay.NonResizableMarkerPolygonOverlay;
import com.tiani.jvision.overlay.NormalDistanceOverlay;
import com.tiani.jvision.overlay.OverlayContainer;
import com.tiani.jvision.overlay.OverlayType;
import com.tiani.jvision.overlay.PointOverlay;
import com.tiani.jvision.overlay.PolygonOverlay;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.RatioOverlay;
import com.tiani.jvision.overlay.RectangleOverlayMPR;
import com.tiani.jvision.overlay.RightMarkerPolygonOverlay;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.curve.CurveOverlay;
import java.util.ArrayList;

public class ROIFactory {
    private static final ALogger log = ALogger.getLogger(ROIFactory.class);

    public static PresentationObject getInstance(OverlayType overlayType) {
        if (OverlayType.ANGLE == overlayType) {
            return new AngleOverlay();
        }
        if (OverlayType.COBB_ANGLE == overlayType) {
            return new CobbAngleOverlay();
        }
        if (OverlayType.ARROW == overlayType) {
            return new ArrowOverlay();
        }
        if (OverlayType.TEXT == overlayType) {
            return new TextOverlay();
        }
        if (OverlayType.CIRCLE == overlayType) {
            return new CircleOverlay();
        }
        if (OverlayType.CIRCLE_3POINT == overlayType) {
            return new Circle3PointOverlay();
        }
        if (OverlayType.ELLIPSE == overlayType) {
            return new EllipseOverlay();
        }
        if (OverlayType.ADD_FREEHAND_POLYGON == overlayType) {
            return new ClosedFreehandPolygonOverlay(ClosedFreehandPolygonOverlay.SEGMENTATION_STRUCTURE_POLYGON_COLOR);
        }
        if (OverlayType.REMOVE_FREEHAND_POLYGON == overlayType) {
            return new ClosedFreehandPolygonOverlay(ClosedFreehandPolygonOverlay.SEGMENTATION_REMOVE_CONTOUR_POLYGON_COLOR);
        }
        if (OverlayType.RECTANGLE == overlayType) {
            return new RectangleOverlayMPR();
        }
        if (OverlayType.POLYGON == overlayType) {
            return new PolygonOverlay();
        }
        if (OverlayType.CURVE == overlayType) {
            return new CurveOverlay();
        }
        if (OverlayType.LENGTH == overlayType) {
            return new LengthOverlay();
        }
        if (OverlayType.NORMAL_DISTANCE == overlayType) {
            return new NormalDistanceOverlay();
        }
        if (OverlayType.RATIO == overlayType) {
            return new RatioOverlay();
        }
        if (OverlayType.BIDIMENSIONAL_LENGTH == overlayType) {
            return new BidimensionalLengthOverlay();
        }
        if (OverlayType.HORIZONTAL_DISTANCE == overlayType) {
            return new HorizontalDistanceOverlay();
        }
        if (OverlayType.CENTERLINE == overlayType) {
            return new CenterlineOverlay();
        }
        if (OverlayType.DOUBLE_CENTERLINE == overlayType) {
            return new DoubleCenterlineOverlay();
        }
        if (OverlayType.LEFT == overlayType) {
            return new LeftMarkerPolygonOverlay();
        }
        if (OverlayType.RIGHT == overlayType) {
            return new RightMarkerPolygonOverlay();
        }
        return null;
    }

    public static PresentationObject makeLinkedGraphicMarkup(GraphicObject graphicObject, int n, PresentationObject presentationObject, boolean bl) {
        DoubleRectangle doubleRectangle;
        double d;
        double d2;
        double d3;
        double d4;
        PresentationObject presentationObject2 = null;
        String string = graphicObject.getTianiROIID();
        string = string.trim();
        double d5 = 1.0 / (double)n;
        float[] fArray = graphicObject.getGraphicData();
        int n2 = graphicObject.getNumberOfGraphicPoints();
        double[] dArray = graphicObject.getTianiPositionData();
        if (string.startsWith("H")) {
            string = string.substring(1);
            if (dArray == null) {
                d4 = (double)fArray[0] * d5;
                d3 = (double)fArray[1] * d5;
                d2 = ((double)fArray[(n2 - 3) * 2] - d4) * d5;
                d = ((double)fArray[(n2 - 3) * 2 + 1] - d3) * d5;
                presentationObject2 = new HistogramOverlay(null, d4, d3, d2, d, AnnotationUnits.Pixel, OverlayContainer.AnchorPosition.TOPLEFT, true);
            } else {
                d4 = dArray[0] * d5;
                d3 = dArray[1] * d5;
                d2 = dArray[2] * d5;
                d = dArray[3] * d5;
                doubleRectangle = new DoubleRectangle(d4, d3, d2, d);
                presentationObject2 = new HistogramOverlay(doubleRectangle, AnnotationUnits.Pixel, OverlayContainer.AnchorPosition.TOPLEFT, true);
            }
            ((HistogramOverlay)presentationObject2).setAutoScaleX(true);
            presentationObject2.setID(Integer.parseInt(string));
        }
        if (string.startsWith("P")) {
            string = string.substring(1);
            if (dArray == null) {
                d4 = (double)fArray[n2 * 2 - 2] * d5;
                d3 = (double)fArray[n2 * 2 - 1] * d5;
                d2 = ((double)fArray[n2 * 2 - 6] - d4) * d5;
                d = ((double)fArray[n2 * 2 - 5] - d3) * d5;
                presentationObject2 = new DataProfile(d4, d3, d2, d, AnnotationUnits.Pixel, OverlayContainer.AnchorPosition.TOPLEFT);
            } else {
                d4 = dArray[0] * d5;
                d3 = dArray[1] * d5;
                d2 = dArray[2] * d5;
                d = dArray[3] * d5;
                doubleRectangle = new DoubleRectangle(d4, d3, d2, d);
                presentationObject2 = new DataProfile(doubleRectangle, AnnotationUnits.Pixel, OverlayContainer.AnchorPosition.TOPLEFT);
            }
            presentationObject2.setID(Integer.parseInt(string));
        }
        if (presentationObject2 != null) {
            presentationObject2.setSaved(bl);
        }
        return presentationObject2;
    }

    public static PresentationObject makeBasicGraphicMarkup(GraphicObject graphicObject, int n, boolean bl) {
        double d = 1.0 / (double)n;
        PresentationObject presentationObject = null;
        if (graphicObject.getGraphicDimensions() != 2) {
            return null;
        }
        String string = graphicObject.getTianiROIID();
        float[] fArray = graphicObject.getGraphicData();
        int n2 = graphicObject.getNumberOfGraphicPoints();
        GraphicType graphicType = graphicObject.getGraphicType();
        boolean bl2 = YN.Yes.equals((Object)graphicObject.getGraphicFilled());
        AnnotationUnits annotationUnits = graphicObject.getGraphicAnnotationUnits();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = (double)fArray[n3 * 2] * d;
            dArray2[n3] = (double)fArray[n3 * 2 + 1] * d;
            ++n3;
        }
        block1 : switch (graphicType) {
            case Point: {
                presentationObject = new PointOverlay(dArray[0], dArray2[0], annotationUnits);
                break;
            }
            case PolyLine: {
                TianiSubType tianiSubType = graphicObject.getTianiSubType();
                if (tianiSubType != null) {
                    switch (tianiSubType) {
                        case Marker: {
                            presentationObject = new NonResizableMarkerPolygonOverlay(dArray, dArray2, annotationUnits, bl2);
                            break block1;
                        }
                        case MarkerLeft: {
                            presentationObject = new LeftMarkerPolygonOverlay(dArray, dArray2, annotationUnits, bl2);
                            break block1;
                        }
                        case MarkerRight: {
                            presentationObject = new RightMarkerPolygonOverlay(dArray, dArray2, annotationUnits, bl2);
                            break block1;
                        }
                        case Length: {
                            presentationObject = new LengthOverlay(dArray[0], dArray2[0], dArray[1], dArray2[1], annotationUnits);
                            break block1;
                        }
                        case NormalDistance: {
                            presentationObject = new NormalDistanceOverlay(dArray[0], dArray2[0], dArray[1], dArray2[1], dArray[2], dArray2[2], annotationUnits);
                            break block1;
                        }
                        case Arrow: {
                            presentationObject = new ArrowOverlay(dArray[0], dArray2[0], dArray[1], dArray2[1], annotationUnits);
                            break block1;
                        }
                        case Angle: {
                            presentationObject = new AngleOverlay(dArray[0], dArray2[0], dArray[1], dArray2[1], dArray[2], dArray2[2], dArray[3], dArray2[3], annotationUnits);
                            break block1;
                        }
                        case CobbAngle: {
                            presentationObject = new CobbAngleOverlay(dArray[n2 - 4], dArray2[n2 - 4], dArray[n2 - 3], dArray2[n2 - 3], dArray[n2 - 2], dArray2[n2 - 2], dArray[n2 - 1], dArray2[n2 - 1], dArray[2], dArray2[2], annotationUnits);
                            break block1;
                        }
                        case Ratio: {
                            presentationObject = new RatioOverlay(dArray[0], dArray2[0], dArray[1], dArray2[1], dArray[2], dArray2[2], dArray[3], dArray2[3], annotationUnits);
                            break block1;
                        }
                        case BidimensionalLength: {
                            presentationObject = new BidimensionalLengthOverlay(dArray[0], dArray2[0], dArray[1], dArray2[1], dArray[2], dArray2[2], dArray[3], dArray2[3], annotationUnits);
                            break block1;
                        }
                        case HorizontalDistance: {
                            presentationObject = new HorizontalDistanceOverlay(dArray[0], dArray2[0], dArray[3], dArray2[3], annotationUnits);
                            break block1;
                        }
                        case Centerline: {
                            presentationObject = new CenterlineOverlay(dArray[2], dArray2[2], dArray[3], dArray2[3], dArray[4], dArray2[4], dArray[5], dArray2[5], annotationUnits);
                            break block1;
                        }
                        case DoubleCenterline: {
                            presentationObject = new DoubleCenterlineOverlay(dArray[4], dArray2[4], dArray[5], dArray2[5], dArray[6], dArray2[6], dArray[7], dArray2[7], dArray[8], dArray2[8], dArray[9], dArray2[9], dArray[10], dArray2[10], dArray[11], dArray2[11], annotationUnits);
                            break block1;
                        }
                        case Rectangle: {
                            presentationObject = new RectangleOverlayMPR(dArray[0], dArray2[0], dArray[2] - dArray[0], dArray2[2] - dArray2[0], annotationUnits, bl2, false);
                            break block1;
                        }
                    }
                    presentationObject = new PolygonOverlay(dArray, dArray2, annotationUnits, bl2);
                    break;
                }
                presentationObject = new PolygonOverlay(dArray, dArray2, annotationUnits, bl2);
                break;
            }
            case Interpolated: {
                presentationObject = new CurveOverlay(dArray, dArray2, annotationUnits, bl2);
                break;
            }
            case Circle: {
                presentationObject = new CircleOverlay(dArray[0], dArray2[0], dArray[1], dArray2[1], annotationUnits, bl2);
                break;
            }
            case Ellipse: {
                double d2 = (dArray[0] + dArray[1]) / 2.0;
                double d3 = (dArray2[0] + dArray2[1]) / 2.0;
                presentationObject = new EllipseOverlay(d2, d3, dArray[0], dArray2[0], dArray[2], dArray2[2], annotationUnits, bl2);
            }
        }
        if (string != null && presentationObject != null) {
            try {
                presentationObject.setID(Integer.parseInt(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Group ID, could not be parsed", (Throwable)numberFormatException);
                presentationObject.setEditable(false);
            }
        } else if (presentationObject != null) {
            presentationObject.setEditable(false);
        }
        if (presentationObject != null) {
            presentationObject.setSaved(bl);
        }
        return presentationObject;
    }

    public static Iterable<PresentationObject> makeTextMarkup(TextObject textObject, IImageInformation iImageInformation, int n, boolean bl) {
        ArrayList<PresentationObject> arrayList = new ArrayList<PresentationObject>(2);
        try {
            Object object;
            TextOverlay textOverlay;
            boolean bl2;
            double d = 1.0 / (double)n;
            AnnotationUnits annotationUnits = textObject.getBoundingBoxAnnotationUnits();
            AnnotationUnits annotationUnits2 = textObject.getAnchorPointAnnotationUnits();
            String string = textObject.getUnformattedTextValue();
            if (string == null) {
                string = "";
            }
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            boolean bl3 = textObject.getAnchorPoint() != null;
            boolean bl4 = false;
            AnnotationUnits annotationUnits3 = null;
            HorizontalJustification horizontalJustification = textObject.getBoundingBoxTextHorizontalJustification();
            if (bl3) {
                d6 = d2 = (double)textObject.getAnchorPoint()[0] * d;
                d7 = d3 = (double)textObject.getAnchorPoint()[1] * d;
                bl4 = YN.Yes.equals((Object)textObject.getAnchorPointVisiblity());
                annotationUnits3 = annotationUnits2;
            }
            boolean bl5 = bl2 = textObject.getBoundingBoxTopLeftHandCorner() != null;
            if (bl2) {
                d2 = (double)textObject.getBoundingBoxTopLeftHandCorner()[0] * d;
                d3 = (double)textObject.getBoundingBoxTopLeftHandCorner()[1] * d;
                d4 = (double)textObject.getBoundingBoxBottomRightHandCorner()[0] * d;
                d5 = (double)textObject.getBoundingBoxBottomRightHandCorner()[1] * d;
                annotationUnits3 = annotationUnits;
            }
            if (bl2) {
                textOverlay = new TextOverlay(d2, d3, d4 - d2, d5 - d3, string, annotationUnits3, false, horizontalJustification);
                if (bl3 && bl4) {
                    object = new ArrowOverlay((d2 + d4) / 2.0, (d3 + d5) / 2.0, d6, d7, annotationUnits2);
                    ((PresentationObject)object).addAnnotation(textOverlay, true);
                    arrayList.add((PresentationObject)object);
                }
            } else if (bl4) {
                if (annotationUnits3 == AnnotationUnits.Display) {
                    textOverlay = new TextOverlay(d2, d3 + 0.1, 0.0, 0.0, string, null, annotationUnits3, false, horizontalJustification, null);
                    object = new ArrowOverlay(d2, d3 + 0.1, d2, d3, annotationUnits2);
                } else {
                    textOverlay = new TextOverlay(d2, d3 + 40.0, 0.0, 0.0, string, null, annotationUnits3, false, horizontalJustification, null);
                    object = new ArrowOverlay(d2, d3 + 40.0, d2, d3, annotationUnits2);
                }
                ((PresentationObject)object).addAnnotation(textOverlay, true);
                arrayList.add((PresentationObject)object);
            } else {
                textOverlay = new TextOverlay(d2, d3, 0.0, 0.0, string, null, annotationUnits3, false, horizontalJustification, null);
            }
            if ((object = textObject.getTianiROIID()) != null) {
                try {
                    textOverlay.setID(Integer.parseInt(((String)object).trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("Group ID, could not be parsed", (Throwable)numberFormatException);
                    textOverlay.setEditable(false);
                }
            } else {
                textOverlay.setEditable(false);
            }
            arrayList.add(textOverlay);
        }
        catch (Exception exception) {
            log.error("Exception occured during makeTextROI(): ", (Throwable)exception);
            arrayList.clear();
        }
        for (PresentationObject presentationObject : arrayList) {
            presentationObject.setSaved(bl);
        }
        return arrayList;
    }
}

