/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.TextOverlay;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class PointOverlay
extends PresentationObject
implements IGraphicObjectContainer {
    protected static final double AL = GUI.getScaledDiagnosticInt((int)8);
    protected boolean largeCross = false;
    protected double[] p = new double[2];
    protected int pxi;
    protected int pyi;
    protected int a1x;
    protected int a1y;
    protected int a2x;
    protected int a2y;
    protected String shortText;

    public PointOverlay() {
        super("Point");
        this.p[1] = 0.0;
        this.p[0] = 0.0;
    }

    public PointOverlay(boolean bl) {
        this(0.0, 0.0, AnnotationUnits.Pixel);
        this.largeCross = bl;
    }

    public PointOverlay(double d, double d2, AnnotationUnits annotationUnits) {
        this();
        this.p[0] = d;
        this.p[1] = d2;
        this.setSpacing(annotationUnits);
        this.makeHandles();
    }

    public void setPosition(double d, double d2) {
        this.p[0] = d;
        this.p[1] = d2;
    }

    public void setAnnotationText(String string) {
        this.shortText = string;
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.p = new double[2];
        this.makeHandles();
    }

    @Override
    public boolean isROI() {
        return !this.largeCross;
    }

    protected void makeHandles() {
        this.handles = new PresentationHandle[]{new PresentationHandle(this.pxi, this.pyi)};
        this.translationHandleIndex = 0;
    }

    @Override
    protected void toScreen() {
        double[] dArray = this.toScreen(this.p);
        this.pxi = (int)dArray[0];
        this.pyi = (int)dArray[1];
        this.handles[0].setPosition(this.pxi, this.pyi);
        this.bounds.x = this.pxi - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = this.pyi - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = 2 * PresentationHandle.HANDLE_SIZE;
        this.a1x = 0;
        this.a1y = (int)AL;
        this.a2x = (int)AL;
        this.a2y = 0;
    }

    public double getX() {
        return this.p[0];
    }

    public double getY() {
        return this.p[1];
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        this.toScreen();
        if (this.largeCross) {
            if (this.isUseOutlineFont()) {
                bufferedImageHolder.graphics.setColor(Color.black);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.a1x - 1, 0, this.pxi + this.a1x - 1, this.pyi - this.a1y);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.a1x - 1, this.pyi + this.a1y, this.pxi + this.a1x - 1, bufferedImageHolder.height);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.a1x + 1, 0, this.pxi + this.a1x + 1, this.pyi - this.a1y);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.a1x + 1, this.pyi + this.a1y, this.pxi + this.a1x + 1, bufferedImageHolder.height);
                bufferedImageHolder.graphics.drawLine(0, this.pyi - this.a2y - 1, this.pxi - this.a2x, this.pyi + this.a2y - 1);
                bufferedImageHolder.graphics.drawLine(this.pxi + this.a2x, this.pyi - this.a2y - 1, bufferedImageHolder.width, this.pyi + this.a2y - 1);
                bufferedImageHolder.graphics.drawLine(0, this.pyi - this.a2y + 1, this.pxi - this.a2x, this.pyi + this.a2y + 1);
                bufferedImageHolder.graphics.drawLine(this.pxi + this.a2x, this.pyi - this.a2y + 1, bufferedImageHolder.width, this.pyi + this.a2y + 1);
                bufferedImageHolder.graphics.setColor(this.objCol);
            }
            bufferedImageHolder.graphics.drawLine(this.pxi - this.a1x, 0, this.pxi + this.a1x, this.pyi - this.a1y);
            bufferedImageHolder.graphics.drawLine(this.pxi - this.a1x, this.pyi + this.a1y, this.pxi + this.a1x, bufferedImageHolder.height);
            bufferedImageHolder.graphics.drawLine(0, this.pyi - this.a2y, this.pxi - this.a2x, this.pyi + this.a2y);
            bufferedImageHolder.graphics.drawLine(this.pxi + this.a2x, this.pyi - this.a2y, bufferedImageHolder.width, this.pyi + this.a2y);
        } else {
            if (this.isUseOutlineFont()) {
                bufferedImageHolder.graphics.setColor(Color.black);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.a1x - 1, this.pyi - this.a1y, this.pxi + this.a1x - 1, this.pyi + this.a1y);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.a2x, this.pyi - this.a2y - 1, this.pxi + this.a2x, this.pyi + this.a2y - 1);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.a1x + 1, this.pyi - this.a1y, this.pxi + this.a1x + 1, this.pyi + this.a1y);
                bufferedImageHolder.graphics.drawLine(this.pxi - this.a2x, this.pyi - this.a2y + 1, this.pxi + this.a2x, this.pyi + this.a2y + 1);
                bufferedImageHolder.graphics.setColor(this.objCol);
            }
            bufferedImageHolder.graphics.drawLine(this.pxi - this.a1x, this.pyi - this.a1y, this.pxi + this.a1x, this.pyi + this.a1y);
            bufferedImageHolder.graphics.drawLine(this.pxi - this.a2x, this.pyi - this.a2y, this.pxi + this.a2x, this.pyi + this.a2y);
        }
        if (this.shortText != null) {
            this.drawString(this.shortText, this.objCol, bufferedImageHolder, (int)((double)this.pxi + AL), (int)((double)this.pyi + 3.0 * AL));
        }
    }

    @Override
    protected void handleDragged(int n, double[] dArray) {
        if (this.isHandleOutsideView(dArray)) {
            return;
        }
        switch (n) {
            case 0: {
                this.p = (double[])dArray.clone();
                this.toScreen();
            }
        }
        this.setSaved(false);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        this.p = (double[])dArray.clone();
        return -1;
    }

    @Override
    protected void translationAction(int n, int n2, PresentationObject presentationObject) {
        if (this.fireing) {
            return;
        }
        this.fireTranslation(n, n2);
        if (presentationObject instanceof TextOverlay) {
            PresentationHandle presentationHandle = this.handles[0];
            this.handleDragged(0, this.toImage(presentationHandle.getX() + n, presentationHandle.getY() + n2));
        } else {
            this.p[0] = this.p[0] + ((double)n * this.unitx[0] + (double)n2 * this.unity[0]);
            this.p[1] = this.p[1] + ((double)n * this.unitx[1] + (double)n2 * this.unity[1]);
            this.toScreen();
        }
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            super.cloneReferences(presentationObject);
            PointOverlay pointOverlay = (PointOverlay)presentationObject;
            pointOverlay.setClonedParameters(ReferencedObjectsCloning.clone(this.p));
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return presentationObject;
    }

    public void setClonedParameters(double[] dArray) {
        this.p = dArray;
    }

    public void setLargeCross(boolean bl) {
        this.largeCross = bl;
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setGraphicType(GraphicType.Point);
        graphicObject.setGraphicData(new float[]{(float)this.p[0], (float)this.p[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(1));
        arrayList.add(graphicObject);
        return arrayList;
    }
}

