/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.fithandler.PixelIdentityFitHandler;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.Renderer;
import java.awt.Point;

public abstract class MagnifierOverlay
extends Overlay {
    protected final Renderer img;
    protected final Renderer orig;
    private int centerx;
    private int centery;
    private int extent = (int)Config.impaxee.jvision.DISPLAY.MagnifyingGlassSize.get();
    private int zoomFactor;
    private boolean autoWindow = Config.impaxee.jvision.DISPLAY.MagnifyingGlassAutoWindow.get();
    private boolean wasAutoWindow = false;
    private boolean inited = false;

    public MagnifierOverlay(Renderer renderer, Renderer renderer2) {
        this.orig = renderer;
        this.img = renderer2;
        this.img.fillBackground(false);
        TEvent tEvent = new TEvent();
        tEvent.id = 80;
        tEvent.interactionModifier = 2;
        this.img.handleTEvent(tEvent, new PixelIdentityFitHandler(), 0, null);
        this.setZoomFactor((int)Config.impaxee.jvision.DISPLAY.MagnifyingGlassZoom.get());
        if (this.img instanceof IRDCRenderer) {
            ((IRDCRenderer)((Object)this.img)).setBorderLockMode(true);
        }
    }

    public int getExtent() {
        return this.extent;
    }

    public static void configureExtent(int n) {
        Config.impaxee.jvision.DISPLAY.MagnifyingGlassSize.set(n);
    }

    public void setExtent(int n) {
        this.extent = n;
        MagnifierOverlay.configureExtent(n);
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(int n) {
        this.zoomFactor = n;
        Config.impaxee.jvision.DISPLAY.MagnifyingGlassZoom.set(this.getZoomFactor());
        TEvent tEvent = new TEvent();
        tEvent.id = 2;
        tEvent.interactionModifier = 2;
        tEvent.source = this;
        this.img.handleTEvent(tEvent, new ZoomParameter(1.0 / (double)this.getZoomFactor()), 0, null);
    }

    public boolean isAutoWindow() {
        return this.autoWindow;
    }

    public static void configureAutoWindow(boolean bl) {
        Config.impaxee.jvision.DISPLAY.MagnifyingGlassAutoWindow.set(bl);
    }

    public void setAutoWindow(boolean bl) {
        this.autoWindow = bl;
        MagnifierOverlay.configureAutoWindow(bl);
        if (!bl) {
            TEvent tEvent = new TEvent();
            tEvent.id = 63;
            this.handleTEvent(tEvent, this.orig.getImageState().window, 0, this.getView());
        }
    }

    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (tEvent.id == 80) {
            return false;
        }
        if (tEvent.id == 63 || tEvent.id == 6 || tEvent.id == 64) {
            if (this.getView() instanceof ImgView2) {
                if (this.getView().getDisplay().getData() != null && this.getView().getDisplay().getData().getPlugin() != null && this.getView().getDisplay().getData().getPlugin().getPluginName() == PluginName.MAMMO2) {
                    return this.img.handleTEvent(tEvent, object, n, this.getView());
                }
                if (tEvent.interactionModifier == 0) {
                    this.wasAutoWindow = this.autoWindow;
                    this.autoWindow = false;
                }
                if (tEvent.interactionModifier == 2) {
                    this.autoWindow = this.wasAutoWindow;
                    this.wasAutoWindow = false;
                    TEvent tEvent2 = new TEvent();
                    tEvent2.id = tEvent.id;
                    tEvent2.interactionModifier = tEvent.interactionModifier;
                    tEvent2.source = null;
                    ((ImgView2)this.getView()).getWindowHandler().handleTEvent(tEvent2, object, n, this.getView());
                }
            }
        } else if (tEvent.id == 12) {
            if (this.owner != null && this.owner instanceof ImgView2) {
                ((ImgView2)this.getView()).disableMagnifyingGlass();
            }
            this.setOwner(null);
            this.img.handleTEvent(tEvent, object, n, view);
            return false;
        }
        return this.img.handleTEvent(tEvent, object, n, view);
    }

    public void setLocation(int n, int n2) {
        this.inited = true;
        this.centerx = n;
        this.centery = n2;
    }

    @Override
    public void paint(BufferedImageHolder bufferedImageHolder) {
        Object object;
        if (!this.inited || bufferedImageHolder.getImageArray() instanceof byte[]) {
            return;
        }
        TEvent tEvent = new TEvent();
        tEvent.id = 2;
        tEvent.interactionModifier = 2;
        tEvent.source = this;
        this.img.handleTEvent(tEvent, new ZoomParameter(1.0 / (double)this.getZoomFactor()), 0, null);
        PickingResult pickingResult = this.orig.pick(this.centerx, this.centery);
        TEvent tEvent2 = new TEvent();
        tEvent2.id = 17;
        this.img.handleTEvent(tEvent2, pickingResult, 0, null);
        int n = this.getExtent() & ~(this.getZoomFactor() - 1);
        if (this.isAutoWindow()) {
            object = new TEvent();
            ((TEvent)object).id = 69;
            ((TEvent)object).interactionModifier = 2;
            ((TEvent)object).source = this;
            this.img.handleTEvent((TEvent)object, new Point(n / 2, n / 2), 0, null);
        }
        object = this.calculateLeftUpperCorner(n);
        Point point = this.calculateRightLowerCorner(n, bufferedImageHolder.width, bufferedImageHolder.height);
        this.img.invalidate();
        bufferedImageHolder.imgInvalid = true;
        this.paintBufferedImageHolder((Point)object, point, n, bufferedImageHolder);
    }

    protected Point calculateLeftUpperCorner(int n) {
        return new Point(this.centerx - n / 2, this.centery - n / 2);
    }

    protected Point calculateRightLowerCorner(int n, int n2, int n3) {
        Point point = new Point(this.centerx + n / 2, this.centery + n / 2);
        if (point.x >= n2) {
            point.x = n2 - 1;
        }
        if (point.y >= n3) {
            point.y = n3 - 1;
        }
        return point;
    }

    protected abstract void paintLensFrame(Point var1, Point var2, int var3, BufferedImageHolder var4);

    protected abstract void paintBufferedImageHolder(Point var1, Point var2, int var3, BufferedImageHolder var4);
}

