/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.math.GeomUtil;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.LocalizerHighlight;
import com.tiani.jvision.overlay.LocalizerLineOverlay;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.localizer.ActiveLocalizerHandler;
import com.tiani.jvision.overlay.localizer.DisplayLocalizerInfo;
import com.tiani.jvision.overlay.localizer.LocalizerManager;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Localizer
extends Overlay {
    private static boolean showOnlyActiveLocalizer = Config.impaxee.jvision.DISPLAY.showOnlyActiveLocalizer.get();
    private static double MAXIMAL_LINE_DISTANCE = 5.0;
    private ActiveLocalizerHandler localizer;
    private int activeSequenceID;
    private LocalizerHighlight localizerHighlight;
    private Map<String, LocalizerLineOverlay> llinesMap = null;
    private List<LocalizerLineOverlay> llines = null;
    private List<LocalizerInfo> lineAnnotations = null;
    private Set<LocalizerLineOverlay> highlightedLines = null;
    private boolean dataInvalid = true;
    private final int sequenceID;
    private ImageState imageState;
    private boolean isPrinting = false;
    private long lastUpdateStamp;
    private boolean isMiniLocalizer = false;
    private List<LocalizerLineOverlay> draggableLocalizerLines = null;

    public Localizer(ActiveLocalizerHandler activeLocalizerHandler, IImageInformation iImageInformation, int n) {
        this.localizer = activeLocalizerHandler;
        this.sequenceID = n;
        if (VisData.getLastModified() == null) {
            this.activeSequenceID = -1;
        } else {
            this.activeSequenceID = VisData.getLastModified().getParent().getDisplaySetID();
            if (this.activeSequenceID == this.sequenceID) {
                this.activeSequenceID = -1;
            }
        }
    }

    public static void setShowOnlyActiveLocalizer(boolean bl) {
        showOnlyActiveLocalizer = bl;
    }

    public void setLocalizerHighlight(LocalizerHighlight localizerHighlight) {
        this.localizerHighlight = localizerHighlight;
    }

    Set<LocalizerLineOverlay> getHighlightedLines() {
        return this.highlightedLines == null ? Collections.EMPTY_SET : this.highlightedLines;
    }

    public List<LocalizerLineOverlay> getLlines() {
        return this.llines;
    }

    public void setLlines(List<LocalizerLineOverlay> list) {
        this.llines = list;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Localizer localizer = (Localizer)super.clone();
        if (this.getLlines() != null) {
            ArrayList<LocalizerLineOverlay> arrayList = new ArrayList<LocalizerLineOverlay>();
            for (LocalizerLineOverlay localizerLineOverlay : this.getLlines()) {
                arrayList.add((LocalizerLineOverlay)localizerLineOverlay.clone());
            }
            localizer.setLlines(arrayList);
        }
        localizer.dataInvalid = true;
        return localizer;
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public void setPrinting(boolean bl) {
        if (this.getView().getImageInformation().getImageClass() == IImageInformation.ImageClass.CT && this.activeSequenceID > 0) {
            this.isPrinting = bl;
        }
        this.dataInvalid = true;
    }

    private boolean setActiveDisplay(VisDisplayData visDisplayData) {
        if (visDisplayData == this.getView().getDisplayData()) {
            this.activeSequenceID = -1;
            return false;
        }
        this.activeSequenceID = visDisplayData == null ? -1 : visDisplayData.getDisplaySetID();
        return true;
    }

    private void setVisibility(VisDisplayData visDisplayData) {
        if (visDisplayData == null) {
            return;
        }
        if (this.activeSequenceID > 0 && this.llinesMap != null) {
            HashSet<LocalizerLineOverlay> hashSet = new HashSet<LocalizerLineOverlay>(4);
            ImageState imageState = null;
            if (this.owner != null) {
                imageState = this.owner.getImageState();
            }
            if (imageState == null) {
                imageState = this.imageState;
            }
            for (Vis2 vis2 : visDisplayData.getVisDisplay().getVisViews()) {
                try {
                    VisData visData = vis2.getData();
                    if (visData == null) continue;
                    String string = visData.getFrameData().getImageInformation().getKey();
                    LocalizerLineOverlay localizerLineOverlay = this.llinesMap.get(string);
                    if (localizerLineOverlay != null) {
                        hashSet.add(localizerLineOverlay);
                        continue;
                    }
                    localizerLineOverlay = this.localizer.presentReferencedImage(visData.getFrameData().getImageInformation(), true);
                    if (localizerLineOverlay == null) continue;
                    localizerLineOverlay.updateCoordinates(imageState);
                    hashSet.add(localizerLineOverlay);
                }
                catch (Exception exception) {
                    log.error("Could not update localizer", (Throwable)exception);
                }
            }
            this.highlightedLines = hashSet;
        }
    }

    @Override
    public void setSize(int n, int n2, ImageState imageState) {
        super.setSize(n, n2, imageState);
        this.imageState = imageState;
    }

    public LocalizerLineOverlay getImageRepresentation(IImageInformation iImageInformation) {
        return this.localizer.presentReferencedImage(iImageInformation, true);
    }

    public int getActiveSequenceID() {
        return this.activeSequenceID;
    }

    @Override
    public void paint(BufferedImageHolder bufferedImageHolder) {
        if (LocalizerManager.isFastRepaintInProgress() || !this.visible) {
            return;
        }
        if (this.dataInvalid || this.owner != null && this.getView().imgInvalid) {
            this.refreshData(new Rectangle(0, 0, bufferedImageHolder.width, bufferedImageHolder.height));
        }
        if (this.llines != null && this.llines.size() > 0) {
            int[] nArray = new int[4];
            int[] nArray2 = null;
            Color color = bufferedImageHolder.graphics.getColor();
            Color color2 = new Color(200, 200, 200, 180);
            bufferedImageHolder.graphics.setColor(color2);
            for (LocalizerLineOverlay localizerLineOverlay : this.llines) {
                nArray2 = localizerLineOverlay.getScreenCoordinates();
                if (nArray[0] == nArray2[0] && nArray[1] == nArray2[1] && nArray[2] == nArray2[2] && nArray[3] == nArray2[3]) continue;
                bufferedImageHolder.graphics.drawLine(nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
                nArray = nArray2;
            }
            bufferedImageHolder.graphics.setColor(color);
            if (this.lineAnnotations != null) {
                for (LocalizerInfo localizerInfo : this.lineAnnotations) {
                    this.drawString(localizerInfo.text, bufferedImageHolder, localizerInfo.x, localizerInfo.y);
                }
            }
        }
    }

    protected void refreshData(Rectangle rectangle) {
        this.dataInvalid = false;
        if (this.llines == null) {
            return;
        }
        ImageState imageState = null;
        if (this.owner != null) {
            imageState = this.owner.getImageState();
        }
        if (imageState == null || this.isPrinting()) {
            imageState = this.imageState;
        }
        if (imageState != null && imageState.updateStamp > this.lastUpdateStamp) {
            this.lastUpdateStamp = imageState.updateStamp;
            for (LocalizerLineOverlay localizerLineOverlay : this.llines) {
                localizerLineOverlay.updateCoordinates(imageState);
            }
        }
        int n = this.getCurrentFontMetrics().charWidth('0');
        int n2 = ("" + this.llines.size()).length();
        int[] nArray = new int[]{(n * n2 >> 1) + 8, (this.getFontHeight() >> 1) + 8};
        this.lineAnnotations = new ArrayList<LocalizerInfo>(16);
        Iterator<LocalizerLineOverlay> iterator = this.llines.iterator();
        int[] nArray2 = new int[2];
        while (iterator.hasNext()) {
            LocalizerLineOverlay localizerLineOverlay = iterator.next();
            int[] nArray3 = localizerLineOverlay.getScreenCoordinates();
            int n3 = localizerLineOverlay.getAnnotation().length();
            int[] nArray4 = this.clipAnnotationIntoVisibleRect(nArray3, localizerLineOverlay.getAnnotation(), nArray, rectangle);
            if (Math.abs(nArray2[0] - nArray4[0]) > n3 * (n << 1) || Math.abs(nArray2[1] - nArray4[1]) > this.getFontHeight() << 1) {
                this.lineAnnotations.add(new LocalizerInfo(nArray4[0], nArray4[1], localizerLineOverlay.getAnnotation()));
                nArray2[0] = nArray4[0];
                nArray2[1] = nArray4[1];
                continue;
            }
            if (iterator.hasNext() || this.lineAnnotations.size() <= 0) continue;
            if (this.lineAnnotations.size() > 0) {
                this.lineAnnotations.remove(this.lineAnnotations.size() - 1);
            }
            nArray4 = this.clipAnnotationIntoVisibleRect(nArray3, localizerLineOverlay.getAnnotation(), nArray, rectangle);
            this.lineAnnotations.add(new LocalizerInfo(nArray4[0], nArray4[1], localizerLineOverlay.getAnnotation()));
        }
    }

    private int[] clipAnnotationIntoVisibleRect(int[] nArray, String string, int[] nArray2, Rectangle rectangle) {
        int n;
        int n2;
        int[] nArray3 = new int[2];
        int n3 = string.length();
        int n4 = this.getCurrentFontMetrics().charWidth('0');
        int[] nArray4 = new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        if (!rectangle.intersectsLine(nArray[0], nArray[1], nArray[2], nArray[3])) {
            return nArray;
        }
        nArray4[0] = nArray4[0] + nArray2[0];
        nArray4[1] = nArray4[1] + nArray2[1];
        nArray4[2] = nArray4[2] - nArray2[0];
        nArray4[3] = nArray4[3] - nArray2[1];
        int n5 = nArray[2] - nArray[0];
        int n6 = nArray[3] - nArray[1];
        nArray3[0] = nArray[0];
        nArray3[1] = nArray[1];
        if (nArray3[0] < nArray4[0] && n5 != 0) {
            n2 = nArray4[0] - nArray3[0];
            nArray3[0] = nArray3[0] + n2;
            if (n5 != 0) {
                n = n2 * n6 / n5;
                nArray3[1] = nArray3[1] + n;
            }
        } else if (nArray3[0] > nArray4[2] && n5 != 0) {
            n2 = nArray3[0] - nArray4[2];
            nArray3[0] = nArray3[0] - n2;
            n = n2 * n6 / n5;
            nArray3[1] = nArray3[1] - n;
        }
        if (nArray3[1] < nArray4[1] && n6 != 0) {
            n2 = nArray4[1] - nArray3[1];
            nArray3[1] = nArray3[1] + n2;
            n = n2 * n5 / n6;
            nArray3[0] = nArray3[0] + n;
        } else if (nArray3[1] > nArray4[3] && n6 != 0) {
            n2 = nArray3[1] - nArray4[3];
            nArray3[1] = nArray3[1] - n2;
            n = n2 * n5 / n6;
            nArray3[0] = nArray3[0] - n;
        }
        nArray3[0] = nArray3[0] - (n3 * n4 >> 1);
        nArray3[1] = nArray3[1] + (this.getFontHeight() >> 1);
        return nArray3;
    }

    @Override
    public void presentationObjectAdded(View view) {
        super.presentationObjectAdded(view);
    }

    public void exitView() {
        this.llines = null;
        this.llinesMap = null;
        this.lineAnnotations = null;
        this.highlightedLines = null;
        this.activeSequenceID = -1;
    }

    public void handleUpdate(VisDisplayData visDisplayData, DisplayLocalizerInfo.ParallelityCheckResult parallelityCheckResult, ImgView2 imgView2) {
        int n = this.activeSequenceID;
        if (!this.isVisible()) {
            return;
        }
        if (this.setActiveDisplay(visDisplayData)) {
            boolean bl;
            boolean bl2 = bl = n != this.getActiveSequenceID();
            if (bl) {
                Collection<Overlay> collection = imgView2.getExcludeFromLock();
                imgView2.lockBackground(false);
                if (imgView2.getVisView() != null) {
                    imgView2.getVisView().setHRPaintMode(false, false);
                }
                if (this.sequenceID != this.activeSequenceID) {
                    this.calculateLines(visDisplayData, parallelityCheckResult, imgView2);
                    this.draggableLocalizerLines = null;
                    if (this.localizerHighlight != null) {
                        if (collection == null) {
                            collection = new HashSet<Overlay>();
                        }
                        collection.add(this.localizerHighlight);
                        imgView2.lockBackground(true, collection);
                        if (imgView2.getVisView() != null) {
                            imgView2.getVisView().setHRPaintMode(true, false);
                        }
                    }
                } else {
                    imgView2.invalidate();
                }
            }
            this.setVisibility(visDisplayData);
            imgView2.repaint();
        } else {
            imgView2.invalidate();
        }
    }

    private void calculateLines(VisDisplayData visDisplayData, DisplayLocalizerInfo.ParallelityCheckResult parallelityCheckResult, ImgView2 imgView2) {
        HashMap<String, LocalizerLineOverlay> hashMap;
        if (visDisplayData == null || visDisplayData.getPlugin().getPluginName() != PluginName.DEFAULT) {
            this.llines = null;
            this.llinesMap = null;
            this.lineAnnotations = null;
            this.highlightedLines = null;
            return;
        }
        if (showOnlyActiveLocalizer) {
            hashMap = new HashMap<String, LocalizerLineOverlay>(2);
            IImageInformation iImageInformation = visDisplayData.getVis(0).getImageInformation();
            LocalizerLineOverlay localizerLineOverlay = this.localizer.presentReferencedImage(iImageInformation, parallelityCheckResult == DisplayLocalizerInfo.ParallelityCheckResult.NotChecked);
            if (localizerLineOverlay != null) {
                hashMap.put(iImageInformation.getKey(), localizerLineOverlay);
            }
            if ((localizerLineOverlay = this.localizer.presentReferencedImage(iImageInformation = visDisplayData.getVis(visDisplayData.getVisCount() - 1).getImageInformation(), parallelityCheckResult == DisplayLocalizerInfo.ParallelityCheckResult.NotChecked)) != null) {
                hashMap.put(iImageInformation.getKey(), localizerLineOverlay);
            }
        } else {
            hashMap = new HashMap(visDisplayData.getVisCount());
            for (VisData object2 : visDisplayData.getVis()) {
                IImageInformation iImageInformation = object2.getImageInformation();
                LocalizerLineOverlay localizerLineOverlay = this.localizer.presentReferencedImage(iImageInformation, parallelityCheckResult == DisplayLocalizerInfo.ParallelityCheckResult.NotChecked);
                if (localizerLineOverlay == null) continue;
                hashMap.put(iImageInformation.getKey(), localizerLineOverlay);
            }
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Collections.sort(arrayList);
        this.llines = arrayList;
        this.llinesMap = hashMap;
    }

    public void setMiniLocalizer(boolean bl) {
        this.isMiniLocalizer = bl;
    }

    public boolean isMiniLocalizer() {
        return this.isMiniLocalizer;
    }

    private boolean isWithinLocalizer(int n, int n2) {
        if (this.llines != null && this.llines.size() > 1) {
            int[] nArray;
            LocalizerLineOverlay localizerLineOverlay = this.llines.get(0);
            LocalizerLineOverlay localizerLineOverlay2 = this.llines.get(this.llines.size() - 1);
            int[] nArray2 = localizerLineOverlay.getScreenCoordinates();
            if (GeomUtil.isParallel((int)nArray2[0], (int)nArray2[1], (int)nArray2[2], (int)nArray2[3], (int)(nArray = localizerLineOverlay2.getScreenCoordinates())[0], (int)nArray[1], (int)nArray[2], (int)nArray[3], (double)0.06283185307179587)) {
                Polygon polygon = new Polygon();
                polygon.addPoint(nArray2[0], nArray2[1]);
                polygon.addPoint(nArray2[2], nArray2[3]);
                polygon.addPoint(nArray[2], nArray[3]);
                polygon.addPoint(nArray[0], nArray[1]);
                Rectangle rectangle = polygon.getBounds();
                rectangle.x -= 5;
                rectangle.width += 10;
                rectangle.y -= 5;
                rectangle.height += 10;
                return rectangle.contains(n, n2);
            }
            return true;
        }
        return false;
    }

    private int lineToPosition(LocalizerLineOverlay localizerLineOverlay) {
        VisDisplay2 visDisplay2 = VisData.getLastModified().getVisual().getVisDisplay();
        List<VisData> list = visDisplay2.getVis();
        int n = 0;
        for (VisData visData : list) {
            if ((visData.getImageInformation().getFrameNumber() == -1 || visData.getImageInformation().getFrameNumber() == localizerLineOverlay.getFrameNumer()) && visData.getImageInformation().getInstanceNumber() == localizerLineOverlay.getImageNumber()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int findPositionOfNearestLine(List<LocalizerLineOverlay> list, int n, int n2, boolean bl) {
        int n3 = Integer.MAX_VALUE;
        LocalizerLineOverlay localizerLineOverlay = null;
        for (LocalizerLineOverlay localizerLineOverlay2 : list) {
            double d;
            int[] nArray = localizerLineOverlay2.getScreenCoordinates();
            int n4 = (int)Math.abs(GeomUtil.getSignedDistanceFromLine((double)nArray[0], (double)nArray[1], (double)nArray[2], (double)nArray[3], (double)n, (double)n2));
            if (n4 >= n3 || !((d = GeomUtil.getPerpendicularPositionOnLine((int)nArray[0], (int)nArray[1], (int)nArray[2], (int)nArray[3], (int)n, (int)n2)) >= 0.0) || !(d <= 1.0)) continue;
            n3 = n4;
            localizerLineOverlay = localizerLineOverlay2;
            if (n3 != 0) continue;
            return this.lineToPosition(localizerLineOverlay);
        }
        if (localizerLineOverlay != null && (!bl || (double)n3 <= MAXIMAL_LINE_DISTANCE)) {
            return this.lineToPosition(localizerLineOverlay);
        }
        return -1;
    }

    private void calculateDraggableLocalizerLines(VisDisplayData visDisplayData) {
        ImageState imageState = null;
        if (this.owner != null) {
            imageState = this.owner.getImageState();
        }
        if (imageState == null || this.isPrinting()) {
            imageState = this.imageState;
        }
        this.draggableLocalizerLines = new ArrayList<LocalizerLineOverlay>(visDisplayData.getVisCount());
        for (VisData visData : visDisplayData.getVis()) {
            IImageInformation iImageInformation = visData.getImageInformation();
            LocalizerLineOverlay localizerLineOverlay = this.localizer.presentReferencedImage(iImageInformation, true);
            if (localizerLineOverlay == null) continue;
            localizerLineOverlay.updateCoordinates(imageState);
            this.draggableLocalizerLines.add(localizerLineOverlay);
        }
    }

    public boolean mousePressed(int n, int n2) {
        if (this.isWithinLocalizer(n, n2)) {
            int n3 = this.findPositionOfNearestLine(this.llines, n, n2, true);
            if (n3 == -1) {
                return false;
            }
            VisDisplay2 visDisplay2 = VisData.getLastModified().getVisual().getVisDisplay();
            visDisplay2.move2synchronisedPosition(n3);
            return true;
        }
        return false;
    }

    public void localizerDragged(int n, int n2) {
        int n3;
        VisDisplayData visDisplayData = VisData.getLastModified().getParent();
        if (this.draggableLocalizerLines == null) {
            this.calculateDraggableLocalizerLines(visDisplayData);
        }
        if ((n3 = this.findPositionOfNearestLine(this.draggableLocalizerLines, n, n2, false)) > -1) {
            VisDisplay2 visDisplay2 = VisData.getLastModified().getVisual().getVisDisplay();
            visDisplay2.move2synchronisedPosition(n3);
        }
    }

    public void mouseReleased() {
        this.draggableLocalizerLines = null;
    }

    static class LocalizerInfo {
        public final int x;
        public final int y;
        public final String text;

        public LocalizerInfo(int n, int n2, String string) {
            this.x = n;
            this.y = n2;
            this.text = string;
        }
    }

    public static enum LocalizerState {
        On(true, false),
        Off(false, false),
        ForceOn(true, true),
        UserForcedOn(true, true);

        private boolean forced;
        private boolean visible;

        private LocalizerState(boolean bl, boolean bl2) {
            this.forced = bl2;
            this.visible = bl;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean isForced() {
            return this.forced;
        }
    }
}

