/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.ByteGrayscaleBufferedImageHolder;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.overlay.IShutterObject;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.Shutter;
import java.awt.Dimension;

public class LRShutter
extends Shutter {
    private short[] limitsLeft;
    private short[] limitsRight;
    private short[] verticalLimits = new short[2];
    private PresentationObject lastPO = null;

    public LRShutter(int n) {
        this.setShutterValue(n);
    }

    @Override
    public void update(PresentationObject presentationObject) {
        this.lastPO = presentationObject;
        this.limitsLeft = null;
        this.limitsRight = null;
    }

    private void calculateLimits() {
        Dimension dimension = this.lastPO.getSize();
        boolean bl = false;
        if (this.limitsLeft == null || this.limitsLeft.length < dimension.height) {
            this.limitsLeft = new short[dimension.height];
            bl = true;
        }
        if (this.limitsRight == null || this.limitsRight.length < dimension.height) {
            this.limitsRight = new short[dimension.height];
            bl = true;
        }
        if (!bl) {
            return;
        }
        short[] sArray = this.limitsLeft;
        short[] sArray2 = this.limitsRight;
        short[] sArray3 = this.verticalLimits;
        ByteGrayscaleBufferedImageHolder byteGrayscaleBufferedImageHolder = new ByteGrayscaleBufferedImageHolder(dimension.width, dimension.height);
        byte[] byArray = byteGrayscaleBufferedImageHolder.data;
        byteGrayscaleBufferedImageHolder.clear();
        boolean bl2 = this.lastPO.isShutter();
        this.lastPO.setShutterMode(false);
        if (this.lastPO instanceof IShutterObject) {
            ((IShutterObject)((Object)this.lastPO)).paintShape(byteGrayscaleBufferedImageHolder, true);
        } else {
            this.lastPO.paintShape(byteGrayscaleBufferedImageHolder);
        }
        this.lastPO.setShutterMode(bl2);
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < byArray.length) {
            if (byArray[n3] != 0) {
                n = n3 / dimension.width;
                break;
            }
            ++n3;
        }
        if (n == -1) {
            sArray3[0] = 0;
            sArray3[1] = 0;
            return;
        }
        n3 = n * dimension.width;
        int n4 = byArray.length - 1;
        while (n4 > n3) {
            if (byArray[n4] != 0) {
                n2 = n4 / dimension.width;
                break;
            }
            --n4;
        }
        sArray3[0] = (short)n;
        sArray3[1] = (short)n2;
        n4 = n;
        while (n4 <= n2) {
            int n5 = n4 * dimension.width;
            int n6 = 0;
            while (n6 < dimension.width) {
                if (byArray[n5 + n6] != 0) {
                    sArray[n4] = (short)n6;
                    break;
                }
                ++n6;
            }
            n6 = dimension.width - 1;
            while (n6 >= 0) {
                if (byArray[n5 + n6] != 0) {
                    sArray2[n4] = (short)n6;
                    break;
                }
                --n6;
            }
            ++n4;
        }
        byteGrayscaleBufferedImageHolder.release();
    }

    @Override
    public void applyShutter(Object object, int n, int n2) {
        if (this.limitsLeft == null) {
            this.calculateLimits();
        }
        int n3 = n;
        short s = 0;
        short s2 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.verticalLimits[0];
        short s3 = this.verticalLimits[1];
        this.shutterValue |= 0xFF000000;
        try {
            if (object instanceof int[]) {
                int n7;
                int[] nArray = (int[])object;
                int n8 = 0;
                while (n8 < n6) {
                    n4 = n3 * n8;
                    n7 = 0;
                    while (n7 < n) {
                        nArray[n4] = this.shutterValue;
                        ++n4;
                        ++n7;
                    }
                    ++n8;
                }
                n5 = n6 * n3;
                n8 = n6;
                while (n8 <= s3) {
                    s = this.limitsLeft[n8];
                    s2 = this.limitsRight[n8];
                    n4 = n5;
                    n7 = 0;
                    while (n7 < s) {
                        nArray[n4] = this.shutterValue;
                        ++n4;
                        ++n7;
                    }
                    n4 = n3 * n8 + s2 + 1;
                    n7 = s2 + 1;
                    while (n7 < n) {
                        nArray[n4] = this.shutterValue;
                        ++n4;
                        ++n7;
                    }
                    n5 += n3;
                    ++n8;
                }
                n8 = s3 + 1;
                while (n8 < n2) {
                    n4 = n3 * n8;
                    n7 = 0;
                    while (n7 < n) {
                        nArray[n4] = this.shutterValue;
                        ++n4;
                        ++n7;
                    }
                    ++n8;
                }
            } else if (object instanceof byte[]) {
                int n9;
                byte[] byArray = (byte[])object;
                byte by = (byte)this.shutterValue;
                int n10 = 0;
                while (n10 < n6) {
                    n4 = n3 * n10;
                    n9 = 0;
                    while (n9 < n) {
                        byArray[n4] = by;
                        ++n4;
                        ++n9;
                    }
                    ++n10;
                }
                n5 = n6 * n3;
                n10 = n6;
                while (n10 <= s3) {
                    s = this.limitsLeft[n10];
                    s2 = this.limitsRight[n10];
                    n4 = n5;
                    n9 = 0;
                    while (n9 < s) {
                        byArray[n4] = by;
                        ++n4;
                        ++n9;
                    }
                    n4 = n3 * n10 + s2 + 1;
                    n9 = s2 + 1;
                    while (n9 < n) {
                        byArray[n4] = by;
                        ++n4;
                        ++n9;
                    }
                    n5 += n3;
                    ++n10;
                }
                n10 = s3 + 1;
                while (n10 < n2) {
                    n4 = n3 * n10;
                    n9 = 0;
                    while (n9 < n) {
                        byArray[n4] = by;
                        ++n4;
                        ++n9;
                    }
                    ++n10;
                }
            }
        }
        catch (Exception exception) {
            ALogger.getLogger(LRShutter.class).error("Paint exception", (Throwable)exception);
        }
    }

    @Override
    public Shutter clone() {
        return new LRShutter(this.shutterValue);
    }
}

