/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.tiani.jvision.overlay.AbstractLengthOverlay;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.OverlayTransformationException;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;

public class HorizontalDistanceOverlay
extends AbstractLengthOverlay
implements IGraphicObjectContainer {
    private static final double LINE_OVERLENGTH = 0.1;
    protected double[] p = new double[2];
    protected double[] q = new double[2];
    private int psx1;
    private int psy1;
    private int psx2;
    private int psy2;
    private int qsx1;
    private int qsy1;
    private int qsx2;
    private int qsy2;
    private double[] cl1;
    private double[] cl2;
    private int clx1;
    private int cly1;
    private int clx2;
    private int cly2;

    public HorizontalDistanceOverlay() {
        super("Horizontal Distance", AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_FULLY);
        this.p[1] = 0.0;
        this.p[0] = 0.0;
        this.q[1] = 0.0;
        this.q[0] = 0.0;
        this.cl1 = new double[2];
        this.cl2 = new double[2];
    }

    public HorizontalDistanceOverlay(double d, double d2, double d3, double d4, AnnotationUnits annotationUnits) {
        this();
        this.p[0] = d;
        this.p[1] = d2;
        this.q[0] = d3;
        this.q[1] = d4;
        this.setSpacing(annotationUnits);
        this.makeHandles();
    }

    private void makeHandles() {
        this.handles = new PresentationHandle[3];
        this.handles[0] = new PresentationHandle(this.psx1, this.psy1);
        this.handles[1] = new PresentationHandle(this.qsx2, this.qsy2);
        this.handles[2] = new TranslationHandle((this.psx1 + this.qsx2) / 2, (this.psy1 + this.qsy2) / 2);
        this.translationHandleIndex = 2;
    }

    private void setHandles() {
        this.handles[0].setPosition(this.psx1, this.psy1);
        this.handles[1].setPosition(this.qsx2, this.qsy2);
        this.handles[2].setPosition((this.psx1 + this.qsx2) / 2, (this.psy1 + this.qsy2) / 2);
    }

    @Override
    public double[] getXCoordinates() {
        return new double[]{this.p[0], this.q[0]};
    }

    @Override
    public double[] getYCoordinates() {
        return new double[]{this.p[1], this.q[1]};
    }

    @Override
    public int getPointCount() {
        return 2;
    }

    @Override
    public boolean isInterceptionAt(int n) {
        return false;
    }

    @Override
    public boolean supportsProfile() {
        return false;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) throws OverlayTransformationException {
        HorizontalDistanceOverlay horizontalDistanceOverlay = (HorizontalDistanceOverlay)iTransformableOverlay;
        this.p = iOverlayPointModifier.convert(horizontalDistanceOverlay.p);
        this.q = iOverlayPointModifier.convert(horizontalDistanceOverlay.q);
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.q = new double[2];
        this.p = new double[2];
        this.makeHandles();
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        switch (n) {
            case 0: {
                this.p[0] = dArray[0];
                this.p[1] = dArray[1];
                break;
            }
            case 1: {
                this.q[0] = dArray[0];
                this.q[1] = dArray[1];
                TextOverlay textOverlay = this.getAnnotation();
                if (textOverlay == null || this.isCompleted()) break;
                textOverlay.setAnchor(this.p[0], this.p[1]);
                break;
            }
            case 2: {
                double d = (this.p[0] + this.q[0]) / 2.0;
                double d2 = (this.p[1] + this.q[1]) / 2.0;
                double d3 = dArray[0] - d;
                double d4 = dArray[1] - d2;
                this.p[0] = this.p[0] + d3;
                this.p[1] = this.p[1] + d4;
                this.q[0] = this.q[0] + d3;
                this.q[1] = this.q[1] + d4;
            }
        }
        this.toScreen();
        this.setSaved(false);
    }

    @Override
    void toScreenImpl() {
        double[] dArray = this.toScreen(this.p);
        this.psx1 = (int)dArray[0];
        this.psy1 = (int)dArray[1];
        double[] dArray2 = new double[2];
        double d = this.q[0] - this.p[0];
        dArray2[0] = this.p[0] + d / 2.0 + d * 0.1;
        dArray2[1] = this.p[1];
        double[] dArray3 = this.toScreen(dArray2);
        this.psx2 = (int)dArray3[0];
        this.psy2 = (int)dArray3[1];
        double[] dArray4 = new double[]{this.q[0] - d / 2.0 - d * 0.1, this.q[1]};
        double[] dArray5 = this.toScreen(dArray4);
        this.qsx1 = (int)dArray5[0];
        this.qsy1 = (int)dArray5[1];
        double[] dArray6 = this.toScreen(this.q);
        dArray6 = this.toScreen(this.q);
        this.qsx2 = (int)dArray6[0];
        this.qsy2 = (int)dArray6[1];
        this.cl1[0] = (this.p[0] + this.q[0]) / 2.0;
        this.cl1[1] = this.p[1];
        this.cl2[0] = this.cl1[0];
        this.cl2[1] = this.q[1];
        double[] dArray7 = this.toScreen(this.cl1);
        this.clx1 = (int)dArray7[0];
        this.cly1 = (int)dArray7[1];
        double[] dArray8 = this.toScreen(this.cl2);
        this.clx2 = (int)dArray8[0];
        this.cly2 = (int)dArray8[1];
        this.setHandles();
    }

    @Override
    double calculateMeasurementResult() {
        return this.calculateLength(this.cl1, this.clx1, this.cly1, this.cl2, this.clx2, this.cly2);
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(30, "");
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        int n2 = n;
        switch (n) {
            case 1: {
                this.handleDragged(0, dArray);
                this.handleDragged(1, dArray);
                if (!this.hasAnnotation()) {
                    this.createAnnotation();
                }
                this.activeHandleIndex = 1;
                ++n2;
                break;
            }
            case 2: {
                ++n2;
                this.activeHandleIndex = 1;
                break;
            }
            case 3: {
                this.handleDragged(1, dArray);
                n2 = -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    @Override
    protected void paintShape(BufferedImageHolder bufferedImageHolder) {
        Stroke stroke = bufferedImageHolder.graphics.getStroke();
        bufferedImageHolder.graphics.setStroke(AUXILIARY_LINE_STROKE);
        if (this.isUseOutlineFont()) {
            bufferedImageHolder.graphics.setColor(Color.black);
            bufferedImageHolder.graphics.drawLine(this.clx1 - 1, this.cly1, this.clx2 - 1, this.cly2);
            bufferedImageHolder.graphics.drawLine(this.clx1 + 1, this.cly1, this.clx2 + 1, this.cly2);
            bufferedImageHolder.graphics.setColor(this.objCol);
        }
        bufferedImageHolder.graphics.drawLine(this.clx1, this.cly1, this.clx2, this.cly2);
        bufferedImageHolder.graphics.setStroke(stroke);
        if (this.isUseOutlineFont()) {
            bufferedImageHolder.graphics.setColor(Color.black);
            bufferedImageHolder.graphics.drawLine(this.psx1, this.psy1 - 1, this.psx2, this.psy2 - 1);
            bufferedImageHolder.graphics.drawLine(this.psx1, this.psy1 + 1, this.psx2, this.psy2 + 1);
            bufferedImageHolder.graphics.drawLine(this.qsx1, this.qsy1 - 1, this.qsx2, this.qsy2 - 1);
            bufferedImageHolder.graphics.drawLine(this.qsx1, this.qsy1 + 1, this.qsx2, this.qsy2 + 1);
            bufferedImageHolder.graphics.setColor(this.objCol);
        }
        bufferedImageHolder.graphics.drawLine(this.psx1, this.psy1, this.psx2, this.psy2);
        bufferedImageHolder.graphics.drawLine(this.qsx1, this.qsy1, this.qsx2, this.qsy2);
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            super.cloneReferences(presentationObject);
            HorizontalDistanceOverlay horizontalDistanceOverlay = (HorizontalDistanceOverlay)presentationObject;
            horizontalDistanceOverlay.p = ReferencedObjectsCloning.clone(this.p);
            horizontalDistanceOverlay.q = ReferencedObjectsCloning.clone(this.q);
            horizontalDistanceOverlay.cl1 = ReferencedObjectsCloning.clone(this.cl1);
            horizontalDistanceOverlay.cl2 = ReferencedObjectsCloning.clone(this.cl2);
        }
        catch (Exception exception) {
            log.error("Failed to clone a HorizontalDistanceOverlay object", (Throwable)exception);
        }
        return presentationObject;
    }

    protected void createBoundingShape() {
        this.toScreen();
        this.outBounds = new ArrayList();
        this.outBounds.add(this.createBoundingLine(this.psx1, this.psy1, this.psx2, this.psy2));
        this.outBounds.add(this.createBoundingLine(this.qsx1, this.qsy1, this.qsx2, this.qsy2));
        this.outBounds.add(this.createBoundingLine(this.clx1, this.cly1, this.clx2, this.cly2));
    }

    @Override
    public boolean inBounds(int n, int n2) {
        boolean bl = false;
        if (this.isSelected()) {
            bl = this.isHandleClicked(n, n2);
        }
        if (!bl) {
            this.createBoundingShape();
            bl = super.inBounds(n, n2);
        }
        return bl;
    }

    @Override
    public boolean isROI() {
        return true;
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(3);
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.HorizontalDistance);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        double d = this.q[0] - this.p[0];
        double d2 = this.p[0] + d / 2.0 + d * 0.1;
        graphicObject.setGraphicData(new float[]{(float)this.p[0], (float)this.p[1], (float)d2, (float)this.p[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
        arrayList.add(graphicObject);
        graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.HorizontalDistance);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        double d3 = this.q[0] - d / 2.0 - d * 0.1;
        graphicObject.setGraphicData(new float[]{(float)d3, (float)this.q[1], (float)this.q[0], (float)this.q[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
        arrayList.add(graphicObject);
        graphicObject = this.createGraphicObject();
        graphicObject.setTianiSubType(TianiSubType.HorizontalDistance);
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setGraphicData(new float[]{(float)(this.p[0] + d / 2.0), (float)this.p[1], (float)(this.q[0] - d / 2.0), (float)this.q[1]});
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(2));
        arrayList.add(graphicObject);
        return arrayList;
    }
}

