/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.Interval;
import com.tiani.jvision.image.DoubleRectangle;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.OverlayContainer;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class HistogramOverlay
extends OverlayContainer
implements IGraphicObjectContainer {
    private static final String TYPE = "Histogram";
    private Vector<VerticalMarker> markers = new Vector();
    private boolean autoScaleX = false;
    protected Histogram histogram;
    protected int[] screenScaledValues;
    private Interval markedInterval;

    HistogramOverlay(Histogram histogram, double d, double d2, double d3, double d4, AnnotationUnits annotationUnits, OverlayContainer.AnchorPosition anchorPosition, boolean bl) {
        super(TYPE, d, d2, d3, d4, annotationUnits, anchorPosition);
        this.init(histogram, bl);
    }

    HistogramOverlay(DoubleRectangle doubleRectangle, AnnotationUnits annotationUnits, OverlayContainer.AnchorPosition anchorPosition, boolean bl) {
        super(TYPE, doubleRectangle, annotationUnits, anchorPosition);
        this.init(null, bl);
    }

    protected Interval getMarkedInterval() {
        return this.markedInterval;
    }

    public void updateRange(Interval interval) {
        if (CompareUtils.equals((Object)this.markedInterval, (Object)interval)) {
            return;
        }
        this.markedInterval = interval;
        if (this.getView() != null) {
            this.shapeChanged = true;
            this.getImageState().updated();
            this.getCompanionOwner().shapeChanged = true;
            this.getCompanionOwner().toScreen();
            this.getView().invalidate();
            this.getView().repaint();
        }
    }

    private void init(Histogram histogram, boolean bl) {
        this.visible = bl;
        this.histogram = histogram;
        this.setOnlyTranslateAnchor(true);
        if (histogram != null) {
            this.addMarker();
        }
    }

    private void calcScreenScaledValues() {
        if (this.histogram == null || this.histogram.getRawHistogram() == null) {
            this.screenScaledValues = null;
            return;
        }
        int[] nArray = this.histogram.getRawHistogram();
        if (this.screenScaledValues == null) {
            this.screenScaledValues = new int[nArray.length];
        }
        int n = this.histogram.getMaxCount();
        int n2 = this.p3y - this.p0y;
        int n3 = this.histogram.getMinValidIndex();
        int n4 = this.histogram.getMaxValidIndex();
        int n5 = 0;
        while (n5 < n3) {
            this.screenScaledValues[n5] = 0;
            ++n5;
        }
        double d = (double)n2 / Math.log(n);
        int n6 = n3;
        while (n6 <= n4) {
            this.screenScaledValues[n6] = nArray[n6] == 0 ? 0 : (int)(Math.log(nArray[n6]) * d);
            ++n6;
        }
        n6 = n4 + 1;
        while (n6 < nArray.length - 1) {
            this.screenScaledValues[n6] = 0;
            ++n6;
        }
    }

    @Override
    protected void toScreen() {
        if (this.w == 0.0) {
            int n;
            int n2 = this.histogram.getMinIndex();
            int n3 = this.histogram.getMaxIndex();
            if (!this.autoScaleX) {
                n2 = 0;
                n3 = this.histogram.getRawHistogram().length;
            }
            if ((n = n3 - n2) == 0) {
                n = 1;
            }
            while (n < 150) {
                n *= 2;
            }
            if ((double)n > 0.2 * (double)this.width) {
                n = (int)(0.2 * (double)this.width);
            }
            this.w = n;
        }
        super.toScreen();
        this.calcScreenScaledValues();
        for (VerticalMarker verticalMarker : this.markers) {
            verticalMarker.handleHistogramBoundsChanged();
        }
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object2 = bufferedImageHolder.getImageArray();
        if (this.screenScaledValues == null) {
            return;
        }
        int n8 = this.p3y - this.p0y;
        int n9 = this.p1x - this.p0x;
        int n10 = this.p0x;
        int n11 = this.p0y;
        if (n11 + n8 < 0 || n11 > this.height) {
            return;
        }
        this.dimm(n10, n11, n9, n8, 50, bufferedImageHolder);
        if (this.isUseOutlineFont()) {
            bufferedImageHolder.graphics.setColor(Color.black);
            bufferedImageHolder.graphics.drawLine(this.p0x - 1, this.p0y, this.p3x - 1, this.p3y);
            bufferedImageHolder.graphics.drawLine(this.p0x + 1, this.p0y, this.p3x + 1, this.p3y - 1);
            bufferedImageHolder.graphics.drawLine(this.p3x, this.p3y - 1, this.p2x, this.p2y - 1);
            bufferedImageHolder.graphics.drawLine(this.p3x, this.p3y + 1, this.p2x, this.p2y + 1);
            bufferedImageHolder.graphics.setColor(this.objCol);
        }
        bufferedImageHolder.graphics.drawLine(this.p0x, this.p0y, this.p3x, this.p3y);
        bufferedImageHolder.graphics.drawLine(this.p3x, this.p3y, this.p2x, this.p2y);
        int n12 = this.objCol.getRGB();
        int n13 = bufferedImageHolder.width;
        int n14 = this.histogram.getMinIndex();
        int n15 = this.histogram.getMaxIndex();
        if (!this.autoScaleX) {
            n14 = 0;
            n15 = this.histogram.getMaxIndex();
        }
        if ((n7 = n15 - n14) == 0) {
            n7 = 1;
        }
        if (!this.histogram.hasMonotonicValueMapping()) {
            String object3 = Messages.getString("PresentationObject.ValueHistogram.NotAvailable");
            n6 = this.getStringHalfWidth(object3, bufferedImageHolder);
            this.drawString(object3, this.objCol, bufferedImageHolder, (this.p0x + this.p2x) / 2 - n6, (this.p0y + this.p2y) / 2);
        } else if (object2 instanceof int[]) {
            int[] nArray = (int[])object2;
            n6 = n10;
            n5 = n14;
            while (n5 < n15) {
                n4 = n6;
                n6 = n10 + (n5 + 1 - n14) * n9 / n7;
                if (n4 >= 0 && n4 < n13 && (n3 = (n11 + n8 - this.screenScaledValues[n5]) * n13 + n4) < nArray.length) {
                    n2 = (n11 + n8) * n13;
                    if (n3 < 0) {
                        n3 -= (n3 / n13 - 1) * n13;
                    }
                    if (n2 >= nArray.length) {
                        n2 -= ((n2 - nArray.length) / n13 + 1) * n13;
                    }
                    do {
                        n = n3;
                        while (n < n2) {
                            nArray[n] = n12;
                            n += n13;
                        }
                        ++n3;
                        ++n2;
                    } while (++n4 < n6 && n4 < n13);
                }
                ++n5;
            }
        } else if (object2 instanceof byte[]) {
            byte[] byArray = (byte[])object2;
            n6 = n10;
            n5 = n14;
            while (n5 < n15) {
                n4 = n6;
                n6 = n10 + (n5 + 1 - n14) * n9 / n7;
                if (n4 >= 0 && n4 < n13 && (n3 = (n11 + n8 - this.screenScaledValues[n5]) * n13 + n4) < byArray.length) {
                    n2 = (n11 + n8) * n13;
                    if (n3 < 0) {
                        n3 -= (n3 / n13 - 1) * n13;
                    }
                    if (n2 >= byArray.length) {
                        n2 -= ((n2 - byArray.length) / n13 + 1) * n13;
                    }
                    do {
                        n = n3;
                        while (n < n2) {
                            byArray[n] = 127;
                            n += n13;
                        }
                        ++n3;
                        ++n2;
                    } while (++n4 < n6 && n4 < n13);
                }
                ++n5;
            }
        }
        this.drawString(HistogramOverlay.formatValue(this.histogram.getMin(), this.getHistogramUnit()), this.objCol, bufferedImageHolder, n10 + 10, n11 + n8 - 10);
        this.drawString(HistogramOverlay.formatValue(this.histogram.getMax(), this.getHistogramUnit()), this.objCol, bufferedImageHolder, n10 + n9 - 50, n11 + n8 - 10);
        for (VerticalMarker verticalMarker : this.markers) {
            verticalMarker.paint(bufferedImageHolder, this.p0x, this.p1x, this.p0y, this.p2y);
        }
    }

    public void setAutoScaleX(boolean bl) {
        this.autoScaleX = bl;
    }

    public void setHistogram(Histogram histogram) {
        this.histogram = histogram;
        this.calcScreenScaledValues();
        if (this.markers.size() == 0) {
            this.addMarker();
        }
        for (VerticalMarker verticalMarker : this.markers) {
            verticalMarker.handleHistogramDataChanged();
        }
    }

    @Override
    public boolean isROI() {
        return true;
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        if (this.screenScaledValues == null) {
            return null;
        }
        int n = this.histogram.getMaxIndex();
        int n2 = this.p3y - this.p0y;
        int n3 = this.p1x - this.p0x;
        int n4 = this.p0x;
        int n5 = this.p0y;
        int n6 = this.histogram.getMinIndex();
        int n7 = this.histogram.getMaxIndex();
        if (!this.autoScaleX) {
            n6 = 0;
            n7 = n;
        }
        int n8 = n7 - n6;
        int n9 = n4;
        int n10 = Integer.MAX_VALUE;
        int n11 = 0;
        float[] fArray = new float[2 * n8];
        double[] dArray = this.getTopLeft();
        double[] dArray2 = new double[]{0.0, 0.0};
        dArray2[0] = n9;
        dArray2[1] = n5 + n2;
        dArray2 = this.toImage(dArray2);
        fArray[n11 * 2] = (float)dArray2[0];
        fArray[n11 * 2 + 1] = (float)dArray2[1];
        ++n11;
        int n12 = n6;
        while (n12 < n7) {
            int n13 = n9;
            n9 = n4 + (n12 + 1 - n6) * n3 / n8;
            int n14 = n5 + n2 - this.screenScaledValues[n12];
            if (n14 < n10) {
                n10 = n14;
            }
            if (n13 != n9 || n12 == n7 - 1) {
                dArray2[0] = n13;
                dArray2[1] = n10;
                dArray2 = this.toImage(dArray2);
                fArray[n11 * 2] = (float)dArray2[0];
                fArray[n11 * 2 + 1] = (float)dArray2[1];
                ++n11;
                n10 = Integer.MAX_VALUE;
            }
            ++n12;
        }
        dArray2[0] = n9;
        dArray2[1] = n5 + n2;
        dArray2 = this.toImage(dArray2);
        fArray[n11 * 2] = (float)dArray2[0];
        fArray[n11 * 2 + 1] = (float)dArray2[1];
        fArray = Arrays.copyOf(fArray, 2 * ++n11);
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setGraphicFilled(YN.Yes);
        graphicObject.setTianiROIID("H" + this.id);
        graphicObject.setTianiPositionData(dArray[0] / (double)this.width, dArray[1] / (double)this.height, this.w / (double)this.width, this.h / (double)this.height);
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(n11));
        graphicObject.setGraphicData(fArray);
        arrayList.add(graphicObject);
        return arrayList;
    }

    @Override
    public PresentationObject cloneAll() {
        double[] dArray = this.getTopLeft();
        HistogramOverlay histogramOverlay = new HistogramOverlay(this.histogram, dArray[0], dArray[1], this.w, this.h, this.spacingType, this.anchor, this.visible);
        this.setAllowDragOutOfBounds(this.bAllowDragOutOfBounds);
        this.setOnlyTranslateAnchor(this.getOnlyTranslateAnchor());
        histogramOverlay.setAutoScaleX(true);
        histogramOverlay.setClonedParameters((double[])this.a.clone(), (double[])this.o.clone());
        histogramOverlay.setShapeChanged(true);
        return histogramOverlay;
    }

    private void addMarker() {
        if (this.markers != null) {
            this.markers.add(new VerticalMarker(true));
            this.markers.add(new VerticalMarker(false));
            this.handles = Arrays.copyOf(this.handles, this.handles.length + 2);
            this.handles[this.handles.length - 2] = this.markers.get((int)0).plotH;
            this.handles[this.handles.length - 1] = this.markers.get((int)1).plotH;
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.updateRange(null);
    }

    @Override
    public void handleDragged(int n, double[] dArray) {
        super.handleDragged(n, dArray);
        if (n > 4) {
            double[] dArray2 = this.toScreen(dArray);
            int n2 = (int)(dArray2[0] + 0.5);
            int n3 = (int)(dArray2[1] + 0.5);
            this.markers.elementAt(n - 5).handleDragged(n2, n3);
        }
        this.setSaved(false);
    }

    protected int getStringHalfWidth(String string, BufferedImageHolder bufferedImageHolder) {
        return (int)(bufferedImageHolder.graphics.getFontMetrics().getStringBounds(string, bufferedImageHolder.graphics).getWidth() / 2.0);
    }

    private String getHistogramUnit() {
        return this.histogram.getUnit() == null ? "" : this.histogram.getUnit();
    }

    class VerticalMarker {
        boolean leftSide;
        boolean inOrigPos;
        int horPos;
        int rawValue;
        String logicalValue;
        PresentationHandle plotH;

        public VerticalMarker(boolean bl) {
            this.leftSide = bl;
            this.rawValue = bl ? HistogramOverlay.this.histogram.getRawMin() : HistogramOverlay.this.histogram.getRawMax();
            this.recalculateLogicalValue();
            this.plotH = new PresentationHandle(0, 0);
            this.inOrigPos = true;
        }

        public void paint(BufferedImageHolder bufferedImageHolder, int n, int n2, int n3, int n4) {
            int n5 = this.horPos + n;
            bufferedImageHolder.graphics.setColor(HistogramOverlay.this.objCol);
            bufferedImageHolder.graphics.setColor(HistogramOverlay.this.objCol);
            float[] fArray = new float[]{1.0f, 1.0f};
            bufferedImageHolder.graphics.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, fArray, 0.0f));
            bufferedImageHolder.graphics.drawLine(n5, n3, n5, n4);
            bufferedImageHolder.graphics.setColor(Color.black);
            bufferedImageHolder.graphics.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, fArray, 1.0f));
            bufferedImageHolder.graphics.drawLine(n5, n3, n5, n4);
            bufferedImageHolder.graphics.setStroke(new BasicStroke(1.0f));
            bufferedImageHolder.graphics.setColor(HistogramOverlay.this.objCol);
            this.plotH.x = n5;
            if (n5 != n && n5 != n2) {
                this.plotH.y = n3;
                String string = String.valueOf(this.logicalValue) + HistogramOverlay.this.getHistogramUnit();
                int n6 = HistogramOverlay.this.getStringHalfWidth(string, bufferedImageHolder);
                HistogramOverlay.this.drawString(string, HistogramOverlay.this.objCol, bufferedImageHolder, n5 - n6, n3);
            } else {
                this.plotH.y = n3 + Math.abs(n3 - n4) / 2;
            }
        }

        public void handleDragged(int n, int n2) {
            this.horPos = n - HistogramOverlay.this.p0x;
            if (this.horPos < 0) {
                this.horPos = 0;
            } else if (this.horPos > HistogramOverlay.this.p1x - HistogramOverlay.this.p0x) {
                this.horPos = HistogramOverlay.this.p1x - HistogramOverlay.this.p0x;
            }
            this.rawValue = this.pixel2Raw(this.horPos);
            this.inOrigPos = false;
            if (this.leftSide && this.rawValue == HistogramOverlay.this.histogram.getRawMin()) {
                this.inOrigPos = true;
            }
            if (!this.leftSide && this.rawValue == HistogramOverlay.this.histogram.getRawMax()) {
                this.inOrigPos = true;
            }
            this.informListener();
            this.recalculateLogicalValue();
        }

        private void informListener() {
            Interval interval = this.getMarkedInterval();
            HistogramOverlay.this.updateRange(interval);
        }

        public void handleHistogramDataChanged() {
            int n = this.rawValue;
            if (HistogramOverlay.this.histogram.getRawMax() - HistogramOverlay.this.histogram.getRawMin() == 0) {
                if (this.leftSide) {
                    this.rawValue = HistogramOverlay.this.histogram.getRawMin();
                    this.horPos = 0;
                    this.inOrigPos = true;
                } else {
                    this.rawValue = HistogramOverlay.this.histogram.getRawMin();
                    this.horPos = HistogramOverlay.this.p1x - HistogramOverlay.this.p0x;
                    this.inOrigPos = true;
                }
            } else if (HistogramOverlay.this.p1x - HistogramOverlay.this.p0x == 0) {
                this.rawValue = HistogramOverlay.this.histogram.getRawMin();
                this.horPos = 0;
                this.inOrigPos = true;
            } else if (this.inOrigPos) {
                if (this.leftSide) {
                    this.rawValue = HistogramOverlay.this.histogram.getRawMin();
                    this.horPos = 0;
                } else {
                    this.rawValue = HistogramOverlay.this.histogram.getRawMax();
                    this.horPos = HistogramOverlay.this.p1x - HistogramOverlay.this.p0x;
                }
            } else if (this.rawValue <= HistogramOverlay.this.histogram.getRawMin()) {
                this.rawValue = HistogramOverlay.this.histogram.getRawMin();
                this.horPos = 0;
                if (this.leftSide) {
                    this.inOrigPos = true;
                }
            } else if (this.rawValue >= HistogramOverlay.this.histogram.getRawMax()) {
                this.rawValue = HistogramOverlay.this.histogram.getRawMax();
                this.horPos = HistogramOverlay.this.p1x - HistogramOverlay.this.p0x;
                if (!this.leftSide) {
                    this.inOrigPos = true;
                }
            } else {
                this.horPos = this.raw2Pixel(this.rawValue);
            }
            this.recalculateLogicalValue();
            if (this.rawValue != n) {
                this.informListener();
            }
        }

        public void handleHistogramBoundsChanged() {
            if (HistogramOverlay.this.histogram.getRawMax() - HistogramOverlay.this.histogram.getRawMin() == 0 || this.inOrigPos) {
                this.horPos = this.leftSide ? 0 : HistogramOverlay.this.p1x - HistogramOverlay.this.p0x;
                this.inOrigPos = true;
                return;
            }
            if (HistogramOverlay.this.p1x - HistogramOverlay.this.p0x == 0) {
                this.horPos = 0;
                this.inOrigPos = true;
                return;
            }
            this.horPos = this.raw2Pixel(this.rawValue);
        }

        private void recalculateLogicalValue() {
            this.logicalValue = HistogramOverlay.this.histogram.formatValue(HistogramOverlay.this.histogram.applyMapping(this.rawValue));
        }

        private Interval getMarkedInterval() {
            if (HistogramOverlay.this.markers.size() != 2) {
                return null;
            }
            VerticalMarker verticalMarker = (VerticalMarker)HistogramOverlay.this.markers.elementAt(0);
            VerticalMarker verticalMarker2 = (VerticalMarker)HistogramOverlay.this.markers.elementAt(1);
            if (verticalMarker.horPos == 0 && verticalMarker2.horPos == HistogramOverlay.this.p1x - HistogramOverlay.this.p0x || verticalMarker.horPos == HistogramOverlay.this.p1x - HistogramOverlay.this.p0x && verticalMarker2.horPos == 0) {
                return null;
            }
            Interval interval = new Interval(verticalMarker.rawValue, verticalMarker2.rawValue);
            return interval;
        }

        private int pixel2Raw(int n) {
            int n2;
            int n3 = HistogramOverlay.this.histogram.getRawMax() - HistogramOverlay.this.histogram.getRawMin();
            if (n3 == 0) {
                n2 = HistogramOverlay.this.histogram.getRawMin();
            } else {
                double d = (double)(HistogramOverlay.this.p1x - HistogramOverlay.this.p0x) / (double)n3;
                n2 = HistogramOverlay.this.histogram.getRawMin() + (int)Math.round((double)n / d);
            }
            return n2;
        }

        private int raw2Pixel(int n) {
            return (int)Math.round((double)(HistogramOverlay.this.p1x - HistogramOverlay.this.p0x) * (double)(n - HistogramOverlay.this.histogram.getRawMin()) / (double)(HistogramOverlay.this.histogram.getRawMax() - HistogramOverlay.this.histogram.getRawMin()));
        }
    }
}

