/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.tiani.jvision.image.PlanarContext;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.EditTextOverlayContent;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import java.awt.Color;
import java.awt.Rectangle;

public class EditTextOverlay2
extends PresentationObject {
    protected int initPosX;
    protected int initPosY;
    protected double[] m = new double[2];
    protected int xo;
    protected int yo;
    protected int w;
    protected int h;
    protected EditTextOverlayContent content = null;
    protected Color cColor;
    protected double referenceFontSize;
    protected int referenceWidth;
    protected boolean didDragging = false;
    protected boolean succeedingKeyEvents = false;

    public EditTextOverlay2() {
        super("Edit Text");
        this.m[1] = 0.0;
        this.m[0] = 0.0;
        this.initPosX = -1;
        this.initPosY = -1;
        this.cColor = this.objCol;
    }

    public EditTextOverlay2(EditTextOverlayContent editTextOverlayContent) {
        this(0.5, 0.5, editTextOverlayContent, AnnotationUnits.Display);
    }

    public EditTextOverlay2(double d, double d2, EditTextOverlayContent editTextOverlayContent, AnnotationUnits annotationUnits) {
        this();
        this.m[0] = d;
        this.m[1] = d2;
        this.setSpacing(annotationUnits);
        if (editTextOverlayContent == null) {
            return;
        }
        this.content = editTextOverlayContent;
        this.referenceWidth = this.w = this.getCurrentFontMetrics().bytesWidth(editTextOverlayContent.getTextLine().getBytes(), 0, editTextOverlayContent.getTextLine().length());
        this.referenceFontSize = this.getCurrentFontMetrics().charWidth('m');
        this.h = this.getFontHeight();
    }

    @Override
    public boolean isRemoveable() {
        return false;
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        int n3 = 100;
        int n4 = 100;
        super.initPlacement(n + n3 / 2, n2 + n4 / 2, annotationUnits, false, bl2);
        this.referenceWidth = this.w = n3;
        this.h = this.getFontHeight();
        this.referenceFontSize = this.getCurrentFontMetrics().charWidth('m');
    }

    @Override
    public void setContext(PlanarContext planarContext) {
    }

    @Override
    public boolean isROI() {
        return false;
    }

    @Override
    protected void toScreen() {
        double[] dArray = new double[]{this.m[0], this.m[1]};
        dArray = this.toScreen(dArray);
        this.referenceWidth = this.w = this.getCurrentFontMetrics().bytesWidth(this.content.getTextLine().getBytes(), 0, this.content.getTextLine().length());
        this.xo = (int)dArray[0];
        this.yo = (int)dArray[1];
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (this.visible) {
            this.drawString(this.content.getTextLine(), this.cColor, bufferedImageHolder, this.xo, this.yo);
        }
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        return -1;
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            super.cloneReferences(presentationObject);
            EditTextOverlay2 editTextOverlay2 = (EditTextOverlay2)presentationObject;
            editTextOverlay2.setClonedParameters(ReferencedObjectsCloning.clone(this.m));
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return presentationObject;
    }

    public void setClonedParameters(double[] dArray) {
        this.m = dArray;
    }

    @Override
    protected boolean mousePressed(int n, int n2, boolean bl) {
        return false;
    }

    @Override
    public void mouseDragged(int n, int n2) {
    }

    @Override
    public void mouseReleased() {
    }

    public double getCurrentDoubleValue() {
        return this.content.getCurrentDoubleValue();
    }

    public String getCurrentStringValue() {
        return this.content.getCurrentStringValue();
    }

    public boolean setCurrentValue(double d) {
        if (this.content != null) {
            return this.content.setCurrentValue(d);
        }
        return false;
    }

    public boolean setCurrentValue(String string) {
        if (this.content != null) {
            return this.content.setCurrentValue(string);
        }
        return false;
    }

    public void setPosition(double d, double d2, AnnotationUnits annotationUnits) {
        this.m[0] = d;
        this.m[1] = d2;
        this.setSpacing(annotationUnits);
        this.referenceWidth = this.w = this.getCurrentFontMetrics().bytesWidth(this.content.getTextLine().getBytes(), 0, this.content.getTextLine().length());
        this.referenceFontSize = this.getCurrentFontMetrics().charWidth('m');
        this.h = this.getFontHeight();
        this.toScreen();
    }

    public Rectangle getTextArea() {
        return new Rectangle(0, 0, this.referenceWidth, (int)(this.referenceFontSize * 1.5));
    }

    public void move(double d, double d2) {
        this.m[0] = this.m[0] + d;
        this.m[1] = this.m[1] + d2;
    }

    public double[] getPosition() {
        double[] dArray = new double[]{this.m[0], this.m[1]};
        return dArray;
    }

    @Override
    protected void handleDragged(int n, double[] dArray) {
    }

    @Override
    public void setSize(int n, int n2, ImageState imageState) {
        super.setSize(n, n2, imageState);
        this.toScreen();
    }
}

